/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.IRptCellDelegate;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.RptCellComment;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.client.IControlledDialogListener;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.RptCellCmtEditUI;
import com.kingdee.eas.fi.rpt.client.RptCellTextRender;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.util.client.ExceptionHandler;

public class RptCellDelegate
implements IRptCellDelegate {
    ICell cell;
    private RptSheet sheet;
    RptCommentTank comment;
    private RptCellTextRender cellRander;
    private ItemFormula itemFormula;
    private EditorListener edListener = null;

    @Override
    public void addComment(Object cmt) {
        if (this.comment == null) {
            this.comment = new RptCommentTank();
        }
        this.comment.addInitEntry((RptCellComment)cmt);
        this.triggerCmtRander();
    }

    @Override
    public void removeComments() {
        this.comment = null;
        this.triggerCmtRander();
    }

    @Override
    public boolean hasComment() {
        return this.comment != null && this.comment.isValid();
    }

    @Override
    public ItemFormula setItemFormula(String line) {
        if (line == null || line.length() < 1) {
            this.itemFormula = null;
        } else {
            if (this.itemFormula == null) {
                this.itemFormula = new ItemFormula();
            }
            this.itemFormula.FormulaToObject(line.trim());
        }
        this.applyCellRender();
        return this.itemFormula;
    }

    void triggerCmtRander() {
        boolean isModify = false;
        if (this.cellRander == null) {
            this.cellRander = new RptCellTextRender();
            isModify = true;
        }
        boolean newStatus = this.comment != null && this.comment.isValid();
        isModify = !this.cellRander.hasCmtRander || this.cellRander.hasCmtRander != newStatus;
        this.cellRander.hasCmtRander = newStatus;
        if (isModify && this.cell != null) {
            this.cell.setRenderer((IBasicRender)this.cellRander);
        }
    }

    @Override
    public void applyCellRender() {
        boolean isModify = false;
        if (this.cellRander == null) {
            this.cellRander = new RptCellTextRender();
            isModify = true;
        }
        boolean hasItem = this.itemFormula != null && this.itemFormula.getFormula() != null;
        isModify = !this.cellRander.hasItemRander || this.cellRander.hasItemRander != hasItem;
        this.cellRander.hasItemRander = hasItem;
        if (this.itemFormula != null && this.itemFormula.getExt("20") != null) {
            if (this.itemFormula.getExt("20").equals("22")) {
                this.cellRander.isFormulaInvalid = true;
            } else if (this.itemFormula.getExt("20").equals("24")) {
                this.cellRander.isFormulaDuplicate = true;
            } else {
                this.cellRander.isItemNotExists = true;
            }
        } else {
            this.cellRander.isItemNotExists = false;
            this.cellRander.isFormulaInvalid = false;
            this.cellRander.isFormulaDuplicate = false;
        }
        if (this.itemFormula != null) {
            this.cellRander.isBasePoint = this.itemFormula.isBasePoint();
        }
        if (isModify && this.cell != null) {
            this.cell.setRenderer((IBasicRender)this.cellRander);
        }
    }

    @Override
    public void getComments(PostilCollection comments) {
        if (this.comment == null) {
            return;
        }
        this.comment.dump(comments, this.itemFormula != null ? this.itemFormula.getItemNumber() : null);
    }

    @Override
    public String getCommentString() {
        if (this.comment == null || !this.comment.isValid()) {
            return null;
        }
        return this.comment.toString();
    }

    @Override
    public void editComment(boolean isEditable) {
        if (this.comment == null) {
            this.comment = new RptCommentTank();
        }
        if (this.edListener == null) {
            this.edListener = new EditorListener();
        }
        try {
            String title = RptResourceHelper.getString("cellcmt") + RptResourceHelper.getString(isEditable ? "edit" : "view");
            RptCellCmtEditUI ed = RptCellCmtEditUI.getInstance(this.sheet.getParentUI());
            ed.addSimpleDialogListener(this.edListener);
            ed.open(this.comment, title, isEditable);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void setSheet(Object sht) {
        this.sheet = (RptSheet)sht;
    }

    @Override
    public Object getSheet() {
        return this.sheet;
    }

    @Override
    public ICell setCell(ICell cl) {
        this.cell = cl;
        if (this.cell != null) {
            this.cell.setRenderer((IBasicRender)this.cellRander);
        }
        return this.cell;
    }

    @Override
    public Object getComment() {
        return this.comment;
    }

    @Override
    public void setComment(Object cmt) {
        this.comment = (RptCommentTank)cmt;
        this.triggerCmtRander();
    }

    @Override
    public ItemFormula setItemFormula(ItemFormula iFormula) {
        this.itemFormula = iFormula;
        this.applyCellRender();
        return this.itemFormula;
    }

    private final class EditorListener
    implements IControlledDialogListener {
        private EditorListener() {
        }

        @Override
        public Object getTrueController() {
            return new RptCellComment(RptCellDelegate.this.cell.getColumnIndex(), RptCellDelegate.this.cell.getRowIndex());
        }

        @Override
        public void pilotSetout(ISimpleDialog source) {
        }

        @Override
        public void pilotReturnee(ISimpleDialog source, Object result, boolean isOk) {
            if (isOk) {
                RptCellDelegate.this.comment.updateFrom((RptCommentTank)result);
            }
            RptCellDelegate.this.triggerCmtRander();
        }
    }
}

