/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.fi.rpt.FormulaMoveTool;
import com.kingdee.eas.fi.rpt.GenerateSolution;
import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.fi.rpt.check.CheckExrepssionIterator;
import com.kingdee.eas.fi.rpt.client.AbstractRptCheckExpressionEditUI;
import com.kingdee.eas.fi.rpt.client.BatchCheckItemGeneraterUI;
import com.kingdee.eas.fi.rpt.client.IControlledDialogListener;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.ISimpleDialogListener;
import com.kingdee.eas.fi.rpt.client.RptCheckExpLineEditUI;
import com.kingdee.eas.fi.rpt.client.RptCheckUI;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IBreakableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.Area3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class RptCheckExpressionEditUI
extends AbstractRptCheckExpressionEditUI
implements ISimpleDialog {
    private static final Logger log = Logger.getLogger((String)RptCheckExpressionEditUI.class.getName());
    private ArrayList listeners;
    private RptCheckExpression expression;
    private static boolean isK3 = false;
    private boolean isAddNew = false;

    public static RptCheckExpressionEditUI getUIInstance(Map context) throws Exception {
        Object object = context.get("isK3");
        if (object != null) {
            isK3 = (Boolean)object;
        }
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(RptCheckExpressionEditUI.class.getName(), context);
        RptCheckExpressionEditUI res = (RptCheckExpressionEditUI)wnd.getUIObject();
        res.onShow();
        return res;
    }

    public RptCheckExpressionEditUI() throws Exception {
        this.toolBar = null;
        this.menuBar = null;
        this.statusBar = null;
        this.expression = null;
        this.listeners = new ArrayList(1);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initializeUI();
    }

    private void initializeUI() throws Exception {
        RptCheckExpLineEditUI rptCheckExpLineEditUI = new RptCheckExpLineEditUI();
        rptCheckExpLineEditUI.getUIContext().put("REPORT_CONTEXT", this.getUIContext().get("REPORT_CONTEXT"));
        rptCheckExpLineEditUI.setK3(isK3);
        rptCheckExpLineEditUI.initBtn();
        this.pnlCore.add((Component)((Object)rptCheckExpLineEditUI));
    }

    @Override
    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnOk_actionPerformed(e);
        Component[] compList = this.pnlCore.getComponents();
        if (compList != null) {
            for (int i = 0; i < compList.length; ++i) {
                if (!(compList[i] instanceof BatchCheckItemGeneraterUI)) continue;
                BatchCheckItemGeneraterUI ui = (BatchCheckItemGeneraterUI)((Object)compList[i]);
                if (ui.verify()) break;
                return;
            }
        }
        this.endWizard(true);
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnCancel_actionPerformed(e);
        this.endWizard(false);
    }

    private GenerateSolution getBathGenerateSolution() {
        Component[] compList = this.pnlCore.getComponents();
        if (compList != null) {
            for (int i = 0; i < compList.length; ++i) {
                if (!(compList[i] instanceof BatchCheckItemGeneraterUI)) continue;
                BatchCheckItemGeneraterUI ui = (BatchCheckItemGeneraterUI)((Object)compList[i]);
                return ui.getSolution();
            }
        }
        return null;
    }

    @Override
    public void open(Object cookie, String isNew) {
        IUIWindow w;
        this.isAddNew = RptUtil.isTrue(isNew);
        try {
            Component[] compList = this.pnlCore.getComponents();
            if (compList != null) {
                for (int i = 0; i < compList.length; ++i) {
                    if (!(compList[i] instanceof BatchCheckItemGeneraterUI)) continue;
                    this.pnlCore.remove(compList[i]);
                    break;
                }
            }
            if (this.isAddNew) {
                this.pnlCore.add((Component)((Object)new BatchCheckItemGeneraterUI()));
            }
        }
        catch (Exception compList) {
            // empty catch block
        }
        this.fireListenersSetout();
        if (!this.loadExpression((RptCheckExpression)cookie)) {
            this.fireListenersReturnee(null, false);
        }
        if ((w = this.getUIWindow()) instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RptCheckExpressionEditUI.this.endWizard(false);
                }
            });
        }
        w.show();
    }

    public boolean isAddNew() {
        return this.isAddNew;
    }

    void endWizard(boolean isOk) {
        RptCheckExpression[] fireObject = null;
        if (isOk) {
            GenerateSolution solution = this.getBathGenerateSolution();
            if (solution == null) {
                String txt = this.txtName.getText();
                if (txt != null && (txt = txt.trim()).length() == 0) {
                    txt = null;
                }
                if (!(!this.isAddNew && txt != null && txt.equalsIgnoreCase(this.expression.getName()) || this.checkExprName(txt))) {
                    return;
                }
                String content = ((RptCheckExpLineEditUI)((Object)this.pnlCore.getComponentAt(0))).getExpression();
                if (!StringUtil.isEmptyString((String)content.trim())) {
                    String[] lines = content.trim().split("\\n+");
                    Book book = (Book)this.getUIContext().get("book");
                    for (int i = 0; i < lines.length; ++i) {
                        try {
                            String eachLine = lines[i].trim();
                            Expression exp = ExcelFormulaPaserHelper.parse(eachLine);
                            ExpressionHandler handler = new ExpressionHandler(book);
                            ExcelFormulaPaserHelper.walk(exp, handler);
                            if (handler.ok) continue;
                            String errString = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"Not_Found_Sheet").replaceAll("\\{0\\}", lines[i]).replaceAll("\\{1\\}", handler.sheetName);
                            MsgBox.showError((Component)((Object)this), (String)errString);
                            return;
                        }
                        catch (Exception e) {
                            RptCheckExpression me = new RptCheckExpression();
                            me.setContent(lines[i].trim());
                            Sheet sheet = book.getSheet(this.expression.getSheetName());
                            sheet.setUserObject("REAL_MAX_ROW", (Object)new Integer(sheet.getRows().getMaxIntMark() + 1));
                            sheet.setUserObject("REAL_MAX_COL", (Object)new Integer(sheet.getCols().getMaxIntMark() + 1));
                            try {
                                CheckExrepssionIterator it = new CheckExrepssionIterator(book.getSheet(this.expression.getSheetName()), me);
                                while (it.hasNext()) {
                                    RptCheckExpression next = it.next();
                                    String eachLine = next.getContent();
                                    Expression exp = ExcelFormulaPaserHelper.parse(eachLine);
                                    ExpressionHandler handler = new ExpressionHandler(book);
                                    ExcelFormulaPaserHelper.walk(exp, handler);
                                    if (handler.ok) continue;
                                    String errString = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"Not_Found_Sheet").replaceAll("\\{0\\}", lines[i]).replaceAll("\\{1\\}", handler.sheetName);
                                    MsgBox.showError((Component)((Object)this), (String)errString);
                                    return;
                                }
                                continue;
                            }
                            catch (Exception e1) {
                                String errString = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"Formular_Error").replaceAll("\\{0\\}", lines[i]);
                                MsgBox.showError((Component)((Object)this), (String)errString);
                                return;
                            }
                        }
                    }
                }
                this.expression.setName(txt);
                this.expression.setContent(((RptCheckExpLineEditUI)((Object)this.pnlCore.getComponentAt(0))).getExpression());
                this.expression.setCreateOrgNum(this.getCheckCreator(this.expression));
                this.expression.setDescription(((RptCheckExpLineEditUI)((Object)this.pnlCore.getComponentAt(0))).getDescription());
                this.expression.setCheckResultState(((RptCheckExpLineEditUI)((Object)this.pnlCore.getComponentAt(0))).getFormulaCheckResultType());
                fireObject = this.expression;
            } else {
                String txt = this.txtName.getText();
                if (txt != null && (txt = txt.trim()).length() == 0) {
                    txt = null;
                }
                if (txt == null) {
                    txt = " ";
                }
                String formula = ((RptCheckExpLineEditUI)((Object)this.pnlCore.getComponentAt(0))).getExpression();
                String desc = ((RptCheckExpLineEditUI)((Object)this.pnlCore.getComponentAt(0))).getDescription();
                String name = this.containsCheckItemName(txt) ? this.nextName(txt) : txt;
                int checkResultState = ((RptCheckExpLineEditUI)((Object)this.pnlCore.getComponentAt(0))).getFormulaCheckResultType();
                try {
                    String[] list = FormulaMoveTool.generateBysolution(solution, formula);
                    RptCheckExpression[] eps = this.getCheckUI().createDefaultRptCheckExpression(list.length);
                    eps[0].setContent(formula);
                    eps[0].setDescription(desc);
                    eps[0].setName(name);
                    eps[0].setCreateOrgNum(this.getCheckCreator(eps[0]));
                    eps[0].setCheckResultState(checkResultState);
                    for (int i = 0; i < list.length - 1; ++i) {
                        eps[i + 1].setContent(list[i]);
                        eps[i + 1].setDescription(desc);
                        eps[i + 1].setCreateOrgNum(this.getCheckCreator(eps[i + 1]));
                        name = this.nextName(name);
                        eps[i + 1].setName(name);
                        eps[i + 1].setCheckResultState(checkResultState);
                    }
                    fireObject = eps;
                }
                catch (Exception e) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"204_RptCheckExpressionEditUI"));
                    log.debug((Object)e.getMessage());
                    return;
                }
            }
        }
        this.disposeUIWindow();
        this.fireListenersReturnee(fireObject, isOk);
    }

    private String nextName(String name) {
        String newString;
        String part = "";
        int number = 0;
        int firstNumIndex = -1;
        int i = name.length() - 1;
        while (i >= 0 && "0123456789".indexOf(name.charAt(i)) >= 0) {
            firstNumIndex = i--;
        }
        if (firstNumIndex == -1) {
            part = name;
        } else {
            String temp = name.substring(firstNumIndex);
            number = Integer.parseInt(temp);
        }
        if (firstNumIndex > 0) {
            part = name.substring(0, firstNumIndex);
        }
        if (this.containsCheckItemName(newString = part + (number + 1))) {
            return this.nextName(newString);
        }
        return newString;
    }

    private boolean containsCheckItemName(String name) {
        return this.getCheckUI().containsCheckItemName(name);
    }

    private boolean checkExprName(String name) {
        return this.getCheckUI().checkExprName(name);
    }

    private RptCheckUI getCheckUI() {
        for (IControlledDialogListener l : this.listeners) {
            RptCheckUI res;
            if (l == null || (res = (RptCheckUI)l.getTrueController()) == null) continue;
            return res;
        }
        return null;
    }

    private boolean loadExpression(RptCheckExpression exp) {
        this.expression = exp != null ? (RptCheckExpression)exp.clone() : new RptCheckExpression();
        this.txtName.setText(this.expression.getName());
        ((RptCheckExpLineEditUI)((Object)this.pnlCore.getComponentAt(0))).setExpression(this.expression.getContent());
        ((RptCheckExpLineEditUI)((Object)this.pnlCore.getComponentAt(0))).setDescription(this.expression.getDescription());
        ((RptCheckExpLineEditUI)((Object)this.pnlCore.getComponentAt(0))).setFormulaCheckResultType(this.expression.getCheckResultState());
        return true;
    }

    @Override
    public synchronized void addSimpleDialogListener(ISimpleDialogListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void fireListenersReturnee(Object exp, boolean isOk) {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotReturnee(this, exp, isOk);
        }
    }

    private void fireListenersSetout() {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotSetout(this);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setDefaultButton(this, (JButton)this.btnOk);
        RptHelper.setEscAction(this, (Action)((Object)this.actionBtnCancel));
    }

    private String getCheckCreator(RptCheckExpression expression) {
        StringBuffer creCompanyID = new StringBuffer();
        if ((RptCheckUI)this.getUIContext().get("Owner") instanceof RptCheckUI) {
            RptCheckUI rptCheckUI = (RptCheckUI)this.getUIContext().get("Owner");
            creCompanyID.append(rptCheckUI.getCurrentOrgNum());
            if (rptCheckUI.isCreator()) {
                expression.setCreByGroup(true);
            }
        }
        return creCompanyID.toString();
    }

    private final class ExpressionHandler
    implements IBreakableExpressionHandler {
        private final Book book;
        private String sheetName;
        private boolean ok = true;

        public ExpressionHandler(Book book) {
            this.book = book;
        }

        @Override
        public boolean handle(Expression expr) {
            if (expr instanceof Area3DExpr) {
                if (this.book.getSheet(((Area3DExpr)expr).sheetName) == null) {
                    this.sheetName = ((Area3DExpr)expr).sheetName;
                    this.ok = false;
                    return false;
                }
            } else if (expr instanceof Ref3DExpr && this.book.getSheet(((Ref3DExpr)expr).sheetName) == null) {
                this.sheetName = ((Ref3DExpr)expr).sheetName;
                this.ok = false;
                return false;
            }
            return true;
        }
    }
}

