/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.dao.IObjectCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;

public class RptComboBoxModel
extends AbstractListModel
implements MutableComboBoxModel {
    private List objects;
    private Object selectedObject;

    private List getDefaultList() {
        return new ArrayList(6);
    }

    private List getDefaultList(int cap) {
        return new ArrayList(cap);
    }

    public RptComboBoxModel() {
        this.objects = this.getDefaultList();
        this.selectedObject = null;
    }

    public RptComboBoxModel(Object[] items) {
        this(items, true);
    }

    public RptComboBoxModel(Object[] items, boolean isInOrder) {
        int size = items == null ? 0 : items.length;
        this.objects = this.getDefaultList(size);
        if (isInOrder) {
            for (int i = 0; i < size; ++i) {
                this.objects.add(items[i]);
            }
        } else {
            for (int i = size - 1; i >= 0; --i) {
                this.objects.add(items[i]);
            }
        }
        this.setSelectedItemRaw(0);
    }

    public RptComboBoxModel(List list) {
        this.objects = list == null ? this.getDefaultList() : list;
        this.setSelectedItemRaw(0);
    }

    public RptComboBoxModel(IObjectCollection objCollection) {
        this(objCollection, true);
    }

    public RptComboBoxModel(Collection objCollection) {
        int size = objCollection == null ? 0 : objCollection.size();
        this.objects = this.getDefaultList(size);
        if (size > 0) {
            Iterator it = objCollection.iterator();
            while (it.hasNext()) {
                this.objects.add(it.next());
            }
        }
        this.setSelectedItemRaw(0);
    }

    public RptComboBoxModel(IObjectCollection objCollection, boolean isInOrder) {
        int size = objCollection == null ? 0 : objCollection.size();
        this.objects = this.getDefaultList(size);
        if (isInOrder) {
            for (int i = 0; i < size; ++i) {
                this.objects.add(objCollection.getObject(i));
            }
        } else {
            for (int i = size - 1; i >= 0; --i) {
                this.objects.add(objCollection.getObject(i));
            }
        }
        this.setSelectedItemRaw(0);
    }

    @Override
    public void removeElementAt(int index) {
        if (index < 0 || index >= this.objects.size()) {
            return;
        }
        if (this.objects.get(index) == this.selectedObject) {
            if (index == 0) {
                this.setSelectedItem(this.objects.size() == 1 ? null : this.objects.get(index + 1));
            } else {
                this.setSelectedItem(this.objects.get(index - 1));
            }
        }
        this.objects.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void removeAll() {
        int size = this.getSize();
        this.objects = this.getDefaultList();
        this.fireIntervalRemoved(this, 0, size);
    }

    public void addElement(Object obj) {
        this.objects.add(obj);
        this.fireIntervalAdded(this, this.objects.size() - 1, this.objects.size() - 1);
        if (this.objects.size() == 1 && this.selectedObject == null && obj != null) {
            this.setSelectedItem(obj);
        }
    }

    @Override
    public void removeElement(Object obj) {
        int index = this.objects.indexOf(obj);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    public void insertElementAt(Object obj, int index) {
        this.objects.add(index, obj);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        Object oldSelected = this.selectedObject;
        this.selectedObject = anItem;
        this.fireSelectionChanged(oldSelected);
    }

    public void setSelectedItem(int index) {
        this.fireSelectionChanged(this.setSelectedItemRaw(index));
    }

    private void fireSelectionChanged(Object oldSelected) {
        if (this.selectedObject != null && !this.selectedObject.equals(oldSelected) || this.selectedObject == null && oldSelected != null) {
            this.fireContentsChanged(this, -1, -1);
        }
    }

    private Object setSelectedItemRaw(int index) {
        Object oldSelected = this.selectedObject;
        this.selectedObject = index >= 0 && this.objects.size() > index ? this.objects.get(index) : null;
        return oldSelected;
    }

    @Override
    public int getSize() {
        return this.objects.size();
    }

    @Override
    public Object getElementAt(int index) {
        return index >= 0 && index < this.objects.size() ? this.objects.get(index) : null;
    }
}

