/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.client.SheetContainerClient;
import java.util.HashMap;

public class RptContainerClient {
    public static final int CACHESIZE = 5;
    public static final String CACHENAME = "$RptContainerClient$";
    public static final String RPTINFOTYPE = "0758F09F";
    public static final String CSLINFOTYPE = "B712EA2C";
    private HashMap cache = new HashMap(5);
    private IReport rptFactory = null;
    private ICslReport clsrptFactory = null;

    private RptContainerClient() {
    }

    public static RptContainerClient getInstance() {
        RptContainerClient res = (RptContainerClient)SysContext.getSysContext().getProperty((Object)CACHENAME);
        if (res == null) {
            res = new RptContainerClient();
            SysContext.getSysContext().setProperty((Object)CACHENAME, (Object)res);
        }
        return res;
    }

    public SheetContainerClient getReport(String id) throws Exception {
        SheetContainerClient res;
        String hash = this.getHashValue(id);
        if (id != null && id.indexOf(64) != -1) {
            id = id.substring(0, id.indexOf(64));
        }
        if ((res = this.findInCache(hash)) != null) {
            res.upgrade();
            return res;
        }
        ReportBaseInfo rpt = this.getReportRaw(id);
        if (rpt != null) {
            res = new SheetContainerClient(rpt);
            this.cacheUp(hash, res);
        }
        return res;
    }

    private ReportBaseInfo getReportRaw(String id) throws Exception {
        ReportInfo res = null;
        String type = BOSUuid.getBOSObjectType((String)id, (boolean)false).toString();
        if (RPTINFOTYPE.equals(type)) {
            if (this.rptFactory == null) {
                this.rptFactory = ReportFactory.getRemoteInstance();
            }
            if (this.rptFactory != null) {
                res = this.rptFactory.getReportInfo((IObjectPK)new ObjectStringPK("id", id));
            }
        } else if (CSLINFOTYPE.equals(type)) {
            if (this.clsrptFactory == null) {
                this.clsrptFactory = CslReportFactory.getRemoteInstance();
            }
            if (this.clsrptFactory != null) {
                res = this.clsrptFactory.getCslReportInfo((IObjectPK)new ObjectStringPK("id", id));
            }
        }
        return res;
    }

    private SheetContainerClient cacheUp(String key, SheetContainerClient data) {
        SheetContainerClient older = this.cache.put(key, data);
        if (older == null && this.cache.size() >= 5) {
            this.retire(key);
        }
        return older;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retire(String key) {
        String aim = null;
        int minLevel = Integer.MAX_VALUE;
        for (String k : this.cache.keySet()) {
            if (k == null || k.equals(key)) continue;
            SheetContainerClient rpt = (SheetContainerClient)this.cache.get(k);
            if (rpt == null) {
                aim = k;
                break;
            }
            if (rpt.getLevel() > minLevel) continue;
            minLevel = rpt.getLevel();
            aim = k;
        }
        if (aim != null) {
            HashMap hashMap = this.cache;
            synchronized (hashMap) {
                this.cache.remove(aim);
            }
        }
    }

    private SheetContainerClient findInCache(String key) {
        return (SheetContainerClient)this.cache.get(key);
    }

    private String getHashValue(String key) {
        return key;
    }
}

