/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.HelpBasicData;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.AbstractRptContentFinderUI;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.ISimpleDialogListener;
import com.kingdee.eas.fi.rpt.client.ReportProcessUI;
import com.kingdee.eas.fi.rpt.client.RptContentFindTabUI;
import com.kingdee.eas.fi.rpt.client.RptContentReplaceTabUI;
import com.kingdee.eas.fi.rpt.client.RptFinderMode;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RptContentFinderUI
extends AbstractRptContentFinderUI
implements ISimpleDialog {
    private ArrayList listeners;
    protected RptFinderMode mode;
    protected RptContentFindTabUI tabFind = new RptContentFindTabUI();
    protected RptContentReplaceTabUI tabReplace = new RptContentReplaceTabUI();
    protected VirtualSheetParamInfo editData;
    protected Vector findContentType;

    public static RptContentFinderUI getInstance(CoreUIObject parentUI) throws Exception {
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(RptContentFinderUI.class.getName(), (Map)new UIContext((Object)parentUI));
        RptContentFinderUI res = (RptContentFinderUI)wnd.getUIObject();
        res.onShow();
        return res;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.initializeUI();
    }

    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setDefaultButton(this, (JButton)this.btnOk);
        RptHelper.setEscAction(this, (Action)((Object)this.actionBtnCancel));
        RptHelper.registF1Action(this, (Action)((Object)this.actionHelp));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        ReportProcessUI owner = (ReportProcessUI)((Object)this.getUIContext().get("Owner"));
        this.editData = owner.getEditData();
        int itemCount = this.cbxType.getItemCount();
        this.findContentType = new Vector(3);
        for (int i = 0; i < itemCount; ++i) {
            this.findContentType.add(this.cbxType.getItemAt(i));
        }
    }

    @Override
    public void open(Object cookie, String title) {
        this.fireListenersSetout();
        this.setMode((RptFinderMode)cookie);
        IUIWindow w = this.getUIWindow();
        if (w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            if (title != null) {
                d.setTitle(title);
            }
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RptContentFinderUI.this.endWizard(false);
                }
            });
        }
        w.show();
    }

    private void endWizard(boolean isOk) {
        this.disposeUIWindow();
        this.fireListenersReturnee(this.getMode(), isOk);
    }

    private void initializeUI() {
        this.listeners = new ArrayList(1);
        this.tabContent.add((Component)((Object)this.tabFind));
        this.tabContent.add((Component)((Object)this.tabReplace));
        this.setMode(null);
        this.tabContent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RptContentFinderUI.this.updateFindContent();
            }
        });
        RptHelper.setDefaultButton(this, (JButton)this.btnOk);
    }

    @Override
    public synchronized void addSimpleDialogListener(ISimpleDialogListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void fireListenersReturnee(Object content, boolean isOk) {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotReturnee(this, content, isOk);
        }
    }

    private void fireListenersSetout() {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotSetout(this);
        }
    }

    public RptFinderMode getMode() {
        this.updateMode();
        return this.mode;
    }

    private void updateMode() {
        this.setModeInternal(this.mode);
        this.mode.setFindWhat(this.getFindWhat());
        this.mode.setFindLine(this.getFindLine());
        this.mode.setReplaceWhat(this.tabReplace.getReplaceWhat());
        this.mode.setReplaceLine(this.tabReplace.getReplaceLine());
        this.mode.setModRange(this.cbxRange.getSelectedIndex());
        this.mode.setModSort(this.cbxSort.getSelectedIndex());
        this.mode.setModType(this.cbxType.getSelectedIndex());
        this.mode.setMatchCase(this.btnMatchCase.isSelected());
        this.mode.setMatchContent(this.btnMatchFull.isSelected());
        this.mode.setMatchRegular(this.btnMatchRegular.isSelected());
        int status = this.tabContent.getSelectedIndex();
        if (status < 0) {
            status = 0;
        }
        this.mode.setModAction(status);
    }

    private void updateFindContent() {
        if (this.tabContent.getSelectedIndex() == 0) {
            this.tabFind.setFindWhat(this.tabReplace.getFindWhat());
            this.tabFind.setFindLine(this.tabReplace.getFindLine());
            this.tabReplace.getReplaceWhat();
            this.setReplaceEnable(false);
            this.cbxType.removeAllItems();
            this.cbxType.addItems(this.findContentType);
        } else {
            this.tabReplace.setFindWhat(this.tabFind.getFindWhat());
            this.tabReplace.setFindLine(this.tabFind.getFindLine());
            this.setReplaceEnable(true);
            if (!CslRptUIUtil.isItemEditable((VirtualSheetParamInfo)this.editData)) {
                this.cbxType.removeAllItems();
                this.cbxType.addItems(this.findContentType);
                this.cbxType.removeItemAt(2);
            }
        }
    }

    private void setReplaceEnable(boolean isEnable) {
        this.btnReplace.setEnabled(isEnable);
        this.btnReplaceAll.setEnabled(isEnable);
    }

    public void setMode(RptFinderMode aMode) {
        this.setModeInternal(aMode);
        this.updateControls();
    }

    private void updateControls() {
        this.tabContent.setSelectedIndex(this.mode.getModAction());
        this.setReplaceEnable(this.mode.getModAction() == 1);
        this.setFindeWhat(this.mode.getFindWhat());
        this.setFindeLine(this.mode.getFindLine());
        this.tabReplace.setReplaceWhat(this.mode.getReplaceWhat());
        this.tabReplace.setReplaceLine(this.mode.getReplaceLine());
        this.cbxRange.setSelectedIndex(this.mode.getModRange());
        this.cbxSort.setSelectedIndex(this.mode.getModSort());
        this.cbxType.setSelectedIndex(this.mode.getModType());
        int status = this.mode.isMatchCase() ? 32 : 16;
        this.btnMatchCase.setSelected(status);
        status = this.mode.isMatchContent() ? 32 : 16;
        this.btnMatchFull.setSelected(status);
        status = this.mode.isMatchRegular() ? 32 : 16;
        this.btnMatchRegular.setSelected(status);
    }

    private void setFindeWhat(ArrayList what) {
        this.tabFind.setFindWhat(what);
        this.tabReplace.setFindWhat(what);
    }

    private void setFindeLine(String line) {
        this.tabFind.setFindLine(line);
        this.tabReplace.setFindLine(line);
    }

    private ArrayList getFindWhat() {
        return this.tabContent.getSelectedIndex() == 1 ? this.tabReplace.getFindWhat() : this.tabFind.getFindWhat();
    }

    private String getFindLine() {
        return this.tabContent.getSelectedIndex() == 1 ? this.tabReplace.getFindLine() : this.tabFind.getFindLine();
    }

    private void setModeInternal(RptFinderMode aMode) {
        this.mode = aMode == null ? new RptFinderMode() : aMode;
        this.mode.setUI(this);
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnCancel_actionPerformed(e);
        this.endWizard(true);
    }

    @Override
    public void actionFindNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionFindNext_actionPerformed(e);
        this.getMode().findNext();
    }

    @Override
    public void actionFindPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionFindPre_actionPerformed(e);
        this.getMode().findPre();
    }

    @Override
    public void actionReplace_actionPerformed(ActionEvent e) throws Exception {
        super.actionReplace_actionPerformed(e);
        this.getMode().replace();
    }

    @Override
    public void actionReplaceAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionReplaceAll_actionPerformed(e);
        this.getMode().replaceAll();
    }

    @Override
    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
        CSH.setHelpIDString((Component)((Component)e.getSource()), (String)"fatempClassAttribute");
        CSH.DisplayHelpFromSource help = new CSH.DisplayHelpFromSource(HelpBasicData.getInstance().getHelpBroker());
        help.actionPerformed(e);
    }
}

