/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.client.AbstractRptDataTop10FilterUI;
import com.kingdee.eas.fi.rpt.rptdata.StatusFilterItemInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class RptDataTop10FilterUI
extends AbstractRptDataTop10FilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptDataTop10FilterUI.class);
    private static final String SELECT_ALL = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");

    public void onLoad() throws Exception {
        super.onLoad();
        this.comboRptPeriodType.insertItemAt((Object)SELECT_ALL, 0);
        this.comboRptPeriodType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDComboBox thiz = (KDComboBox)e.getSource();
                Object periodType = thiz.getSelectedItem();
                int minPeriod = 1;
                int maxPeriod = 366;
                maxPeriod = RptPeriodTypeEnum.DAILY.equals(periodType) ? 366 : (RptPeriodTypeEnum.WEEKLY.equals(periodType) ? 53 : (RptPeriodTypeEnum.MONTHLY.equals(periodType) ? 99 : (RptPeriodTypeEnum.QUARTERLY.equals(periodType) ? 9 : (RptPeriodTypeEnum.SEMIYEARLY.equals(periodType) ? 2 : (RptPeriodTypeEnum.YEARLY.equals(periodType) ? 1 : 366)))));
                RptDataTop10FilterUI.setSpineRange(RptDataTop10FilterUI.this.txtRptStartPeriod, minPeriod, maxPeriod, false);
                RptDataTop10FilterUI.setSpineRange(RptDataTop10FilterUI.this.txtRptEndPeriod, minPeriod, maxPeriod, false);
            }
        });
        this.radioOrderByCalcNum.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (RptDataTop10FilterUI.this.entityViewInfo == null) {
                    return;
                }
                RptDataTop10FilterUI.this.entityViewInfo.getSorter().clear();
            }
        });
        this.radioOrderByTimeDiff.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (RptDataTop10FilterUI.this.entityViewInfo == null) {
                    return;
                }
                RptDataTop10FilterUI.this.entityViewInfo.getSorter().clear();
            }
        });
        this.comboTopNum.addItems((Object[])new Integer[]{10, 50, 100, 200});
        this.clear();
    }

    public FilterInfo getFilterInfo() {
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        StringBuffer sbFormula = new StringBuffer();
        int formulaIndex = -1;
        Object currCtrlValue = null;
        currCtrlValue = this.dpCalcStartTime.getValue();
        if (currCtrlValue != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("calcStartTime", currCtrlValue, CompareType.GREATER_EQUALS));
            sbFormula.append(" and #" + ++formulaIndex);
        }
        if ((currCtrlValue = this.dpCalcEndTime.getValue()) instanceof Date) {
            Date endTime = (Date)currCtrlValue;
            endTime.getTime();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(endTime);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            this.filterInfo.getFilterItems().add(new FilterItemInfo("calcStartTime", (Object)calendar.getTime(), CompareType.LESS_EQUALS));
            sbFormula.append(" and #" + ++formulaIndex);
        }
        String greatStartYearMaskFlag = "";
        String equalStartYearMaskFlag = "";
        String lessEndYearMaskFlag = "";
        String equalEndYearMaskFlag = "";
        String greatEqualStartPeriodMaskFlag = "";
        String lessEqualEndPeriodMaskFlag = "";
        currCtrlValue = this.txtRptStartYear.getValue(Integer.class);
        if (currCtrlValue != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("rptYear", currCtrlValue, CompareType.GREATER));
            greatStartYearMaskFlag = "#" + ++formulaIndex;
            this.filterInfo.getFilterItems().add(new FilterItemInfo("rptYear", currCtrlValue, CompareType.EQUALS));
            equalStartYearMaskFlag = "#" + ++formulaIndex;
        }
        if ((currCtrlValue = this.txtRptStartPeriod.getValue(Integer.class)) != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("rptPeriod", currCtrlValue, CompareType.GREATER_EQUALS));
            greatEqualStartPeriodMaskFlag = "#" + ++formulaIndex;
        }
        if ((currCtrlValue = this.txtRptEndYear.getValue(Integer.class)) != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("rptYear", currCtrlValue, CompareType.LESS));
            lessEndYearMaskFlag = "#" + ++formulaIndex;
            this.filterInfo.getFilterItems().add(new FilterItemInfo("rptYear", currCtrlValue, CompareType.EQUALS));
            equalEndYearMaskFlag = "#" + ++formulaIndex;
        }
        if ((currCtrlValue = this.txtRptEndPeriod.getValue(Integer.class)) != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("rptPeriod", currCtrlValue, CompareType.LESS_EQUALS));
            lessEqualEndPeriodMaskFlag = "#" + ++formulaIndex;
        }
        if (!("".equals(greatStartYearMaskFlag) || "".equals(lessEndYearMaskFlag) || "".equals(greatEqualStartPeriodMaskFlag) || "".equals(lessEqualEndPeriodMaskFlag))) {
            sbFormula.append(MessageFormat.format(" and ({0} OR ({1} and {2})) and ({3} OR ({4} and {5})) ", greatStartYearMaskFlag, equalStartYearMaskFlag, greatEqualStartPeriodMaskFlag, lessEndYearMaskFlag, equalEndYearMaskFlag, lessEqualEndPeriodMaskFlag));
        }
        if ((currCtrlValue = this.comboRptPeriodType.getSelectedItem()) != null && currCtrlValue != SELECT_ALL) {
            this.filterInfo.appendFilterItem("rptPeriodType", (Object)((RptPeriodTypeEnum)currCtrlValue).getValue());
            sbFormula.append(" and #" + ++formulaIndex);
        }
        if ((currCtrlValue = this.comboTopNum.getSelectedItem()) != null) {
            this.filterInfo.getFilterItems().add((FilterItemInfo)new StatusFilterItemInfo("rptTopNum", "" + currCtrlValue));
            sbFormula.append(" and #" + ++formulaIndex);
        }
        if (Boolean.TRUE.equals(currCtrlValue = Boolean.valueOf(this.radioOrderByTimeDiff.isSelected()))) {
            this.filterInfo.getFilterItems().add((FilterItemInfo)new StatusFilterItemInfo("OrderStyle", "OrderByTimeDiff"));
            sbFormula.append(" and #" + ++formulaIndex);
        }
        if (Boolean.TRUE.equals(currCtrlValue = Boolean.valueOf(this.radioOrderByCalcNum.isSelected()))) {
            this.filterInfo.getFilterItems().add((FilterItemInfo)new StatusFilterItemInfo("OrderStyle", "OrderByCalcNum"));
            sbFormula.append(" and #" + ++formulaIndex);
        }
        this.filterInfo.setMaskString(sbFormula.substring(" and".length()));
        logger.info((Object)("[rptData]filter:" + this.filterInfo.toSql()));
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo ev) {
        this.clearUI();
        super.loadData(ev);
        FilterItemCollection filters = ev.getFilter().getFilterItems();
        FilterItemInfo filterItemInfo = null;
        boolean orderByCalcNum = false;
        for (int i = 0; i < filters.size(); ++i) {
            filterItemInfo = filters.get(i);
            if (RptDataTop10FilterUI.filterEquals(filterItemInfo, "calcStartTime", CompareType.GREATER_EQUALS)) {
                this.dpCalcStartTime.setValue(filterItemInfo.getCompareValue());
                continue;
            }
            if (RptDataTop10FilterUI.filterEquals(filterItemInfo, "calcStartTime", CompareType.LESS_EQUALS)) {
                this.dpCalcEndTime.setValue(filterItemInfo.getCompareValue());
                continue;
            }
            if (RptDataTop10FilterUI.filterEquals(filterItemInfo, "rptYear", CompareType.GREATER)) {
                this.txtRptStartYear.setValue(filterItemInfo.getCompareValue());
                continue;
            }
            if (RptDataTop10FilterUI.filterEquals(filterItemInfo, "rptYear", CompareType.LESS)) {
                this.txtRptEndYear.setValue(filterItemInfo.getCompareValue());
                continue;
            }
            if (RptDataTop10FilterUI.filterEquals(filterItemInfo, "rptPeriod", CompareType.GREATER_EQUALS)) {
                this.txtRptStartPeriod.setValue(filterItemInfo.getCompareValue());
                continue;
            }
            if (RptDataTop10FilterUI.filterEquals(filterItemInfo, "rptPeriod", CompareType.LESS_EQUALS)) {
                this.txtRptEndPeriod.setValue(filterItemInfo.getCompareValue());
                continue;
            }
            if (RptDataTop10FilterUI.filterEquals(filterItemInfo, "rptPeriodType", null)) {
                this.comboRptPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.getEnum((int)((Integer)filterItemInfo.getCompareValue())));
                continue;
            }
            if (RptDataTop10FilterUI.filterEquals(filterItemInfo, "rptTopNum", null)) {
                this.comboTopNum.setSelectedItem((Object)Integer.parseInt((String)filterItemInfo.getCompareValue()));
                continue;
            }
            if (!this.statusFilterEquals(filterItemInfo, "OrderStyle", "OrderByCalcNum")) continue;
            orderByCalcNum = true;
        }
        this.radioOrderByTimeDiff.setSelected(!orderByCalcNum);
        this.radioOrderByCalcNum.setSelected(orderByCalcNum);
    }

    private boolean statusFilterEquals(FilterItemInfo filterItemInfo, String statusKey, String statusValue) {
        return new StatusFilterItemInfo(statusKey, statusValue).toString().equals(filterItemInfo.toString());
    }

    private static boolean filterEquals(FilterItemInfo filterItemInfo, String propName, CompareType propCompType) {
        if (propName == null) {
            return false;
        }
        boolean isEquals = propName.equalsIgnoreCase(filterItemInfo.getPropertyName());
        if (propCompType != null) {
            isEquals = isEquals && propCompType.equals((Object)filterItemInfo.getCompareType());
        }
        return isEquals;
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    private void clearUI() {
        this.radioOrderByTimeDiff.setSelected(true);
        this.radioOrderByCalcNum.setSelected(false);
        RptDataTop10FilterUI.setSpineRange(this.txtRptStartYear, 1900, 2999, false);
        RptDataTop10FilterUI.setSpineRange(this.txtRptEndYear, 1900, 2999, false);
        RptDataTop10FilterUI.setSpineRange(this.txtRptStartPeriod, 1, 366, false);
        RptDataTop10FilterUI.setSpineRange(this.txtRptEndPeriod, 1, 366, false);
        Calendar calendar = Calendar.getInstance();
        int currYear = calendar.get(1);
        int currMonth = calendar.get(2) + 1;
        this.txtRptStartYear.setValue((Object)currYear);
        this.txtRptEndYear.setValue((Object)currYear);
        this.txtRptStartPeriod.setValue((Object)currMonth);
        this.txtRptEndPeriod.setValue((Object)currMonth);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        this.dpCalcEndTime.setValue((Object)calendar.getTime());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.add(2, -1);
        this.dpCalcStartTime.setValue((Object)calendar.getTime());
        this.comboRptPeriodType.setSelectedItem((Object)SELECT_ALL);
        this.comboTopNum.setSelectedItem((Object)10);
    }

    public static void setSpineRange(KDSpinner sp, int minVal, int maxVal, boolean isReset) {
        Integer n;
        if (sp == null) {
            return;
        }
        SpinnerModel sm = sp.getModel();
        if (!(sm instanceof SpinnerNumberModel)) {
            return;
        }
        SpinnerNumberModel nm = (SpinnerNumberModel)sm;
        int oldVal = (Integer)nm.getValue();
        try {
            n = new Integer(maxVal);
            nm.setMaximum(n);
            if (n < 0 && isReset) {
                nm.setValue(n);
            }
        }
        catch (NumberFormatException e) {
            logger.debug((Object)e.getMessage());
        }
        try {
            n = new Integer(minVal);
            nm.setMinimum(n);
            if (n > 0 && isReset) {
                nm.setValue(n);
            }
        }
        catch (NumberFormatException e) {
            logger.debug((Object)e.getMessage());
        }
        if (oldVal > maxVal) {
            nm.setValue(new Integer(maxVal));
        } else if (oldVal < minVal) {
            nm.setValue(new Integer(minVal));
        }
    }
}

