/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.api.IRptContextManager;
import com.kingdee.eas.fi.rpt.client.FormulaPickerUI;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.IFormulaPickerListener;
import com.kingdee.eas.fi.rpt.client.IFormulaWizardListener;
import com.kingdee.eas.fi.rpt.client.IRptLockListener;
import com.kingdee.eas.fi.rpt.client.ReportProcessUI;
import com.kingdee.eas.fi.rpt.client.RptFormula;
import com.kingdee.eas.fi.rpt.client.RptFormulaComp;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.client.RptTablePane;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public final class RptFormulaBar
extends KDPanel {
    private ResourceBundleHelper resHelper;
    boolean isChangingByTable;
    private List listeners;
    private boolean isBudget = false;
    RptTablePane tblPane;
    KDComboBox cbxIndex;
    private KDWorkButton btnFormula;
    private KDWorkButton btnItem;
    private KDTextField txtFormula;
    KDTextField txtItem;
    private JPanel pnlFormula;
    private JPanel pnlItem;
    private KDSplitPane pnlFunction;
    boolean isInPicking;
    boolean alwaysLock = false;
    FormulaLineListener fl;
    ItemLineListener il;
    RangeListener rl;
    PickerListener pickerListener = new PickerListener();
    WizardListener wizardListener = new WizardListener();
    private boolean isItemEnabled = true;

    public RptFormulaBar() {
        super(null, true);
        this.initialize();
    }

    public boolean getBudget() {
        return this.isBudget;
    }

    public void setBudget(boolean isBudget) {
        this.isBudget = isBudget;
    }

    public void setFocus() {
        RptHelper.setFocusTo((Component)this.txtFormula);
    }

    private void initialize() {
        this.isChangingByTable = false;
        this.tblPane = null;
        this.resHelper = new ResourceBundleHelper(RptFormulaBar.class.getName());
        this.cbxIndex = new KDComboBox();
        this.btnFormula = new KDWorkButton();
        this.btnItem = new KDWorkButton();
        this.txtFormula = new KDTextField();
        this.txtItem = new KDTextField();
        this.pnlFormula = new JPanel(null);
        this.pnlItem = new JPanel(null);
        this.pnlFunction = new KDSplitPane();
        Point pt = new Point();
        Dimension dm = new Dimension();
        pt.move(2, 0);
        dm.setSize(130, 20);
        this.cbxIndex.setBounds(pt.x, pt.y, dm.width, dm.height);
        this.cbxIndex.setToolTipText(this.resHelper.getString("cbxIndex.toolTipText"));
        this.cbxIndex.setEditable(true);
        JTextField cft = (JTextField)this.cbxIndex.getEditor().getEditorComponent();
        cft.setHorizontalAlignment(0);
        this.rl = new RangeListener();
        this.cbxIndex.getEditor().addActionListener(this.rl);
        JPanel pnl = null;
        JLabel lbl = null;
        pt.setLocation(2, 0);
        dm.setSize(70, 20);
        lbl = new JLabel();
        lbl.setBounds(pt.x, pt.y, dm.width, dm.height);
        lbl.setText(this.resHelper.getString("btnFormula.Text"));
        lbl.setHorizontalAlignment(4);
        pt.setLocation(70, 0);
        dm.setSize(20, 20);
        this.btnFormula.setBounds(pt.x, pt.y, dm.width, dm.height);
        this.btnFormula.setToolTipText(this.resHelper.getString("btnFormula.toolTipText"));
        dm.setSize(90, 20);
        pnl = new JPanel(null);
        pnl.setPreferredSize(new Dimension(dm));
        pnl.add(lbl);
        pnl.add((Component)this.btnFormula);
        dm.setSize(300, 20);
        this.txtFormula.setPreferredSize(new Dimension(dm));
        this.fl = new FormulaLineListener();
        this.txtFormula.getDocument().addDocumentListener(this.fl);
        this.txtFormula.addFocusListener((FocusListener)this.fl);
        this.txtFormula.addActionListener((ActionListener)this.fl);
        this.cbxIndex.addFocusListener((FocusListener)this.fl);
        this.cbxIndex.getEditor().getEditorComponent().addFocusListener(this.fl);
        dm.setSize(400, 20);
        this.pnlFormula.setPreferredSize(new Dimension(dm));
        this.pnlFormula.setLayout(new BorderLayout());
        this.pnlFormula.add((Component)pnl, "West");
        this.pnlFormula.add((Component)this.txtFormula, "Center");
        pt.setLocation(2, 0);
        dm.setSize(70, 20);
        lbl = new JLabel();
        lbl.setBounds(pt.x, pt.y, dm.width, dm.height);
        lbl.setText(this.resHelper.getString("btnItem.Text"));
        lbl.setHorizontalAlignment(4);
        pt.setLocation(70, 0);
        dm.setSize(20, 20);
        this.btnItem.setBounds(pt.x, pt.y, dm.width, dm.height);
        dm.setSize(90, 20);
        pnl = new JPanel(null);
        pnl.setPreferredSize(new Dimension(dm));
        pnl.add(lbl);
        pnl.add((Component)this.btnItem);
        dm.setSize(200, 20);
        this.txtItem.setPreferredSize(new Dimension(dm));
        this.il = new ItemLineListener();
        this.txtItem.getDocument().addDocumentListener(this.il);
        this.txtItem.addActionListener((ActionListener)this.il);
        this.txtItem.addFocusListener((FocusListener)this.il);
        dm.setSize(268, 20);
        this.pnlItem.setPreferredSize(new Dimension(dm));
        this.pnlItem.setLayout(new BorderLayout());
        this.pnlItem.add((Component)pnl, "West");
        this.pnlItem.add((Component)this.txtItem, "Center");
        dm.setSize(500, 20);
        this.pnlFunction.setPreferredSize(new Dimension(dm));
        this.pnlFunction.setLeftComponent((Component)this.pnlFormula);
        this.pnlFunction.setRightComponent((Component)this.pnlItem);
        this.pnlFunction.setContinuousLayout(false);
        this.pnlFunction.setOrientation(1);
        this.pnlFunction.setDividerSize(2);
        this.pnlFunction.setDividerLocation(550);
        this.pnlFunction.setBorder(null);
        this.pnlFunction.getActionMap().getParent().remove("startResize");
        dm.setSize(600, 20);
        this.setPreferredSize(dm);
        this.setLayout(new BorderLayout());
        this.add((Component)this.cbxIndex, "West");
        this.add((Component)this.pnlFunction, "Center");
        this.btnFormula.setIcon(RptResourceHelper.getIcon("imgTbtn_amountsign"));
        this.btnItem.setIcon(RptResourceHelper.getIcon("imgTbtn_amountsign"));
        this.listeners = new ArrayList(1);
    }

    public synchronized void addFormulaBarLockListener(IRptLockListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void fireFormulaBarLockListeners(boolean isLock) {
        for (IRptLockListener l : this.listeners) {
            if (l == null) continue;
            l.setLock(isLock);
        }
    }

    public void pickFormula(CoreUIObject parent) throws Exception {
        if (this.tblPane == null || !this.tblPane.canPickFormula(true)) {
            return;
        }
        List<Object> hints = null;
        FormulaHint hint = null;
        RptFormula fm = null;
        String txt = this.txtFormula.getText();
        try {
            ICell cell;
            hints = TableToolkit.parseExcelFormula(txt, true);
            if ((hints == null || hints.size() < 1) && (cell = this.tblPane.getFoucusCell()) != null) {
                txt = cell.getExpressions();
                hints = TableToolkit.parseExcelFormula(txt, true);
            }
        }
        catch (ParserException e) {
            hints = new ArrayList<FormulaHint>(1);
            hints.add(TableToolkit.parseFormula(txt));
        }
        if (hints != null && hints.size() > 0) {
            hint = (FormulaHint)hints.get(hints.size() - 1);
            fm = RptFormulaComp.getInstance().getFormula(hint.name);
        }
        if (hint != null && fm != null && hints.size() < 2) {
            FormulaWizardUI wizard = FormulaWizardUI.creatFormulaWizard((String)fm.wizard, (Object)parent);
            wizard.addFormulaWizardListener((IFormulaWizardListener)this.wizardListener);
            wizard.setUserObject((Object)this.txtFormula);
            wizard.setRptContext((IRptContextManager)((ReportProcessUI)parent).getContext());
            wizard.open(hint.name, hint);
        } else {
            FormulaPickerUI picker = FormulaPickerUI.creatFormulaPicker(parent);
            picker.addFormulaPickerListener(this.pickerListener);
            boolean showAdvn = hints != null;
            picker.setUserObject(this.txtFormula);
            picker.setRptContext(((ReportProcessUI)parent).getContext());
            picker.setFormulaLine(txt);
            if (this.isBudget) {
                picker.open("exclude:formulas{BgItem,BgAct,Item, FpItem,DItem};exclude:categorys{fm_fp}", showAdvn, null);
            } else {
                picker.open("exclude:formulas{BgItem,BgFormula,Item,FpItem,DItem};exclude:categorys{fm_fp}", showAdvn, null);
            }
        }
    }

    public void pickItemFormula(String funcName, CoreUIObject parent) throws Exception {
        if (this.tblPane == null || !this.tblPane.canPickFormula(false)) {
            return;
        }
        RptFormula rptFormula = RptFormulaComp.getInstance().getFormula(funcName);
        FormulaWizardUI wizard = null;
        wizard = rptFormula == null ? FormulaWizardUI.creatFormulaWizard((Object)parent) : FormulaWizardUI.creatFormulaWizard((String)rptFormula.wizard, (Object)parent);
        wizard.addFormulaWizardListener((IFormulaWizardListener)this.wizardListener);
        wizard.setUserObject((Object)this.txtItem);
        wizard.open(funcName, TableToolkit.parseFormula(this.txtItem.getText()));
    }

    public void setLogger(Logger logger) {
    }

    public void setFormulaAction(Action action) {
        this.btnFormula.setAction(action);
        this.btnFormula.setText(null);
    }

    public void setItemAction(Action action) {
        this.btnItem.setAction(action);
        this.btnItem.setText(null);
    }

    public void beginEdit() {
        this.isChangingByTable = true;
        this.txtFormula.setText("");
    }

    public void setFormulaLine(String line) {
        this.isChangingByTable = true;
        this.txtFormula.setText(line);
    }

    public void setItemLine(String line) {
        if (line != null && !line.trim().equals("") && this.isBudget) {
            FormulaHint hint;
            String[] params;
            List list = new ArrayList();
            try {
                list = TableToolkit.parseExcelFormula(line, false);
            }
            catch (ParserException parserException) {
                // empty catch block
            }
            if (list == null || list.isEmpty()) {
                // empty if block
            }
            if ((params = (hint = (FormulaHint)list.get(0)).getParams()).length == 6 && hint.name.equalsIgnoreCase("BgItem")) {
                line = "=BgItem(\"" + params[0] + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[5] + "\")";
            }
        }
        this.isChangingByTable = true;
        if (line == null) {
            line = "";
        }
        this.txtItem.setText(line);
    }

    public void endEdit() {
        this.isChangingByTable = false;
    }

    void setItemFormulaLine(DocumentEvent event) {
        if (this.isChangingByTable || this.tblPane == null) {
            return;
        }
        String line = this.txtItem.getText().trim();
        if (line != null && !line.trim().equals("") && this.isBudget) {
            List list = new ArrayList();
            try {
                list = TableToolkit.parseExcelFormula(line, false);
            }
            catch (ParserException e1) {
                return;
            }
            if (list == null || list.isEmpty()) {
                return;
            }
            FormulaHint hint = (FormulaHint)list.get(0);
            String[] params = hint.getParams();
            if (params.length == 4 && hint.name.equalsIgnoreCase("BgItem")) {
                line = "=BgItem(\"" + params[0] + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"BgData\",true,\"" + params[3] + "\")";
            }
        }
        this.tblPane.setItemLine(line);
    }

    void setFormulaLine(DocumentEvent event) {
        if (this.isChangingByTable || this.tblPane == null) {
            return;
        }
        this.tblPane.setFormulaLine(this.txtFormula.getText());
    }

    public void setTblPane(RptTablePane pane) {
        this.tblPane = pane;
        this.btnFormula.setIcon(RptResourceHelper.getIcon("imgTbtn_amountsign"));
        this.btnItem.setIcon(RptResourceHelper.getIcon("imgTbtn_amountsign"));
    }

    public void setLocked(boolean isLocked) {
        if (this.alwaysLock) {
            this.txtFormula.setEditable(false);
            this.btnFormula.setEnabled(false);
            this.txtItem.setEditable(false);
            this.btnItem.setEnabled(false);
            return;
        }
        this.txtFormula.setEditable(!isLocked);
        this.btnFormula.setEnabled(!isLocked);
        if (this.isItemEnabled) {
            this.txtItem.setEditable(!isLocked);
            this.btnItem.setEnabled(!isLocked);
        }
        this.fireFormulaBarLockListeners(isLocked);
    }

    public void setCurrentRange(String range) {
        this.cbxIndex.getEditor().setItem(range);
    }

    public void setItemEnabled(boolean isEnable) {
        this.isItemEnabled = isEnable;
        this.txtItem.setEditable(this.isItemEnabled);
        this.btnItem.setEnabled(this.isItemEnabled);
    }

    public void setFormulaEnabled(boolean isEnable) {
        this.txtFormula.setEditable(isEnable);
        this.btnFormula.setEnabled(isEnable);
    }

    public boolean getItemEnabled() {
        return this.isItemEnabled;
    }

    public boolean isAlwaysLock() {
        return this.alwaysLock;
    }

    public void setAlwaysLock(boolean alwaysLock) {
        this.alwaysLock = alwaysLock;
        this.setLocked(true);
    }

    public KDTextField getTxtFormula() {
        return this.txtFormula;
    }

    public KDTextField getTxtItem() {
        return this.txtItem;
    }

    public void removeNotify() {
        this.txtFormula.getDocument().removeDocumentListener(this.fl);
        this.txtFormula.removeFocusListener((FocusListener)this.fl);
        this.txtFormula.removeActionListener((ActionListener)this.fl);
        this.cbxIndex.removeFocusListener((FocusListener)this.fl);
        this.cbxIndex.getEditor().getEditorComponent().removeFocusListener(this.fl);
        this.txtItem.getDocument().removeDocumentListener(this.il);
        this.txtItem.removeActionListener((ActionListener)this.il);
        this.txtItem.removeFocusListener((FocusListener)this.il);
        this.cbxIndex.getEditor().removeActionListener(this.rl);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            this.listeners.remove(0);
        }
        this.freeCaret((Component)((Object)this));
        super.removeNotify();
    }

    private void freeCaret(Component cmp) {
        JTextComponent text;
        Caret caret;
        if (cmp instanceof Container && cmp != null) {
            Container container = (Container)cmp;
            Component[] cmps = container.getComponents();
            for (int i = 0; cmps != null && i < cmps.length; ++i) {
                this.freeCaret(cmps[i]);
            }
        }
        if (cmp instanceof JTextComponent && (caret = (text = (JTextComponent)cmp).getCaret()) != null) {
            caret.deinstall(text);
        }
    }

    private class ItemLineListener
    implements FocusListener,
    ActionListener,
    DocumentListener {
        private ItemLineListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String line = RptFormulaBar.this.txtItem.getText();
            if (StringUtils.isEmpty((String)line) || !this.justEditPermission()) {
                return;
            }
            RptFormulaBar.this.tblPane.beginEdit();
            RptFormulaBar.this.tblPane.setItemLine(line);
            RptFormulaBar.this.tblPane.endEdit();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            RptFormulaBar.this.setItemFormulaLine(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            RptFormulaBar.this.setItemFormulaLine(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            RptFormulaBar.this.setItemFormulaLine(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (RptFormulaBar.this.tblPane != null) {
                RptFormulaBar.this.isChangingByTable = true;
                RptFormulaBar.this.tblPane.endEdit();
            }
        }

        private boolean justEditPermission() {
            if (RptFormulaBar.this.tblPane == null || !RptFormulaBar.this.tblPane.canPickFormula(false)) {
                RptFormulaBar.this.txtItem.setText(null);
                return false;
            }
            return true;
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (RptFormulaBar.this.tblPane != null) {
                RptFormulaBar.this.isChangingByTable = false;
                RptFormulaBar.this.tblPane.beginEdit();
            }
            JTextField jtf = (JTextField)RptFormulaBar.this.cbxIndex.getEditor().getEditorComponent();
            if (e.getSource() == jtf) {
                jtf.selectAll();
            }
        }
    }

    private class FormulaLineListener
    implements DocumentListener,
    FocusListener,
    ActionListener {
        private FormulaLineListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            RptFormulaBar.this.setFormulaLine(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            RptFormulaBar.this.setFormulaLine(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (!RptFormulaBar.this.isInPicking) {
                RptFormulaBar.this.setFormulaLine(e);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (RptFormulaBar.this.tblPane != null) {
                RptFormulaBar.this.isChangingByTable = false;
                RptFormulaBar.this.tblPane.beginEdit();
            }
            JTextField jtf = (JTextField)RptFormulaBar.this.cbxIndex.getEditor().getEditorComponent();
            if (e.getSource() == jtf) {
                jtf.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (RptFormulaBar.this.tblPane != null) {
                RptFormulaBar.this.isChangingByTable = true;
                RptFormulaBar.this.tblPane.endEdit();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!RptFormulaBar.this.isChangingByTable && RptFormulaBar.this.tblPane != null) {
                RptFormulaBar.this.tblPane.endEdit();
            }
        }
    }

    public static class FeedBack {
        public int status;
        public String text;
    }

    private class RangeListener
    implements ActionListener {
        private RangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!RptFormulaBar.this.isChangingByTable && RptFormulaBar.this.tblPane != null) {
                RptFormulaBar.this.tblPane.setSelectRange((String)RptFormulaBar.this.cbxIndex.getEditor().getItem());
            }
        }
    }

    private class WizardListener
    implements IFormulaWizardListener {
        private WizardListener() {
        }

        public void wizardSetout(FormulaWizardUI wizard) {
        }

        public void wizardReturnee(FormulaWizardUI wizard, String formulaLine, boolean isOk) {
            KDTextField fld = (KDTextField)wizard.getUserObject();
            if (isOk) {
                RptFormulaBar.this.isChangingByTable = false;
                RptFormulaBar.this.tblPane.beginEdit();
                RptFormulaBar.this.isInPicking = true;
                fld.setText("=" + formulaLine);
                RptFormulaBar.this.isInPicking = false;
                if (fld == RptFormulaBar.this.txtItem) {
                    String line = RptFormulaBar.this.txtItem.getText().trim();
                    if (line != null && !line.trim().equals("") && RptFormulaBar.this.isBudget) {
                        FormulaHint hint;
                        String[] params;
                        List list = new ArrayList();
                        try {
                            list = TableToolkit.parseExcelFormula(line, false);
                        }
                        catch (ParserException parserException) {
                            // empty catch block
                        }
                        if (list == null || list.isEmpty()) {
                            // empty if block
                        }
                        if ((params = (hint = (FormulaHint)list.get(0)).getParams()).length == 4 && hint.name.equalsIgnoreCase("BgItem")) {
                            line = "=BgItem(\"" + params[0] + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"BgData\",true,\"" + params[3] + "\")";
                        }
                    }
                    RptFormulaBar.this.tblPane.setItemLine(line);
                }
                RptFormulaBar.this.isChangingByTable = true;
                RptFormulaBar.this.tblPane.endEdit();
            }
            fld.requestFocus();
        }
    }

    private class PickerListener
    implements IFormulaPickerListener {
        private PickerListener() {
        }

        @Override
        public void pickerSetout(FormulaPickerUI picker) {
        }

        @Override
        public void pickerReturnee(FormulaPickerUI picker, String formulaLine, boolean isOk) {
            KDTextField fld = (KDTextField)picker.getUserObject();
            if (isOk) {
                RptFormulaBar.this.isChangingByTable = false;
                RptFormulaBar.this.tblPane.beginEdit();
                RptFormulaBar.this.isInPicking = true;
                fld.setText("=" + formulaLine);
                RptFormulaBar.this.isInPicking = false;
                RptFormulaBar.this.isChangingByTable = true;
                RptFormulaBar.this.tblPane.endEdit();
            }
            fld.requestFocus();
        }
    }
}

