/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.ReportImportModeEnum;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.client.AbstractRptImportSheetSelectorUI;
import com.kingdee.eas.fi.rpt.client.ReportProcessUI;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class RptImportSheetSelectorUI
extends AbstractRptImportSheetSelectorUI {
    private boolean isOKey;

    public RptImportSheetSelectorUI() throws Exception {
        this.toolBar = null;
        this.menuBar = null;
        this.dataObjects = null;
        this.dataBinder = null;
        this.statusBar = null;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.cbxStyle.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public static RptImportSheetSelectorUI getInstance(CoreUIObject parentUI) throws Exception {
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(RptImportSheetSelectorUI.class.getName(), (Map)new UIContext((Object)parentUI));
        RptImportSheetSelectorUI res = (RptImportSheetSelectorUI)wnd.getUIObject();
        res.onShow();
        return res;
    }

    public void open(List sheetName) {
        IUIWindow w = this.getUIWindow();
        if (w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    e.setSource(null);
                    RptImportSheetSelectorUI.this.endWizard(false);
                }
            });
        }
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearSelect.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.cbxStyle.setSelected(true);
        this.initTree(sheetName);
        this.applyStateByReportType();
        w.show();
    }

    private void applyStateByReportType() {
        ReportTypeEnum type;
        Object obj = this.getUIContext().get("Owner");
        if (obj instanceof ReportProcessUI && (type = ((ReportProcessUI)((Object)obj)).getReportType()) != null && type.getValue() == 1) {
            this.rbnImportValue.setEnabled(false);
        }
    }

    private void initTree(List sheetName) {
        if (sheetName == null) {
            sheetName = new ArrayList();
        }
        DefaultKingdeeTreeNode node = null;
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)RptUtil.getResourceSince51("AllSheets"));
        int j = sheetName.size();
        for (int i = 0; i < j; ++i) {
            node = new DefaultKingdeeTreeNode((Object)sheetName.get(i).toString());
            node.setChecked(true);
            root.add((MutableTreeNode)node);
        }
        this.treeSheets.setShowCheckBox(true);
        this.treeSheets.setRootVisible(false);
        this.treeSheets.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.treeSheets.setSyncChecked(true);
        this.treeSheets.setCollapsePathDisabled(true);
        this.treeSheets.setBorder(BorderFactory.createLineBorder(new Color(128, 128, 128), 1));
    }

    void endWizard(boolean isOk) {
        this.isOKey = isOk;
        this.disposeUIWindow();
    }

    @Override
    public void actionDeselectAllSheet_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeselectAllSheet_actionPerformed(e);
        this.checkAll(false);
    }

    @Override
    public void actionSelectAllSheet_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAllSheet_actionPerformed(e);
        this.checkAll(true);
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.endWizard(e != null && e.getSource() == this.btnOK);
    }

    public boolean isOKey() {
        return this.isOKey;
    }

    public int getImportOption() {
        ButtonModel bm = this.btnImportOption.getSelection();
        int options = 14;
        if (bm == this.rbnImportValue.getModel()) {
            options = 2;
        }
        if (bm == this.rbnImportFormula.getModel()) {
            options = 4;
        }
        if (this.cbxStyle.isSelected()) {
            options |= 1;
        }
        return options;
    }

    public ReportImportModeEnum getImportMode() {
        return (ReportImportModeEnum)((Object)this.comboImportMode.getSelectedItem());
    }

    public boolean isImportPostil() {
        return !this.chkImportPostil.isSelected();
    }

    public Map getSelectedSheets() {
        HashMap<String, Boolean> selectedSheets = new HashMap<String, Boolean>();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeSheets.getModel().getRoot();
        int j = root.getChildCount();
        for (int i = 0; i < j; ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.isChecked()) {
                selectedSheets.put(node.getUserObject().toString(), new Boolean(true));
                continue;
            }
            selectedSheets.put(node.getUserObject().toString(), new Boolean(false));
        }
        return selectedSheets;
    }

    private final void checkAll(boolean checkIt) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeSheets.getModel().getRoot();
        int j = root.getChildCount();
        for (int i = 0; i < j; ++i) {
            ((DefaultKingdeeTreeNode)root.getChildAt(i)).setChecked(checkIt);
        }
        this.treeSheets.repaint();
    }

    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setDefaultButton(this, (JButton)this.btnOK);
        RptHelper.setEscAction(this, (Action)((Object)this.actionExit));
    }
}

