/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.rpt.client.AbstractRptReportF7QueryUI;
import com.kingdee.eas.fi.rpt.client.RptComboBoxModel;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.swing.ComboBoxModel;

public class RptReportF7QueryUI
extends AbstractRptReportF7QueryUI {
    TreeMap yearMap = new TreeMap();
    Integer currentYear = null;
    Integer[] countWeek = new Integer[52];
    Integer[] countQuarterly = new Integer[4];
    Integer[] countSemiyYear = new Integer[2];
    Integer currentPeriod = null;
    HashMap filter = new HashMap();
    boolean isOK = false;
    int periodType;
    OrgType orgType = OrgType.Company;
    OrgUnitInfo orgUnitInfo = null;
    ActionListener periodListener = null;

    public RptReportF7QueryUI() throws Exception {
        this.prmpCompany.setEnabled(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initSelfUI();
        if (this.getUIContext().get("templateId") != null) {
            this.filter.put("templateId", this.getUIContext().get("templateId"));
        }
        if (this.getUIContext().get("templateGroup") != null) {
            this.filter.put("templateGroup", this.getUIContext().get("templateGroup"));
        }
        if (this.getUIContext().get("orgType") != null) {
            this.orgType = (OrgType)this.getUIContext().get("orgType");
        }
        if (this.getUIContext().get("periodType") != null) {
            this.filter.put("periodType", this.getUIContext().get("periodType"));
            switch (this.periodType) {
                case 1: {
                    this.labStartDate.setVisible(true);
                    this.labEndDate.setVisible(true);
                    break;
                }
                case 6: {
                    this.labyEndYear.setVisible(true);
                    this.labyStartYear.setVisible(true);
                    break;
                }
                default: {
                    this.labStart.setVisible(true);
                    this.labEnd.setVisible(true);
                    this.cbxStartYear.setVisible(true);
                    this.cbxEndYear.setVisible(true);
                    this.labStartYear.setVisible(true);
                    this.labEndYear.setVisible(true);
                    this.cbxEndYear.setVisible(true);
                    this.cbxStartYear.setVisible(true);
                    this.labFiscal.setVisible(true);
                    this.labEndFiscal.setVisible(true);
                }
            }
        }
    }

    public void initSelfUI() throws Exception {
        this.periodType = Integer.parseInt(this.getUIContext().get("periodType").toString());
        this.orgUnitInfo = (OrgUnitInfo)this.getUIContext().get("orgUnitInfo");
        PeriodCollection periodCollection = RptNewUIUtil.getFiscal((OrgUnitInfo)this.orgUnitInfo);
        if (periodCollection != null && periodCollection.size() > 0) {
            for (int i = 0; i < periodCollection.size(); ++i) {
                Integer year = new Integer(periodCollection.get(i).getPeriodYear());
                Integer period = new Integer(periodCollection.get(i).getPeriodNumber());
                ArrayList<Integer> periodVec = (ArrayList<Integer>)this.yearMap.get(year);
                if (periodVec == null) {
                    periodVec = new ArrayList<Integer>(12);
                    this.yearMap.put(year, periodVec);
                }
                periodVec.add(period);
            }
        }
        int[] yearAndPeriod = RptNewUIUtil.getFICurrPeriod((OrgUnitInfo)this.orgUnitInfo);
        this.currentYear = new Integer(yearAndPeriod[0]);
        this.currentPeriod = new Integer(yearAndPeriod[1]);
        if (this.yearMap.size() > 0) {
            this.cbxStartYear.setModel((ComboBoxModel)new RptComboBoxModel(this.yearMap.keySet().toArray(), false));
            this.cbxStartYear.setSelectedItem((Object)this.currentYear);
            this.cbxEndYear.setModel((ComboBoxModel)new RptComboBoxModel(this.yearMap.keySet().toArray(), false));
            this.cbxEndYear.setSelectedItem((Object)this.currentYear);
            if (this.periodListener != null) {
                this.cbxStartYear.removeActionListener(this.periodListener);
                this.cbxEndYear.removeActionListener(this.periodListener);
            }
            this.periodListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (arg0.getSource().equals(RptReportF7QueryUI.this.cbxStartYear)) {
                        RptReportF7QueryUI.this.cbxStartFiscal.setModel((ComboBoxModel)new RptComboBoxModel((List)RptReportF7QueryUI.this.yearMap.get(RptReportF7QueryUI.this.cbxStartYear.getSelectedItem())));
                    }
                    if (arg0.getSource().equals(RptReportF7QueryUI.this.cbxEndYear)) {
                        RptReportF7QueryUI.this.cbxEndFiscal.setModel((ComboBoxModel)new RptComboBoxModel((List)RptReportF7QueryUI.this.yearMap.get(RptReportF7QueryUI.this.cbxEndYear.getSelectedItem())));
                    }
                }
            };
            this.cbxStartYear.addActionListener(this.periodListener);
            this.cbxEndYear.addActionListener(this.periodListener);
            this.cbxStartYear.setSelectedItem(this.cbxStartYear.getSelectedItem());
            this.cbxEndYear.setSelectedItem(this.cbxEndYear.getSelectedItem());
            this.cbxStartFiscal.setSelectedItem((Object)this.currentPeriod);
            this.cbxEndFiscal.setSelectedItem((Object)this.currentPeriod);
        }
        this.prmpCompany.setData(this.orgUnitInfo == null ? SysContext.getSysContext().getCurrentCompany() : this.orgUnitInfo);
        this.prmpCompany.setDisplayFormat("$number$--$name$");
        this.prmpCompany.setEditFormat("$number$--$name$");
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void actionEnter_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmpCompany.getData() != null) {
            this.filter.put("company", ((OrgUnitInfo)this.prmpCompany.getData()).getId().toString());
        }
        if (this.periodType == 6) {
            this.filter.put("startYear", this.cbxyStartFiscal.getSelectedItem());
            this.filter.put("endYear", this.cbxyEndFiscal.getSelectedItem());
        } else {
            if (this.cbxStartYear.getSelectedItem() != null) {
                this.filter.put("startYear", this.cbxStartYear.getSelectedItem());
            }
            if (this.cbxEndYear.getSelectedItem() != null) {
                this.filter.put("endYear", this.cbxEndYear.getSelectedItem());
            }
        }
        if (this.cbxStartFiscal.getSelectedItem() != null) {
            this.filter.put("startFiscal", this.cbxStartFiscal.getSelectedItem());
        }
        if (this.cbxEndFiscal.getSelectedItem() != null) {
            this.filter.put("endFiscal", this.cbxEndFiscal.getSelectedItem());
        }
        if (this.dateStart.getValue() != null) {
            this.filter.put("startDate", RptUtil.beginOfDay((Date)this.dateStart.getValue()));
        }
        if (this.dateEnd.getValue() != null) {
            this.filter.put("endDate", RptUtil.endOfDay((Date)this.dateEnd.getValue()));
        }
        if (this.orgType != null) {
            this.filter.put("orgType", this.orgType);
        }
        this.isOK = true;
        this.disposeUIWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    public HashMap getFilter() {
        return this.filter;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean isOK() {
        return this.isOK;
    }
}

