/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.fi.rpt.client.AbstractRptSheetChooserUI;
import com.kingdee.eas.fi.rpt.client.ISheetChooseListener;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.client.SheetChooseEvent;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class RptSheetChooserUI
extends AbstractRptSheetChooserUI {
    private boolean isOKey;
    private ISheetChooseListener chooseListener;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnCheckAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        List sheets = (List)this.getUIContext().get("sheetName");
        List selectedSheets = (List)this.getUIContext().get("selectedSheetName");
        this.initTree(sheets, selectedSheets);
    }

    public void open(ArrayList sheetName) {
        IUIWindow w = this.getUIWindow();
        if (w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    e.setSource(null);
                    RptSheetChooserUI.this.endWizard(false);
                }
            });
        }
        this.initTree(sheetName, null);
        w.show();
    }

    void endWizard(boolean isOk) {
        this.isOKey = isOk;
        if (this.chooseListener != null) {
            SheetChooseEvent e = new SheetChooseEvent((Object)this);
            e.setDialogResult(isOk);
            e.setSelectedSheets(this.getSelectedSheetsName());
            this.chooseListener.endChoose(e);
            if (e.isCanceled()) {
                return;
            }
        }
        this.disposeUIWindow();
    }

    @Override
    public void actionCheckAllItem_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeSheets.getModel().getRoot();
        int j = root.getChildCount();
        for (int i = 0; i < j; ++i) {
            ((DefaultKingdeeTreeNode)root.getChildAt(i)).setChecked(true);
        }
        this.treeSheets.repaint();
    }

    @Override
    public void actionClearAllItem_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeSheets.getModel().getRoot();
        int j = root.getChildCount();
        for (int i = 0; i < j; ++i) {
            ((DefaultKingdeeTreeNode)root.getChildAt(i)).setChecked(false);
        }
        this.treeSheets.repaint();
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.endWizard(e != null && e.getSource() == this.btnOk);
    }

    private void initTree(List sheetName, List selectedSheets) {
        if (sheetName == null) {
            sheetName = new ArrayList();
        }
        DefaultKingdeeTreeNode node = null;
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)RptUtil.getResourceSince51("AllSheets"));
        int j = sheetName.size();
        for (int i = 0; i < j; ++i) {
            node = new DefaultKingdeeTreeNode((Object)((String)sheetName.get(i)));
            if (selectedSheets != null && selectedSheets.contains(sheetName.get(i))) {
                node.setChecked(true);
            }
            root.add((MutableTreeNode)node);
        }
        this.treeSheets.setShowCheckBox(true);
        this.treeSheets.setRootVisible(false);
        this.treeSheets.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.treeSheets.setSyncChecked(true);
        this.treeSheets.setCollapsePathDisabled(true);
        this.kDScrollPane1.setBorder(BorderFactory.createLineBorder(new Color(128, 128, 128), 1));
    }

    public boolean isOKey() {
        return this.isOKey;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void setInputData(HashMap arg0) throws Exception {
    }

    public boolean isCanceled() {
        return !this.isOKey;
    }

    public Object getData() {
        List l = this.getSelectedSheetsName();
        if (l == null || l.size() < 1) {
            return null;
        }
        return l;
    }

    public List getSelectedSheetsName() {
        ArrayList<Object> result = new ArrayList<Object>();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeSheets.getModel().getRoot();
        int j = root.getChildCount();
        for (int i = 0; i < j; ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (!node.isChecked()) continue;
            result.add(node.getUserObject());
        }
        return result;
    }

    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setDefaultButton((CoreUIObject)this, (JButton)this.btnOk);
        RptHelper.setEscAction((CoreUIObject)this, (Action)((Object)this.actionExit));
    }

    public ISheetChooseListener getSheetChooseListener() {
        return this.chooseListener;
    }

    public void setSheetChooseListener(ISheetChooseListener chooseListener) {
        this.chooseListener = chooseListener;
    }
}

