/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.client.AbstractRptPageSummaryUI;
import com.kingdee.eas.fi.rpt.client.IControlledDialogListener;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.ISimpleDialogListener;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.fi.rpt.client.RptSheetChooseDialog;
import com.kingdee.eas.fi.rpt.client.RptTablePane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;

public class RptSheetSummaryUI
extends AbstractRptPageSummaryUI
implements ISimpleDialog {
    private ArrayList listeners = new ArrayList(1);

    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setDefaultButton(this, (JButton)this.btnOk);
        RptHelper.setEscAction(this, (Action)((Object)this.actionBtnCancel));
    }

    public static RptSheetSummaryUI getInstance(CoreUIObject parentUI) throws Exception {
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(RptSheetSummaryUI.class.getName(), (Map)new UIContext((Object)parentUI));
        RptSheetSummaryUI res = (RptSheetSummaryUI)wnd.getUIObject();
        res.onShow();
        return res;
    }

    public RptSheetSummaryUI() throws Exception {
        this.initialize();
    }

    private void initialize() throws Exception {
        this.boxRegion.setEnabled(false);
        this.boxRegion.setEditable(true);
        this.grpPageSelection.setValue(0);
        class GroupListener
        implements ActionListener {
            GroupListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                RptSheetSummaryUI.this.boxRegion.setEnabled(e.getSource() == RptSheetSummaryUI.this.btnPageSelect);
            }
        }
        GroupListener gl = new GroupListener();
        this.btnPageAll.addActionListener((ActionListener)gl);
        this.btnPageSelect.addActionListener((ActionListener)gl);
    }

    @Override
    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnOk_actionPerformed(e);
        this.endWizard(true);
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnCancel_actionPerformed(e);
        this.endWizard(false);
    }

    @Override
    public void open(Object cookie, String title) {
        this.fireListenersSetout();
        try {
            ArrayList sheets = this.getTablePane().getSheets();
            ArrayList<String> sheetNames = new ArrayList<String>();
            for (int i = 0; i < sheets.size(); ++i) {
                sheetNames.add(((RptSheet)sheets.get(i)).getTable().getName());
            }
            this.boxRegion.setSelector((KDPromptSelector)new RptSheetChooseDialog((IUIObject)this, sheetNames));
            this.boxRegion.setEditable(false);
        }
        catch (Exception sheets) {
            // empty catch block
        }
        IUIWindow w = this.getUIWindow();
        if (w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            if (title != null) {
                d.setTitle(title);
            }
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RptSheetSummaryUI.this.endWizard(false);
                }
            });
        }
        w.show();
    }

    private RptTablePane getTablePane() {
        ISimpleDialogListener l;
        RptTablePane res = null;
        Iterator ls = this.listeners.iterator();
        while (ls.hasNext() && ((l = (ISimpleDialogListener)ls.next()) == null || !(l instanceof IControlledDialogListener) || (res = (RptTablePane)((Object)((IControlledDialogListener)l).getTrueController())) == null)) {
        }
        return res;
    }

    private void endWizard(boolean isOk) {
        RptTablePane pane;
        Collection result = null;
        if (isOk && (pane = this.getTablePane()) != null) {
            if (this.btnPageAll.isSelected()) {
                result = pane.getVisibleIndices();
            } else {
                List line = (List)this.boxRegion.getData();
                if (line != null) {
                    result = this.getIndicesBySheetName(line);
                }
            }
        }
        this.disposeUIWindow();
        this.fireListenersReturnee(result, isOk);
    }

    private Collection getIndicesBySheetName(List nameList) {
        RptTablePane pane = this.getTablePane();
        ArrayList<Integer> rs = new ArrayList<Integer>(nameList.size());
        for (int i = 0; i < pane.getSheetCount(); ++i) {
            if (!nameList.contains(pane.getSheet(i).getName())) continue;
            rs.add(new Integer(i));
        }
        return rs;
    }

    @Override
    public synchronized void addSimpleDialogListener(ISimpleDialogListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void fireListenersSetout() {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotSetout(this);
        }
    }

    private void fireListenersReturnee(Collection result, boolean isOk) {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotReturnee(this, result, isOk);
        }
    }
}

