/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.IDObject;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ISumRptRela;
import com.kingdee.eas.fi.gr.cslrpt.SumRptRelaCollection;
import com.kingdee.eas.fi.gr.cslrpt.SumRptRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptRelaInfo;
import com.kingdee.eas.fi.rpt.IInitDataFacada;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.SumReportListUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class RptSumaryManager {
    SumReportListUI lister;

    public RptSumaryManager(SumReportListUI listUI) {
        this.lister = listUI;
    }

    public RptSumaryManager() {
        this(null);
    }

    public void creat(HashMap sumResult) throws Exception {
        if (sumResult == null) {
            return;
        }
        CslReportInfo report = this.createNewData();
        this.initNewData(report, sumResult);
        report.setKDF(this.getImageData(sumResult));
        report.setSourceType(RptSrcTypeEnum.COMMOMSUM);
        BOSUuid id = this.submit(report);
        report.setId(id);
        ReportInfo[] relaIDs = this.getRelations(sumResult);
        this.saveRelations(report, relaIDs);
        this.refresh();
    }

    private void refresh() throws Exception {
        if (this.lister != null) {
            this.lister.refreshList();
        }
    }

    private void saveRelations(CslReportInfo sumReport, ReportInfo[] subReports) throws Exception {
        if (sumReport == null || subReports == null || subReports.length < 1) {
            return;
        }
        SumRptRelaCollection chain = new SumRptRelaCollection();
        for (int i = 0; i < subReports.length; ++i) {
            SumRptRelaInfo entry = new SumRptRelaInfo();
            entry.setSumReportID(sumReport.getId().toString());
            entry.setReportID(subReports[i].getId().toString());
            chain.add(entry);
        }
        this.submit(chain);
    }

    private CslReportInfo createNewData() {
        return new CslReportInfo();
    }

    private CslReportInfo initNewData(CslReportInfo data, HashMap info) throws Exception {
        if (data == null) {
            return null;
        }
        HashMap initInfo = this.getInitData();
        if (info != null && initInfo != null) {
            Short m;
            Integer y = (Integer)initInfo.get("curYear");
            if (y != null) {
                data.setYear(y.intValue());
            }
            if ((m = (Short)initInfo.get("curPeriod")) != null) {
                data.setPeriod(m.shortValue());
            }
            data.setTemplate((TemplateInfo)info.get("template"));
            data.setCurrency((CurrencyInfo)info.get("currency"));
            CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)info.get("rptCompany");
            if (org == null) {
                org = (CompanyOrgUnitInfo)initInfo.get("curCompany");
            }
            data.setOrgUnit((OrgUnitInfo)org);
            data.setCompany(org);
            IOrgTree ot = OrgTreeFactory.getRemoteInstance();
            OrgTreeCollection oc = ot.getCollectionWithType(OrgType.Company);
            data.setOrgTree(oc.get(0));
            data.setNumber((String)info.get("rptCode"));
            data.setName((String)info.get("rptName"));
            data.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            data.setCreateTime(new Timestamp(System.currentTimeMillis()));
        }
        return data;
    }

    private HashMap getInitData() throws Exception {
        HashMap<String, Number> res = new HashMap<String, Number>(5);
        IInitDataFacada ida = InitDataFacadaFactory.getRemoteInstance();
        PeriodInfo pi = ida.getCurrentFiscal();
        res.put("curYear", new Integer(pi.getPeriodYear()));
        res.put("curPeriod", new Short((short)pi.getPeriodNumber()));
        String cid = (String)SysContext.getSysContext().getProperty((Object)"CurCompanyId");
        if (!StringUtils.isEmpty((String)cid)) {
            ICompanyOrgUnit ico = CompanyOrgUnitFactory.getRemoteInstance();
            CompanyOrgUnitInfo ci = ico.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cid)));
            res.put("curCompany", (Number)ci);
        }
        return res;
    }

    private KDF getImageData(HashMap sumResult) {
        if (sumResult == null) {
            return null;
        }
        Collection kdTables = (Collection)sumResult.get("tables");
        if (kdTables == null) {
            return null;
        }
        KDF kdf = new KDF();
        Iterator it = kdTables.iterator();
        while (it.hasNext()) {
            kdf.addTable((IDObject)((KDTable)it.next()));
        }
        return kdf;
    }

    private BOSUuid submit(CslReportInfo report) throws Exception {
        ICslReport base = CslReportFactory.getRemoteInstance();
        IObjectPK pk = base.submit((CoreBaseInfo)report);
        return pk == null ? null : BOSUuid.read((String)pk.toString());
    }

    private void submit(SumRptRelaCollection report) throws Exception {
        if (report == null) {
            return;
        }
        ISumRptRela base = SumRptRelaFactory.getRemoteInstance();
        for (int i = 0; i < report.size(); ++i) {
            base.submit((CoreBaseInfo)report.get(i));
        }
    }

    private ReportInfo[] getRelations(HashMap sumResult) throws Exception {
        if (sumResult == null) {
            return null;
        }
        Collection subIDs = (Collection)sumResult.get("subReports");
        if (subIDs == null) {
            return null;
        }
        IReport base = ReportFactory.getRemoteInstance();
        ObjectStringPK pk = new ObjectStringPK();
        ReportInfo[] res = new ReportInfo[subIDs.size()];
        Iterator it = subIDs.iterator();
        int i = 0;
        while (it.hasNext()) {
            pk.setKeyValue("id", it.next());
            res[i] = base.getReportInfo((IObjectPK)pk);
            ++i;
        }
        return res;
    }
}

