/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.AbstractRptSummaryListUI;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.ISimpleDialogListener;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.client.RptSummaryFiltersUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;

public class RptSummaryListUI
extends AbstractRptSummaryListUI
implements ISimpleDialog {
    private ArrayList listeners = new ArrayList(1);
    private EntityViewInfo mainQuery = null;
    private IMetaDataPK mainQueryPK;

    public static RptSummaryListUI getInstance(CoreUIObject parentUI) throws Exception {
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(RptSummaryListUI.class.getName(), (Map)new UIContext((Object)parentUI));
        RptSummaryListUI res = (RptSummaryListUI)wnd.getUIObject();
        res.onShow();
        return res;
    }

    public RptSummaryListUI() throws Exception {
        this.initialize();
    }

    private void initialize() throws Exception {
        this.btnSelectAll.setIcon(RptResourceHelper.getIcon("imgTbtn_selectall"));
        this.btnSelectNone.setIcon(RptResourceHelper.getIcon("imgTbtn_deleteall"));
        this.defaultObjectName = "mainQuery";
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.fi.rpt.app", "ReportQuery");
        this.mainQuery = new EntityViewInfo();
        this.setDataObject((IObjectValue)this.mainQuery);
        this.tblMain.setFormatXml(this.resHelper.getString("tblMain.formatXml"));
        this.tblMain.putBindContents("mainQuery", new String[]{"Report.id", "isNeed", "Report.number", "Report.name", "creator.name", "Report.startDate", "Report.endDate"});
        this.tblMain.checkParsed();
        this.tblMain.getColumn(1).setWidth(35);
        this.tblMain.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                RptSummaryListUI.this.tblMain_doRequestRowSet(e);
            }
        });
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.mainQuery != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            try {
                IQueryExecutor exec = this.getQueryExecutor(this.mainQueryPK, this.mainQuery);
                IRowSet rowSet = exec.executeQuery(start, length);
                e.setRowSet(rowSet);
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    @Override
    public void actionBtnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnSelectAll_actionPerformed(e);
        this.setAllSelect(true);
    }

    @Override
    public void actionBtnSelectNone_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnSelectNone_actionPerformed(e);
        this.setAllSelect(false);
    }

    private void setAllSelect(boolean isSelect) {
        int num = this.tblMain.getExpandedRowCount();
        for (int i = 0; i < num; ++i) {
            IRow r = this.tblMain.getRow(i);
            if (r == null) continue;
            r.getCell(1).setValue((Object)(isSelect ? Boolean.TRUE : Boolean.FALSE));
        }
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnCancel_actionPerformed(e);
        this.endWizard(false);
    }

    @Override
    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnOk_actionPerformed(e);
        this.endWizard(true);
    }

    @Override
    public void open(Object cookie, String title) {
        this.fireListenersSetout();
        if (cookie instanceof RptSummaryFiltersUI) {
            this.setFilter((RptSummaryFiltersUI)cookie);
        } else {
            this.setFilter(null);
        }
        IUIWindow w = this.getUIWindow();
        if (w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            if (title != null) {
                d.setTitle(title);
            }
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RptSummaryListUI.this.endWizard(false);
                }
            });
        }
        w.show();
    }

    private void setFilter(RptSummaryFiltersUI fui) {
        Timestamp et;
        CurrencyInfo cif;
        if (fui == null || this.mainQuery == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        StringBuffer mask = new StringBuffer();
        int foreLand = 0;
        TemplateInfo tif = fui.getTemplateInfo();
        if (tif != null) {
            foreLand = this.pushBaby(fic, mask, foreLand, "template.id", tif.getId(), CompareType.EQUALS);
        }
        if ((cif = fui.getCurrencyInfo()) != null) {
            foreLand = this.pushBaby(fic, mask, foreLand, "currency.id", cif.getId(), CompareType.EQUALS);
        }
        boolean ido = fui.isDatesInOrder();
        int sy = fui.getYear(ido);
        int ey = fui.getYear(!ido);
        int sm = fui.getMonth(ido);
        int em = fui.getMonth(!ido);
        if (sy > 0 && ey > 0 && sm > 0 && em > 0) {
            foreLand = this.pushBaby(fic, null, foreLand, "year", String.valueOf(sy), CompareType.GREATER);
            mask.append("and ((#" + foreLand++ + " ");
            foreLand = this.pushBaby(fic, null, foreLand, "year", String.valueOf(sy), CompareType.EQUALS);
            mask.append("or (#" + foreLand++ + " ");
            foreLand = this.pushBaby(fic, null, foreLand, "period", String.valueOf(sm), CompareType.GREATER_EQUALS);
            mask.append("and #" + foreLand++ + ")) ");
            foreLand = this.pushBaby(fic, null, foreLand, "year", String.valueOf(ey), CompareType.LESS);
            mask.append("and (#" + foreLand++ + " ");
            foreLand = this.pushBaby(fic, null, foreLand, "year", String.valueOf(ey), CompareType.EQUALS);
            mask.append("or (#" + foreLand++ + " ");
            foreLand = this.pushBaby(fic, null, foreLand, "period", String.valueOf(em), CompareType.LESS_EQUALS);
            mask.append("and #" + foreLand++ + "))) ");
        } else {
            if (sy > 0) {
                foreLand = this.pushBaby(fic, mask, foreLand, "year", String.valueOf(sy), CompareType.GREATER_EQUALS);
            }
            if (ey > 0) {
                foreLand = this.pushBaby(fic, mask, foreLand, "year", String.valueOf(ey), CompareType.LESS_EQUALS);
            }
            if (sm > 0) {
                foreLand = this.pushBaby(fic, mask, foreLand, "period", String.valueOf(sm), CompareType.GREATER_EQUALS);
            }
            if (em > 0) {
                foreLand = this.pushBaby(fic, mask, foreLand, "period", String.valueOf(em), CompareType.LESS_EQUALS);
            }
        }
        Timestamp st = fui.getDate(true);
        if (st != null) {
            foreLand = this.pushBaby(fic, mask, foreLand, "startDate", st, CompareType.GREATER_EQUALS);
        }
        if ((et = fui.getDate(false)) != null) {
            foreLand = this.pushBaby(fic, mask, foreLand, "endDate", et, CompareType.LESS_EQUALS);
        }
        Object[] orgs = fui.getOrgUnitInfo();
        StringBuffer cs = new StringBuffer();
        if (orgs != null) {
            int i = 0;
            for (i = 0; i < orgs.length; ++i) {
                CompanyOrgUnitInfo co = (CompanyOrgUnitInfo)orgs[i];
                if (co == null) continue;
                BOSUuid id = co.getId();
                if (id != null) {
                    cs.append(id.toString());
                }
                if (i == orgs.length - 1) continue;
                cs.append(",");
            }
            if (i != 0) {
                foreLand = this.pushBaby(fic, mask, foreLand, "company.id", cs, CompareType.INCLUDE);
            }
        }
        if (foreLand > 0) {
            String prefix = "and ";
            foreLand = mask.indexOf(prefix);
            String mk = foreLand == 0 ? mask.substring(prefix.length()) : mask.toString();
            filter.setMaskString(mk);
            this.mainQuery.setFilter(filter);
        }
    }

    private int pushBaby(FilterItemCollection fic, StringBuffer mask, int foreLand, String name, Object value, CompareType cp) {
        if (value != null && fic.add(new FilterItemInfo(name, value = value.toString(), cp)) && mask != null) {
            mask.append("and #" + foreLand++ + " ");
        }
        return foreLand;
    }

    private void endWizard(boolean isOk) {
        Collection result = null;
        if (isOk) {
            result = this.getSummaryInfo();
        }
        this.disposeUIWindow();
        this.fireListenersReturnee(result, isOk);
    }

    private Collection getSummaryInfo() {
        ArrayList<Object> al = new ArrayList<Object>(5);
        int num = this.tblMain.getExpandedRowCount();
        for (int i = 0; i < num; ++i) {
            ICell c0;
            Object o;
            IRow r = this.tblMain.getRow(i);
            ICell c1 = r.getCell(1);
            if (c1 == null || !Boolean.TRUE.equals(o = c1.getValue()) || (c0 = r.getCell(0)) == null || (o = c0.getValue()) == null) continue;
            al.add(o);
        }
        return al;
    }

    @Override
    public synchronized void addSimpleDialogListener(ISimpleDialogListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void fireListenersSetout() {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotSetout(this);
        }
    }

    private void fireListenersReturnee(Object result, boolean isOk) {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotReturnee(this, result, isOk);
        }
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setDefaultButton(this, (JButton)this.btnOk);
        RptHelper.setEscAction(this, (Action)((Object)this.actionBtnCancel));
    }
}

