/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.TableToolkit;
import java.awt.Color;
import java.awt.Font;
import java.lang.reflect.Method;
import java.util.BitSet;

public class RptTableHelper {
    private KDTable table = null;
    public static final int STYLE_FONT_COLOR = 1;
    public static final int STYLE_FILL_COLOR = 2;
    public static final int STYLE_ALIGN_HOZ = 3;
    public static final int STYLE_FONT = 4;
    private static final String GETKDTSA = "getStyleAttributes";

    public static RptTableHelper getInstance(KDTable table) {
        RptTableHelper res = new RptTableHelper();
        res.setKDTable(table);
        return res;
    }

    protected RptTableHelper() {
    }

    public void setKDTable(KDTable tbl) {
        this.table = tbl;
    }

    public KDTable getKDTable(KDTable tbl) {
        return this.table;
    }

    public boolean isFormulaInRange(KDTRange range) {
        if (range == null) {
            return false;
        }
        for (int i = 0; i < range.size(); ++i) {
            if (!this.isFormulaInBlock((IBlock)range.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isFormulaInBlock(IBlock block) {
        IRow row;
        switch (block.getMode()) {
            case 8: {
                block.setTop(0);
                block.setLeft(0);
                block.setBottom(this.table.getExpandedRowCount() - 1);
                block.setRight(this.table.getExpandedColumnCount() - 1);
                break;
            }
            case 4: {
                block.setTop(0);
                block.setBottom(this.table.getExpandedRowCount() - 1);
                break;
            }
            case 2: {
                block.setLeft(0);
                block.setRight(this.table.getExpandedColumnCount() - 1);
                break;
            }
        }
        int top = block.getTop();
        int left = block.getLeft();
        int bottom = block.getBottom();
        int right = block.getRight();
        for (int i = top; i <= bottom && (row = this.table.getRow(i)) != null; ++i) {
            for (int j = left; j <= right; ++j) {
                ICell cell = row.getCell(j);
                if (cell == null || !TableToolkit.isFormulaLine(cell.getExpressions())) continue;
                return true;
            }
        }
        return false;
    }

    public static int getKDTDeleteMode(String sm) {
        int mod = 15;
        if ("value".equals(sm)) {
            mod = 2;
        } else if ("formula".equals(sm)) {
            mod = 4;
        } else if ("content".equals(sm)) {
            mod = 14;
        } else if ("format".equals(sm)) {
            mod = 1;
        } else if ("item".equals(sm)) {
            mod = 8;
        }
        return mod;
    }

    public void delete(int actionMode) {
        this.table.getEditHelper().delete(actionMode);
    }

    public void delete(String actionName) {
        if (this.table == null) {
            return;
        }
        this.table.setRefresh(false);
        KDTRange range = this.table.getSelectManager().toRange();
        if (range == null) {
            return;
        }
        for (int i = 0; i < range.size(); ++i) {
            this.deleteInBlock((IBlock)range.get(i), actionName);
        }
        this.table.setRefresh(true);
        this.table.repaint();
    }

    public void deleteInBlock(IBlock block, String actionName) {
        IRow row;
        if (block == null || this.table == null) {
            return;
        }
        if (actionName == null) {
            actionName = "content";
        }
        switch (block.getMode()) {
            case 8: {
                block.setTop(0);
                block.setLeft(0);
                block.setBottom(this.table.getExpandedRowCount() - 1);
                block.setRight(this.table.getExpandedColumnCount() - 1);
                break;
            }
            case 4: {
                block.setTop(0);
                block.setBottom(this.table.getExpandedRowCount() - 1);
                break;
            }
            case 2: {
                block.setLeft(0);
                block.setRight(this.table.getExpandedColumnCount() - 1);
                break;
            }
        }
        int mod = 99;
        if ("value".equals(actionName)) {
            mod = 118;
        } else if ("formula".equals(actionName)) {
            mod = 102;
        } else if ("content".equals(actionName)) {
            mod = 99;
        } else if ("format".equals(actionName)) {
            mod = 115;
        } else if ("item".equals(actionName)) {
            mod = 105;
        }
        int top = block.getTop();
        int left = block.getLeft();
        int bottom = block.getBottom();
        int right = block.getRight();
        for (int i = top; i <= bottom && (row = this.table.getRow(i)) != null; ++i) {
            block12: for (int j = left; j <= right; ++j) {
                ICell cell = row.getCell(j);
                if (cell == null) continue;
                Object tmp = null;
                switch (mod) {
                    case 118: {
                        cell.setValue(null);
                        continue block12;
                    }
                    case 102: {
                        cell.setExpressions(null);
                        continue block12;
                    }
                    case 115: {
                        cell.setStyleAttributes(Styles.getDefaultSA());
                        continue block12;
                    }
                    case 105: {
                        RptCell rc;
                        tmp = cell.getUserObject();
                        if (tmp == null || (rc = RptCell.getRptCell(tmp)) == null) continue block12;
                        rc.setItemFormula((String)null);
                        continue block12;
                    }
                    default: {
                        RptCell rcl;
                        cell.setValue(null);
                        cell.setExpressions(null);
                        cell.setStyleAttributes(Styles.getDefaultSA());
                        tmp = cell.getUserObject();
                        if (tmp == null || (rcl = RptCell.getRptCell(tmp)) == null) continue block12;
                        rcl.setCell(cell);
                        rcl.setItemFormula((String)null);
                    }
                }
            }
        }
    }

    public int removeSelectedColumns() {
        if (this.table == null) {
            return 0;
        }
        this.table.setRefresh(false);
        BitSet chain = new BitSet();
        chain.clear();
        KDTSelectManager sm = this.table.getSelectManager();
        int count = sm.size();
        for (int i = 0; i < count; ++i) {
            KDTSelectBlock sb = sm.get(i);
            if (sb == null) continue;
            for (int j = sb.getBeginCol(); j <= sb.getEndCol(); ++j) {
                chain.set(j);
            }
        }
        Rect rg = new Rect();
        rg.y1 = 0;
        rg.y2 = this.table.getExpandedRowCount();
        int res = 0;
        int restmp = 0;
        count = chain.size();
        int base = 0;
        for (int c = 0; c < count; ++c) {
            if (!chain.get(c)) continue;
            rg.x1 = rg.x2 = c - base;
            restmp = this.tryDelete(this.table, rg);
            if (res == 0) {
                res = restmp;
            }
            if (restmp != 0) continue;
            if (this.table.removeColumn(c - base) == null) {
                return res;
            }
            ++base;
        }
        this.table.setRefresh(true);
        this.table.repaint();
        sm.removeAll();
        return res;
    }

    public int removeSelectedRows() {
        if (this.table == null) {
            return 0;
        }
        this.table.setRefresh(false);
        BitSet chain = new BitSet();
        chain.clear();
        KDTSelectManager sm = this.table.getSelectManager();
        int count = sm.size();
        for (int i = 0; i < count; ++i) {
            KDTSelectBlock sb = sm.get(i);
            if (sb == null) continue;
            for (int j = sb.getBeginRow(); j <= sb.getEndRow(); ++j) {
                chain.set(j);
            }
        }
        Rect rg = new Rect();
        rg.x1 = 0;
        rg.x2 = this.table.getExpandedColumnCount();
        int res = 0;
        int restmp = 0;
        count = chain.size();
        int base = 0;
        for (int r = 0; r < count; ++r) {
            if (!chain.get(r)) continue;
            rg.y1 = rg.y2 = r - base;
            restmp = this.tryDelete(this.table, rg);
            if (res == 0) {
                res = restmp;
            }
            if (restmp != 0) continue;
            if (this.table.removeRow(r - base) == null) {
                return res;
            }
            ++base;
        }
        this.table.setRefresh(true);
        this.table.repaint();
        sm.removeAll();
        return res;
    }

    private int tryDelete(KDTable table, Rect region) {
        IRow row;
        if (table == null || region == null) {
            return 0;
        }
        for (int i = region.y1; i <= region.y2 && (row = table.getRow(i)) != null; ++i) {
            for (int j = region.x1; j <= region.x2; ++j) {
                ICell cell = row.getCell(j);
                if (cell == null || !cell.getStyleAttributes().isLocked()) continue;
                return 0x30000000;
            }
        }
        return 0;
    }

    public void setStyle(int action, Object value) {
        if (this.table == null) {
            return;
        }
        this.table.setRefresh(false);
        KDTRange range = this.table.getSelectManager().toRange();
        if (range == null) {
            return;
        }
        try {
            for (int i = 0; i < range.size(); ++i) {
                this.setStyle(action, (IBlock)range.get(i), value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.table.setRefresh(true);
        this.table.repaint();
    }

    private void setStyle(int action, IBlock block, Object value) throws Exception {
        switch (block.getMode()) {
            case 8: {
                this.setStyle(action, this.table, value);
                break;
            }
            case 4: {
                int l = block.getLeft();
                int r = block.getRight();
                while (l <= r) {
                    this.setStyle(action, this.table.getColumn(l++), value);
                }
                break;
            }
            case 2: {
                int t = block.getTop();
                int b = block.getBottom();
                while (t <= b) {
                    this.setStyle(action, this.table.getRow(t++), value);
                }
                break;
            }
            default: {
                int nl = block.getLeft();
                int nr = block.getRight();
                int nt = block.getTop();
                int nb = block.getBottom();
                int L = nl;
                while (nt <= nb) {
                    IRow row = this.table.getRow(nt++);
                    nl = L;
                    while (nl <= nr) {
                        this.setStyle(action, row.getCell(nl++), value);
                    }
                }
                break block0;
            }
        }
    }

    private void setStyle(int action, Object target, Object value) throws Exception {
        StyleAttributes sa;
        Method mth = null;
        Class<?> cls = target.getClass();
        if (cls == KDTable.class) {
            mth = cls.getMethod(GETKDTSA, null);
        } else {
            Class<?>[] ins = cls.getInterfaces();
            for (int i = 0; i < ins.length && (mth = ins[i].getMethod(GETKDTSA, null)) == null; ++i) {
            }
        }
        StyleAttributes styleAttributes = sa = mth == null ? null : (StyleAttributes)mth.invoke(target, null);
        if (sa == null) {
            return;
        }
        switch (action) {
            case 1: {
                sa.setFontColor((Color)value);
                break;
            }
            case 2: {
                sa.setBackground((Color)value);
                break;
            }
            case 3: {
                sa.setHorizontalAlign((Styles.HorizontalAlignment)value);
                break;
            }
            case 4: {
                Font af = (Font)value;
                sa.setFontName(af.getFontName());
                sa.setFontSize(af.getSize());
                sa.setBold(af.isBold());
                sa.setItalic(af.isItalic());
            }
        }
    }

    public void repaintSelectedCellsRender() {
        if (this.table == null) {
            return;
        }
        KDTSelectManager sm = this.table.getSelectManager();
        int s = sm.size();
        for (int i = 0; i < s; ++i) {
            this.repaintBlockRender(this.table, sm.get(i));
        }
    }

    private void repaintBlockRender(KDTable table, KDTSelectBlock block) {
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        switch (block.getMode()) {
            case 8: {
                top = 0;
                left = 0;
                bottom = table.getRowCount3() - 1;
                right = table.getColumnCount() - 1;
                break;
            }
            case 4: {
                top = 0;
                left = block.getLeft();
                bottom = table.getRowCount3() - 1;
                right = block.getRight();
                break;
            }
            case 2: {
                top = block.getTop();
                left = 0;
                bottom = block.getBottom();
                right = table.getColumnCount() - 1;
                break;
            }
            case 1: {
                top = block.getTop();
                left = block.getLeft();
                bottom = block.getBottom();
                right = block.getRight();
                break;
            }
            default: {
                return;
            }
        }
        for (int j = top; j <= bottom; ++j) {
            for (int k = left; k <= right; ++k) {
                RptCell rptCell;
                ICell cell;
                IRow row = table.getRow(j);
                if (row == null || (cell = row.getCell(k, false)) == null || (rptCell = RptCell.getRptCellWithoutUserObject(cell)) == null) continue;
                rptCell.applyCellRender();
            }
        }
    }
}

