/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ColorSchemeFactory;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IInitDataFacada;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.client.AbstractRptWeaveProgressListUI;
import com.kingdee.eas.fi.rpt.client.ColorChangeListener;
import com.kingdee.eas.fi.rpt.client.RptColorSchemesUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class RptWeaveProgressListUI
extends AbstractRptWeaveProgressListUI
implements ColorChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(RptWeaveProgressListUI.class);
    private IReport iReport;
    private String lastSortFieldName;
    private SorterItemInfo sorterItemInfo;
    private boolean isDescSort;
    private Map defaultColors;
    boolean isMergeByFiscalPeriod;

    public RptWeaveProgressListUI() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                RptWeaveProgressListUI.this.autoTranslateEnum(e.getFirstRow(), e.getLastRow());
            }
        });
        this.cmbxPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RptWeaveProgressListUI.this.actionDateChange_actionPerformed();
                }
            }
        });
        this.dpReportDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() == null) {
                    RptWeaveProgressListUI.this.dpReportDate.setValue(eventObj.getOldValue());
                } else {
                    RptWeaveProgressListUI.this.actionDateChange_actionPerformed();
                }
            }
        });
        this.cbxDataCollect.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RptWeaveProgressListUI.this.actionrefreshCollect_actionPerformed(e);
                RptWeaveProgressListUI.this.refresh13Period();
            }
        });
        this.isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(null);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CslRptUIUtil.setSpineRange((KDSpinner)this.period, (int)0, (int)365);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.initDefaultStyle();
        this.initDefaultQuery();
        this.execQuery();
        this.colorChanged(this.defaultColors);
        if (this.isMergeByFiscalPeriod) {
            IInitDataFacada iInitDataFacada = InitDataFacadaFactory.getRemoteInstance();
            PeriodInfo periodInfo = iInitDataFacada.getCurrentFiscal();
            this.year.setValue((Object)new Integer(periodInfo.getPeriodYear()));
            this.period.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
            FiscalPeriodHelper.refreshAndAddListeners((boolean)this.isMergeByFiscalPeriod, (KDComboBox)this.cmbxPeriodType, (KDSpinner)this.year, (KDSpinner)this.period, (KDDatePicker)this.dpReportDate, (PeriodCollection)iInitDataFacada.getFiscal());
        }
    }

    private void initDefaultStyle() {
        this.txtUnWeave.setHorizontalAlignment(4);
        this.txtWeaving.setHorizontalAlignment(4);
        this.txtAudited.setHorizontalAlignment(4);
        this.txtCommited.setHorizontalAlignment(4);
        this.txtTotal.setHorizontalAlignment(4);
    }

    private void actionDateChange_actionPerformed() {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbxPeriodType.getSelectedItem();
        if (periodType == null) {
            return;
        }
        if (FiscalPeriodHelper.isMergeByFiscalPeriod((boolean)this.isMergeByFiscalPeriod, (RptPeriodTypeEnum)periodType)) {
            return;
        }
        List listPeriod = RPTDateUtil.getRptPeriod((Date)this.dpReportDate.getSqlDate(), (RptPeriodTypeEnum)periodType);
        this.dpReportDate.setValue(listPeriod.get(2));
        Object[] params = new Object[]{listPeriod.get(0), listPeriod.get(1)};
        this.year.setValue(params[0]);
        this.period.setValue(params[1]);
        this.refresh13Period();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddNew.setEnabled(false);
        this.actionAddNew.setVisible(false);
        this.actionRemove.setEnabled(false);
        this.actionRemove.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.actionEdit.setVisible(false);
        this.actionQuery.setEnabled(false);
        this.actionQuery.setVisible(false);
        this.actionView.setEnabled(false);
        this.actionView.setVisible(false);
        this.menuEdit.setEnabled(false);
        this.menuEdit.setVisible(false);
        this.btnQuickQuery.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.year.setEnabled(false);
        this.period.setEnabled(false);
    }

    protected void autoTranslateEnum(int firstRow, int lastRow) {
        for (int i = firstRow; i <= lastRow; ++i) {
            ICell cell = this.tblMain.getRow(i).getCell("sourceType");
            Number rptType = (Number)cell.getValue();
            cell.setValue((Object)RptSrcTypeEnum.getEnum(rptType.intValue()));
            cell = this.tblMain.getRow(i).getCell("auditedStatus");
            Number auditedStatus = (Number)cell.getValue();
            cell.setValue((Object)AuditedStatusEnum.getEnum(auditedStatus.intValue()));
            cell = this.tblMain.getRow(i).getCell("committedStatus");
            Number committedStatus = (Number)cell.getValue();
            cell.setValue((Object)CommittedStatusEnum.getEnum(committedStatus.intValue()));
        }
        this.colorChanged(this.defaultColors);
    }

    private void initDefaultQuery() {
        this.cmbxPeriodType.addItems(RptPeriodTypeEnum.getEnumList().toArray());
        this.cmbxPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        try {
            this.initComboDataCollection();
        }
        catch (Exception e1) {
            logger.debug((Object)e1.getStackTrace(), (Throwable)e1);
        }
        this.cmbxCurrency.addItem((Object)RptUtil.getReportResource("AllCurrencies"));
        try {
            CurrencyCollection currencies = InitDataFacadaFactory.getRemoteInstance().getCurrencyNoGLC();
            CurrencyInfo baseCurrency = SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency();
            for (int i = 0; i < currencies.size(); ++i) {
                CurrencyInfo currency = currencies.get(i);
                this.cmbxCurrency.addItem((Object)currency);
                if (baseCurrency == null || !baseCurrency.getId().equals((Object)currency.getId())) continue;
                this.cmbxCurrency.setSelectedIndex(i + 1);
            }
        }
        catch (BOSException e) {
            logger.debug((Object)e.getMessage());
        }
        this.actionDateChange_actionPerformed();
    }

    private void initComboDataCollection() throws BOSException, EASBizException {
        this.cbxDataCollect.addItem((Object)DataCollectConstant.getActualDC());
        Object isSupportOtherDS = CslRptUtil.getParamValue(null, null, (String)"GR_CSL_SupportOtherDS");
        if ("true".equals(isSupportOtherDS)) {
            boolean hasPermisson = CSLPermissionUtil.hasDataCollectPermission(null, (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (DataCollectInfo)DataCollectConstant.getActualDC());
            if (!hasPermisson) {
                this.cbxDataCollect.removeAllItems();
            }
            if (hasPermisson = CSLPermissionUtil.hasDataCollectPermission(null, (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (DataCollectInfo)DataCollectConstant.getBudgetDC())) {
                this.cbxDataCollect.addItem((Object)DataCollectConstant.getBudgetDC());
            }
        } else {
            this.lblDataCollect.setVisible(false);
        }
        if (this.cbxDataCollect.getItemCount() <= 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Query_No_ALLDC_Permission"));
            SysUtil.abort();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.actionView_actionPerformed(null);
        if (e.getColIndex() != -1 && e.getType() == 0) {
            String fieldName = this.tblMain.getColumn(e.getColIndex()).getFieldName();
            this.sorterItemInfo = new SorterItemInfo("\"" + fieldName + "\"");
            this.isDescSort = fieldName.equals(this.lastSortFieldName) ? !this.isDescSort : true;
            if (this.isDescSort) {
                this.sorterItemInfo.setSortType(SortType.DESCEND);
            } else {
                this.sorterItemInfo.setSortType(SortType.ASCEND);
            }
            this.lastSortFieldName = fieldName;
            super.tblMain_tableClicked(e);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReportFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        String companyId = (String)this.getUIContext().get("companyId");
        try {
            if (this.iReport == null) {
                this.iReport = (IReport)this.getBizInterface();
            }
            Map result = this.iReport.getWeaveProgess(companyId, this.getFilterInfo(), this.sorterItemInfo);
            IRowSet rowSet = (IRowSet)result.get("KEY_RCV_ROWSET");
            this.setStatData((int[])result.get("KEY_RCV_STAT"));
            this.tblMain.setRowCount(rowSet.size());
            e.setRowSet(rowSet);
            this.onGetRowSet(rowSet);
        }
        catch (Exception ex) {
            super.handUIException((Throwable)ex);
            SysUtil.abort();
        }
    }

    private FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbxPeriodType.getSelectedItem();
        filterInfo.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(periodType.getValue())));
        filterInfo.getFilterItems().add(new FilterItemInfo("year", this.year.getValue()));
        filterInfo.getFilterItems().add(new FilterItemInfo("period", this.period.getValue()));
        StringBuffer status = new StringBuffer("0");
        if (this.chbxUnWeave.isSelected()) {
            status.append(",1");
        }
        if (this.chbxWeaving.isSelected()) {
            status.append(",2");
        }
        if (this.chbxAudited.isSelected()) {
            status.append(",3");
        }
        if (this.chbxCommited.isSelected()) {
            status.append(",4");
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)status.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("sqlTime", (Object)this.dpReportDate.getSqlTime()));
        if (this.cmbxCurrency.getSelectedIndex() > 0) {
            CurrencyInfo currency = (CurrencyInfo)this.cmbxCurrency.getSelectedItem();
            filterInfo.getFilterItems().add(new FilterItemInfo("currency", (Object)currency.getId().toString()));
        }
        DataCollectInfo dataCollectInfo = (DataCollectInfo)this.cbxDataCollect.getSelectedItem();
        if (this.cbxDataCollect.getSelectedItem() == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)"ACTUALDATA"));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)dataCollectInfo.getNumber().toString()));
        }
        return filterInfo;
    }

    protected void actionrefreshCollect_actionPerformed(ItemEvent e) {
        this.tblMain.refresh();
    }

    private void setStatData(int[] statData) {
        this.txtTotal.setText(String.valueOf(statData[0]));
        this.txtUnWeave.setText(String.valueOf(statData[1]));
        this.txtWeaving.setText(String.valueOf(statData[2]));
        this.txtAudited.setText(String.valueOf(statData[3]));
        this.txtCommited.setText(String.valueOf(statData[4]));
    }

    protected String getKeyFieldName() {
        return "Report.id";
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionColorScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionColorScheme_actionPerformed(e);
        String uiclass = RptColorSchemesUI.class.getName();
        UIContext uiContext = new UIContext((Object)this);
        IUIFactory factory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow newWindow = factory.create(uiclass, (Map)uiContext, null, OprtState.EDIT);
        RptColorSchemesUI colorSchemesUI = (RptColorSchemesUI)newWindow.getUIObject();
        colorSchemesUI.addColorChangeListener(this);
        newWindow.show();
    }

    protected String[] getLocateNames() {
        ArrayList<String> lnames = new ArrayList<String>();
        lnames.add("template.number");
        lnames.add("template.name");
        lnames.add("Report.number");
        lnames.add("Report.name");
        String[] locateNames = new String[lnames.size()];
        lnames.toArray(locateNames);
        return locateNames;
    }

    @Override
    public void colorChanged(Map newColors) {
        if (newColors == null || newColors.isEmpty()) {
            String uiClassName = "com.kingdee.eas.fi.rpt.client.RptWeaveProgressListUI";
            try {
                this.defaultColors = ColorSchemeFactory.getRemoteInstance().getColorSchemesMap(uiClassName);
            }
            catch (BOSException bOSException) {}
        } else {
            this.defaultColors = newColors;
        }
        this.txtTotal.setBackground((Color)this.defaultColors.get("Total"));
        this.txtUnWeave.setBackground((Color)this.defaultColors.get(ReportStatusEnum.UnWeave.getName()));
        this.txtWeaving.setBackground((Color)this.defaultColors.get(ReportStatusEnum.Weaving.getName()));
        this.txtAudited.setBackground((Color)this.defaultColors.get(ReportStatusEnum.Audited.getName()));
        this.txtCommited.setBackground((Color)this.defaultColors.get(ReportStatusEnum.Commited.getName()));
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            ICell cell = this.tblMain.getRow(i).getCell("periodType");
            Color color = null;
            Number reportStatus = (Number)cell.getValue();
            if (reportStatus.intValue() == 1) {
                color = (Color)this.defaultColors.get(ReportStatusEnum.UnWeave.getName());
            } else if (reportStatus.intValue() == 2) {
                color = (Color)this.defaultColors.get(ReportStatusEnum.Weaving.getName());
            } else if (reportStatus.intValue() == 3) {
                color = (Color)this.defaultColors.get(ReportStatusEnum.Audited.getName());
            } else if (reportStatus.intValue() == 4) {
                color = (Color)this.defaultColors.get(ReportStatusEnum.Commited.getName());
            }
            this.tblMain.getRow(i).getStyleAttributes().setBackground(color);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void refresh13Period() {
        if (!CslRptUtil.isSupport13Period(null)) return;
        RptPeriodTypeEnum RptPeriodTypeEnum2 = (RptPeriodTypeEnum)this.cmbxPeriodType.getSelectedItem();
        int periodType = RptPeriodTypeEnum2 == null ? 0 : RptPeriodTypeEnum2.getValue();
        DataCollectInfo dc = (DataCollectInfo)this.cbxDataCollect.getSelectedItem();
        if (3 == periodType) {
            if (RPTDateUtil.isYearLastPeriod((Date)((Date)this.dpReportDate.getValue()), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY)) {
                if (dc != null && dc.getNumber().equals("ACTUALDATA")) {
                    this.period.setEnabled(true);
                    CslRptUIUtil.setSpineRange((KDSpinner)this.period, (int)12, (int)13);
                    return;
                }
                SpinnerModel sm = this.period.getModel();
                if (!(sm instanceof SpinnerNumberModel)) {
                    return;
                }
                SpinnerNumberModel nm = (SpinnerNumberModel)sm;
                if (nm.getValue() != null && (Integer)nm.getValue() == 13) {
                    nm.setValue(new Integer(12));
                }
                this.period.setEnabled(false);
                CslRptUIUtil.setSpineRange((KDSpinner)this.period, (int)0, (int)365);
                return;
            }
        }
        this.period.setEnabled(false);
        CslRptUIUtil.setSpineRange((KDSpinner)this.period, (int)0, (int)365);
    }
}

