/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.expr.TableRelations;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.table.ITableAliasParser;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCaclProxy;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import java.util.Collection;
import java.util.HashMap;

public class SheetContainerClient {
    private ReportBaseInfo rptInfo = null;
    protected HashMap tables = null;
    private int level = 0;

    public SheetContainerClient(ReportBaseInfo report) {
        this.rptInfo = report;
    }

    public ReportBaseInfo getRptInfo() {
        return this.rptInfo;
    }

    public Collection getTables() {
        if (!this.isLoaded()) {
            this.load();
        }
        return this.tables == null ? null : this.tables.values();
    }

    public boolean isLoaded() {
        return this.tables != null && this.tables.size() > 1;
    }

    public boolean load() {
        this.tables = null;
        Collection chain = null;
        KDF kdf = null;
        if (this.rptInfo != null) {
            try {
                kdf = this.rptInfo.getKDF();
                chain = kdf.getAllTable();
            }
            catch (Exception e) {
                chain = null;
                kdf = null;
            }
        }
        if (chain == null || chain.size() < 1 || kdf == null) {
            return false;
        }
        RptSheetParamCollection params = this.rptInfo.getSheetParam();
        TableAliasParser pl = new TableAliasParser();
        TableRelations rela = new TableRelations();
        KDTableHelper.mergeTableRelations((TableRelations)rela, (Collection)chain);
        this.tables = new HashMap(chain.size());
        for (KDTable tbl : chain) {
            Page head = kdf.getHeader(tbl.getID() + "header");
            Page foot = kdf.getFooter(tbl.getID() + "footer");
            tbl.getPrintManager().setHeaderFooter(head, foot);
            tbl.getPrintManager().setExpandedOnly(true);
            tbl.getScriptManager().setRelationsObject(rela);
            tbl.getScriptManager().setAliasParser((ITableAliasParser)pl);
            try {
                ReportCaclProxy proxy = new ReportCaclProxy(tbl, (IObjectValue)this.rptInfo);
                tbl.getScriptManager().addFunctionProvider((Object)proxy);
                proxy.SetSheetParam((IObjectValue)this.getParams(params, tbl.getID()));
                this.tables.put(tbl.getName().toLowerCase(), tbl);
            }
            catch (Exception e) {
                this.tables = null;
                break;
            }
        }
        return this.tables != null;
    }

    private RptSheetParamInfo getParams(RptSheetParamCollection params, String id) {
        if (params == null || id == null) {
            return null;
        }
        for (int i = 0; i < params.size(); ++i) {
            if (!id.equals(params.get(i).getSheetID().trim())) continue;
            return params.get(i);
        }
        return null;
    }

    public synchronized void upgrade() {
        if (this.level++ >= Integer.MAX_VALUE) {
            this.level = 0;
        }
    }

    public int getLevel() {
        return this.level;
    }

    private class TableAliasParser
    implements ITableAliasParser {
        private TableAliasParser() {
        }

        public KDTable parseAlias(String alias) {
            return alias == null ? null : (KDTable)SheetContainerClient.this.tables.get(alias.toLowerCase());
        }
    }
}

