/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.rpt.client.AbstractSheetSelectUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreeSelectionModel;
import org.apache.log4j.Logger;

public class SheetSelectUI
extends AbstractSheetSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(SheetSelectUI.class);

    public SheetSelectUI() throws Exception {
        this.kDTree1.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)SheetSelectUI.this.kDTree1.getModel().getRoot();
                if (event.getNode() == root) {
                    if (root.isChecked()) {
                        try {
                            SheetSelectUI.this.actionSelectAll_actionPerformed(null);
                        }
                        catch (Exception e) {
                            SheetSelectUI.this.handleException(e);
                        }
                    } else {
                        try {
                            SheetSelectUI.this.actionClearAll_actionPerformed(null);
                        }
                        catch (Exception e) {
                            SheetSelectUI.this.handleException(e);
                        }
                    }
                }
            }
        });
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.lable12");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSelectFile_actionPerformed(ActionEvent e) throws Exception {
        this.kDTextField1.setText(this.getPathName(true));
        this.loadTree();
        this.updateBtnOKState();
    }

    private void updateBtnOKState() {
        boolean enable = false;
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode note = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (!note.isChecked()) continue;
            enable = true;
            break;
        }
        this.btnOK.setEnabled(enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTree() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.lable13"));
        this.kDTree1.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        this.kDTree1.setShowCheckBox(true);
        String path = this.kDTextField1.getText();
        if (path == null || path.trim().length() == 0) {
            return;
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
            String line = in.readLine();
            while (line != null) {
                try {
                    line = line.trim();
                    if (line.startsWith("[") && line.endsWith("]")) {
                        String sheetName = line.substring(1, line.length() - 1).trim();
                        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
                        node.setChecked(true);
                        node.setText(sheetName);
                        root.add((MutableTreeNode)node);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"create tree node Exception", (Throwable)e);
                }
                line = in.readLine();
            }
        }
        catch (FileNotFoundException e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.lable5"));
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)"close BufferedReader Exception", (Throwable)e);
                }
            }
        }
        this.kDTree1.expandAllNodes(true, (TreeNode)root);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode note = (DefaultKingdeeTreeNode)root.getChildAt(i);
            note.setChecked(true);
        }
        this.updateBtnOKState();
        this.kDTree1.updateUI();
        this.kDTree1.expandAllNodes(true, (TreeNode)root);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode note = (DefaultKingdeeTreeNode)root.getChildAt(i);
            note.setChecked(false);
        }
        this.updateBtnOKState();
        this.kDTree1.updateUI();
        this.kDTree1.expandAllNodes(true, (TreeNode)root);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        HashMap map = (HashMap)this.getUIContext().get("RETURN_OBJECT");
        map.put("BTN", "OK");
        map.put("FILE_NAME", this.kDTextField1.getText());
        map.put("SHEET_NAMES", this.getSelectSheets());
        this.disposeUIWindow();
    }

    private ArrayList getSelectSheets() {
        ArrayList<String> list = new ArrayList<String>();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode note = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (!note.isChecked()) continue;
            list.add(note.getText());
        }
        return list;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        HashMap map = (HashMap)this.getUIContext().get("RETURN_OBJECT");
        map.put("BTN", "CANCEL");
        this.disposeUIWindow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        HashMap map = (HashMap)this.getUIContext().get("RETURN_OBJECT");
        map.put("BTN", "CANCEL");
        this.kDTextField1.setEditable(false);
        DefaultTreeSelectionModel sm = new DefaultTreeSelectionModel();
        sm.setSelectionMode(2);
        this.kDTree1.setSelectionModel((TreeSelectionModel)sm);
        this.kDTree1.setModel((TreeModel)new DefaultTreeModel(null));
        this.btnFileSelect.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnClearAll.setVisible(true);
        this.btnOK.setEnabled(true);
        this.btnSelectAll.setVisible(true);
        this.btnClearAll.setEnabled(true);
        this.btnSelectAll.setEnabled(true);
        this.kDTree1.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)SheetSelectUI.this.kDTree1.getModel().getRoot();
                SheetSelectUI.this.kDTree1.expandAllNodes(true, (TreeNode)root);
                SheetSelectUI.this.updateBtnOKState();
            }
        });
        this.btnOK.setEnabled(false);
        this.loadTree();
    }

    private String getPathName(boolean isInMode) {
        String pathName = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new PathFilter(isInMode));
        if (isInMode) {
            chooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.lable6"));
        } else {
            chooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.lable7"));
        }
        int returnVal = chooser.showOpenDialog((Component)((Object)this));
        if (returnVal == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return pathName;
    }

    private class PathFilter
    extends FileFilter {
        private boolean modeIn;

        public PathFilter(boolean inMode) {
            this.modeIn = inMode;
        }

        @Override
        public boolean accept(File arg0) {
            return arg0.getName().endsWith(".txt") || arg0.getName().endsWith(".txt");
        }

        @Override
        public String getDescription() {
            return ".txt/.TXT";
        }
    }
}

