/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.NewRptConstant;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.client.AbstractStandardTempExportUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class StandardTempExportUI
extends AbstractStandardTempExportUI {
    private static Logger logger = Logger.getLogger(StandardTempExportUI.class);
    private String[] reportSetInfo = null;
    private String[] reportItemInfo = null;
    static final String XML = "xml";
    protected KDFileChooser _chsFile;
    protected Book standandBook;
    protected String curSheetName;
    protected ReportBaseInfo baseInfo;
    private final FileFilter Filter_XML = new SimpleFileFilter("xml", "xml");
    private boolean isCancelExport = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.standandBook = (Book)this.getUIContext().get("standandtemp");
        this.curSheetName = (String)this.getUIContext().get("curSheetName");
        this.baseInfo = (ReportBaseInfo)this.getUIContext().get("objectInfo");
        this.textFile.setEditable(false);
        this.btnFile.addActionListener((ActionListener)new ChooseFileAction());
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardTempExportUI.this.beforeActionPerformed(e);
                try {
                    StandardTempExportUI.this.btnCancel_actionPerformed(e);
                }
                catch (Exception exc) {
                    StandardTempExportUI.this.handUIException(exc);
                }
                finally {
                    StandardTempExportUI.this.afterActionPerformed(e);
                }
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                String fileName = StandardTempExportUI.this.textFile.getText();
                boolean isSuccess = StandardTempExportUI.this.exportToXml(fileName);
                if (!isSuccess && !StandardTempExportUI.this.isCancelExport) {
                    MsgBox.showInfo((String)RptResourceHelper.getString("reportprocessui-fileexport-error"));
                } else {
                    StandardTempExportUI.this.destroyWindow();
                }
            }
        });
        this.reportSetInfo = new String[7];
        this.reportSetInfo[0] = this.getValue("reportSet");
        this.reportSetInfo[1] = this.getValue("reportNumber");
        this.reportSetInfo[2] = this.getValue("reportName");
        this.reportSetInfo[3] = this.getValue("reportNotifyDay");
        this.reportSetInfo[4] = this.getValue("reportNotifyPeriod");
        this.reportSetInfo[5] = this.getValue("weaveUnit");
        this.reportSetInfo[6] = this.getValue("currencyUnit");
        this.reportItemInfo = new String[6];
        this.reportItemInfo[0] = this.getValue("reportItemData");
        this.reportItemInfo[1] = this.getValue("reportNumber");
        this.reportItemInfo[2] = this.getValue("reportItemNumber");
        this.reportItemInfo[3] = this.getValue("reportItemName");
        this.reportItemInfo[4] = this.getValue("reportItemFormula");
        this.reportItemInfo[5] = this.getValue("reportItemValue");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportToXml(String fileName) {
        FileOutputStream fos = null;
        try {
            int startRow;
            int[][] cols;
            if (fileName == null || fileName.trim().length() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.client.designer.DesignerResource", (String)"Select_File_First"));
                boolean bl = false;
                return bl;
            }
            Sheet curSheet = this.standandBook.getSheet(this.curSheetName);
            int sheetRowCount = curSheet.getMaxRowIndex() + 1;
            int sheetColCount = curSheet.getMaxColIndex() + 1;
            String rootName = this.curSheetName;
            Document document = null;
            int titleRow = 3;
            String[] titles = new String[sheetColCount];
            for (int i = 0; i < sheetColCount; ++i) {
                titles[i] = curSheet.getCell(titleRow, i, false) != null && curSheet.getCell(titleRow, i, false).getValue() != null ? curSheet.getCell(titleRow, i, false).getValue().toString() : "";
            }
            int RowCount = sheetRowCount;
            String templateNumber = this.baseInfo.getTemplate().getNumber();
            if ("Auto-Standard-01".equals(templateNumber) || "Auto-Standard-05".equals(templateNumber) || "Auto-Standard-09".equals(templateNumber)) {
                cols = new int[][]{{1, 2}, {4, 5}};
                startRow = 4;
                document = this.generateXMLRoot(rootName, cols, startRow, RowCount, titles);
            } else if ("Auto-Standard-02".equals(templateNumber) || "Auto-Standard-06".equals(templateNumber) || "Auto-Standard-10".equals(templateNumber)) {
                cols = new int[][]{{1, 2}};
                startRow = 4;
                document = this.generateXMLRoot(rootName, cols, startRow, RowCount, titles);
            } else if ("Auto-Standard-03".equals(templateNumber) || "Auto-Standard-07".equals(templateNumber) || "Auto-Standard-11".equals(templateNumber)) {
                cols = new int[][]{{1, 2}};
                startRow = 4;
                document = this.generateXMLRoot(rootName, cols, startRow, RowCount, titles);
            } else if ("Auto-Standard-04".equals(templateNumber) || "Auto-Standard-08".equals(templateNumber)) {
                titleRow = 4;
                titles = new String[sheetColCount];
                for (int i = 0; i < sheetColCount; ++i) {
                    titles[i] = curSheet.getCell(titleRow, i, false) != null && curSheet.getCell(titleRow, i, false).getValue() != null ? curSheet.getCell(titleRow, i, false).getValue().toString() : (curSheet.getCell(3, i, false) != null ? curSheet.getCell(3, i, false).getValue().toString() : "");
                }
                cols = new int[][]{{1, 6}, {7, 12}};
                startRow = 5;
                document = this.generateXMLRoot(rootName, cols, startRow, RowCount, titles);
            } else if ("Auto-Standard-12".equals(templateNumber)) {
                titleRow = 5;
                titles = new String[sheetColCount];
                if (curSheet.getCell(3, 0, false) != null) {
                    titles[0] = curSheet.getCell(3, 0, false).getValue().toString();
                }
                for (int i = 1; i < sheetColCount; ++i) {
                    titles[i] = curSheet.getCell(titleRow, i, false) != null && curSheet.getCell(titleRow, i, false).getValue() != null ? curSheet.getCell(titleRow, i, false).getValue().toString() : (curSheet.getCell(4, i, false) != null ? curSheet.getCell(4, i, false).getValue().toString() : "");
                }
                cols = new int[][]{{1, 10}, {11, 20}};
                startRow = 6;
                document = this.generateXMLRoot(rootName, cols, startRow, RowCount, titles);
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("utf-8");
            fos = new FileOutputStream(new File(fileName));
            XMLWriter writer = new XMLWriter((OutputStream)fos, format);
            writer.write(document);
            writer.close();
            MsgBox.showInfo((Component)((Object)this), (String)RptUtil.getReportResource("report_export_success"));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)"In the method exportToXml() exception!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error((Object)"FileOutputStream close Exception", (Throwable)e);
                }
            }
        }
    }

    private String addExtension(String fileName, String extension) {
        if (extension != null && fileName != null && fileName.length() > extension.length() && fileName.substring(fileName.length() - extension.length() - 1).equalsIgnoreCase("." + extension)) {
            return fileName;
        }
        return fileName + "." + extension;
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkStandardTempChange(int columnCount, String[] titles, int titleRow) {
        block14: {
            this.isCancelExport = false;
            String fileName = this.baseInfo.getTemplate().getNumber() + ".xls";
            String filePath = "com/kingdee/eas/fi/newrpt/client/standardtemp/" + fileName;
            filePath = "/" + filePath;
            InputStream stream = null;
            try {
                stream = NewRptConstant.class.getResourceAsStream(filePath);
                if (stream == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"284_NoExistStandardTemp"));
                    SysUtil.abort();
                }
                KDSBook bookTemplate = POIXlsReader.parse((InputStream)stream);
                KDSSheet sheetTemplate = bookTemplate.getSheet((Object)new Integer(0));
                int sheetColCount = sheetTemplate.getExpandedColumns() + 1;
                boolean isSameReportAndTemp = true;
                if (columnCount != sheetColCount) {
                    isSameReportAndTemp = false;
                    if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"NoSameReportAndTemp")) == 2) {
                        this.isCancelExport = true;
                        SysUtil.abort();
                    }
                    break block14;
                }
                if (!isSameReportAndTemp) break block14;
                for (int i = 0; i < sheetColCount; ++i) {
                    KDSCell srcCell = sheetTemplate.getCell(titleRow, i, false);
                    if (srcCell == null) continue;
                    Object value = srcCell.getValue();
                    if ("".equals(value) && sheetTemplate.getCell(titleRow - 1, i, false) != null) {
                        value = sheetTemplate.getCell(titleRow - 1, i, false).getValue();
                    }
                    if ("".equals(value) && sheetTemplate.getCell(titleRow - 2, i, false) != null) {
                        value = sheetTemplate.getCell(titleRow - 2, i, false).getValue();
                    }
                    if (titles[i].equals(value)) continue;
                    if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"NoSameReportAndTemp")) == 2) {
                        this.isCancelExport = true;
                        SysUtil.abort();
                        continue;
                    }
                    break;
                }
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    logger.error((Object)"InputStream close Exception", (Throwable)e);
                }
            }
        }
    }

    public Document generateXMLRoot(String rootName, int[][] cols, int startRow, int RowCount, String[] titles) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootName);
        root.addAttribute("xsi:schemaLocation", "http://sxbw.audit.gov.cn/AccountingSoftwareDataInterfaceStandard/2010/SOE/XMLSchema " + rootName + ".xsd");
        String xmlHead = "xmlns:" + this.getValue("enterprise");
        root.addAttribute(xmlHead, "http://sxbw.audit.gov.cn/AccountingSoftwareDataInterfaceStandard/2010/SOE/XMLSchema");
        root.addAttribute("xmlns", "http://sxbw.audit.gov.cn/AccountingSoftwareDataInterfaceStandard/2010/SOE/XMLSchema");
        root.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        Element reportSet = root.addElement(this.reportSetInfo[0]);
        String reportNumber = "";
        String reportPerroid = "" + this.baseInfo.getYear();
        reportPerroid = String.valueOf(this.baseInfo.getPeriod()).length() == 1 ? reportPerroid + "0" + String.valueOf(this.baseInfo.getPeriod()) : reportPerroid + String.valueOf(this.baseInfo.getPeriod());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd ");
        String endDateStr = dateFormat.format(this.baseInfo.getEndDate());
        reportSet.addElement(this.reportSetInfo[1]).setText(this.baseInfo.getNumber());
        reportSet.addElement(this.reportSetInfo[2]).setText(this.baseInfo.getName());
        reportSet.addElement(this.reportSetInfo[3]).setText(endDateStr);
        reportSet.addElement(this.reportSetInfo[4]).setText(reportPerroid);
        reportSet.addElement(this.reportSetInfo[5]).setText(this.baseInfo.getCompany().getName());
        reportSet.addElement(this.reportSetInfo[6]).setText(this.baseInfo.getCurrency().getName());
        reportNumber = this.baseInfo.getNumber();
        Sheet curSheet = this.standandBook.getSheet(this.curSheetName);
        String[] colLetter = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        for (int i = 0; i < cols.length; ++i) {
            for (int row = startRow; row < RowCount; ++row) {
                int k = 0;
                for (int col = cols[i][0]; col <= cols[i][1]; ++col) {
                    String templateNumber = this.baseInfo.getTemplate().getNumber();
                    k = "Auto-Standard-04".equals(templateNumber) || "Auto-Standard-08".equals(templateNumber) || "Auto-Standard-12".equals(templateNumber) ? col : ++k;
                    Element reportItem = root.addElement(this.reportItemInfo[0]);
                    reportItem.addElement(this.reportItemInfo[1]).setText(reportNumber);
                    String itemNumber = colLetter[col] + (row + 1);
                    reportItem.addElement(this.reportItemInfo[2]).setText(itemNumber);
                    String itemName = "";
                    itemName = curSheet.getCell(row, col - k, false) == null || curSheet.getCell(row, col - k, false).getValue() == null ? "" : curSheet.getCell(row, col - k, false).getValue().toString() + titles[col];
                    reportItem.addElement(this.reportItemInfo[3]).setText(itemName);
                    String formula = "";
                    if (curSheet.getCell(row, col, false) != null && curSheet.getCell(row, col, false).hasFormula() && StringUtil.isEmptyString((String)(formula = curSheet.getCell(row, col, false).getFormula()))) {
                        formula = "";
                    }
                    reportItem.addElement(this.reportItemInfo[4]).setText(formula);
                    String cellVaule = "";
                    if (curSheet.getCell(row, col, false) != null && curSheet.getCell(row, col, false).getValue() != null) {
                        cellVaule = curSheet.getCell(row, col, false).getValue().toString();
                    }
                    reportItem.addElement(this.reportItemInfo[5]).setText(cellVaule);
                }
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String key) {
        String strValue = "";
        InputStream inStream = null;
        try {
            Properties props = new Properties();
            inStream = StandardTempExportUI.class.getResourceAsStream("/com/kingdee/eas/fi/rpt/client/standardTempExportXml.properties");
            props.load(inStream);
            strValue = props.getProperty(key);
        }
        catch (IOException e) {
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"392_StandardTempExportUI"), (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)"InputStream close Exception", (Throwable)e);
                }
            }
        }
        return strValue;
    }

    private class ChooseFileAction
    extends AbstractAction {
        private ChooseFileAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String fileName = "";
            String currentDirectory = null;
            StandardTempExportUI.this._chsFile = new KDFileChooser(currentDirectory);
            StandardTempExportUI.this._chsFile.addChoosableFileFilter(StandardTempExportUI.this.Filter_XML);
            if (StandardTempExportUI.this._chsFile.showSaveDialog((Component)((Object)StandardTempExportUI.this)) == 0) {
                int showConfirm3;
                File file = StandardTempExportUI.this._chsFile.getSelectedFile();
                fileName = file.getAbsolutePath();
                file = new File(fileName = StandardTempExportUI.this.addExtension(fileName, StandardTempExportUI.XML));
                String name = file.getName();
                if (name.matches(".*[\\>|\\<|\\||\\:|\\?|\\*|\\/|\\\\|\"].*")) {
                    MsgBox.showWarning((String)(name + "\n" + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"invalidFileName", (Locale)SysContext.getSysContext().getLocale())));
                    return;
                }
                if (file.exists() && (showConfirm3 = MsgBox.showConfirm3((Component)StandardTempExportUI.this.textFile, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"file-overwrite-confirm", (Locale)SysContext.getSysContext().getLocale()))) != 0) {
                    StandardTempExportUI.this.destroyWindow();
                    return;
                }
            } else {
                return;
            }
            StandardTempExportUI.this.textFile.setText(fileName);
        }
    }
}

