/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.IInitDataFacada;
import com.kingdee.eas.fi.rpt.IRptAutoCptCmtSchema;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.RptAutoCptCmtSchemaCollection;
import com.kingdee.eas.fi.rpt.RptAutoCptCmtSchemaFactory;
import com.kingdee.eas.fi.rpt.RptAutoCptCmtSchemaInfo;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.AbstractTemplateAutoCalcCmtUI;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class TemplateAutoCalcCmtUI
extends AbstractTemplateAutoCalcCmtUI {
    private EASWfServiceClient workflowClient = null;
    RptAutoCptCmtSchemaInfo info = null;
    private static final Logger logger = CoreUIObject.getLogger(TemplateAutoCalcCmtUI.class);
    IRptAutoCptCmtSchema iRptCalcScheme = RptAutoCptCmtSchemaFactory.getRemoteInstance();
    private String schedule = null;

    public void onLoad() throws Exception {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"232_TemplateAutoCalcCmtUI"));
        IInitDataFacada iInitDataFacada = InitDataFacadaFactory.getRemoteInstance();
        this.btnCurrency.addItem(null);
        CurrencyCollection initCurrencyCollection = iInitDataFacada.getCurrencyNoGLC();
        if (initCurrencyCollection != null && initCurrencyCollection.size() > 0) {
            this.btnCurrency.addItems(initCurrencyCollection.toArray());
        }
        this.btnCurrency.setSelectedIndex(0);
        this.btnCancel.setEnabled(true);
        this.btnSet2.setEnabled(true);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("currency.*"));
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("template.id", this.getUIContext().get("id")));
        RptAutoCptCmtSchemaCollection c = this.iRptCalcScheme.getCollection(view);
        if (c != null && c.size() > 0) {
            this.info = c.get(0);
        } else {
            this.info = new RptAutoCptCmtSchemaInfo();
            TemplateInfo t = new TemplateInfo();
            t.setId(BOSUuid.read((String)this.getUIContext().get("id").toString()));
            this.info.setTemplate(t);
            this.info.setCurrency((CurrencyInfo)this.btnCurrency.getSelectedItem());
        }
        super.onLoad();
        this.btnCurrency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CurrencyInfo c = (CurrencyInfo)TemplateAutoCalcCmtUI.this.btnCurrency.getSelectedItem();
                TemplateAutoCalcCmtUI.this.info.setCurrency(c);
                TemplateAutoCalcCmtUI.this.loadFields();
            }
        });
        this.loadFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setSchedule(this.info.getShcema());
        for (int i = 0; i < this.btnCurrency.getItemCount(); ++i) {
            CurrencyInfo cin = (CurrencyInfo)this.btnCurrency.getItemAt(i);
            if (this.info.getCurrency() == null || !this.info.getCurrency().getId().equals((Object)cin.getId())) continue;
            this.btnCurrency.setSelectedIndex(i);
            break;
        }
        if (this.getSchedule() != null && this.getSchedule().trim().length() > 0) {
            this.kDTextArea1.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"233_TemplateAutoCalcCmtUI"));
        } else {
            this.kDTextArea1.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"234_TemplateAutoCalcCmtUI"));
        }
        this.updateBtnState();
    }

    void updateBtnState() {
        if (this.info.getCurrency() != null && this.getSchedule() != null && this.getSchedule().trim().length() > 0) {
            this.btnOK.setEnabled(true);
        } else {
            this.btnOK.setEnabled(false);
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        FunctionObjectInfo function = this.getForewarnFunction();
        OperationInfo operation = function.getOperation().get(1);
        HashMap<String, String> jobContext = new HashMap<String, String>();
        if (this.getRptCalcSchemeInfo().getId() == null) {
            BOSUuid uuid = BOSUuid.create((BOSObjectType)this.iRptCalcScheme.getType());
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            jobContext.put("pk", pk.toString());
            String jobProcessDefID = this.getWorkflowClient().createJobProcessDef("TemplateAutoCalc", function, operation, jobContext, this.getSchedule(), SysContext.getSysContext().getLocale());
            this.getRptCalcSchemeInfo().setJobProcessDef(jobProcessDefID);
            this.getRptCalcSchemeInfo().setId(uuid);
            this.iRptCalcScheme.addnew((IObjectPK)pk, this.getRptCalcSchemeInfo());
        } else {
            ObjectUuidPK schemePk = new ObjectUuidPK(this.getRptCalcSchemeInfo().getId());
            jobContext.put("pk", schemePk.toString());
            this.getWorkflowClient().updateProcessSchedule(this.getRptCalcSchemeInfo().getJobProcessDef(), this.getSchedule());
            this.iRptCalcScheme.update((IObjectPK)schemePk, this.getRptCalcSchemeInfo());
        }
        this.destroyWindow();
    }

    private FunctionObjectInfo getForewarnFunction() {
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.fi.rpt.app.ReportCaclSoluFunc");
        FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)functionPK);
        return function;
    }

    public RptAutoCptCmtSchemaInfo getRptCalcSchemeInfo() {
        return this.info;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.destroyWindow();
    }

    private EASWfServiceClient getWorkflowClient() throws Exception {
        if (this.workflowClient == null) {
            this.workflowClient = new EASWfServiceClient();
            this.workflowClient.init(UIConfig.getUrl(), SysContext.getSysContext().getSessionID());
        }
        return this.workflowClient;
    }

    @Override
    public void actionSet_actionPerformed(ActionEvent e) throws Exception {
        super.actionSet_actionPerformed(e);
        String scd = ProcessSchedulePlan.open((Object)((Object)this), (String)this.getSchedule());
        this.info.setShcema(scd);
        this.loadFields();
    }
}

