/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.OperationType;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.PermItemCheckBoxGroup;
import com.kingdee.eas.base.permission.client.discreteImpl.DiscreteViewFactory;
import com.kingdee.eas.base.permission.client.discreteImpl.DiscreteViewPermissionHelper;
import com.kingdee.eas.base.permission.client.helper.OrgHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientCenter;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientDefaultImpl;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.rptnewui.ReportWorktableUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.TemplateWorktableUI;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.UserUnDiscreteAccreditFacadeFactory;
import com.kingdee.eas.fi.rpt.VersionStatusEnum;
import com.kingdee.eas.fi.rpt.client.AbstractUserUnDiscreteAccreditUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class UserUnDiscreteAccreditUI
extends AbstractUserUnDiscreteAccreditUI {
    private static final Logger logger = CoreUIObject.getLogger(UserUnDiscreteAccreditUI.class);
    protected boolean isRpt = true;
    public static final String BOS_OBJECT_TYPE = "bosObjectType";
    private BOSObjectType bizObjectType = null;
    private DiscreteViewPermissionHelper viewHelper = null;
    private PermItemCheckBoxGroup checkBoxGroup = new PermItemCheckBoxGroup();
    protected boolean isCtrlPress = false;
    protected KDTable kdtable = null;
    protected OrgUnitInfo orgUnitInfo = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadUIContext();
        this.initUI();
    }

    protected void initUI() throws Exception {
        if (this.isRpt) {
            this.kdtable = this.rptkDTable;
        } else {
            this.kdtable = this.templatekDTable;
            this.kdtable.setVisible(true);
            this.rptkDTable.setVisible(false);
        }
        if (!this.isRpt) {
            this.filterComBox.removeAllItems();
            this.filterComBox.addItem((Object)RptUtil.getReportResource("484_templateNumber"));
            this.filterComBox.addItem((Object)RptUtil.getReportResource("485_templateName"));
            this.filterComBox.setSelectedIndex(0);
        }
        this.initTblMain();
        this.initOrgF7();
        this.initUser();
        this.initPermItemPanel();
    }

    protected void initTblMain() throws Exception {
        this.kdtable.checkParsed();
        this.kdtable.getSelectManager().setSelectMode(10);
        this.kdtable.getDataRequestManager().setDataRequestMode(0);
        this.kdtable.getStyleAttributes().setLocked(true);
        this.kdtable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock selectBlock;
                if (!UserUnDiscreteAccreditUI.this.isCtrlPress && (selectBlock = e.getSelectBlock()) != null) {
                    if (selectBlock.getBottom() - selectBlock.getTop() > 0) {
                        for (int i = selectBlock.getTop(); i <= selectBlock.getBottom(); ++i) {
                            UserUnDiscreteAccreditUI.this.kdtable.getCell(i, 0).setValue((Object)((Boolean)UserUnDiscreteAccreditUI.this.kdtable.getCell(i, 0).getValue() == false ? 1 : 0));
                        }
                    } else if (selectBlock.getBottom() - selectBlock.getTop() == 0 && selectBlock.getBeginCol() == selectBlock.getEndCol() && selectBlock.getBeginCol() == 0) {
                        ICell cell;
                        cell.setValue((Object)((cell = UserUnDiscreteAccreditUI.this.kdtable.getCell(selectBlock.getBottom(), selectBlock.getBeginCol())).getValue() != null ? false : (Boolean)cell.getValue() == false));
                    }
                }
            }
        });
        this.kdtable.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    UserUnDiscreteAccreditUI.this.isCtrlPress = true;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (UserUnDiscreteAccreditUI.this.isCtrlPress) {
                    UserUnDiscreteAccreditUI.this.isCtrlPress = false;
                }
            }
        });
        this.kdtable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent paramMouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent paramMouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent paramMouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent paramMouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent paramMouseEvent) {
                if (UserUnDiscreteAccreditUI.this.isCtrlPress) {
                    UserUnDiscreteAccreditUI.this.isCtrlPress = false;
                }
            }
        });
        this.kdtable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    if (e.getButton() == 1 && e.getClickCount() == 1 && UserUnDiscreteAccreditUI.this.isCtrlPress) {
                        UserUnDiscreteAccreditUI.this.kdtable.getEditManager().stopEditing();
                        IRow row = UserUnDiscreteAccreditUI.this.kdtable.getRow(e.getRowIndex());
                        boolean isSelect = (Boolean)row.getCell("isSelected").getValue();
                        row.getCell("isSelected").setValue((Object)(!isSelect ? 1 : 0));
                        UserUnDiscreteAccreditUI.this.kdtable.checkParsed();
                    }
                }
                catch (Exception exc) {
                    UserUnDiscreteAccreditUI.this.handUIException(exc);
                }
            }
        });
        this.kdtable.getColumn("isSelected").getStyleAttributes().setLocked(false);
    }

    private void loadUIContext() {
        if (this.getUIContext().get(BOS_OBJECT_TYPE) == null) {
            throw new IllegalArgumentException("discreteAccreditContext can not be NULL.");
        }
        this.bizObjectType = (BOSObjectType)this.getUIContext().get(BOS_OBJECT_TYPE);
        this.isRpt = new ReportInfo().getBOSType().equals((Object)this.bizObjectType);
        this.viewHelper = DiscreteViewFactory.create((String)this.bizObjectType.toString());
        this.orgUnitInfo = this.getUIContext().get("orgUnitInfo") != null ? (OrgUnitInfo)this.getUIContext().get("orgUnitInfo") : SysContext.getSysContext().getCurrentFIUnit();
    }

    private void initPermItemPanel() throws EASBizException, BOSException {
        this.pnlPermItem.setLayout((LayoutManager)new FlowLayout(3));
        this.loadPermItems();
    }

    private void loadPermItems() throws EASBizException, BOSException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        Set permItemNames = (Set)iPermission.getConfigurationInfo().getDiscretEntityPermItems().get(this.bizObjectType.toString());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", new HashSet(permItemNames), CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("enableDataPermission", (Object)new Integer(1)));
        entityViewInfo.setFilter(filterInfo);
        IPermItem iPermItem = PermItemFactory.getRemoteInstance();
        PermItemCollection permItems = iPermItem.getPermItemCollection(entityViewInfo);
        HashSet setPermItemPK = new HashSet();
        this.viewHelper.loadPermItem(permItems, this.checkBoxGroup, this.pnlPermItem, setPermItemPK);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KDCheckBox curCheckBox = (KDCheckBox)e.getSource();
                PermItemInfo curPermItemInfo = (PermItemInfo)curCheckBox.getUserObject();
                if (curPermItemInfo != null && OperationType.READ.equals((Object)curPermItemInfo.getOperationType())) {
                    if (curCheckBox.isSelected()) {
                        UserUnDiscreteAccreditUI.this.setNoReadPermEnable(false, true);
                    } else {
                        UserUnDiscreteAccreditUI.this.setNoReadPermEnable(true, null);
                    }
                }
            }
        };
        Iterator iter = this.checkBoxGroup.iterator();
        while (iter.hasNext()) {
            ((KDCheckBox)iter.next()).addChangeListener(changeListener);
        }
        this.checkBoxGroup.setAllSelected(true);
    }

    protected void setNoReadPermEnable(boolean isEnable, Boolean isSelected) {
        for (KDCheckBox checkBox : this.checkBoxGroup) {
            PermItemInfo permItemInfo = (PermItemInfo)checkBox.getUserObject();
            if (permItemInfo == null || OperationType.READ.equals((Object)permItemInfo.getOperationType())) continue;
            checkBox.setEnabled(isEnable);
            if (isSelected == null) continue;
            checkBox.setSelected(isSelected.booleanValue());
        }
    }

    protected void initUser() throws EASBizException, BOSException {
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(new FilterInfo());
            StringBuffer oql = new StringBuffer();
            oql.append("USER.id in(select distinct fuserid from ").append(this.isRpt ? "T_PM_DiscretePermReport" : "T_PM_DiscretePermRptTemplate");
            oql.append(" where fuserid<>'").append(ToolUtils.getCurrentUserPK()).append("' ");
            if (this.orgPromBox.getData() != null && this.orgPromBox.getData() instanceof OrgUnitInfo) {
                oql.append(" and forgId='").append(((OrgUnitInfo)this.orgPromBox.getData()).getId().toString()).append("'");
            }
            oql.append(" ) ");
            viewInfo.getFilter().mergeFilter(new FilterInfo(oql.toString()), "and");
            this.userPromBox.setEntityViewInfo(viewInfo);
            this.userPromBox.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    try {
                        UserUnDiscreteAccreditUI.this.actionQuery_actionPerformed(null);
                    }
                    catch (Exception e) {
                        UserUnDiscreteAccreditUI.this.handUIException(e);
                    }
                }
            });
            this.userPromBox.setEditable(false);
        }
        catch (Exception ex) {
            logger.error((Object)"initUser error", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    protected void initOrgF7() throws EASBizException, BOSException {
        OrgType orgType = OrgHelper.getBizObjectOrgType((BOSObjectType)this.bizObjectType);
        OrgTypeClientDefaultImpl clientHelper = (OrgTypeClientDefaultImpl)OrgTypeClientCenter.getInstance().getClientImp(orgType);
        NewOrgViewF7PromptDialog orgF7 = clientHelper.createNewF7ByCondition("TREETYPE_ORDINARY");
        this.orgPromBox.setSelector((KDPromptSelector)orgF7);
        this.orgPromBox.setEditable(false);
        this.viewHelper.setF7FilterInfo(orgF7, orgType, ToolUtils.getCurrentUserPK());
        this.orgPromBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    UserUnDiscreteAccreditUI.this.actionQuery_actionPerformed(null);
                    UserUnDiscreteAccreditUI.this.initUser();
                }
                catch (Exception e) {
                    UserUnDiscreteAccreditUI.this.handUIException(e);
                }
            }
        });
        this.orgPromBox.setData((Object)this.orgUnitInfo);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.setSelect(true);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.setSelect(false);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String orgId = null;
        if (this.orgPromBox.getData() != null && this.orgPromBox.getData() instanceof OrgUnitInfo && ((OrgUnitInfo)this.orgPromBox.getData()).getId() != null) {
            orgId = ((OrgUnitInfo)this.orgPromBox.getData()).getId().toString();
        }
        String userId = null;
        if (this.userPromBox.getData() != null && this.userPromBox.getData() instanceof UserInfo && ((UserInfo)this.userPromBox.getData()).getId() != null) {
            userId = ((UserInfo)this.userPromBox.getData()).getId().toString();
        }
        String numberTxt = null;
        String nameTxt = null;
        if (this.filterComBox.getSelectedIndex() == 0) {
            numberTxt = this.filterTxt.getText();
        }
        if (this.filterComBox.getSelectedIndex() == 1) {
            nameTxt = this.filterTxt.getText();
        }
        this.kdtable.removeRows();
        List datas = UserUnDiscreteAccreditFacadeFactory.getRemoteInstance().getPermBizDatas(userId, orgId, numberTxt, nameTxt, this.isRpt);
        if (datas != null) {
            int rowFrom = this.kdtable.getRowCount3();
            this.insertRows(datas, rowFrom, this.kdtable);
        }
        this.checkBoxGroup.setAllSelected(true);
    }

    private void insertRows(List rows, int insertRowIndex, KDTable table) throws Exception {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        table.setRefresh(false);
        KDTColumns columns = table.getColumns();
        IRow row = null;
        ICell cell = null;
        Object value = null;
        String columnKey = null;
        for (int i = 0; i < rows.size(); ++i) {
            Map rowData = (Map)rows.get(i);
            rowData.put("isSelected".toUpperCase(Locale.ENGLISH), true);
            row = table.setRow(insertRowIndex++);
            for (int c = 0; c < columns.size(); ++c) {
                columnKey = columns.getColumnKey(c);
                cell = row.getCell(columnKey);
                if (!rowData.containsKey(columnKey = columnKey.toUpperCase(Locale.ENGLISH))) continue;
                value = rowData.get(columnKey);
                if ("PERIODTYPE".equals(columnKey) && value != null) {
                    cell.setValue((Object)RptPeriodTypeEnum.getEnum((int)Integer.valueOf(value.toString())));
                    continue;
                }
                if ("AUDITEDSTATUS".equals(columnKey) && value != null) {
                    cell.setValue((Object)AuditedStatusEnum.getEnum(Integer.valueOf(value.toString())));
                    continue;
                }
                if ("VERSIONSTATUS".equals(columnKey) && value != null) {
                    cell.setValue((Object)VersionStatusEnum.getEnum(Integer.valueOf(value.toString())));
                    continue;
                }
                if ("TEMPLATETYPE".equals(columnKey) && value != null) {
                    cell.setValue((Object)RptTmpTypeEnum.getEnum(Integer.valueOf(value.toString())));
                    continue;
                }
                cell.setValue(value);
            }
        }
        table.setRefresh(true);
        table.reLayoutAndPaint();
    }

    @Override
    public void actionUnDiscrete_actionPerformed(ActionEvent e) throws Exception {
        List<String> permItems;
        List<String[]> selectDatas = this.getSelectedDatas();
        if (selectDatas == null || selectDatas.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)RptUtil.getReportResource(this.isRpt ? "477_selectRpt" : "478_selectTemplate"));
            this.abort();
        }
        if ((permItems = this.getSelectPermItems()) == null || permItems.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)RptUtil.getReportResource("479_selectPermItem"));
            this.abort();
        }
        UserUnDiscreteAccreditFacadeFactory.getRemoteInstance().unDiscreteAccredit(selectDatas, permItems, this.isRpt);
        this.actionQuery_actionPerformed(e);
        MsgBox.showInfo((Component)((Object)this), (String)RptUtil.getReportResource(this.isRpt ? "480_rptUnDisSuccess" : "481_tmplateUnDisSuccess"));
    }

    public List<String> getSelectPermItems() throws Exception {
        ArrayList<String> permItems = new ArrayList<String>();
        for (KDCheckBox checkBox : this.checkBoxGroup) {
            PermItemInfo permItemInfo;
            if (!checkBox.isSelected() || (permItemInfo = (PermItemInfo)checkBox.getUserObject()) == null || permItemInfo.getId() == null) continue;
            permItems.add(permItemInfo.getId().toString());
        }
        return permItems;
    }

    public List<String[]> getSelectedDatas() throws Exception {
        ArrayList<String[]> datas = new ArrayList<String[]>();
        IRow row = null;
        for (int i = 0; i < this.kdtable.getRowCount(); ++i) {
            row = this.kdtable.getRow(i);
            if (row == null || !((Boolean)row.getCell("isSelected").getValue()).booleanValue()) continue;
            Object userId = row.getCell("discreteUserId").getValue();
            Object orgId = row.getCell("orgId").getValue();
            Object objId = row.getCell("objId").getValue();
            if (userId == null || orgId == null || objId == null) continue;
            datas.add(new String[]{userId.toString(), orgId.toString(), objId.toString()});
        }
        return datas;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension == null) {
            dimension = new Dimension();
        }
        dimension.setSize(900, 470);
        return dimension;
    }

    public void setSelect(boolean isSelect) {
        for (int i = 0; i < this.kdtable.getRowCount(); ++i) {
            this.kdtable.getRow(i).getCell("isSelected").setValue((Object)isSelect);
        }
        this.kdtable.checkParsed();
    }

    public static void addUnDiscreteAccreditMenum(final CoreUI mainUI, KDMenu menuBiz, final boolean isRpt) {
        for (int i = 0; i < menuBiz.getItemCount(); ++i) {
            if (menuBiz.getItem(i) == null || (!isRpt || !"menuBathDiscreteAccredit".equals(menuBiz.getItem(i).getName())) && (isRpt || !"menuDiscreteAccredit".equals(menuBiz.getItem(i).getName()))) continue;
            KDMenuItem unDiscreteMenu = new KDMenuItem();
            unDiscreteMenu.setText(RptUtil.getReportResource(isRpt ? "482_rptUnDis" : "483_templateUnDis") + "(F)");
            unDiscreteMenu.setMnemonic(70);
            unDiscreteMenu.setIcon(EASResource.getIcon((String)"imgTbtn_undistribute"));
            unDiscreteMenu.setName("menuUnDiscreteAccredit");
            unDiscreteMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserUnDiscreteAccreditUI.actionUnDiscreteAccredit_actionPerformed(mainUI, isRpt);
                }
            });
            menuBiz.insert((JMenuItem)unDiscreteMenu, i + 1);
            break;
        }
    }

    public static void actionUnDiscreteAccredit_actionPerformed(CoreUI mainUI, boolean isRpt) {
        try {
            UIContext uiContext = new UIContext((Object)mainUI);
            if (mainUI instanceof ReportWorktableUI || mainUI instanceof TemplateWorktableUI) {
                Method method = mainUI.getClass().getDeclaredMethod("getSelectNodeOrgUnitInfo", KDTreeNode.class);
                NewRptUtil.makeAccessible((Method)method);
                Object node = null;
                Object orgUnitInfo = method.invoke((Object)mainUI, node);
                if (orgUnitInfo != null) {
                    uiContext.put((Object)"orgUnitInfo", orgUnitInfo);
                }
            }
            uiContext.put((Object)BOS_OBJECT_TYPE, (Object)(isRpt ? new ReportInfo().getBOSType() : new TemplateInfo().getBOSType()));
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UserUnDiscreteAccreditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            window.show();
        }
        catch (Exception ex) {
            mainUI.handUIException((Throwable)ex);
        }
    }

    public static void setVisible(boolean isVisible, KDMenu menuBiz) {
        for (int i = 0; i < menuBiz.getItemCount(); ++i) {
            if (menuBiz.getItem(i) == null || !"menuUnDiscreteAccredit".equals(menuBiz.getItem(i).getName())) continue;
            menuBiz.getItem(i).setVisible(isVisible);
            return;
        }
    }
}

