/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.eas.fi.rpt.RptContextManager;
import com.kingdee.eas.fi.rpt.ValidatorResults;
import com.kingdee.eas.fi.rpt.client.FormulaValidation;
import com.kingdee.eas.fi.rpt.client.FormulaValidator;
import com.kingdee.eas.fi.rpt.client.FormulaWizardCompoundResult;
import com.kingdee.eas.fi.rpt.client.RptFormula;
import com.kingdee.eas.fi.rpt.client.RptFormulaComp;
import com.kingdee.eas.fi.rpt.client.RptFormulaParameter;
import com.kingdee.eas.fi.rpt.client.ValidatorAction;
import java.util.ArrayList;
import java.util.List;

public class Validator {
    private RptFormula formula;
    private RptFormulaComp formulaContext;
    protected ClassLoader classLoader = null;
    protected boolean useContextClassLoader = false;
    private boolean strict = false;
    private final FormulaWizardCompoundResult paramValues;

    public Validator(RptFormula formula, FormulaWizardCompoundResult res) {
        this.formula = formula;
        this.paramValues = res;
        this.formulaContext = RptFormulaComp.getInstance();
    }

    public boolean validate(ValidatorResults results, RptContextManager context) throws Exception {
        if (this.formula.parameters.size() < 1) {
            return true;
        }
        this.fieldValidate(results, context);
        this.formulaValiate(results, context);
        return results.getResults().size() < 1;
    }

    private void fieldValidate(ValidatorResults results, RptContextManager context) throws Exception {
        for (int i = 0; i < this.formula.parameters.size(); ++i) {
            RptFormulaParameter param = (RptFormulaParameter)this.formula.parameters.get(i);
            if (param.getDepends() == null) continue;
            List depends = param.getDepends();
            for (int j = 0; j < depends.size(); ++j) {
                String depend = (String)depends.get(j);
                FormulaValidator validator = this.formulaContext.getValidator(depend);
                ArrayList<String> vars = new ArrayList<String>(1);
                vars.add('$' + param.getName() + '$');
                ValidatorAction action = new ValidatorAction(validator, vars, this.paramValues);
                action.setClassLoader(this.getClassLoader());
                boolean isvalid = action.validate(results, context);
                if (this.strict || isvalid || validator.isStrict() == null || !validator.isStrict().booleanValue()) continue;
                this.strict = true;
            }
        }
    }

    private void formulaValiate(ValidatorResults results, RptContextManager context) throws Exception {
        for (int i = 0; this.formula.getValidations() != null && i < this.formula.getValidations().size(); ++i) {
            FormulaValidation validation = (FormulaValidation)((Object)this.formula.getValidations().get(i));
            List depends = validation.getDepends();
            for (int j = 0; depends != null && j < depends.size(); ++j) {
                String depend = (String)depends.get(j);
                FormulaValidator validator = this.formulaContext.getValidator(depend);
                ValidatorAction action = new ValidatorAction(validator, validation.getVars(), this.paramValues);
                action.setClassLoader(this.getClassLoader());
                boolean isvalid = action.validate(results, context);
                if (this.strict || isvalid) continue;
                if (validation.isStrict() != null) {
                    if (!validation.isStrict().booleanValue()) continue;
                    this.strict = true;
                    continue;
                }
                if (validator.isStrict() == null || !validator.isStrict().booleanValue()) continue;
                this.strict = true;
            }
        }
    }

    public ClassLoader getClassLoader() {
        ClassLoader contextLoader;
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.useContextClassLoader && (contextLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return contextLoader;
        }
        return this.getClass().getClassLoader();
    }

    public boolean isUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean useContextClassLoader) {
        this.useContextClassLoader = useContextClassLoader;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }
}

