/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client.template;

import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.fi.newrpt.client.designer.ReportMenuState;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import java.awt.Component;

public class TemplateMenuManager
extends IMenuStrategy {
    public void applyMenuState(ReportMenuState state) {
        this.common(state);
        this.refreshAuditMenu(state);
        if (OprtState.ADDNEW.equalsIgnoreCase(state.getEditState()) || OprtState.EDIT.equalsIgnoreCase(state.getEditState())) {
            this.edit();
        } else if (OprtState.VIEW.equalsIgnoreCase(state.getEditState())) {
            this.view();
        }
    }

    private void view() {
        Component component = this.findMenuUsingPath("menuTool/itemIdxItemDefine");
        if (component != null) {
            component.setEnabled(false);
        }
    }

    private void edit() {
    }

    private void common(ReportMenuState state) {
        boolean isDynamic;
        boolean canSave = ReportMenuState.ADDNEW.equals(state.getEditState()) || ReportMenuState.EDIT.equals(state.getEditState());
        this.enableVisibleMenu("menuFile/menuItemSave", true, canSave);
        TemplateInfo template = (TemplateInfo)state.getBookProvider().getEditValue();
        RptTmpTypeEnum templateType = template.getTemplateType();
        this.enableVisibleMenu("menuFile/itemCopyImport", false, false);
        this.enableVisibleMenu("menuEdit/menuClear/menuItemClearComments", false, false);
        this.enableVisibleMenu("menuView/menuItemViewValue", false, true);
        this.enableVisibleMenu("menuView/menuComments", false, false, true);
        this.enableVisibleMenu("menuInsert/menuInsertComments", false, false, true);
        this.enableVisibleMenu("menuTool/menuItemCalculator", false, false);
        this.enableVisibleMenu("menuTool/menuItemSheeSum", false, false);
        this.enableVisibleMenu("menuTool/menuReportCheck/menuItemReportCheck", false, false);
        this.enableVisibleMenu("menuTool/menuReportRound/menuItemReportRound", false, false);
        this.enableVisibleMenu("menuTool/menuConvert/menuItemConvert", false, false);
        this.enableVisibleMenu("menuTool/menuItemAttachement", false, false);
        this.enableVisibleMenu("menuTool/miEnumTemplateWizard", false, false);
        int type = templateType.getValue();
        boolean bl = isDynamic = type == 12 || type == 10 || type == 11 || type == 15 || type == 17 || type == 16;
        if (type == 10 || type == 12 || type == 15 || type == 16) {
            this.enableVisibleMenu("menuTool/menuItemGradeSetting", false, false);
        } else {
            this.enableVisibleMenu("menuTool/menuItemGradeSetting", isDynamic, isDynamic);
        }
        this.enableVisibleMenu("menuFile/menuItemSaveas", true, !isDynamic);
        this.enableVisibleMenu("menuTool/itemIdxItemDefine", true, !isDynamic);
        this.enableVisibleMenu("menuTool/itemIdxItemList", true, !isDynamic);
        this.enableVisibleMenu("menuTool/miEnumItemWizard", isDynamic, isDynamic);
        this.enableVisibleMenu("menuTool/itemItemFill", false, false);
        this.enableVisibleMenu("menuTool/itemCheckItemFormula", false, false);
        this.enableVisibleMenu("menuTool/miInnerCompanyFill", false, false);
        this.enableVisibleMenu("menuTool/orgBoundSelect", false, false);
        this.enableVisibleMenu("menuData", false, false, true);
        this.enableVisibleMenu("menuData", true, true);
        this.enableVisibleMenu("menuData/menuItemValidation", true, true);
        this.enableVisibleMenu("menuData/menuItemGroup", true, true);
        this.enableVisibleMenu("menuData/menuItemGroup/menuItemCreateGroup", true, true);
        this.enableVisibleMenu("menuData/menuItemGroup/menuItemDelGroup", true, true);
        this.enableVisibleMenu("menuData/menuItemGroup/menuItemConfigGroup", true, true);
        this.enableVisibleMenu("menuData/menuItemGroup/menuItemClearGroup", true, true);
        this.enableVisibleMenu("menuData/menuItemGroup/menuItemHideGroup", true, true);
        this.enableVisibleMenu("menuData/menuItemGroup/menuItemShowGroup", true, true);
        this.enableVisibleMenu("menuData/menuItemCalculateOptions", true, true);
        this.enableVisibleMenu("menuView/menuItemReportVariables", true, true);
        this.groupStrategy(type);
        this.commonPublicStrategy();
    }

    public void refreshAuditMenu(ReportMenuState state) {
        TemplateInfo template = (TemplateInfo)state.getBookProvider().getEditValue();
        int type = template.getTemplateType().getValue();
        boolean useWorkFlow = type == 1 || type == 3 || type == 12;
        boolean isAudited = template.getAuditedStatus().getValue() == 2;
        boolean isVersion = template.getVersionStatus().getValue() == 2;
        boolean isGroupTemplate = type == 6 || type == 10;
        String meunText = isAudited ? RptUtil.getRptMenuResource("miUnAudit") : RptUtil.getRptMenuResource("miAudit");
        this.setMenuText("menuTool/menuItemAudit", meunText);
        if (useWorkFlow) {
            meunText = isAudited ? RptUtil.getRptMenuResource("submitUnAudit") : RptUtil.getRptMenuResource("submitAudit");
            this.setMenuText("menuTool/itemWorkflow", meunText);
            this.enableVisibleMenu("menuTool/menuItemAudit", true, !isGroupTemplate && !isVersion);
            this.enableVisibleMenu("menuTool/itemWorkflow", false, false);
            this.enableVisibleMenu("menuTool/unSubmit", false, false);
        } else {
            this.enableVisibleMenu("menuTool/menuItemAudit", true, !isVersion);
            this.enableVisibleMenu("menuTool/itemWorkflow", false, false);
        }
    }

    private void commonPublicStrategy() {
        this.enableVisibleMenu("menuEdit/menuClear/menuItemClearItemFormula", false, false);
        this.enableVisibleMenu("menuRangeContext/menuRightClear/menuItemRightClearItemFormula", false, false);
    }

    private void groupStrategy(int templateType) {
        if (templateType != 6 && templateType != 2) {
            return;
        }
        Component component = this.findMenuUsingPath("menuFile/menuItemSaveas");
        if (component != null) {
            component.setEnabled(false);
        }
    }
}

