/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client.template;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.ba.IRptReportSubscibe;
import com.kingdee.eas.cp.ba.RptReportSubscibeCollection;
import com.kingdee.eas.cp.ba.RptReportSubscibeFactory;
import com.kingdee.eas.cp.ba.RptReportSubscibeInfo;
import com.kingdee.eas.cp.ba.RptSubscibeReceiverCollection;
import com.kingdee.eas.cp.ba.RptSubscibeReceiverInfo;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.ITemplateReportSavePoint;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointCollection;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointFactory;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointInfo;
import com.kingdee.eas.fi.rpt.VersionStatusEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.sql.Timestamp;
import java.util.Calendar;

public class TemplateProvider
extends IBookProvider {
    private FullOrgUnitInfo currCompanyUnitInfo;

    public Book loadBook() throws Exception {
        Book book = null;
        if (this.getTemplateInfo().getData() != null) {
            book = this.getTemplateInfo().getBook();
        }
        if (book == null) {
            return null;
        }
        ReportVariables variables = ReportVariables.loadFromBook((Book)book);
        RptSheetParamCollection sheetParam = this.getTemplateInfo().getSheetParam();
        RptPeriodTypeEnum periodType = this.getTemplateInfo().getPeriodType();
        for (int i = 0; sheetParam != null && i < sheetParam.size(); ++i) {
            RptSheetParamInfo p = sheetParam.get(i);
            ReportVariables sheetV = VariablesHelper.sheetParams2Variables((RptSheetParamInfo)p, (RptPeriodTypeEnum)periodType);
            if (variables == null) {
                variables = new ReportVariables();
            }
            variables.addAll(sheetV, false);
        }
        variables.storeToBook(book);
        return book;
    }

    public void restoreBook(Book book) throws Exception {
        ReportVariables variables = ReportVariables.loadFromBook((Book)book);
        this.getTemplateInfo().getSheetParam().clear();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            String name = sheet.getSheetName();
            RptSheetParamInfo info = VariablesHelper.variables2SheetParams((ReportVariables)variables, (String)name, (boolean)true, null);
            info.setSheetID(sheet.getID());
            info.setRelaType(ReportTypeEnum.TEMPLATE);
            this.getTemplateInfo().getSheetParam().add(info);
        }
        RptUtilForClient.prepareReportInfo4Save((IObjectValue)this.getTemplateInfo(), book);
        this.getTemplateInfo().setBook(book);
    }

    public IObjectValue createNewReport() {
        return new TemplateInfo();
    }

    public ICoreBase getBizInterface() throws Exception {
        return TemplateFactory.getRemoteInstance();
    }

    public void auditTemplate(OrgUnitInfo selectOrg) throws Exception {
        ObjectStringPK pk = new ObjectStringPK();
        pk.setKeyValue(this.getTemplateInfo().getPKField(), (Object)this.getTemplateInfo().getId().toString());
        if (this.getTemplateInfo().getAuditedStatus() == AuditedStatusEnum.AUDITED) {
            ((ITemplate)this.getBizInterface()).unAudit((IObjectPK)pk, selectOrg);
            this.getTemplateInfo().setAuditedStatus(AuditedStatusEnum.UNAUDITED);
            this.getTemplateInfo().setVersionStatus(VersionStatusEnum.CREATED);
        } else {
            ((ITemplate)this.getBizInterface()).audit((IObjectPK)pk);
            this.getTemplateInfo().setAuditedStatus(AuditedStatusEnum.AUDITED);
        }
    }

    public void auditTemplate() throws Exception {
        this.auditTemplate(null);
    }

    public void save() throws Exception {
        if (this.getTemplateInfo().getTemplateType().getValue() == 6 || this.getTemplateInfo().getTemplateType().getValue() == 10 || this.getTemplateInfo().getTemplateType().getValue() == 15 || Boolean.TRUE.equals(this.getTemplateInfo().get("PublilcTemlateNeedVersioning"))) {
            this.copyAndSave(true);
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.getTemplateInfo().getId());
        String oldTemplateId = pk.toString();
        this.getTemplateInfo().getOrgSavePoint().clear();
        if (RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)this.getTemplateInfo().getTemplateType()) && this.getTemplateInfo().getGroupCompany() == null) {
            this.getTemplateInfo().setGroupCompany(this.getCurrCompanyUnitInfo());
        }
        pk = ((ITemplate)this.getBizInterface()).existRpt((IObjectPK)pk) ? ((ITemplate)this.getBizInterface()).tempVersion(this.getTemplateInfo()) : ((ITemplate)this.getBizInterface()).submit((CoreBaseInfo)this.getTemplateInfo());
        this.setRptReportSubscibe(pk.toString(), oldTemplateId);
        this.setEditValue((IObjectValue)RptUtil.filterTemplateReportSavePoint(((ITemplate)this.getBizInterface()).getTemplateInfo((IObjectPK)pk, this.getSelectors())));
    }

    public void saveas() throws Exception {
        this.copyAndSave(false);
    }

    public void copyAndSave(boolean isGroupTempVersion) throws Exception {
        int oldTempType = this.getTemplateInfo().getTemplateType().getValue();
        TemplateInfo copy = (TemplateInfo)this.getTemplateInfo().clone();
        BOSUuid oldId = this.getTemplateInfo().getId();
        copy.setData(this.getTemplateInfo().getData());
        copy.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        copy.setNumber(this.getTemplateInfo().getNumber());
        copy.setName(this.getTemplateInfo().getName());
        copy.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        copy.setAuditor(null);
        copy.setAuditedTime(null);
        if ((oldTempType == 6 || oldTempType == 10 || oldTempType == 14 || oldTempType == 15) && isGroupTempVersion) {
            copy.setId(null);
            TemplateInfo oldTemp = new TemplateInfo();
            oldTemp.setId(oldId);
            if (oldTempType == 10) {
                copy.setTemplateType(RptTmpTypeEnum.DYNAMICNORMALREPORT);
                copy.setIsChangeByTemplate(true);
            } else if (oldTempType == 15) {
                copy.setTemplateType(RptTmpTypeEnum.MULTIDYNAMICCSLREPORT);
                copy.setIsChangeByTemplate(true);
            } else if (oldTempType == 14) {
                copy.setTemplateType(RptTmpTypeEnum.COMMONPUBLICTEMPLATE);
            } else {
                copy.setTemplateType(RptTmpTypeEnum.GROUPCOMMREPORT);
                copy.setIsChangeByTemplate(true);
            }
            copy.setGroupTemplate(oldTemp);
            copy.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            copy.setCreateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
            copy.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
            copy.setVersionStatus(VersionStatusEnum.CREATED);
            copy.setLastUpdateTime(null);
            copy.setLastUpdateUser(null);
        } else {
            copy.setId(null);
            copy.setVersionNumber(null);
            copy.setGroup(null);
            copy.setVersionStatus(VersionStatusEnum.UNVERSION);
            if (oldTempType == 14) {
                copy.setTemplateType(RptTmpTypeEnum.COMMONPUBLICTEMPLATE);
            } else {
                copy.setTemplateType(RptTmpTypeEnum.COMMONREPORT);
            }
            copy.setGroupTemplate(null);
            copy.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
            copy.setVersionStatus(VersionStatusEnum.CREATED);
            copy.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        }
        copy.getOrgSavePoint().clear();
        copy.setCompany(this.getCurrCompanyUnitInfo());
        if (oldTempType == 14 && copy.getGroupCompany() == null) {
            copy.setGroupCompany(this.getCurrCompanyUnitInfo());
        }
        copy.setReportSavePoint(this.getTemplateInfo().getReportSavePoint());
        copy.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        IObjectPK pk = ((ITemplate)this.getBizInterface()).submit((CoreBaseInfo)copy);
        if ((oldTempType == 6 || oldTempType == 10 || oldTempType == 14 || oldTempType == 15) && isGroupTempVersion) {
            this.updateTemplateStatus(this.getTemplateInfo().getId(), pk);
        }
        if (pk != null) {
            copy.setId(BOSUuid.read((String)pk.toString()));
            TemplateReportSavePointCollection reportSavePoint = this.getTemplateInfo().getReportSavePoint();
            ITemplateReportSavePoint iTemplateReportSavePoint = TemplateReportSavePointFactory.getRemoteInstance();
            for (int i = 0; reportSavePoint != null && i < reportSavePoint.size(); ++i) {
                TemplateReportSavePointInfo templateReportSavePointInfo = reportSavePoint.get(i);
                templateReportSavePointInfo.setTemplate(copy);
                iTemplateReportSavePoint.addnew(templateReportSavePointInfo);
            }
            this.setRptReportSubscibe(pk.toString(), oldId.toString());
        }
        this.setEditValue((IObjectValue)RptUtil.filterTemplateReportSavePoint(((ITemplate)this.getBizInterface()).getTemplateInfo(pk, this.getSelectors())));
    }

    private void setRptReportSubscibe(String newTemplateId, String oldTemplateId) throws EASBizException, BOSException {
        String companyId = this.getCurrCompanyUnitInfo().getId().toString();
        String virsualId = "cid=" + companyId + ";tid=" + oldTemplateId;
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection sic = ev.getSelector();
        sic.add(new SelectorItemInfo("personDec"));
        sic.add(new SelectorItemInfo("releaseType"));
        sic.add(new SelectorItemInfo("fromSys"));
        sic.add(new SelectorItemInfo("rptType.*"));
        sic.add(new SelectorItemInfo("rptType.name"));
        sic.add(new SelectorItemInfo("reader.*"));
        sic.add(new SelectorItemInfo("supplyID"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("supplyID", (Object)virsualId));
        filter.setMaskString("#0");
        ev.setFilter(filter);
        RptReportSubscibeCollection cols = null;
        IRptReportSubscibe iSub = null;
        try {
            iSub = RptReportSubscibeFactory.getRemoteInstance();
            cols = iSub.getRptReportSubscibeCollection(ev);
        }
        catch (Exception e) {
            return;
        }
        if (cols == null || cols.isEmpty()) {
            return;
        }
        RptReportSubscibeInfo subInfo = cols.get(0);
        RptSubscibeReceiverCollection reader = subInfo.getReader();
        for (int i = 0; i < reader.size(); ++i) {
            RptSubscibeReceiverInfo rsrInfo = reader.get(i);
            rsrInfo.setId(null);
        }
        virsualId = "cid=" + companyId + ";tid=" + newTemplateId;
        subInfo.setId(null);
        subInfo.setSupplyID(virsualId);
        RptReportSubscibeFactory.getRemoteInstance().submit((CoreBaseInfo)subInfo);
    }

    private void updateTemplateStatus(BOSUuid oldId, IObjectPK newID) throws BOSException, EASBizException {
        if (oldId != null && newID != null) {
            TemplateFactory.getRemoteInstance().updateTemplateStatus(oldId.toString(), newID.toString());
        }
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("includeOtherDC"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.cu.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.*"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.*"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("orgSavePoint.relaType"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.parent.*"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.*"));
        sic.add(new SelectorItemInfo("orgSavePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("reportSavePoint.*"));
        sic.add(new SelectorItemInfo("reportSavePoint.company.*"));
        sic.add(new SelectorItemInfo("groupCompany.id"));
        sic.add(new SelectorItemInfo("groupCompany.name"));
        sic.add(new SelectorItemInfo("groupCompany.number"));
        return sic;
    }

    public TemplateInfo getTemplateInfo() {
        return (TemplateInfo)this.getEditValue();
    }

    public String getBizFactoryName() {
        return TemplateFactory.class.getName();
    }

    public FullOrgUnitInfo getCurrCompanyUnitInfo() {
        return this.currCompanyUnitInfo != null ? this.currCompanyUnitInfo : SysContext.getSysContext().getCurrentFIUnit().castToFullOrgUnitInfo();
    }

    public void setCurrCompanyUnitInfo(FullOrgUnitInfo currCompanyUnitInfo) {
        this.currCompanyUnitInfo = currCompanyUnitInfo;
    }
}

