/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.excelformula;

import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.ParseException;
import com.kingdee.eas.fi.rpt.excelformula.expr.Area3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.NameExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import com.kingdee.eas.util.client.EASResource;
import junit.framework.TestCase;
import org.apache.log4j.Logger;

public class Test
extends TestCase {
    private static final Logger log = Logger.getLogger((String)Test.class.getName());

    public void testParser() {
        try {
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("acct()").toString(), (String)"ACCT()");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("acct(,)").toString(), (String)"ACCT(, )");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("acct(,,)").toString(), (String)"ACCT(, , )");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("acct(a1,)").toString(), (String)"ACCT(A1, )");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("acct(,a1,)").toString(), (String)"ACCT(, A1, )");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("acct(,a1)").toString(), (String)"ACCT(, A1)");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("acct(,a1,,a1,)").toString(), (String)"ACCT(, A1, , A1, )");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("FOG_FA(\"\",\"\",\"\",\"\",\"\",\"\",\"\",0,0,0,\"J\",\"YC\")").toString(), (String)"FOG_FA(\"\", \"\", \"\", \"\", \"\", \"\", \"\", 0, 0, 0, \"J\", \"YC\")");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("1").toString(), (String)"1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("-1").toString(), (String)"-1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("-A1").toString(), (String)"-A1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("-SHEET!A1").toString(), (String)"-SHEET!A1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("-A1*3").toString(), (String)"(-A1)*3");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("+1").toString(), (String)"+1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("+A1").toString(), (String)"+A1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("+SHEET!A1").toString(), (String)"+SHEET!A1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("1+1").toString(), (String)"1+1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("1*1").toString(), (String)"1*1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("1^1").toString(), (String)"1^1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("1&\"1\"").toString(), (String)"1&\"1\"");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("A1").toString(), (String)"A1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("A1:B2").toString(), (String)"A1:B2");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("SHEET!A1").toString(), (String)"SHEET!A1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("SHEET!A1:B3").toString(), (String)"SHEET!A1:B3");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("A1&(\"abc12Asd\")").toString(), (String)"A1&\"abc12Asd\"");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("A1^2+3").toString(), (String)"(A1^2)+3");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("A1^(1+1)+3+2").toString(), (String)"((A1^(1+1))+3)+2");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("'shee!t'!a1:B3").toString(), (String)"'SHEE!T'!A1:B3");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"251_Test")).toString(), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"251_Test"));
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("IF(SIGN(E11)+SIGN(F11)=0,\"***\",IF(OR(SIGN(E11)=0,SIGN(F11)=0),\"***\",G11/ABS(F11)))").toString(), (String)"IF((SIGN(E11)+SIGN(F11))=0, \"***\", IF(OR(SIGN(E11)=0, SIGN(F11)=0), \"***\", G11/ABS(F11)))");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("$K$4&J14").toString(), (String)"$K$4&J14");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("DATEVALUE(CONCATENATE(RPTPERIOD(\"SY\"),\"/\",RPTPERIOD(\"SM\"),\"/\",RPTPERIOD(\"SD\")))").toString(), (String)"DATEVALUE(CONCATENATE(RPTPERIOD(\"SY\"), \"/\", RPTPERIOD(\"SM\"), \"/\", RPTPERIOD(\"SD\")))");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"278_Test") + "\"MMM\"))").toString(), (String)(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"279_Test") + "\"MMM\"))"));
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"252_Test")).toString(), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"253_Test"));
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("SUM(Sheet1!29:30)").toString(), (String)"SUM(SHEET1!29:30)");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("SUM(29:30)").toString(), (String)"SUM(29:30)");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("SUM(Sheet1!A29)").toString(), (String)"SUM(SHEET1!A29)");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("SUM(B:B)").toString(), (String)"SUM(B:B)");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("2473.5+1000000").toString(), (String)"2473.5+1000000");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("A1=B1+C1=D4*B3+a1+acct(\"a\")=$b4=c5").toString(), (String)"A1=((B1+C1)=((((D4*B3)+A1)+ACCT(\"a\"))=($B4=C5)))");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("$a$1").toString(), (String)"$A$1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("b1:$a$1").toString(), (String)"B1:$A$1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("sheet!$a$1:b1").toString(), (String)"SHEET!$A$1:B1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("3+3%").toString(), (String)"3+(3%)");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("3%").toString(), (String)"3%");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("(3%)*3+3").toString(), (String)"((3%)*3)+3");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("(3+3)%*3+3").toString(), (String)"(((3+3)%)*3)+3");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("IF(((3+3)*3)% + 3, 3)").toString(), (String)"IF((((3+3)*3)%)+3, 3)");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("IF(((3+3)*3)% + 3, 3)+ACCT(1)").toString(), (String)"IF((((3+3)*3)%)+3, 3)+ACCT(1)");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("sum(\"\"\"abcd\"\"\"&\"1\", 1, 3)").toString(), (String)"SUM(\"\"\"abcd\"\"\"&\"1\", 1, 3)");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("'_098'!a1").toString(), (String)"'_098'!A1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("a:a").toString(), (String)"A:A");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("1").toString(), (String)"1");
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"254_Test")).toString(), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"254_Test"));
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"255_Test")).toString(), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"255_Test"));
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"256_Test")).toString(), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"257_Test"));
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse("$A$3:$B$3").toString(), (String)"$A$3:$B$3");
            Test.assertTrue((boolean)(ExcelFormulaPaserHelper.parse("Sheet!A1:A2") instanceof Area3DExpr));
            Test.assertTrue((boolean)(ExcelFormulaPaserHelper.parse("Sheet!A1") instanceof Ref3DExpr));
            Test.assertTrue((boolean)(ExcelFormulaPaserHelper.parse("$a$1") instanceof ReferenceExpr));
            Test.assertTrue((boolean)(ExcelFormulaPaserHelper.parse("a1") instanceof ReferenceExpr));
            Test.assertTrue((boolean)(ExcelFormulaPaserHelper.parse("a1a") instanceof NameExpr));
            Test.assertTrue((boolean)(ExcelFormulaPaserHelper.parse(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"255_Test")) instanceof NameExpr));
            Test.assertTrue((boolean)(ExcelFormulaPaserHelper.parse(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"254_Test")) instanceof NameExpr));
            Test.assertEquals((String)ExcelFormulaPaserHelper.parse(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"258_Test")).toString(), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"258_Test"));
            try {
                Test.assertEquals((String)ExcelFormulaPaserHelper.parse("\"" + EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"259_Test")).toString(), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"260_Test"));
            }
            catch (ParseException pe) {
                Test.assertEquals((String)pe.getMessage(), (String)"Cannot Parse, sorry : \" Expected");
            }
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage());
            Test.fail((String)e.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        log.debug((Object)ExcelFormulaPaserHelper.parse("\"" + EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"259_Test")));
    }

    public static Expression a(Expression exp) throws Exception {
        Expression bin = null;
        if (exp instanceof FunctionExpr) {
            FunctionExpr e = (FunctionExpr)exp;
            String s = "";
            for (int i = 0; i < e.parameters.size(); ++i) {
                Expression p = (Expression)e.parameters.get(i);
                if (i != 0) {
                    s = s + "+";
                }
                s = s + e.funcionName + "(" + p.toString() + ")";
            }
            Expression expression = ExcelFormulaPaserHelper.parse(s);
            return expression;
        }
        return bin;
    }
}

