/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.excelformula.util;

public class CellReference {
    private int row;
    private int col;
    private String sheetName;
    private boolean rowAbs;
    private boolean colAbs;
    private static final char ABSOLUTE_REFERENCE_MARKER = '$';

    public CellReference(String cellRef) {
        String[] parts = this.separateRefParts(cellRef);
        this.sheetName = parts[0];
        String colRef = parts[1];
        if (colRef.length() < 1) {
            this.col = -1;
        } else {
            boolean bl = this.colAbs = colRef.charAt(0) == '$';
            if (this.colAbs) {
                colRef = colRef.substring(1);
            }
            this.col = CellReference.convertColStringToIndex(colRef);
        }
        String rowRef = parts[2];
        if (rowRef.length() < 1) {
            this.row = -1;
        } else {
            boolean bl = this.rowAbs = rowRef.charAt(0) == '$';
            if (this.rowAbs) {
                rowRef = rowRef.substring(1);
            }
            this.row = Integer.parseInt(rowRef) - 1;
        }
    }

    public CellReference(int pRow, int pCol) {
        this(pRow, pCol, false, false);
    }

    public CellReference(int pRow, int pCol, boolean pAbsRow, boolean pAbsCol) {
        this.row = pRow;
        this.col = pCol;
        this.rowAbs = pAbsRow;
        this.colAbs = pAbsCol;
    }

    public int getRow() {
        return this.row;
    }

    public short getCol() {
        return (short)this.col;
    }

    public boolean isRowAbsolute() {
        return this.rowAbs;
    }

    public boolean isColAbsolute() {
        return this.colAbs;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setRowAbsolute(boolean b) {
        this.rowAbs = b;
    }

    public void setColAbsolute(boolean b) {
        this.colAbs = b;
    }

    private int convertColStringToNum(String ref) {
        int retval = 0;
        int pos = 0;
        for (int k = ref.length() - 1; k > -1; --k) {
            char thechar = ref.charAt(k);
            retval = pos == 0 ? (retval += Character.getNumericValue(thechar) - 9) : (retval += (Character.getNumericValue(thechar) - 9) * (pos * 26));
            ++pos;
        }
        return retval - 1;
    }

    private String[] separateRefParts(String reference) {
        int loc;
        char[] chars;
        String[] retval = new String[3];
        int start = reference.indexOf("!");
        if (start != -1) {
            retval[0] = reference.substring(0, start);
        }
        if ((chars = reference.toCharArray())[loc = ++start] == '$') {
            ++loc;
        }
        while (loc < chars.length && !Character.isDigit(chars[loc]) && chars[loc] != '$') {
            ++loc;
        }
        retval[1] = reference.substring(start, loc);
        retval[2] = reference.substring(loc);
        return retval;
    }

    private static String convertNumToColString(int col) {
        int excelColNum = col + 1;
        String colRef = "";
        int colRemain = excelColNum;
        while (colRemain > 0) {
            int thisPart = colRemain % 26;
            if (thisPart == 0) {
                thisPart = 26;
            }
            colRemain = (colRemain - thisPart) / 26;
            char colChar = (char)(thisPart + 64);
            colRef = colChar + colRef;
        }
        return colRef;
    }

    public static int convertColStringToIndex(String ref) {
        int pos = 0;
        int retval = 0;
        for (int k = ref.length() - 1; k >= 0; --k) {
            char thechar = ref.charAt(k);
            if (thechar == '$') {
                if (k == 0) break;
                throw new IllegalArgumentException("Bad col ref format '" + ref + "'");
            }
            int shift = (int)Math.pow(26.0, pos);
            retval += (Character.getNumericValue(thechar) - 9) * shift;
            ++pos;
        }
        return retval - 1;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        if (this.col > -1) {
            retval.append(this.colAbs ? "$" : "");
            retval.append(CellReference.convertNumToColString(this.col));
        }
        if (this.row > -1) {
            retval.append(this.rowAbs ? "$" : "");
            retval.append(this.row + 1);
        }
        return retval.toString();
    }
}

