/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.jdbc;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JdbcUtils {
    private static final Log logger = LogFactory.getLog(JdbcUtils.class);

    public static void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                logger.debug((Object)"Could not close JDBC Connection", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.debug((Object)"Unexpected exception on closing JDBC Connection", ex);
            }
        }
    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                logger.debug((Object)"Could not close JDBC Statement", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.debug((Object)"Unexpected exception on closing JDBC Statement", ex);
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                logger.debug((Object)"Could not close JDBC ResultSet", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.debug((Object)"Unexpected exception on closing JDBC ResultSet", ex);
            }
        }
    }

    public static Object getResultSetValue(ResultSet rs, int index) throws SQLException {
        Object obj = rs.getObject(index);
        if (obj instanceof Blob) {
            obj = rs.getBytes(index);
        } else if (obj instanceof Clob) {
            obj = rs.getString(index);
        } else if (obj != null && obj.getClass().getName().startsWith("oracle.sql.TIMESTAMP")) {
            obj = rs.getTimestamp(index);
        } else if (obj != null && obj.getClass().getName().startsWith("oracle.sql.DATE")) {
            String metaDataClassName = rs.getMetaData().getColumnClassName(index);
            obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(index) : rs.getDate(index);
        } else if (obj != null && obj instanceof Date && "java.sql.Timestamp".equals(rs.getMetaData().getColumnClassName(index))) {
            obj = rs.getTimestamp(index);
        }
        return obj;
    }

    public static int countParameterPlaceholders(String str, char placeholder, char delim) {
        return JdbcUtils.countParameterPlaceholders(str, placeholder, "" + delim);
    }

    public static int countParameterPlaceholders(String str, char placeholder, String delimiters) {
        int count = 0;
        boolean insideLiteral = false;
        int activeLiteral = -1;
        for (int i = 0; str != null && i < str.length(); ++i) {
            if (str.charAt(i) == placeholder) {
                if (insideLiteral) continue;
                ++count;
                continue;
            }
            if (delimiters.indexOf(str.charAt(i)) <= -1) continue;
            if (!insideLiteral) {
                insideLiteral = true;
                activeLiteral = delimiters.indexOf(str.charAt(i));
                continue;
            }
            if (activeLiteral != delimiters.indexOf(str.charAt(i))) continue;
            insideLiteral = false;
            activeLiteral = -1;
        }
        return count;
    }

    public static boolean isNumeric(int sqlType) {
        return -7 == sqlType || -5 == sqlType || 3 == sqlType || 8 == sqlType || 6 == sqlType || 4 == sqlType || 2 == sqlType || 7 == sqlType || 5 == sqlType || -6 == sqlType;
    }
}

