/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.k3.calc;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.k3.calc.K3CalcBase;
import com.kingdee.eas.fi.rpt.k3.calc.K3FormulaBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class K3AcctCalc
extends K3CalcBase {
    private static final Logger logger = Logger.getLogger(K3AcctCalc.class);

    public K3AcctCalc(Context srvCtx, ICalculateContextProvider calcCtx) {
        super(srvCtx, calcCtx);
    }

    @Override
    protected String getK3ParamText(K3FormulaBase formula) {
        StringBuffer sb = new StringBuffer();
        if (formula instanceof K3Acct) {
            K3Acct acct = (K3Acct)formula;
            sb.append(acct.account);
            sb.append(",");
            sb.append(acct.balDataType);
            sb.append(",");
            sb.append(acct.currency);
            sb.append(",");
            sb.append(acct.year);
            sb.append(",");
            sb.append(acct.startPeriod);
            sb.append(",");
            sb.append(acct.endPeriod);
            sb.append(",");
            sb.append(acct.isInPost ? "Y" : "N");
        }
        return sb.toString();
    }

    @Override
    protected K3FormulaBase initParam(Parameter p) {
        Object[] args = p.getArgs();
        if (args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        K3Acct acct = new K3Acct();
        String sheetName = p.getSheetName();
        String sdsn = (String)((Variant)args[6]).getValue();
        sdsn = this.getAccountSdsn(sdsn);
        int year = ((Number)((Variant)args[3]).getValue()).intValue();
        year = year <= 0 ? this.getBatchHelper().getReport_Year() + year : year;
        int startPeriod = ((Number)((Variant)args[4]).getValue()).intValue();
        startPeriod = startPeriod <= 0 ? this.getBatchHelper().getSheet_StartPeriod(sheetName) + startPeriod : startPeriod;
        int endPeriod = ((Number)((Variant)args[5]).getValue()).intValue();
        endPeriod = endPeriod <= 0 ? this.getBatchHelper().getSheet_EndPeriod(sheetName) + endPeriod : endPeriod;
        int periodType = this.getBatchHelper().getReport_PeriodType();
        int reportPeriod = this.getBatchHelper().getReport_Period();
        int reportYear = this.getBatchHelper().getReport_Year();
        Date date = RPTDateUtil.getPeriodLastDate((int)reportYear, (int)reportPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType));
        int[] yearAndPeriod = RPTDateUtil.getPeriod((Date)date, (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
        year = year <= 0 ? year + yearAndPeriod[0] : year;
        startPeriod = startPeriod <= 0 ? startPeriod + yearAndPeriod[1] : startPeriod;
        endPeriod = endPeriod <= 0 ? endPeriod + yearAndPeriod[1] : endPeriod;
        String currency = (String)((Variant)args[2]).getValue();
        currency = StringUtils.isEmpty((String)currency) ? this.getBatchHelper().getCorrect_Currency_Number(sheetName) : currency;
        acct.account = (String)((Variant)args[0]).getValue();
        acct.balDataType = (String)((Variant)args[1]).getValue();
        acct.currency = currency;
        acct.year = year;
        acct.startPeriod = startPeriod;
        acct.endPeriod = endPeriod;
        acct.isInPost = this.getBatchHelper().isSheet_IncludePosted(sheetName);
        acct.setFormulaSdsn(StringUtils.isEmpty((String)sdsn) ? this.getCurrentCompanySdsn() : sdsn);
        this.validate(acct);
        return acct;
    }

    protected void validate(K3Acct acct) {
        if (StringUtils.isEmpty((String)acct.account)) {
            acct.setHashException(true);
            acct.setException(new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"313inputAccount", (Locale)this.srvCtx.getOriginLocale())));
        } else if (StringUtils.isEmpty((String)acct.balDataType)) {
            acct.setHashException(true);
            acct.setException(new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"312inputBalDataType", (Locale)this.srvCtx.getOriginLocale())));
        }
    }

    @Override
    protected String getK3MethodName() {
        return "acct";
    }

    class K3Acct
    extends K3FormulaBase {
        String account;
        String balDataType;
        String currency;
        int year;
        int startPeriod;
        int endPeriod;
        boolean isInPost;

        K3Acct() {
        }
    }
}

