/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.k3.calc;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.k3.calc.K3CalcBase;
import com.kingdee.eas.fi.rpt.k3.calc.K3FormulaBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.Locale;

public class K3AcctItemCalc
extends K3CalcBase {
    public K3AcctItemCalc(Context srvCtx, ICalculateContextProvider calcCtx) {
        super(srvCtx, calcCtx);
    }

    @Override
    protected String getK3ParamText(K3FormulaBase formula) {
        Locale locale = ContextUtils.getOriginalLocaleFromEnv();
        StringBuffer sb = new StringBuffer();
        if (formula instanceof K3AcctItem) {
            K3AcctItem acct = (K3AcctItem)formula;
            sb.append(acct.orgTreeType);
            sb.append(",");
            sb.append(acct.orgUnit);
            sb.append(",");
            sb.append(acct.item);
            sb.append(",");
            sb.append(acct.cycle);
            sb.append(",");
            sb.append(acct.currency);
            sb.append(",");
            if (acct.balDataType.equals(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"303_K3AcctItemCalc", (Locale)locale))) {
                sb.append("4");
            } else if (acct.balDataType.equals(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"304_K3AcctItemCalc", (Locale)locale))) {
                sb.append("3");
            } else if (acct.balDataType.equals(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"305_K3AcctItemCalc", (Locale)locale))) {
                sb.append("2");
            } else if (acct.balDataType.equals(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"306_K3AcctItemCalc", (Locale)locale))) {
                sb.append("1");
            } else {
                sb.append(acct.balDataType);
            }
            sb.append(",");
            sb.append(acct.dataElement);
            sb.append(",");
            sb.append(acct.year);
            sb.append(",");
            sb.append(acct.startPeriod);
            sb.append(",");
            sb.append(acct.endPeriod);
            sb.append(",");
            sb.append(acct.isInPost ? "Y" : "N");
        }
        return sb.toString();
    }

    @Override
    protected K3FormulaBase initParam(Parameter p) {
        Object[] args = p.getArgs();
        if (args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        String sheetName = p.getSheetName();
        String sdsn = (String)((Variant)args[10]).getValue();
        sdsn = this.getAccountSdsn(sdsn);
        String currency = (String)((Variant)args[4]).getValue();
        currency = StringUtils.isEmpty((String)currency) ? this.getBatchHelper().getCorrect_Currency_Number(sheetName) : currency;
        int year = ((Number)((Variant)args[7]).getValue()).intValue();
        year = year <= 0 ? this.getBatchHelper().getReport_Year() + year : year;
        int startPeriod = ((Number)((Variant)args[8]).getValue()).intValue();
        startPeriod = startPeriod <= 0 ? this.getBatchHelper().getSheet_StartPeriod(sheetName) + startPeriod : startPeriod;
        int endPeriod = ((Number)((Variant)args[9]).getValue()).intValue();
        endPeriod = endPeriod <= 0 ? this.getBatchHelper().getSheet_EndPeriod(sheetName) + endPeriod : endPeriod;
        int periodType = this.getBatchHelper().getReport_PeriodType();
        int reportPeriod = this.getBatchHelper().getReport_Period();
        int reportYear = this.getBatchHelper().getReport_Year();
        Date date = RPTDateUtil.getPeriodLastDate((int)reportYear, (int)reportPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType));
        int[] yearAndPeriod = RPTDateUtil.getPeriod((Date)date, (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
        year = year <= 0 ? year + yearAndPeriod[0] : year;
        startPeriod = startPeriod <= 0 ? startPeriod + yearAndPeriod[1] : startPeriod;
        endPeriod = endPeriod <= 0 ? endPeriod + yearAndPeriod[1] : endPeriod;
        K3AcctItem k3 = new K3AcctItem();
        k3.orgTreeType = (String)((Variant)args[0]).getValue();
        k3.orgUnit = (String)((Variant)args[1]).getValue();
        k3.item = (String)((Variant)args[2]).getValue();
        k3.cycle = (String)((Variant)args[3]).getValue();
        k3.currency = currency;
        k3.balDataType = (String)((Variant)args[5]).getValue();
        k3.dataElement = (String)((Variant)args[6]).getValue();
        k3.year = year;
        k3.startPeriod = startPeriod;
        k3.endPeriod = endPeriod;
        k3.isInPost = this.getBatchHelper().isSheet_IncludePosted(sheetName);
        k3.setFormulaSdsn(StringUtils.isEmpty((String)sdsn) ? this.getCurrentCompanySdsn() : sdsn);
        this.validate(k3);
        return k3;
    }

    protected void validate(K3AcctItem acct) {
        if (StringUtils.isEmpty((String)acct.balDataType)) {
            acct.setHashException(true);
            acct.setException(new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"312inputBalDataType", (Locale)this.srvCtx.getOriginLocale())));
        } else if (StringUtils.isEmpty((String)acct.cycle)) {
            acct.setHashException(true);
            acct.setException(new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"315inputPeriod", (Locale)this.srvCtx.getOriginLocale())));
        } else if (StringUtils.isEmpty((String)acct.dataElement)) {
            acct.setHashException(true);
            acct.setException(new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"316inputDataType", (Locale)this.srvCtx.getOriginLocale())));
        }
    }

    @Override
    protected String getK3MethodName() {
        return "acctItem";
    }

    class K3AcctItem
    extends K3FormulaBase {
        String orgTreeType;
        String orgUnit;
        String item;
        String cycle;
        String currency;
        String balDataType;
        String dataElement;
        int year;
        int startPeriod;
        int endPeriod;
        boolean isInPost;

        K3AcctItem() {
        }
    }
}

