/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.rptdata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.IRptData;
import com.kingdee.eas.fi.rpt.RptDataFactory;
import com.kingdee.eas.fi.rpt.RptDataInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.rptdata.IntegerConvert;
import com.kingdee.eas.fi.rpt.rptdata.RptDataMerge;
import com.kingdee.eas.fi.rpt.rptdata.RptDataQuery;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RptDataTogether {
    private static final Logger log = Logger.getLogger(RptDataTogether.class);
    private RptDataInfo currRptDataInfo;
    private Context serverCtx;

    public RptDataTogether(Context serverCtx) {
        this.serverCtx = serverCtx;
    }

    public boolean register(RptDataInfo rptDataInfo) {
        log.info((Object)("[rptDataInfo]id:" + rptDataInfo.getId() + ",calcStartTime:" + rptDataInfo.getCalcStartTime()));
        log.info((Object)("[rptDataInfo]rptId:" + rptDataInfo.getRptId() + ",rptNumber:" + rptDataInfo.getRptNumber() + ",rptName:" + rptDataInfo.getRptName()));
        log.info((Object)("[rptDataUser]userid:" + rptDataInfo.getUserId()));
        log.info((Object)("[rptDataUser]userNumber:" + rptDataInfo.getUserNumber()));
        log.info((Object)("[rptDataUser]userName:" + rptDataInfo.getUserName()));
        if (rptDataInfo == null || rptDataInfo.getRptId() == null || rptDataInfo.getRptNumber() == null) {
            return false;
        }
        this.currRptDataInfo = rptDataInfo;
        return true;
    }

    public void startRecordForServer() {
        this.startRecordForServer(new Timestamp(System.currentTimeMillis()));
    }

    public void startRecordForServer(Timestamp currTime) {
        this.currRptDataInfo.setServerCalcStartTime(currTime);
        log.info((Object)("[rptData]startServerCalcTime:" + currTime));
        try {
            this.dbSave();
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public void endRecordForServer() throws BOSException, EASBizException {
        try {
            this.currRptDataInfo.setServerCalcFinishTime(System.currentTimeMillis() - this.currRptDataInfo.getServerCalcStartTime().getTime());
            log.info((Object)("[rptData]ServerCalcFinishTime:" + this.currRptDataInfo.getServerCalcFinishTime()));
            String formulaDetail = this.currRptDataInfo.getFormulaDetail();
            int totalFormulaNum = this.currRptDataInfo.getTotalFormulaNum();
            this.currRptDataInfo.setFormulaDetail("");
            this.currRptDataInfo.setTotalFormulaNum(0);
            this.dbSave();
            this.currRptDataInfo.setFormulaDetail(formulaDetail);
            this.currRptDataInfo.setTotalFormulaNum(totalFormulaNum);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public void endRecordForAll() throws BOSException, EASBizException {
        try {
            long time = System.currentTimeMillis() - this.currRptDataInfo.getServerCalcStartTime().getTime();
            this.currRptDataInfo.setServerCalcFinishTime(time);
            this.currRptDataInfo.setCalcFinishTime(time);
            log.info((Object)("[rptData]ServerCalcFinishTime:" + this.currRptDataInfo.getServerCalcFinishTime()));
            String formulaDetail = this.currRptDataInfo.getFormulaDetail();
            int totalFormulaNum = this.currRptDataInfo.getTotalFormulaNum();
            this.currRptDataInfo.setFormulaDetail("");
            this.currRptDataInfo.setTotalFormulaNum(0);
            this.dbSave();
            this.currRptDataInfo.setFormulaDetail(formulaDetail);
            this.currRptDataInfo.setTotalFormulaNum(totalFormulaNum);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public List<RptDataInfo> executeQuery(RptDataQuery query) throws EASBizException, BOSException {
        return this.dbQuery(query.getSQL(), query.getParams().toArray());
    }

    private void dbSave() throws BOSException, EASBizException {
        IRptData rptData = null;
        rptData = this.serverCtx != null ? RptDataFactory.getLocalInstance(this.serverCtx) : RptDataFactory.getRemoteInstance();
        if (this.currRptDataInfo.getId() != null && rptData.exists((IObjectPK)new ObjectUuidPK(this.currRptDataInfo.getId().toString()))) {
            RptDataInfo rptDataAfterMerge = new RptDataMerge().merge((RptDataInfo)rptData.getValue((IObjectPK)new ObjectUuidPK(this.currRptDataInfo.getId().toString())), this.currRptDataInfo);
            rptData.save((CoreBaseInfo)rptDataAfterMerge);
            return;
        }
        rptData.save((CoreBaseInfo)this.currRptDataInfo);
    }

    private List<RptDataInfo> dbQuery(String sql, Object[] params) throws BOSException, EASBizException, SQLDataException {
        LinkedList<RptDataInfo> records = new LinkedList<RptDataInfo>();
        if (this.serverCtx == null) {
            return new ArrayList<RptDataInfo>();
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.serverCtx, (String)sql, (Object[])params);
        try {
            while (rs.next()) {
                RptDataInfo record = new RptDataInfo();
                Object field = this.getDBFieldValue(rs, "FID");
                if (field != null) {
                    record.setId(BOSUuid.read((String)((String)field)));
                }
                if ((field = this.getDBFieldValue(rs, "FRptID")) != null) {
                    record.setRptId(BOSUuid.read((String)((String)field)));
                }
                if ((field = this.getDBFieldValue(rs, "FRptName")) != null) {
                    record.setRptName((String)field);
                }
                if ((field = this.getDBFieldValue(rs, "FRptNumber")) != null) {
                    record.setRptNumber((String)field);
                }
                if ((field = this.getDBFieldValue(rs, "FRptYear")) != null) {
                    record.setRptYear(IntegerConvert.action(field, 0));
                }
                if ((field = this.getDBFieldValue(rs, "FRptPeriod")) != null) {
                    record.setRptPeriod(IntegerConvert.action(field, 0));
                }
                if ((field = this.getDBFieldValue(rs, "FRptPeriodType")) != null) {
                    record.setRptPeriodType(RptPeriodTypeEnum.getEnum((int)IntegerConvert.action(field, 0)));
                }
                if ((field = this.getDBFieldValue(rs, "FRptSourceType")) != null) {
                    record.setRptSourceType(RptSrcTypeEnum.getEnum(IntegerConvert.action(field, 0)));
                }
                if ((field = this.getDBFieldValue(rs, "FCompanyId")) != null) {
                    record.setCompanyId(BOSUuid.read((String)((String)field)));
                }
                if ((field = this.getDBFieldValue(rs, "FCompanyNumber")) != null) {
                    record.setCompanyNumber((String)field);
                }
                if ((field = this.getDBFieldValue(rs, "FCompanyName")) != null) {
                    record.setCompanyName((String)field);
                }
                if ((field = this.getDBFieldValue(rs, "FUserId")) != null) {
                    record.setUserId(BOSUuid.read((String)((String)field)));
                }
                if ((field = this.getDBFieldValue(rs, "FUserNumber")) != null) {
                    record.setUserNumber((String)field);
                }
                if ((field = this.getDBFieldValue(rs, "FUserName")) != null) {
                    record.setUserName((String)field);
                }
                if ((field = this.getDBFieldValue(rs, "FUserIp")) != null) {
                    record.setUserIp((String)field);
                }
                if ((field = this.getDBFieldValue(rs, "FTotalFormulaNum")) != null) {
                    record.setTotalFormulaNum(IntegerConvert.action(field, 0));
                }
                if ((field = this.getDBFieldValue(rs, "FFormulaDetail")) != null) {
                    record.setFormulaDetail((String)field);
                }
                if ((field = this.getDBFieldValue(rs, "FCalcStartTime")) != null) {
                    record.setCalcStartTime((Timestamp)field);
                }
                if ((field = this.getDBFieldValue(rs, "FCalcFinishTime")) != null) {
                    record.setCalcFinishTime(IntegerConvert.action(field, 0).longValue());
                }
                if ((field = this.getDBFieldValue(rs, "FServerCalcStartTime")) != null) {
                    record.setServerCalcStartTime((Timestamp)field);
                }
                if ((field = this.getDBFieldValue(rs, "FServerCalcFinishTime")) != null) {
                    record.setServerCalcFinishTime(IntegerConvert.action(field, 0).longValue());
                }
                if ((field = this.getDBFieldValue(rs, "FRptCurrencyNumber")) != null) {
                    record.setRptCurrencyNumber((String)field);
                }
                if ((field = this.getDBFieldValue(rs, "FRptCurrencyName_L1")) != null) {
                    record.setRptCurrencyName((String)field, new Locale("L1"));
                }
                if ((field = this.getDBFieldValue(rs, "FRptCurrencyName_L2")) != null) {
                    record.setRptCurrencyName((String)field, new Locale("L2"));
                }
                if ((field = this.getDBFieldValue(rs, "FRptCurrencyName_L3")) != null) {
                    record.setRptCurrencyName((String)field, new Locale("L3"));
                }
                if ((field = this.getDBFieldValue(rs, "FRptCalcNum")) != null) {
                    record.setRptCalcNum(IntegerConvert.action(field, 0));
                }
                records.add(record);
            }
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            throw new SQLDataException(e);
        }
        return records;
    }

    private Object getDBFieldValue(IRowSet rs, String fieldName) throws SQLException {
        try {
            return rs.getObject(fieldName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Object getDBFieldValue(IRowSet rs, String fieldName, String dbTypeKey, Class<?> javaTypeValue) throws SQLException {
        try {
            HashMap typeMap = new HashMap(1);
            typeMap.put(dbTypeKey, javaTypeValue);
            return rs.getObject(fieldName, typeMap);
        }
        catch (Exception e) {
            log.warn((Object)"", (Throwable)e);
            return null;
        }
    }
}

