/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.rptdata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RptProperty2Info {
    private static final Logger log = Logger.getLogger(RptProperty2Info.class);

    public ReportInfo convert(Context serverCtx, IReportPropertyAdapter propertyAdapter) {
        ReportInfo rpt = new ReportInfo();
        rpt.setId(BOSUuid.read((String)((String)propertyAdapter.getReportProperty("Report.ID"))));
        rpt.setNumber((String)propertyAdapter.getReportProperty("Report.Number"));
        rpt.setName((String)propertyAdapter.getReportProperty("Report.Name"));
        rpt.setYear((Integer)propertyAdapter.getReportProperty("Report.Year"));
        rpt.setPeriod(((Integer)propertyAdapter.getReportProperty("Report.Period")).shortValue());
        rpt.setSourceType(RptSrcTypeEnum.getEnum((Integer)propertyAdapter.getReportProperty("Report.SourceType")));
        rpt.setPeriodType(RptPeriodTypeEnum.getEnum((int)((Integer)propertyAdapter.getReportProperty("PeriodType"))));
        CurrencyInfo currency = this.queryCurrency(serverCtx, (String)propertyAdapter.getReportProperty("Currency.Number"));
        rpt.setCurrency(currency);
        FullOrgUnitInfo company = new FullOrgUnitInfo();
        company.setId(BOSUuid.read((String)((String)propertyAdapter.getReportProperty("Company.ID"))));
        company.setName((String)propertyAdapter.getReportProperty("Company.Name"));
        company.setNumber((String)propertyAdapter.getReportProperty("Company.Number"));
        rpt.setCompany(company);
        return rpt;
    }

    private CurrencyInfo queryCurrency(Context serverCtx, String currencyNumber) {
        CurrencyInfo currency = new CurrencyInfo();
        currency.setNumber(currencyNumber);
        try {
            ICurrency currencyDB = null;
            currencyDB = serverCtx != null ? CurrencyFactory.getLocalInstance((Context)serverCtx) : CurrencyFactory.getRemoteInstance();
            CurrencyCollection currs = currencyDB.getCurrencyCollection("select name where number = '" + currencyNumber + "'");
            if (currs.size() >= 1) {
                Locale local = new Locale("L1");
                CurrencyInfo currencyInfo = currs.get(0);
                currency.setName(currencyInfo.getName(new Locale("L1")), local);
                local = new Locale("L2");
                currency.setName(currencyInfo.getName(local), local);
                local = new Locale("L3");
                currency.setName(currencyInfo.getName(local), local);
            }
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
        }
        return currency;
    }
}

