/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.treetable;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.fi.rpt.treetable.ITreeTableNodeEntity;
import com.kingdee.eas.fi.rpt.treetable.ITreeTableNodeEntityConvert;
import com.kingdee.eas.fi.rpt.treetable.LogTrace;
import java.util.List;

public class TreeTableNodeFoldAction {
    protected KDTable tblCompany;
    protected ITreeTableNodeEntityConvert entityConvert;

    public TreeTableNodeFoldAction(KDTable tblCompany, ITreeTableNodeEntityConvert entityConvert) {
        this.tblCompany = tblCompany;
        this.entityConvert = entityConvert;
    }

    public void action(int rowIndex) {
        IRow currRow = this.tblCompany.getRow(rowIndex);
        LogTrace.trace("start expand row", "Current RowIndex is " + rowIndex);
        if (currRow == null || currRow.getUserObject() == null) {
            LogTrace.trace("omit all expand row", "current company's longnumber is null or empty");
            return;
        }
        ITreeTableNodeEntity currOrg = this.entityConvert.convertRowUserObject(currRow.getUserObject());
        if (currOrg == null) {
            LogTrace.trace("omit all expand row", "current company's longnumber is null or empty");
            return;
        }
        String currLongNumber = currOrg.getLongNumber();
        LogTrace.trace("current company ", "company number is " + currLongNumber);
        if (currOrg.isLeaf()) {
            LogTrace.trace("omit expand row", "current company is leaf or have not 'isExpand' attribute");
            return;
        }
        boolean expandStatusWhenCurrIsRoot = !currOrg.isExpand();
        currOrg.setExpand(expandStatusWhenCurrIsRoot);
        LogTrace.trace("current company's expand status", "" + expandStatusWhenCurrIsRoot);
        List entrys = this.entityConvert.convertTableUserObject(this.tblCompany.getUserObject());
        if (entrys == null || entrys.isEmpty()) {
            LogTrace.trace("omit all expand row", "tblCompany.getUserObject() is null or empty,isNull = " + (entrys == null));
            return;
        }
        ITreeTableNodeEntity entity = null;
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            entity = (ITreeTableNodeEntity)entrys.get(i);
            if (entity.getLongNumber() == null) {
                LogTrace.trace("omit expand row", "rowIndex=" + i + ", company longNumber is null");
                continue;
            }
            if (!entity.getLongNumber().startsWith(currLongNumber + "!")) {
                LogTrace.trace("omit expand row", "circle company 's longnumber is not match,rowIndex=" + i + ",longNumber=" + entity.getLongNumber());
                continue;
            }
            if (expandStatusWhenCurrIsRoot && entity.getLongNumber().substring((currLongNumber + "!").length()).indexOf("!") == -1) {
                entity.cleanStatusBeforeCollapse();
            } else if (expandStatusWhenCurrIsRoot && entity.getLongNumber().substring((currLongNumber + "!").length()).indexOf("!") != -1) {
                if (entity.hideStatusBeforeCollapse() != null && currLongNumber.startsWith(entity.parentNodeLongNumberForCollapse())) {
                    LogTrace.trace("omit expand row", "circle company must be current company's direct sub company,rowIndex=" + i + ",longNumber=" + entity.getLongNumber() + ",expandStatusBeforeNoExpand = " + entity.hideStatusBeforeCollapse());
                    this.tblCompany.getRow(i).getStyleAttributes().setHided(entity.hideStatusBeforeCollapse().booleanValue());
                    entity.cleanStatusBeforeCollapse();
                    continue;
                }
                LogTrace.trace("omit expand row", "circle company must be current company's direct sub company,rowIndex=" + i + ",longNumber=" + entity.getLongNumber());
                continue;
            }
            if (!expandStatusWhenCurrIsRoot && entity.getLongNumber().substring((currLongNumber + "!").length()).indexOf("!") != -1 && (entity.parentNodeLongNumberForCollapse() == null || currLongNumber.startsWith(entity.parentNodeLongNumberForCollapse() + "!"))) {
                entity.setHideStatusBeforeCollapse(this.tblCompany.getRow(i).getStyleAttributes().isHided());
                entity.setParentNodeLongNumberForCollapse(currLongNumber);
            }
            LogTrace.trace("execute expand row", "rowIndex=" + i + ",longNumber=" + entity.getLongNumber() + ",isHidden=" + !expandStatusWhenCurrIsRoot);
            this.tblCompany.getRow(i).getStyleAttributes().setHided(!expandStatusWhenCurrIsRoot);
        }
    }
}

