/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cbs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.AuditStatus;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.IBankPayingBill;
import com.kingdee.eas.fm.be.client.BankCommitToBeServiceClient;
import com.kingdee.eas.fm.be.client.BankLogListUI;
import com.kingdee.eas.fm.be.client.BankPayingBillModifyReason;
import com.kingdee.eas.fm.be.client.BankPayingBillSyncFilterUI;
import com.kingdee.eas.fm.be.client.BankPayingBillUpdateStateUI;
import com.kingdee.eas.fm.cbs.client.AbstractCBSBankPayingBillListUI;
import com.kingdee.eas.fm.cbs.client.CBSBankPayingBillFilterParam;
import com.kingdee.eas.fm.cbs.client.CBSBankPayingBillFilterUI;
import com.kingdee.eas.fm.cbs.client.CBSBankPayingBillPrintDataProvider;
import com.kingdee.eas.fm.cbs.client.CBSBankPayingBillUI;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.client.DefaultOriginalCurrencyPrecProvider;
import com.kingdee.eas.fm.common.client.DefaultTablePrecisionFormat;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.ITablePrecisionProvider;
import com.kingdee.eas.fm.common.client.ProgressDialog;
import com.kingdee.eas.fm.fs.client.SettleBitBackUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CBSBankPayingBillListUI
extends AbstractCBSBankPayingBillListUI {
    CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private static final Logger logger = CoreUIObject.getLogger(CBSBankPayingBillListUI.class);
    private ProgressDialog progressDialog;
    private BankPayingBillSyncFilterUI syncFilterUI;
    private CompanyOrgUnitInfo curCompany;
    private String secondSubmitValue;
    private boolean mustAuditParam;
    private boolean auditerNotSameSubmiter;
    private static final String ERROR_KEY = "error";
    private IBankPayingBill iBankPayingBill;
    private CBSBankPayingBillFilterUI filterUI;

    public CBSBankPayingBillListUI() throws Exception {
        DefaultTablePrecisionFormat precFmt = new DefaultTablePrecisionFormat();
        DefaultOriginalCurrencyPrecProvider origCurrPrecProvider = new DefaultOriginalCurrencyPrecProvider("currency.id");
        precFmt.setPrecProvider((ITablePrecisionProvider)origCurrPrecProvider);
        precFmt.initFormat(this.tblMain, new String[]{"payAmount", "cbPayInfo.payeeAmount"});
    }

    private IBankPayingBill getBankPayingBillInterface() throws BOSException {
        return BankPayingBillFactory.getRemoteInstance();
    }

    private String getBEAutoResource(String resName) {
        return EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)resName);
    }

    private String getBEResource(String resName) {
        return EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)resName);
    }

    private void showActionResult(List<BankPayResult> resultList, String title, String spentTimeHint) throws Exception {
        int size = resultList.size();
        if (resultList == null || size == 0) {
            return;
        }
        if (size == 1 && resultList.get(0).getId().equals(ERROR_KEY)) {
            BankPayResult bankPayResult = resultList.get(0);
            MsgBox.showInfo((Component)((Object)this), (String)bankPayResult.getErrorDetail());
            return;
        }
        StringBuilder hintBuilder = new StringBuilder();
        StringBuffer errorDetail = new StringBuffer();
        int fail = 0;
        String LINE_SEPARATOR = System.getProperty("line.separator");
        String numberTitle = this.getBEResource("number");
        String successTitle = this.getBEResource("success");
        String failureTitle = this.getBEResource("failure");
        String recordTile = this.getBEResource("balanceMessage3");
        for (int j = 0; j < size; ++j) {
            BankPayResult resultInfo = resultList.get(j);
            if (!CheckUtils.exist((Object)resultInfo.getErrorDetail())) continue;
            errorDetail.append(numberTitle).append(resultInfo.getNumber()).append("\uff1a");
            errorDetail.append(resultInfo.getErrorDetail()).append(LINE_SEPARATOR);
            ++fail;
        }
        if (fail == 0) {
            hintBuilder.append(title + successTitle).append(" ").append(size).append(" ").append(recordTile);
            if (!EmptyUtil.isEmpty((String)spentTimeHint)) {
                hintBuilder.append(" , ").append(spentTimeHint);
            }
            MsgBox.showInfo((Component)((Object)this), (String)hintBuilder.toString());
            this.refreshList();
        } else {
            hintBuilder.append(title + successTitle).append(" ").append(size - fail).append(" ").append(recordTile).append(" , ");
            hintBuilder.append(failureTitle).append(fail).append(recordTile);
            if (!EmptyUtil.isEmpty((String)spentTimeHint)) {
                hintBuilder.append(" , ").append(spentTimeHint);
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)hintBuilder.toString(), (String)errorDetail.toString(), (int)0);
            if (size != fail) {
                this.refreshList();
            }
        }
    }

    protected void initWorkButton() {
        this.actionSyncState.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_synchronization"));
        this.actionSyncStateByBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_synchronization"));
        this.actionViewDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        super.initWorkButton();
        this.btnQuery.setText(this.resHelper.getString("ActionQuery.NAME"));
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionSyncState.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_synchronization"));
        this.actionBitBack.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fclose"));
        this.actionViewLog.setEnabled(true);
        this.actionViewLog.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.kDMenuItemViewLog.setAccelerator(KeyStroke.getKeyStroke("ctrl R"));
    }

    private List<String> requestObjIdLock(List<String> idList, BankPayingBillCollection bankPayingBills, List<BankPayResult> resultLockList) {
        ArrayList<String> successIdList = new ArrayList<String>();
        Map resultRequest = MutexServiceControlFactory.getRemoteInstance().batchRequestObjIDForUpdate(idList);
        int size = bankPayingBills.size();
        for (int i = 0; i < size; ++i) {
            BankPayingBillInfo info = bankPayingBills.get(i);
            String id = info.getId().toString();
            Boolean boolResult = (Boolean)resultRequest.get(id);
            if (boolResult == null) continue;
            if (!boolResult.booleanValue()) {
                resultLockList.add(this.createBankPayResult(id, info.getNumber(), null, this.getBEResource("billLock")));
                continue;
            }
            successIdList.add(id);
        }
        return successIdList;
    }

    public FMFilterBaseUI getSyncFilterUI() throws Exception {
        if (this.syncFilterUI == null) {
            this.syncFilterUI = new BankPayingBillSyncFilterUI();
        }
        return this.syncFilterUI;
    }

    @Override
    public void actionBitBack_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        this.checkSelected();
        HashSet idSet = new HashSet(this.getSelectedIdValues());
        String Msg = "";
        if (idSet.size() == 1) {
            try {
                BankPayingBillInfo info = BankPayingBillFactory.getRemoteInstance().getBankPayingBillInfo((IObjectPK)new ObjectUuidPK(idSet.toArray()[0].toString()));
                Msg = info.getBankReturnInfo();
            }
            catch (EASBizException e2) {
                logger.error((Object)e2);
            }
            catch (BOSException e2) {
                logger.error((Object)e2);
            }
        }
        if ((msg = SettleBitBackUI.showDialogWindow((IUIObject)this, (String)Msg)) == null) {
            return;
        }
        ArrayList resultList = this.getBankPayingBillInterface().bitBack(idSet, msg);
        this.showActionResult(resultList, this.getBEResource("bankPayBill") + this.btnBitBack.getText(), null);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
        IContextHelper iContextHelper = ContextHelperFactory.getRemoteInstance();
        this.curCompany = iContextHelper.getCurrentCompany();
        this.secondSubmitValue = iContextHelper.getStringParam("TM018", (IObjectPK)new ObjectUuidPK(this.curCompany.getId()));
        this.mustAuditParam = iContextHelper.getBooleanParam("BE001", (IObjectPK)new ObjectUuidPK(this.curCompany.getId()));
        this.auditerNotSameSubmiter = iContextHelper.getBooleanParam("BE002", (IObjectPK)new ObjectUuidPK(this.curCompany.getId()));
        if (this.secondSubmitValue == null || "0".equals(this.secondSubmitValue)) {
            this.actionSubmit.setEnabled(false);
            this.actionAudit.setEnabled(false);
            this.actionAntiAudit.setEnabled(false);
        } else {
            this.actionSubmit.setEnabled(true);
            this.actionAudit.setEnabled(this.mustAuditParam);
            this.actionAntiAudit.setEnabled(this.mustAuditParam);
        }
        this.actionRemove.setVisible(false);
        this.btnSignature.setVisible(false);
        this.btnViewSignature.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.menuWorkFlow.setVisible(false);
        this.actionSubmit.setDaemonRun(true);
        this.tblMain.getColumn("submitTime").getStyleAttributes().setNumberFormat(this.timeFormat);
        this.tblMain.getColumn("expectTransTime").getStyleAttributes().setNumberFormat(this.timeFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList<BankPayResult> resultList = new ArrayList<BankPayResult>();
        HashSet idSet = new HashSet(this.getSelectedIdValues());
        ArrayList idList = this.getSelectedIdValues();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("number");
        selectors.add("creator");
        selectors.add("state");
        selectors.add("status");
        BankPayingBillCollection bankPayingBillColls = this.getBankPayingBillColls(idSet, null, selectors);
        UserInfo curUser = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        int size = bankPayingBillColls.size();
        for (int i = 0; i < size; ++i) {
            BankPayingBillInfo info = bankPayingBillColls.get(i);
            String id = info.getId().toString();
            String number = info.getNumber();
            if (info.getState() != BankPayingBillStateEnum.OP) {
                resultList.add(this.createBankPayResult(id, number, null, this.getBEAutoResource("68_BankPayingBillListUI")));
                idList.remove(id);
                continue;
            }
            if (info.getStatus() == AuditStatus.audited) {
                resultList.add(this.createBankPayResult(id, number, null, this.getBEAutoResource("69_BankPayingBillListUI")));
                idList.remove(id);
                continue;
            }
            if (this.auditerNotSameSubmiter && info.getCreator() != null && info.getCreator().getId().equals((Object)curUser.getId())) {
                resultList.add(this.createBankPayResult(id, number, null, this.getBEAutoResource("67_BankPayingBillListUI")));
                idList.remove(id);
                continue;
            }
            resultList.add(this.createBankPayResult(id, number, null, null));
        }
        if (!EmptyUtil.isEmpty((Collection)idList)) {
            List<String> successIdList = null;
            try {
                successIdList = this.requestObjIdLock(idList, bankPayingBillColls, resultList);
                if (!EmptyUtil.isEmpty(successIdList)) {
                    HashSet<String> validIdSet = new HashSet<String>(successIdList);
                    this.getBankPayingBillInterface().audit(validIdSet, AuditStatus.audited);
                }
            }
            finally {
                if (!EmptyUtil.isEmpty(successIdList)) {
                    MutexServiceControlFactory.getRemoteInstance().batchReleaseObjIDForUpdate(successIdList);
                }
            }
        }
        this.showActionResult(resultList, this.btnAudit.getText(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList<BankPayResult> resultList = new ArrayList<BankPayResult>();
        HashSet idSet = new HashSet(this.getSelectedIdValues());
        ArrayList idList = this.getSelectedIdValues();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("number");
        selectors.add("state");
        selectors.add("status");
        BankPayingBillCollection bankPayingBillColls = this.getBankPayingBillColls(idSet, null, selectors);
        int size = bankPayingBillColls.size();
        for (int i = 0; i < size; ++i) {
            BankPayingBillInfo info = bankPayingBillColls.get(i);
            String id = info.getId().toString();
            String number = info.getNumber();
            if (info.getState() != BankPayingBillStateEnum.OP) {
                resultList.add(this.createBankPayResult(id, number, null, this.getBEAutoResource("68_BankPayingBillListUI")));
                idList.remove(id);
                continue;
            }
            if (info.getStatus() == AuditStatus.unAudit) {
                resultList.add(this.createBankPayResult(id, number, null, this.getBEAutoResource("70_BankPayingBillListUI")));
                idList.remove(id);
                continue;
            }
            resultList.add(this.createBankPayResult(id, number, null, null));
        }
        if (!EmptyUtil.isEmpty((Collection)idList)) {
            List<String> successIdList = null;
            try {
                successIdList = this.requestObjIdLock(idList, bankPayingBillColls, resultList);
                if (!EmptyUtil.isEmpty(successIdList)) {
                    HashSet<String> validIdSet = new HashSet<String>(successIdList);
                    this.getBankPayingBillInterface().audit(validIdSet, AuditStatus.unAudit);
                }
            }
            finally {
                if (!EmptyUtil.isEmpty(successIdList)) {
                    MutexServiceControlFactory.getRemoteInstance().batchReleaseObjIDForUpdate(successIdList);
                }
            }
        }
        this.showActionResult(resultList, this.btnUnAudit.getText(), null);
    }

    private BankPayingBillCollection getBankPayingBillColls(Set idSet, FilterInfo filter, SelectorItemCollection selectors) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        if (filter != null) {
            filterInfo.mergeFilter(filter, "AND");
        }
        view.setFilter(filterInfo);
        if (selectors != null) {
            view.setSelector(selectors);
        }
        return BankPayingBillFactory.getRemoteInstance().getBankPayingBillCollection(view);
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        int i = this.tblMain.getSelectManager().getActiveRowIndex();
        if (i >= 0) {
            BizEnumValueInfo srcBillType = (BizEnumValueInfo)this.tblMain.getRow(i).getCell("srcBillType").getValue();
            Object value = this.tblMain.getRow(i).getCell("srcBillId").getValue();
            if (value == null) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getBEAutoResource("37_BankAgentPayBillListUI"));
                return;
            }
            String billId = value.toString();
            if (billId != null) {
                CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                FMClientHelper.viewDetailBill((CoreUIObject)this, (String)billId, (CompanyOrgUnitInfo)company);
            }
        } else {
            this.setMessageText(this.getBEResource("SelectOneRow"));
            this.showMessage();
        }
    }

    @Override
    public void actionViewLog_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55");
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"bankPaymentBillId", idList.get(0));
        String uiName = BankLogListUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSyncStateByBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList<BankPayResult> resultList = new ArrayList<BankPayResult>();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("number");
        selectors.add("state");
        BankPayingBillCollection billColls = this.getBankPayingBillColls(new HashSet(idList), null, selectors);
        int size = billColls.size();
        for (int i = 0; i < size; ++i) {
            String billId;
            BankPayingBillInfo info = billColls.get(i);
            if (info.getState() == BankPayingBillStateEnum.OP) {
                billId = info.getId().toString();
                resultList.add(this.createBankPayResult(billId, info.getNumber(), null, this.getBEAutoResource("57_BankPayingBillListUI")));
                idList.remove(billId);
                continue;
            }
            if (info.getState() != BankPayingBillStateEnum.OF) continue;
            billId = info.getId().toString();
            resultList.add(this.createBankPayResult(billId, info.getNumber(), null, "\u63d0\u4ea4\u5931\u8d25\u72b6\u6001\u7684\u7684\u94f6\u884c\u4ed8\u6b3e\u5355\u4e0d\u5141\u8bb8\u540c\u6b65\u72b6\u6001\uff01"));
            idList.remove(billId);
        }
        IBankFacade bankFacade = BankFacadeFactory.getRemoteInstance();
        List<String> successIdList = null;
        try {
            successIdList = this.requestObjIdLock(idList, billColls, resultList);
            Map map = bankFacade.syncStateByBillIds(successIdList);
            Collection values = map.values();
            if (values != null && values.size() > 0) {
                resultList.addAll(values);
            }
            String title = this.btnSyncStateByBill.getText() + this.getBEResource("bankPayBill");
            this.showActionResult(resultList, title, null);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        finally {
            if (!EmptyUtil.isEmpty(successIdList)) {
                MutexServiceControlFactory.getRemoteInstance().batchReleaseObjIDForUpdate(successIdList);
            }
        }
    }

    protected void execQuery() {
        super.execQuery();
    }

    public static IUIWindow showDialogWindows(IUIObject ui, Set idSet) throws UIException {
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"ID_SET", (Object)idSet);
        uiContext.put((Object)"source", (Object)"sourceBill");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(CBSBankPayingBillListUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        return uiWindow;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmitNew(e);
    }

    @Override
    public void actionEditState_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        this.checkSelected();
        int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
        if (CheckUtils.sameIn((Object)EBSstatus, (Object[])new Object[]{2, 3})) {
            MsgBox.showInfo((String)"\u94fe\u63a5\u94f6\u4f01\u670d\u52a1\u5668\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u94f6\u4f01\u914d\u7f6e\u548c\u542f\u52a8\u72b6\u51b5\u3002");
            return;
        }
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        int state = ((BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("state").getValue()).getInt();
        if (state != 4) {
            throw new BEException(BEException.UPDATESTATEERROR1);
        }
        ArrayList idList = this.getSelectedIdValues();
        UIContext uiContext = new UIContext((Object)this);
        String uiNameReason = BankPayingBillModifyReason.class.getName();
        IUIWindow uiWindowReason = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiNameReason, (Map)uiContext, null, OprtState.VIEW);
        uiWindowReason.show();
        String reason = ((BankPayingBillModifyReason)uiWindowReason.getUIObject()).getReason();
        if (reason.length() == 0) {
            SysUtil.abort();
        }
        BankPayingBillFactory.getRemoteInstance().modifyReason(ConvertUtils.SET((Object[])new Object[]{idList}), reason);
        String uiName = BankPayingBillUpdateStateUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        BankPayingBillStateEnum updateState = ((BankPayingBillUpdateStateUI)uiWindow.getUIObject()).getResult();
        if (updateState == null) {
            return;
        }
        if (updateState == BankPayingBillStateEnum.TF && MsgBox.showConfirm2((Component)((Object)this), (String)(msg = this.getBEAutoResource("41_BankAgentPayBillListUI"))) == 2) {
            SysUtil.abort();
        }
        IObjectPK[] pks = (IObjectPK[])ConvertUtils.ARRAY((Object)idList, IObjectPK.class);
        Map ret = this.getBankPayingBillInterface().updateState(pks, updateState);
        List resultList = (List)ret.get("resultList");
        this.showActionResult(resultList, "\u4fee\u6539\u94f6\u884c\u4ed8\u6b3e\u5355\u72b6\u6001", "");
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        String currencyId = null;
        if (row != null && row.getCell("payAmount") != null) {
            try {
                currencyId = ((CBSBankPayingBillFilterParam)this.getFilterParam()).getCurrencyId();
                if (currencyId == null) {
                    currencyId = this.companyInfo.getBaseCurrency().getId().toString();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            String numberFormat = FMClientHelper.getNumberFtm((int)2);
            if (currencyId != null) {
                numberFormat = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
            }
            row.getCell("payAmount").getStyleAttributes().setNumberFormat(numberFormat);
        }
        return row;
    }

    @Override
    public void actionTdPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionTdPrint_actionPerformed(e);
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        CBSBankPayingBillPrintDataProvider data = new CBSBankPayingBillPrintDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print("/FM/BE/CBSBANKPAY", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTdPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionTdPreview_actionPerformed(e);
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        CBSBankPayingBillPrintDataProvider data = new CBSBankPayingBillPrintDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview("/FM/BE/CBSBANKPAY", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    private BankPayResult createBankPayResult(String id, String number, String returnMsg, String errorDetail) {
        BankPayResult resultInfo = new BankPayResult();
        resultInfo.setId(id);
        resultInfo.setNumber(number);
        resultInfo.setBankResult(returnMsg);
        resultInfo.setErrorDetail(errorDetail);
        return resultInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List commitBankPayBillToBE(List idList, BankPayingBillCollection billColls) throws Exception {
        ArrayList<BankPayResult> resultList = new ArrayList<BankPayResult>();
        if (billColls == null || billColls.size() == 0) {
            return resultList;
        }
        ArrayList<BankPayResult> resultLockList = new ArrayList<BankPayResult>();
        List<String> successIdList = null;
        try {
            successIdList = this.requestObjIdLock(idList, billColls, resultLockList);
            if (successIdList.size() > 0) {
                resultList.addAll(this.commitToBe(new HashSet<String>(successIdList)));
            }
        }
        catch (Exception en) {
            logger.error((Object)en);
            this.handleException(en);
        }
        finally {
            if (!EmptyUtil.isEmpty(successIdList)) {
                MutexServiceControlFactory.getRemoteInstance().batchReleaseObjIDForUpdate(successIdList);
            }
        }
        resultList.addAll(resultLockList);
        return resultList;
    }

    private void actionSubmitNew(ActionEvent e) throws Exception {
        this.checkSelected();
        SimpleTimer simpleTimer = new SimpleTimer();
        ThreadPool.setBackgroundRunButtonEnabled((boolean)false);
        ArrayList idList = this.getSelectedIdValues();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(3)));
        filter.mergeFilter(filter2, "or");
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("number");
        BankPayingBillCollection billColls = this.getBankPayingBillColls(new HashSet(idList), filter, selectors);
        List invalidResultList = this.getInVaildBankPayingResult(new HashSet(idList));
        List resultList = this.commitBankPayBillToBE(idList, billColls);
        String spentTime = String.format("%.2f", (double)simpleTimer.getTime() / 1000.0);
        String spentTimeHint = this.getBEResource("spentTime") + spentTime + this.getBEResource("second");
        ArrayList<Object> lastResult = null;
        lastResult = EmptyUtil.isEmpty((Collection)resultList) || !EmptyUtil.isEmpty((Collection)resultList) && resultList.size() == 0 ? new ArrayList<BankPayResult>() : new ArrayList(resultList);
        if (invalidResultList.size() > 0) {
            lastResult.addAll(invalidResultList);
        }
        this.showActionResult(lastResult, this.btnSubmit.getText() + this.getBEResource("bankPayBill"), spentTimeHint);
    }

    private List getInVaildBankPayingResult(Set hashSet) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)hashSet, CompareType.INCLUDE));
        ArrayList<Integer> stateList = new ArrayList<Integer>();
        stateList.add(new Integer(3));
        stateList.add(new Integer(1));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", new HashSet(stateList), CompareType.NOTINCLUDE));
        view.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("number");
        view.setSelector(selectors);
        BankPayingBillCollection invalidBankPayingBill = BankPayingBillFactory.getRemoteInstance().getBankPayingBillCollection(view);
        ArrayList<BankPayResult> invaildResult = new ArrayList<BankPayResult>();
        int invalidSize = invalidBankPayingBill.size();
        for (int i = 0; i < invalidSize; ++i) {
            BankPayingBillInfo bankPayingBillInfo = invalidBankPayingBill.get(i);
            BankPayResult bankPayResult = new BankPayResult();
            bankPayResult.setId(bankPayingBillInfo.getId().toString());
            bankPayResult.setErrorDetail("\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u51c6\u5907\u63d0\u4ea4\u6216\u8005\u63d0\u4ea4\u5931\u8d25\u7684\u94f6\u884c\u4ed8\u6b3e\u5355\u624d\u53ef\u4ee5\u63d0\u4ea4!");
            bankPayResult.setNumber(bankPayingBillInfo.getNumber());
            bankPayResult.setSubmitToBe(false);
            invaildResult.add(bankPayResult);
        }
        return invaildResult;
    }

    protected ArrayList commitToBe(Set validSet) throws BOSException, EASBizException {
        BankCommitToBeServiceClient bankCommitToBeServiceClient = new BankCommitToBeServiceClient();
        return bankCommitToBeServiceClient.commitToBENewBatchWithThread(validSet);
    }

    @Override
    protected String getEditUIName() {
        return CBSBankPayingBillUI.class.getName();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CBSBankPayingBillFilterUI();
        }
        return this.filterUI;
    }
}

