/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cbs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.BizTypeEnum;
import com.kingdee.eas.fi.cas.CurrentInfo;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.TemplatePaymentBillInfo;
import com.kingdee.eas.fi.cas.TemplateReceivingBillInfo;
import com.kingdee.eas.fi.cas.client.BookNotifyClientHelper;
import com.kingdee.eas.fi.cas.client.RecPayMakeBillFromSettlementBillListUI;
import com.kingdee.eas.fi.gl.common.GLf7Utils;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fpl.FPItemDirectionEnum;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.client.SettlementBillUnitListUI;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.framework.AbstractCoreBillEntryBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CBSPayHandler {
    private static Logger logger = Logger.getLogger((String)CBSPayHandler.class.getName());
    public static final String srcPath = "com.kingdee.eas.fi.cas.RecPayResource";
    public static final String COL_OPPACCOUNT = "oppAccount";
    public static final String IS_INITIALIZE_BILL = "IsInitializeBill";
    public static final String COL_AMT = "amount";
    public static final String COL_LOC_AMT = "localAmt";
    public static final String COL_SEQ = "seq";
    public static final String COL_CURRENCY = "currency";
    private RecPayInstanceAmountBean instanceBean = new RecPayInstanceAmountBean(Constants.ZERO, null, null);
    private static final boolean[][] billActionStatus = new boolean[][]{{false, false, false, false, false, false}, {true, false, false, false, true, false}, {false, true, true, false, false, false}, {false, false, false, true, false, false}, {false, false, false, true, false, false}, {true, false, false, false, false, true}};
    private static final boolean[][] voucherActionStatus = new boolean[][]{{false, false}, {true, false}, {false, true}};
    static Map exchangeRatePrecMap = new HashMap();
    private static final String COST_CENTER_DISPLAY_FORMAT = "$number$ $displayname$";

    public boolean[] getBillActionStatus(int billStatus) {
        switch (billStatus) {
            case 10: {
                return billActionStatus[0];
            }
            case 11: {
                return billActionStatus[1];
            }
            case 12: {
                return billActionStatus[2];
            }
            case 8: {
                return billActionStatus[5];
            }
            case 15: {
                return billActionStatus[3];
            }
            case 14: {
                return billActionStatus[4];
            }
        }
        return billActionStatus[0];
    }

    public boolean getCommitSettleStatus(int billStatus, int settlementStatus) {
        return billStatus == 12 && settlementStatus == 10;
    }

    public boolean getCancelCommitSettleStatus(int billStatus, int settlementStatus) {
        return settlementStatus == 11;
    }

    public boolean getWriteOffStatus(int billStatus, int fundType, boolean isRelateCheque) {
        return fundType == 101 && billStatus == 12 && !isRelateCheque;
    }

    public boolean getCommitBeStatus(int billStatus, AccountBankInfo acctBank) {
        return billStatus == 12;
    }

    public boolean[] getVoucherActionStatus(int billStatus, boolean isVouchered) {
        if (billStatus == 12 || billStatus == 15 || billStatus == 14) {
            if (!isVouchered) {
                return voucherActionStatus[1];
            }
            return voucherActionStatus[2];
        }
        return voucherActionStatus[0];
    }

    public boolean[] getVoucherActionStatus(IObjectValue obj, int billStatus, boolean isVouchered) {
        if (billStatus == 12 || billStatus == 15 || billStatus == 14) {
            if (!isVouchered) {
                return voucherActionStatus[1];
            }
            return voucherActionStatus[2];
        }
        return voucherActionStatus[0];
    }

    public Set getValidWriteOffIdSet(Set idSet) throws BOSException, RecPayException {
        int i;
        HashSet<String> validSet = new HashSet<String>();
        PaymentBillCollection coll = RecPayHelper.getPayColl(null, (Set)idSet);
        PaymentBillCollection validColl = new PaymentBillCollection();
        PaymentBillInfo info = null;
        int size = coll.size();
        for (int i2 = 0; i2 < size; ++i2) {
            info = coll.get(i2);
            if (!info.getFundType().equals((Object)BizTypeEnum.BANK) || !info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || info.isIsRelateCheque()) continue;
            validColl.add(info);
            if (info.getSettlementType() != null && info.getSettlementType().getNtType() != null && NTTypeGroupEnum.CHEQUE.equals((Object)info.getSettlementType().getNtType().getGroup())) continue;
            String settleType = "";
            if (info.getSettlementType() != null) {
                settleType = info.getSettlementType().getName();
            }
            throw new RecPayException(RecPayException.SETTLETYPE_ISNOTVALID, new Object[]{info.getNumber(), settleType});
        }
        PaymentBillInfo tempInfo = null;
        int size2 = validColl.size();
        for (i = 0; i < size2; ++i) {
            tempInfo = coll.get(0);
            info = coll.get(i);
            validSet.add(info.getId().toString());
            if (tempInfo.getPayerAccount().equals((Object)info.getPayerAccount()) && tempInfo.getCurrency().equals((Object)info.getCurrency()) && tempInfo.getSettlementType().equals((Object)info.getSettlementType())) continue;
            throw new RecPayException(RecPayException.MULTIBILL_ISNOTACCORD);
        }
        size2 = validColl.size();
        for (i = 0; i < size2; ++i) {
            tempInfo = coll.get(0);
            info = coll.get(i);
            if ((tempInfo.getSettlementNumber() != null || info.getSettlementNumber() == null) && (tempInfo.getSettlementNumber() == null || tempInfo.getSettlementNumber().equals(info.getSettlementNumber()))) continue;
            String msg = EASResource.getString((String)srcPath, (String)"SettleNumIsNotAccord");
            int reslut = MsgBox.showConfirm2((String)msg);
            if (reslut != 2) break;
            SysUtil.abort();
        }
        return validSet;
    }

    public void fillPayeeOrPayer(KDBizPromptBox promptBox, String id, String number, String name) {
        if (EmptyUtil.isEmpty((String)id) && EmptyUtil.isEmpty((String)name)) {
            promptBox.setData(null);
            return;
        }
        CurrentInfo info = new CurrentInfo();
        if (!EmptyUtil.isEmpty((String)id)) {
            info.setId(BOSUuid.read((String)id));
        }
        info.setName(name);
        info.setNumber(number);
        promptBox.setData((Object)info);
    }

    protected IIDList filterDupID(IIDList idList, String selectedId) {
        RealModeIDList noDupIdList = RealModeIDList.getEmptyIDList();
        if (idList == null) {
            return null;
        }
        int size = idList.size();
        String id = null;
        for (int i = 0; i < size; ++i) {
            id = idList.getID(i);
            if (noDupIdList.contains(id)) continue;
            noDupIdList.add(id);
        }
        noDupIdList.setCurrentID(selectedId);
        return noDupIdList;
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        IRow row = null;
        String currencyId = null;
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (e == null) {
            return;
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            row = tblMain.getRow(i);
            if (!EmptyUtil.isEmpty((Object)row.getCell("currency.id")) && !EmptyUtil.isEmpty((Object)row.getCell("currency.id").getValue())) {
                currencyId = (String)row.getCell("currency.id").getValue();
            }
            if (currencyId != null) {
                FMClientHelper.setNumberFormat((IRow)row, (String)"actPayAmt", currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"cbPayInfo.payeeAmount", currencyId);
            }
            if (companyInfo != null && companyInfo.getBaseCurrency() != null) {
                String baseCurrency = companyInfo.getBaseCurrency().getId().toString();
                FMClientHelper.setNumberFormat((IRow)row, (String)"actPayLocAmt", (String)baseCurrency);
            }
            if (tblMain.getColumn("exchangeRate") != null) {
                Date date = (Date)row.getCell("bizDate").getValue();
                int prec = CBSPayHandler.getExRatePrec(currencyId, null, companyInfo, date);
                row.getCell("exchangeRate").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)prec));
            }
            if (tblMain.getColumn("payeeType.name") != null && row.getCell("payeeType.name").getValue() == null) {
                row.getCell("payeeType.name").setValue((Object)FMSysDefinedEnum.OTHER);
            }
            if (tblMain.getColumn("payerType.name") == null || row.getCell("payerType.name").getValue() != null) continue;
            row.getCell("payerType.name").setValue((Object)FMSysDefinedEnum.OTHER);
        }
    }

    public static int getExchangeRatePrec(String sourceCurID, String desCurID) throws BOSException, EASBizException {
        String key = sourceCurID + "+" + desCurID;
        if (exchangeRatePrecMap.containsKey(key)) {
            return (Integer)exchangeRatePrecMap.get(key);
        }
        int prec = FMClientHelper.getExchangeRatePrec((String)sourceCurID, (String)desCurID);
        exchangeRatePrecMap.put(key, new Integer(prec));
        return prec;
    }

    public static int getExRatePrec(String srcCurrId, String destCurrId, CompanyOrgUnitInfo company, Date date) {
        if (srcCurrId == null || date == null) {
            return 0;
        }
        try {
            if (destCurrId == null) {
                if (company == null) {
                    company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                }
                if (srcCurrId.equals(destCurrId = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company).getId().toString())) {
                    return 0;
                }
            }
            return CBSPayHandler.getExchangeRatePrec(srcCurrId, destCurrId);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return 0;
    }

    public static int getExRatePrec(String srcCurrId, String destCurrId, String companyId, Date date) {
        if (srcCurrId == null || date == null) {
            return 0;
        }
        try {
            if (destCurrId == null) {
                CompanyOrgUnitInfo company = null;
                company = companyId == null ? ContextHelperFactory.getRemoteInstance().getCurrentCompany() : CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                destCurrId = company.getBaseCurrency().getId().toString();
            }
            return CBSPayHandler.getExchangeRatePrec(srcCurrId, destCurrId);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return 0;
    }

    public static ExchangeRateInfo getExRateInfo(String srcCurrId, String destCurrId, CompanyOrgUnitInfo company, Date date) {
        ExchangeTableInfo baseExchangeTable;
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        try {
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        if (destCurrId == null) {
            destCurrId = company.getBaseCurrency().getId().toString();
        }
        if ((baseExchangeTable = company.getBaseExchangeTable()) == null) {
            return null;
        }
        ExchangeRateInfo exRateInfo = null;
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurrId);
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurrId);
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        if (sourceCurrpk.equals((Object)destCurrpk)) {
            exRateInfo = new ExchangeRateInfo();
            exRateInfo.setConvertRate(new BigDecimal(1));
            return exRateInfo;
        }
        try {
            IExchangeRate iExchangRate = ExchangeRateFactory.getRemoteInstance();
            exRateInfo = iExchangRate.getExchangeRate((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, DateTimeUtils.truncateDate((Date)date));
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return exRateInfo;
    }

    public static boolean isIndirectExRate(ExchangeRateInfo exRateInfo) {
        if (exRateInfo == null) {
            return false;
        }
        return ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)exRateInfo.getConvertMode());
    }

    public String[] getMergeColumnKeys(KDTable tblMain) {
        tblMain.checkParsed();
        int size = tblMain.getColumn("entries.id").getColumnIndex();
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    public void initAsstActType(KDComboBox comboBox, String cuId) throws Exception {
        comboBox.removeAllItems();
        AsstActTypeCollection asstActTypeColl = CBSPayHandler.getAsstActTypeColl(cuId, false, false);
        comboBox.addItem((Object)FMSysDefinedEnum.OTHER);
        comboBox.addItems(asstActTypeColl.toArray());
    }

    public static AsstActTypeCollection getAsstActTypeColl(String companyID, boolean isPay, boolean isRec) throws BOSException, EASBizException {
        FilterInfo filter = CBSPayHandler.getAsstActTypeFilter(companyID, isPay, isRec);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("realtionDataObject"));
        IAsstActType asstActType = AsstActTypeFactory.getRemoteInstance();
        AsstActTypeCollection asstActTypeCollection = asstActType.getAsstActTypeCollection(evi);
        return asstActTypeCollection;
    }

    public static AsstActTypeCollection getAsstActTypeDefalutPayColl(String cuId) throws BOSException, EASBizException {
        FilterInfo filter = CBSPayHandler.getAsstActTypeFilter(cuId, false, false);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IAsstActType asstActType = AsstActTypeFactory.getRemoteInstance();
        AsstActTypeCollection asstActTypeCollection = asstActType.getAsstActTypeCollection(evi);
        return asstActTypeCollection;
    }

    private static FilterInfo getAsstActTypeFilter(String companyID, boolean isPay, boolean isRec) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((String)companyID)) {
            companyID = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        }
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        sb.append("select FAsstActTypeID from T_BD_AsstActTypeDefault where FIsAccountCussent=1 ");
        sb.append(" and FCompanyID='" + companyID + "'");
        if (isPay) {
            sb.append(" and FISDEFAULTACCOUNTPAYABLE=1");
        }
        if (isRec) {
            sb.append(" and FISDEFAULTACCOUNTRECEIVABLE=1");
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        return filter;
    }

    private static Set getAsstActTypeIdSet(String companyId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("asstActType.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isAccountCussent", (Object)Constants.TRUE));
        evi.setFilter(filter);
        IAsstActTypeDefault iAsstActTypeDefault = AsstActTypeDefaultFactory.getRemoteInstance();
        AsstActTypeDefaultCollection coll = iAsstActTypeDefault.getAsstActTypeDefaultCollection(evi);
        HashSet<String> idSet = new HashSet<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(coll.get(i).getAsstActType().getId().toString());
        }
        return idSet;
    }

    public static EntityViewInfo getAccountViewEvi(String cuId, String companyId, String currencyId, boolean isLeaf) throws EASBizException, BOSException {
        return CBSPayHandler.getAccountViewEvi(cuId, companyId, currencyId, isLeaf, true);
    }

    public static EntityViewInfo getAccountViewEvi(String cuId, String companyId, String currencyId, boolean isLeaf, boolean isShowCashAndBank) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        CurrencyInfo baseCurrency = company.getBaseCurrency();
        BOSUuid acctTableId = company.getAccountTable().getId();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        if (acctTableId != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)acctTableId.toString()));
        }
        if (isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        }
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Boolean.FALSE));
        if (!isShowCashAndBank) {
            filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)Boolean.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)Boolean.FALSE));
        }
        FilterInfo filterAcctCurrency = new FilterInfo();
        filterAcctCurrency.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(2)));
        filterAcctCurrency.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(1)));
        filterAcctCurrency.getFilterItems().add(new FilterItemInfo("id", (Object)("select FACCOUNTVIEWID from t_bd_accountcurrency where FCURRENCYID = '" + currencyId + "'"), CompareType.INNER));
        if (baseCurrency != null) {
            filterAcctCurrency.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(0)));
            filterAcctCurrency.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)("select FID from t_org_company where fBaseCurrencyid = '" + baseCurrency.getId().toString() + "' "), CompareType.INNER));
            filterAcctCurrency.setMaskString("(#0) OR (#1 AND #2) OR (#3 AND #4)");
        } else {
            filterAcctCurrency.setMaskString("(#0) OR (#1 AND #2) ");
        }
        if (currencyId != null) {
            filter.mergeFilter(filterAcctCurrency, "AND");
        }
        EntityViewInfo customEvi = new EntityViewInfo();
        customEvi.setFilter(filter);
        SorterItemCollection sorter = customEvi.getSorter();
        sorter.add(new SorterItemInfo("number"));
        return customEvi;
    }

    public static AccountViewInfo getAcctViewInfo(EntityViewInfo evi) throws BOSException {
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        AccountViewCollection coll = iAccountView.getAccountViewCollection(evi);
        if (coll != null && !coll.isEmpty()) {
            return coll.get(0);
        }
        return null;
    }

    public static EntityViewInfo getCashAccountEvi(String companyId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Boolean.FALSE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return evi;
    }

    public static EntityViewInfo getBankAccountEvi(String companyId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Boolean.FALSE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return evi;
    }

    public static EntityViewInfo getAccountBankContainTurstEvi(String companyId, String accountId) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String sql = " select bd.fid from t_bd_accountbanks bd  left outer join T_BD_AcctBankTrusterEntries AS en on en.FAcctBankID=bd.fid  where bd.fcompanyid='" + companyId + "' or en.ftrustCompanyID ='" + companyId + "'";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        if (accountId != null) {
            filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        evi.setFilter(filter);
        return evi;
    }

    public static EntityViewInfo getAccountBankContainTurstEvi(String companyId, String turstCompanyID, String accountId) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String sql = "select bd.fid from t_bd_accountbanks bd  left outer join T_BD_AcctBankTrusterEntries AS en on en.FAcctBankID=bd.fid   where bd.fcompanyid='" + companyId + "'  or (bd.fcompanyid='" + turstCompanyID + "' and en.ftrustCompanyID ='" + companyId + "')";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        if (accountId != null) {
            filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        evi.setFilter(filter);
        return evi;
    }

    public static EntityViewInfo getAccountBankEvi(String companyId, String accountId) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        if (accountId != null) {
            filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        evi.setFilter(filter);
        return evi;
    }

    public static EntityViewInfo getCustomAcctEvi(String accountTable, boolean hasCashBank) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTable));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)FMConstants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)FMConstants.FALSE));
        if (hasCashBank) {
            System.out.print("o");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)FMConstants.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.FALSE));
        }
        EntityViewInfo customEvi = new EntityViewInfo();
        customEvi.setFilter(filter);
        return customEvi;
    }

    public static EntityViewInfo getCustomAcctEvi(String companyId, String accountTable, boolean hasCashBank) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTable));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        if (!hasCashBank) {
            filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)Constants.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)Constants.FALSE));
        }
        EntityViewInfo customEvi = new EntityViewInfo();
        customEvi.setFilter(filter);
        return customEvi;
    }

    public static EntityViewInfo getCustomAcctEvi(String companyId, String accountTable, boolean isLeaf, boolean hasCashBank) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
        if (isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        }
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTable));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        if (!hasCashBank) {
            filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)Constants.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)Constants.FALSE));
        }
        EntityViewInfo customEvi = new EntityViewInfo();
        customEvi.setFilter(filter);
        return customEvi;
    }

    public static EntityViewInfo getCommonAcctEvi(String companyId, String accountTable) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTable));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        EntityViewInfo customEvi = new EntityViewInfo();
        customEvi.setFilter(filter);
        return customEvi;
    }

    public static EntityViewInfo getCustomAcctEvi(String companyId, String accountTable, BizTypeEnum bizType) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTable));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        EntityViewInfo customEvi = new EntityViewInfo();
        customEvi.setFilter(filter);
        return customEvi;
    }

    public static EntityViewInfo getFpItemEvi(FPItemDirectionEnum direction) {
        HashSet<String> set = new HashSet<String>();
        set.add(direction.getValue());
        set.add("other");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("direction", set, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return evi;
    }

    public void initCellEditor(KDTable kdtEntries, String currId, String localCurrId) throws Exception {
        if (EmptyUtil.isEmpty((String)currId) || EmptyUtil.isEmpty((String)localCurrId)) {
            return;
        }
        int prec = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)currId));
        int localPrec = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)localCurrId));
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField((KDTable)kdtEntries, (String)COL_AMT, (int)prec, (BigDecimal)Constants.MIN_VALUE);
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField((KDTable)kdtEntries, (String)COL_LOC_AMT, (int)localPrec, (BigDecimal)Constants.MIN_VALUE);
        FMClientHelper.setNumberFormat((KDTable)kdtEntries, (String)COL_AMT, (String)currId);
        FMClientHelper.setNumberFormat((KDTable)kdtEntries, (String)COL_LOC_AMT, (String)localCurrId);
        KDTextField editor = new KDTextField();
        editor.setMaxLength(500);
        KDTDefaultCellEditor ed = new KDTDefaultCellEditor((JTextField)editor);
        kdtEntries.getColumn("remark").setEditor((ICellEditor)ed);
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyInfo info = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currId));
        IRow row = null;
        int count = kdtEntries.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = kdtEntries.getRow(i);
            row.getCell(COL_CURRENCY).setValue((Object)info);
        }
    }

    public void initCellEditor(KDTable kdtEntries, CurrencyInfo selecedInfo, String localCurrId) throws Exception {
        if (EmptyUtil.isEmpty((CoreBaseInfo)selecedInfo) || EmptyUtil.isEmpty((String)localCurrId)) {
            return;
        }
        String currId = selecedInfo.getId().toString();
        int prec = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)currId));
        int localPrec = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)localCurrId));
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField((KDTable)kdtEntries, (String)COL_AMT, (int)prec, (BigDecimal)Constants.MIN_VALUE);
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField((KDTable)kdtEntries, (String)COL_LOC_AMT, (int)localPrec, (BigDecimal)Constants.MIN_VALUE);
        FMClientHelper.setNumberFormat((KDTable)kdtEntries, (String)COL_AMT, (String)currId);
        FMClientHelper.setNumberFormat((KDTable)kdtEntries, (String)COL_LOC_AMT, (String)localCurrId);
        KDTextField editor = new KDTextField();
        editor.setMaxLength(500);
        KDTDefaultCellEditor ed = new KDTDefaultCellEditor((JTextField)editor);
        kdtEntries.getColumn("remark").setEditor((ICellEditor)ed);
        IRow row = null;
        int count = kdtEntries.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = kdtEntries.getRow(i);
            row.getCell(COL_CURRENCY).setValue((Object)selecedInfo);
        }
    }

    public void setEntrySeq(KDTable table) {
        if (table == null) {
            return;
        }
        IRow row = null;
        int seq = 1;
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = table.getRow(i);
            if (row.getUserObject() instanceof AbstractCoreBillEntryBaseInfo) {
                ((AbstractCoreBillEntryBaseInfo)row.getUserObject()).setSeq(seq);
            }
            row.getCell(COL_SEQ).setValue((Object)new Integer(seq++));
        }
    }

    public void setEntryTableAmt(KDTable table, BigDecimal rate, BOSUuid currencyId) {
        IRow row = null;
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = table.getRow(i);
            this.setEntryRowAmt(row, rate, currencyId);
        }
    }

    private void setEntryRowAmt(IRow row, BigDecimal rate, BOSUuid currencyId) {
        if (row == null || rate == null || currencyId == null) {
            return;
        }
        BigDecimal amount = (BigDecimal)row.getCell(COL_AMT).getValue();
        if (amount == null) {
            amount = Constants.ZERO;
        }
        int scale = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyId);
        BigDecimal localAmt = amount.multiply(rate);
        localAmt = localAmt.setScale(scale, 4);
        row.getCell(COL_LOC_AMT).setValue((Object)localAmt);
    }

    public void setEntryTableIsNullAmt(KDTable table, BigDecimal rate, BOSUuid currencyId) {
        IRow row = null;
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = table.getRow(i);
            if (row == null || rate == null || currencyId == null) {
                return;
            }
            BigDecimal amount = (BigDecimal)row.getCell(COL_AMT).getValue();
            if (amount == null) {
                amount = Constants.ZERO;
            }
            int scale = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyId);
            BigDecimal localAmt = amount.multiply(rate);
            localAmt = localAmt.setScale(scale, 4);
            if (row.getCell(COL_LOC_AMT).getValue() != null) continue;
            row.getCell(COL_LOC_AMT).setValue((Object)localAmt);
        }
    }

    public BigDecimal getEntrySumAmt(KDTable table, String colName) {
        if (table == null || table.getRowCount() < 1 || colName == null) {
            return Constants.ZERO;
        }
        IRow row = null;
        BigDecimal sumAmt = Constants.ZERO;
        BigDecimal tempAmt = Constants.ZERO;
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = table.getRow(i);
            if (row.getCell(colName).getValue() == null) continue;
            tempAmt = (BigDecimal)row.getCell(colName).getValue();
            sumAmt = sumAmt.add(tempAmt);
        }
        return sumAmt;
    }

    public void setHeadSumAmt(KDTable table, KDFormattedTextField txtAmt, KDFormattedTextField txtLocalAmt) {
        BigDecimal sumAmt = this.getEntrySumAmt(table, COL_AMT);
        txtAmt.setValue((Object)sumAmt);
        BigDecimal sumLocalAmt = this.getEntrySumAmt(table, COL_LOC_AMT);
        txtLocalAmt.setValue((Object)sumLocalAmt);
    }

    public TemplatePaymentBillInfo getDefaultTplPayInfo(CompanyOrgUnitInfo companyInfo, TemplatePaymentBillInfo info) {
        if (info.getCompany() == null) {
            info.getActPayAmt();
            info.setCompany(companyInfo);
        }
        if (info.getActPayAmt() == null) {
            info.setActPayAmt(Constants.ZERO);
        }
        if (info.getExchangeRate() == null) {
            info.setExchangeRate(Constants.ONE);
        }
        if (info.getActPayLocAmt() == null) {
            info.setActPayLocAmt(info.getActPayAmt().multiply(info.getExchangeRate()));
        }
        if (info.getCreator() == null) {
            info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        }
        if (info.getCreateTime() == null) {
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        }
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            if (info.getEntries().get(i).getActualAmt() == null) {
                info.getEntries().get(i).setActualAmt(Constants.ZERO);
            }
            if (info.getEntries().get(i).getActualAmt() != null) continue;
            BigDecimal amount = info.getEntries().get(i).getActualAmt();
            info.getEntries().get(i).setActualLocAmt(amount.multiply(info.getExchangeRate()));
        }
        return info;
    }

    public TemplateReceivingBillInfo getDefaultTplRecInfo(CompanyOrgUnitInfo companyInfo, TemplateReceivingBillInfo info) {
        if (info.getCompany() == null) {
            info.setCompany(companyInfo);
        }
        if (info.getActRecAmt() == null) {
            info.setActRecAmt(Constants.ZERO);
        }
        if (info.getExchangeRate() == null) {
            info.setExchangeRate(Constants.ONE);
        }
        if (info.getActRecLocAmt() == null) {
            info.setActRecLocAmt(info.getActRecAmt().multiply(info.getExchangeRate()));
        }
        if (info.getCreator() == null) {
            info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        }
        if (info.getCreateTime() == null) {
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        }
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            if (info.getEntries().get(i).getActualAmt() == null) {
                info.getEntries().get(i).setActualAmt(Constants.ZERO);
            }
            if (info.getEntries().get(i).getActualAmt() != null) continue;
            BigDecimal amount = info.getEntries().get(i).getActualAmt();
            info.getEntries().get(i).setActualLocAmt(amount.multiply(info.getExchangeRate()));
        }
        return info;
    }

    public PaymentBillInfo getDefaultPayInfo(CompanyOrgUnitInfo companyInfo, PaymentBillInfo info) {
        if (info.getCompany() == null) {
            info.setCompany(companyInfo);
        }
        if (info.getBizDate() == null) {
            info.setBizDate(new Date());
        }
        if (info.getBillStatus() == null) {
            info.setBillStatus(BillStatusEnum.SAVE);
        }
        if (info.getActPayAmt() == null) {
            info.setActPayAmt(Constants.ZERO);
        }
        if (info.getCreator() == null) {
            info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        }
        if (info.getCreateTime() == null) {
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        }
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            if (info.getEntries().get(i).getActualAmt() != null) continue;
            info.getEntries().get(i).setActualAmt(Constants.ZERO);
        }
        return info;
    }

    public ReceivingBillInfo getDefaultRecInfo(CompanyOrgUnitInfo companyInfo, ReceivingBillInfo info) {
        if (info.getCompany() == null) {
            info.setCompany(companyInfo);
        }
        if (info.getBizDate() == null) {
            info.setBizDate(new Date());
        }
        if (info.getBillStatus() == null) {
            info.setBillStatus(BillStatusEnum.SAVE);
        }
        if (info.getActRecAmt() == null) {
            info.setActRecAmt(Constants.ZERO);
        }
        if (info.getExchangeRate() == null) {
            info.setExchangeRate(Constants.ONE);
        }
        if (info.getActRecLocAmt() == null) {
            info.setActRecLocAmt(info.getActRecAmt().multiply(info.getExchangeRate()));
        }
        if (info.getCreator() == null) {
            info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        }
        if (info.getCreateTime() == null) {
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        }
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            if (info.getEntries().get(i).getActualAmt() != null) continue;
            info.getEntries().get(i).setActualAmt(Constants.ZERO);
        }
        return info;
    }

    public static void assActSelector(CoreUIObject ui, Object selectedItem, KDBizPromptBox prmtPayee) {
        if (selectedItem instanceof AsstActTypeInfo) {
            AsstActTypeInfo info = (AsstActTypeInfo)selectedItem;
            prmtPayee.setSelector(null);
            prmtPayee.setFilterInfoProducer(null);
            prmtPayee.setQueryInfo(info.getDefaultQueryName());
            prmtPayee.setDefaultF7UIName(info.getDefaultF7UI());
            GLf7Utils.assignSelector((KDBizPromptBox)prmtPayee, (GeneralAsstActTypeGroupInfo)info.getGlAsstActTypeGrp(), (String)info.getAsstHGAttribute(), (boolean)true, (boolean)false, null, (CoreUIObject)ui, (boolean)false);
            prmtPayee.setCommitFormat("$number$");
            prmtPayee.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$", prmtPayee));
        } else if (selectedItem instanceof FMSysDefinedEnum) {
            ExtendParser parser = new ExtendParser(prmtPayee);
            prmtPayee.setCommitParser((IParser)parser);
        }
    }

    public static void checkBillsHasWF(List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        ArrayList<String> hasWFList = new ArrayList<String>();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            String id = (String)idList.get(i);
            if (!FMHelper.hasWFInstance(null, (String)id)) continue;
            hasWFList.add(id);
        }
        if (hasWFList != null && !hasWFList.isEmpty() && hasWFList.size() != idList.size()) {
            throw new RecPayException(RecPayException.HASWFINSTANCEERROR);
        }
    }

    public void resetColumnFontColor(KDTable kdtEntries, Color colorType, String[] redArray, boolean isRedBill) {
        int i;
        int row;
        int num = kdtEntries.getRowCount();
        for (row = 0; row < num; ++row) {
            for (i = 0; i < redArray.length; ++i) {
                try {
                    kdtEntries.getColumn(redArray[i]).getStyleAttributes().setFontColor(colorType);
                    continue;
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
        num = kdtEntries.getRowCount();
        for (row = 0; row < num; ++row) {
            for (i = 0; i < redArray.length; ++i) {
                KDTDefaultCellEditor editor = (KDTDefaultCellEditor)kdtEntries.getColumn(redArray[i]).getEditor();
                Component componet = editor.getComponent();
                if (!(componet instanceof KDFormattedTextField)) continue;
                KDFormattedTextField textFeild = (KDFormattedTextField)componet;
                if (isRedBill) {
                    textFeild.setMinimumValue((Comparable)Constants.ZERO);
                    continue;
                }
                textFeild.setMinimumValue(null);
            }
        }
    }

    public boolean getBankAccountNumberBelong(String companyNumber, String bankAccountNumber) {
        String sql = " SELECT fBankAccountNumber FROM T_BD_AccountBanks where FCompanyID='" + companyNumber + "' and fBankAccountNumber ='" + bankAccountNumber + "'";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = null;
        boolean result = false;
        try {
            rs = exec.executeSQL();
        }
        catch (BOSException e1) {
            SysUtil.abort((Throwable)e1);
        }
        try {
            if (rs != null && rs.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            SysUtil.abort((Throwable)e);
        }
        return result;
    }

    public boolean getAccountBelong(String companyId, String accountId, String bankacctNumber) {
        String sql = "SELECT ab.fid FROM T_BD_AccountBanks ab ,T_ORG_Company c ,T_BD_AccountView av where ab.FCompanyID = c.FID and c.FID = '" + companyId + "' and ab.FAccountID = av.FID and av.FID='" + accountId + "'and ab.fbankaccountnumber = '" + bankacctNumber + "'";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = null;
        boolean result = false;
        try {
            rs = exec.executeSQL();
        }
        catch (BOSException e1) {
            SysUtil.abort((Throwable)e1);
        }
        try {
            if (rs != null && rs.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            SysUtil.abort((Throwable)e);
        }
        return result;
    }

    public static List getDlFromStBillList(Context mainOrgContext, EntityViewInfo botpEvi, HashMap paramCtx) throws Exception {
        BOSObjectType targetBillType = (BOSObjectType)paramCtx.get("TargetBillBosType");
        BOSObjectType srcBillType = new SettlementBillInfo().getBOSType();
        UIContext uiContext = new UIContext();
        uiContext.put("billEdit", null);
        uiContext.put("destBillBOSTypeString", targetBillType);
        uiContext.put("srcBillBOSTypeString", srcBillType);
        uiContext.put("srcBillListUIName", SettlementBillUnitListUI.class.getName());
        uiContext.put("BOTPFilter", botpEvi);
        if (paramCtx != null) {
            uiContext.put("BTPEDITPARAMETER", paramCtx);
        }
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(RecPayMakeBillFromSettlementBillListUI.class.getName(), (Map)uiContext, null);
        ((RecPayMakeBillFromSettlementBillListUI)window.getUIObject()).setSrcBosType(srcBillType.toString());
        window.show();
        List srcBillColsList = ((RecPayMakeBillFromSettlementBillListUI)window.getUIObject()).getSrcBillColsList();
        return srcBillColsList;
    }

    public static FilterInfo getOrgFilterInfo(String cuid, OrgViewType orgType, FilterInfo filter) {
        try {
            HashMap map = OrgF7InnerUtils.getAuthorizedOrgViewIDs((IObjectPK)new ObjectUuidPK(cuid), (boolean)true, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (OrgViewType)orgType, null, null, null);
            if (map != null) {
                Object[] ids = map.keySet().toArray();
                StringBuffer strFilter = new StringBuffer("");
                for (int i = 0; i < ids.length; ++i) {
                    String id = ids[i].toString();
                    if (i > 0) {
                        strFilter.append(",");
                    }
                    strFilter.append(id);
                }
                FilterInfo filterID = new FilterInfo();
                filterID.getFilterItems().add(new FilterItemInfo("id", (Object)strFilter.toString(), CompareType.INCLUDE));
                filter.mergeFilter(filterID, "and");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return filter;
    }

    public RecPayInstanceAmountBean getInstanceBean() {
        return this.instanceBean;
    }

    public void setInstanceBean(RecPayInstanceAmountBean instanceBean) {
        this.instanceBean = instanceBean;
    }

    public static void initCostCenterF7(IUIObject owner, KDBizPromptBox prmtCostCenter, String currentOrgId, Object paramCS082) {
        NewCostCenterF7 costCenterF7 = new NewCostCenterF7(owner);
        costCenterF7.setNeedAddOrgRange(false);
        costCenterF7.setIsCUFilter(true);
        costCenterF7.setMultiSelect(false);
        costCenterF7.setContainSealUp(false);
        costCenterF7.setNeedConsiderFaultTree(false);
        costCenterF7.setCurrentCUID(currentOrgId);
        if (paramCS082 != null && paramCS082.equals("0")) {
            costCenterF7.showCheckBoxOfShowingAllOUs();
            costCenterF7.setIsCUFilter(false);
        }
        prmtCostCenter.setEditFormat("$number$");
        prmtCostCenter.setCommitFormat("$number$;$name$");
        prmtCostCenter.setDisplayFormat(COST_CENTER_DISPLAY_FORMAT);
        prmtCostCenter.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
        prmtCostCenter.setEnabledMultiSelection(false);
        prmtCostCenter.setSelector((KDPromptSelector)costCenterF7);
    }

    public static void initCostCenterF7(IUIObject owner, KDBizPromptBox prmtCostCenter, String currentOrgId, boolean isARAP) {
        NewCostCenterF7 costCenterF7 = new NewCostCenterF7(owner);
        costCenterF7.setNeedAddOrgRange(false);
        costCenterF7.setIsCUFilter(true);
        costCenterF7.setMultiSelect(false);
        costCenterF7.setContainSealUp(false);
        costCenterF7.setNeedConsiderFaultTree(false);
        costCenterF7.setCurrentCUID(currentOrgId);
        costCenterF7.showCheckBoxOfShowingAllOUs();
        prmtCostCenter.setEditFormat("$number$");
        prmtCostCenter.setCommitFormat("$number$;$name$");
        prmtCostCenter.setDisplayFormat(COST_CENTER_DISPLAY_FORMAT);
        prmtCostCenter.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
        prmtCostCenter.setEnabledMultiSelection(false);
        prmtCostCenter.setSelector((KDPromptSelector)costCenterF7);
    }

    public static void initCostCenterF7Cell(IUIObject owner, KDTable kdTable, String columnName, String currentOrgId, Object paramCS082) {
        KDBizPromptBox prmtCostCenter = new KDBizPromptBox();
        CBSPayHandler.initCostCenterF7(owner, prmtCostCenter, currentOrgId, paramCS082);
        prmtCostCenter.setDisplayFormat(COST_CENTER_DISPLAY_FORMAT);
        kdTable.getColumn(columnName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtCostCenter));
        ObjectValueRender renderer = new ObjectValueRender();
        renderer.setFormat((IDataFormat)new BizDataFormat(COST_CENTER_DISPLAY_FORMAT));
        kdTable.getColumn(columnName).setRenderer((IBasicRender)renderer);
    }

    public void setTableRowHide(KDTable kdtEntries, String[] rowNames, boolean isHide) {
        int n = rowNames.length;
        for (int i = 0; i < n; ++i) {
            if (rowNames[i] == null || kdtEntries.getColumn(rowNames[i]) == null) continue;
            kdtEntries.getColumn(rowNames[i]).getStyleAttributes().setHided(isHide);
        }
    }

    public static String sumList(KDTable tblMain, int prec, boolean isDisplayEntries) {
        String colAmt = "actPayAmt";
        if (isDisplayEntries) {
            colAmt = "actPayAmt";
        }
        StringBuffer msg = new StringBuffer();
        int sumCount = KDTableHelper.getSelectedCountInColumn((KDTable)tblMain, (int)tblMain.getColumn("number").getColumnIndex());
        BigDecimal sumMoney = KDTableHelper.getSelectedSumInColumn((KDTable)tblMain, (int)tblMain.getColumn(colAmt).getColumnIndex());
        NumberFormat fm = NumberFormat.getInstance();
        fm.setMinimumFractionDigits(prec);
        msg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"381_RecPayHandler")).append(fm.format(sumMoney)).append("        ").append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"382_RecPayHandler")).append(sumCount).append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"383_RecPayHandler"));
        return msg.toString();
    }

    public class RecPayInstanceAmountBean {
        private BigDecimal orignalAmt = Constants.ZERO;
        private AccountBankInfo acctBank = null;
        private AccountViewInfo acctView = null;

        public RecPayInstanceAmountBean(BigDecimal orignalAmt, AccountBankInfo acctBank, AccountViewInfo acctView) {
            this.orignalAmt = orignalAmt;
            this.acctBank = acctBank;
            this.acctView = acctView;
        }

        public AccountBankInfo getAcctBank() {
            return this.acctBank;
        }

        public void setAcctBank(AccountBankInfo acctBank) {
            this.acctBank = acctBank;
        }

        public AccountViewInfo getAcctView() {
            return this.acctView;
        }

        public void setAcctView(AccountViewInfo acctView) {
            this.acctView = acctView;
        }

        public BigDecimal getOrignalAmt() {
            return this.orignalAmt;
        }

        public void setOrignalAmt(BigDecimal orignalAmt) {
            this.orignalAmt = orignalAmt;
        }
    }
}

