/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.ctl.client.AbstractAssureBillDetailFilterUI;
import com.kingdee.eas.fm.ctl.client.AssureBillDetailFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;

public class AssureBillDetailFilterUI
extends AbstractAssureBillDetailFilterUI {
    protected Class getParamClass() {
        return AssureBillDetailFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public Object getParam() {
        AssureBillDetailFilterParam filterParam = new AssureBillDetailFilterParam();
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterParam.setCompanyIdSet(this.getCompanyIdSet());
        }
        if (this.dpBegin.getValue() != null) {
            filterParam.setBeginDate(this.dpBegin.getSqlDate());
        }
        if (this.dpEnd.getValue() != null) {
            filterParam.setEndDate(this.dpEnd.getSqlDate());
        }
        if (this.prmtBank.getValue() != null) {
            filterParam.setBankIdSet(this.getIdSetFromF7(this.prmtBank));
        }
        if (this.prmtAssureType.getValue() != null) {
            filterParam.setAssureTypeIdSet(this.getIdSetFromF7(this.prmtAssureType));
        }
        if (this.comboUnit.getSelectedItem() != null) {
            filterParam.setAmountUnit((AmountUnitEnum)this.comboUnit.getSelectedItem());
        }
        if (this.txtAmount.getBigDecimalValue() != null) {
            filterParam.setAmount(this.txtAmount.getBigDecimalValue());
        }
        filterParam.setCancelDisplay(this.ckboxcancel.isSelected());
        if (this.txtDesc.getText() != null) {
            filterParam.setDescription(this.txtDesc.getText());
        }
        filterParam.setGroupType(this.kDButtonGroupType.getValue());
        return filterParam;
    }

    public void setParam(Object param) {
        AssureBillDetailFilterParam filterParam = (AssureBillDetailFilterParam)((Object)param);
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
        this.dpBegin.setValue((Object)filterParam.getBeginDate());
        this.dpEnd.setValue((Object)filterParam.getEndDate());
        try {
            this.prmtBank.setValue((Object)this.getBaseInfoFromIdSet(filterParam.getBankIdSet()));
            this.prmtAssureType.setValue((Object)this.getBaseInfoFromIdSet(filterParam.getAssureTypeIdSet()));
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        FMClientHelper.setSelectObject((KDComboBox)this.comboUnit, (Object)filterParam.getAmountUnit());
        if (this.comboUnit.getSelectedItem() == null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboUnit, (Object)AmountUnitEnum.wan_yuan);
        }
        this.txtAmount.setValue((Object)filterParam.getAmount());
        this.txtDesc.setText(filterParam.getDescription());
        this.kDButtonGroupType.setValue(filterParam.getGroupType());
        this.ckboxcancel.setSelected(filterParam.getCancelDisplay());
    }

    protected void init() throws Exception {
        super.init();
        this.dpBegin.setValue((Object)DateUtil.getDayBegin());
        this.dpEnd.setValue((Object)DateUtil.getDayBegin());
        this.prmtBank.setValue(null);
        this.prmtAssureType.setValue(null);
        FMClientHelper.setSelectObject((KDComboBox)this.comboUnit, (Object)AmountUnitEnum.wan_yuan);
        this.txtAmount.setSupportedEmpty(true);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        this.txtAmount.setPrecision(2);
        this.txtAmount.setValue((Object)new BigDecimal("10.00"));
        this.getFirstDayOfMonth(this.dpBegin);
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.txtDesc.setText(companyInfo.getName());
        this.kDButtonGroupType.setValue(0);
        this.ckboxcancel.setSelected(false);
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    protected boolean isAutoFillCurCompany() {
        return false;
    }

    protected boolean isCheckCompanyNullWhenOnlyUnion() {
        return true;
    }

    private void getFirstDayOfMonth(KDDatePicker kdDate) {
        Date date = new Date();
        GregorianCalendar firstDay = new GregorianCalendar();
        firstDay.add(5, -(date.getDate() - 1));
        kdDate.setValue((Object)firstDay.getTime());
    }

    public boolean verify() {
        Date kdDateFrom = DateTimeUtils.truncateDate((Date)this.dpBegin.getSqlDate());
        Date kdDateTo = DateTimeUtils.truncateDate((Date)this.dpEnd.getSqlDate());
        if (kdDateFrom == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"131_RptLetterOfGuaranteeDetailFilterUI"));
            SysUtil.abort();
        }
        if (kdDateTo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"132_RptLetterOfGuaranteeDetailFilterUI"));
            SysUtil.abort();
        }
        if (kdDateFrom.compareTo(kdDateTo) > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"133_RptLetterOfGuaranteeDetailFilterUI"));
            SysUtil.abort();
        }
        return super.verify();
    }
}

