/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.DefaultKDTCurrencyProvider;
import com.kingdee.eas.fm.common.client.DefaultKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IKDTPrecisionProvider;
import com.kingdee.eas.fm.common.client.IKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.KDTActualPrecisionProvider;
import com.kingdee.eas.fm.ctl.AssureBillException;
import com.kingdee.eas.fm.ctl.AssureBillFactory;
import com.kingdee.eas.fm.ctl.AssureBillHelper;
import com.kingdee.eas.fm.ctl.AssureBillInfo;
import com.kingdee.eas.fm.ctl.AssureBillStateEnum;
import com.kingdee.eas.fm.ctl.IAssureBill;
import com.kingdee.eas.fm.ctl.RelationWithAssuredUnitEnum;
import com.kingdee.eas.fm.ctl.client.AbstractAssureBillListUI;
import com.kingdee.eas.fm.ctl.client.AssureBillEditUI;
import com.kingdee.eas.fm.ctl.client.AssureBillFilterParam;
import com.kingdee.eas.fm.ctl.client.AssureBillFilterUI;
import com.kingdee.eas.fm.ctl.client.AssureBillUsedListUI;
import com.kingdee.eas.fm.ctl.client.SetAssureExpiredDateUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class AssureBillListUI
extends AbstractAssureBillListUI {
    private AssureBillFilterUI filterUI;
    private IKDTablePrecisionFormater currencyPrecFormater = null;
    private IKDTablePrecisionFormater actualPrecFormater = null;
    private Logger logger = CtrlUtil.Log.getLogger((String)"com.kingdee.eas.fm.ctl.client.AssureBillListUI");
    private static final String tdTemplateFile = "/FM/CTL/ASSUREBILL";

    public AssureBillListUI() throws Exception {
        this.currencyPrecFormater = new DefaultKDTablePrecisionFormater();
        this.currencyPrecFormater.setPrecProvider((IKDTPrecisionProvider)new DefaultKDTCurrencyProvider("currency.id"));
        this.actualPrecFormater = new DefaultKDTablePrecisionFormater();
        this.actualPrecFormater.setPrecProvider((IKDTPrecisionProvider)new KDTActualPrecisionProvider());
    }

    protected void checkBizUnit() throws EASBizException, BOSException {
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.currentCompanyCommon)) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionUpdateCloseDate.setVisible(false);
            this.actionAudit.setVisible(false);
            this.actionAntiAudit.setVisible(false);
            this.actionCancel.setVisible(false);
            this.actionUnCancel.setVisible(false);
        }
    }

    public void onLoad() throws Exception {
        this.currencyPrecFormater.init(this.getMainTable(), new String[]{"contactAmount", "contactLocalAmt", "assureLimitAmt", "asLocalLimitAmt", "bizLocalBalance", "assureResAmount", "antiAssAmount", "antiAssValue", "assurefee", "assurecfgfee", "KdtRepayPlanEntries.repayAmt"});
        this.tblMain.getColumn("exRate").getStyleAttributes().setNumberFormat("%r-[]0.4n");
        this.tblMain.getColumn("assurePercent").getStyleAttributes().setNumberFormat("%r-[]0.2n");
        super.onLoad();
        this.btnAttachment.setEnabled(true);
        this.MenuItemAttachment.setEnabled(true);
        this.actionWorkFlowG.setVisible(true);
        this.btnCancel.setIsControlByParent(true);
        this.btnTDPrint.setEnabled(true);
        this.btnTDPrintPreview.setEnabled(true);
        this.menuItemTDPrint.setEnabled(true);
        this.menuItemTDPrintPreview.setEnabled(true);
        this.checkBizUnit();
        String dformat = CtrlFormatUtilities.getDateFormatString();
        this.tblMain.getColumn("begindate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("enddate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("cancelDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("repayDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("assureCloseDate").getStyleAttributes().setNumberFormat(dformat);
    }

    protected boolean isIgnoreBizUnit() {
        return false;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new AssureBillFilterUI();
        }
        return this.filterUI;
    }

    @Override
    protected String getEditUIName() {
        return AssureBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return AssureBillFactory.getRemoteInstance();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnViewUsed.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.btnCancel.setTextIconDisStyle((short)3);
        this.btnCancel.setText(this.resHelper.getString("btnCancel.text"));
        this.actionCancel.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_unreview"));
        this.actionUnCancel.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_review"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    protected boolean isFootVisible() {
        return true;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
            throw new FMException(FMException.UNIONCANNOTOPRT);
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.currentCompanyCommon.isIsBizUnit()) {
            throw new FMException(FMException.UNIONCANNOTOPRT);
        }
        AssureBillInfo info = this.getSelectedInfo();
        if (!AssureBillHelper.isCanEdit(info)) {
            throw new AssureBillException(AssureBillException.ALREADYCANCELNOEDIT);
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (!this.currentCompanyCommon.isIsBizUnit()) {
            throw new FMException(FMException.UNIONCANNOTOPRT);
        }
        AssureBillInfo bill = this.getSelectedInfo();
        if (bill.isCanceled()) {
            throw new AssureBillException(AssureBillException.ALREADYCANCELNOREMOVE);
        }
        if (!AssureBillHelper.isCanRemove(bill)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"61_AssureBillListUI"));
            SysUtil.abort();
        }
        if (bill.getUnionType().equals((Object)RelationWithAssuredUnitEnum.DEPART) && bill.getBizLocalBalance().signum() != 0) {
            throw new AssureBillException(AssureBillException.BIZBALANCEISZEROCANONLYOPRT);
        }
        super.actionRemove_actionPerformed(e);
        this.refresh(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        IAssureBill assureBill = (IAssureBill)this.getBizInterface();
        assureBill.batchSubmit(idSet);
        this.refreshList();
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"62_AssureBillListUI"));
    }

    @Override
    public void actionViewUsed_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
        this.getUIContext().put("IDList", null);
        map.putAll(this.getUIContext());
        map.put("ASSUREBILLIDMAP", this.getSelectedIdValues());
        IUIWindow window = uiFactory.create(AssureBillUsedListUI.class.getName(), map, null, OprtState.VIEW);
        window.show();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int ret = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.AssureBillResource", (String)"ConfirmCancel"));
        if (ret == 0) {
            AssureBillInfo info = this.getSelectedInfo();
            if (AssureBillHelper.isCanCancel(info)) {
                AssureBillFactory.getRemoteInstance().cancel(this.getSelectedKeyValue());
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.AssureBillResource", (String)"CancelOK"));
                this.showMessage();
                this.refresh(e);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"63_AssureBillListUI"));
            }
        }
    }

    @Override
    public void actionUnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int ret = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.AssureBillResource", (String)"ConfirmUnCancel"));
        if (ret == 0) {
            AssureBillInfo info = this.getSelectedInfo();
            if (AssureBillHelper.isCanAntiCancel(info)) {
                AssureBillFactory.getRemoteInstance().unCancel(this.getSelectedKeyValue());
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.AssureBillResource", (String)"unCancelOK"));
                this.showMessage();
                this.refresh(e);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"64_AssureBillListUI"));
            }
        }
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.ctl.app.AssureBillTDQuery");
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
        if (hasWf) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            ObjectUuidPK pk;
            IAssureBill assureBill = (IAssureBill)this.getBizInterface();
            AssureBillInfo info = assureBill.getAssureBillInfo((IObjectPK)(pk = new ObjectUuidPK(id)));
            if (AssureBillHelper.isCanAudit(info)) {
                assureBill.audit((IObjectPK)pk);
                this.refreshList();
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"65_AssureBillListUI"));
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"33_ReceiveLetterControllerBean"));
            }
        }
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiAudit_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
        if (hasWf) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            ObjectUuidPK pk;
            IAssureBill assureBill = (IAssureBill)this.getBizInterface();
            AssureBillInfo info = assureBill.getAssureBillInfo((IObjectPK)(pk = new ObjectUuidPK(id)));
            if (AssureBillHelper.isCanAntiAudit(info)) {
                if (AssureBillHelper.hasUsedAssureBill(info)) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"66_AssureBillListUI"));
                    SysUtil.abort();
                }
                if (this.isAssureBillReferenced(info)) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"66_AssureBillListUI"));
                    SysUtil.abort();
                }
                assureBill.antiAudit((IObjectPK)pk);
                this.refreshList();
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"67_AssureBillListUI"));
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"68_AssureBillListUI"));
            }
        }
    }

    private boolean isAssureBillReferenced(AssureBillInfo info) throws BTPException, BOSException {
        Set set = FMHelper.getDestBillIdSet(null, (String)info.getId().toString());
        return set.size() > 0;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.checkSelected();
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        boolean iscanceled = (Boolean)row.getCell("canceled").getValue();
        String state = row.getCell("state").getValue().toString();
        if (this.selectChange(rowNumber)) {
            this.actionCancel.setEnabled(!iscanceled);
            this.actionUnCancel.setEnabled(iscanceled);
            this.btnCancel.setEnabled(!iscanceled);
            this.btnUnCancel.setEnabled(iscanceled);
            this.actionUpdateCloseDate.setEnabled(!iscanceled);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String ctime = formatter.format(new Date());
            if (this.tblMain.getRow(rowNumber).getCell("assureCloseDate").getValue() != null && formatter.parse(this.tblMain.getRow(rowNumber).getCell("assureCloseDate").getValue().toString()).getTime() <= formatter.parse(ctime).getTime()) {
                this.btnUnCancel.setEnabled(false);
                this.btnCancel.setEnabled(false);
                this.actionCancel.setEnabled(false);
                this.actionUnCancel.setEnabled(false);
            }
            if (this.tblMain.getRow(rowNumber).getCell("begindate").getValue() == null && this.tblMain.getRow(rowNumber).getCell("enddate").getValue() == null) {
                this.btnSetClosed.setEnabled(false);
            }
        }
        if (row.getCell("enddate").getValue() == null) {
            this.actionUpdateCloseDate.setEnabled(false);
        }
        if (!IvtModualUtils.getSysParam(null, (String)"CTL001")) {
            this.actionEdit.setEnabled(!state.equals(AssureBillStateEnum.APPROVE.toString()));
        }
    }

    private AssureBillInfo getSelectedInfo() throws BOSException, EASBizException {
        this.checkSelected();
        ObjectUuidPK id = new ObjectUuidPK(this.getSelectedKeyValue());
        AssureBillInfo bill = AssureBillFactory.getRemoteInstance().getAssureBillInfo((IObjectPK)id);
        return bill;
    }

    protected void execQuery() {
        super.execQuery();
        this.formatFootRow();
        this.resIsClosed();
        this.resAssureEndTime();
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            AssureBillFilterParam param = (AssureBillFilterParam)((Object)this.getFilterUI().getParam());
            if (this.tblMain.getFootManager() == null) {
                return;
            }
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyId() == null ? company.getBaseCurrency().getId().toString() : param.getCurrencyId();
            String[] columns = new SumFiledsInfo(SumBillEnum.DanBao).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void actionUpdateCloseDate_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SetAssureExpiredDateUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.actionRefresh_actionPerformed(e);
    }

    public void resIsClosed() {
        ArrayList<Object> closedID = new ArrayList<Object>();
        boolean upClosed = false;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String ctime = formatter.format(new Date());
        try {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                Boolean isClosed;
                if (this.tblMain.getRow(i).getCell("assureCloseDate").getValue() == null || formatter.parse(this.tblMain.getRow(i).getCell("assureCloseDate").getValue().toString()).getTime() >= formatter.parse(ctime).getTime() || (isClosed = new Boolean(this.tblMain.getRow(i).getCell("canceled").getValue().toString())).booleanValue()) continue;
                this.tblMain.getRow(i).getCell("canceled").setValue((Object)new Boolean(true));
                closedID.add(this.tblMain.getRow(i).getCell("id").getValue());
                upClosed = true;
            }
            if (upClosed) {
                IAssureBill assure = AssureBillFactory.getRemoteInstance();
                assure.upIsClosed(closedID);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
        }
    }

    public boolean selectChange(int index) throws Exception {
        CompanyOrgUnitInfo companyif = SysContext.getSysContext().getCurrentFIUnit();
        ObjectUuidPK pk = new ObjectUuidPK(this.getSelectedKeyValue());
        IAssureBill assure = AssureBillFactory.getRemoteInstance();
        AssureBillInfo info = assure.getAssureBillInfo((IObjectPK)pk);
        boolean isAssured = true;
        if (!info.getTailorCompany().getId().equals((Object)companyif.getId())) {
            isAssured = false;
        }
        this.actionEdit.setEnabled(isAssured);
        this.btnEdit.setEnabled(isAssured);
        this.actionRemove.setEnabled(isAssured);
        this.btnRemove.setEnabled(isAssured);
        this.actionAuditResult.setEnabled(isAssured);
        this.btnAuditResult.setEnabled(isAssured);
        this.actionSubmit.setEnabled(isAssured);
        this.btnSubmit.setEnabled(isAssured);
        this.actionCancel.setEnabled(isAssured);
        this.btnCancel.setEnabled(isAssured);
        this.actionUnCancel.setEnabled(isAssured);
        this.btnUnCancel.setEnabled(isAssured);
        this.actionAudit.setEnabled(isAssured);
        this.btnAudit.setEnabled(isAssured);
        this.actionAntiAudit.setEnabled(isAssured);
        this.btnAntiAudit.setEnabled(isAssured);
        this.actionUpdateCloseDate.setEnabled(isAssured);
        this.btnSetClosed.setEnabled(isAssured);
        return isAssured;
    }

    public void resAssureEndTime() {
        ArrayList<Object> closedID = new ArrayList<Object>();
        boolean upClosed = false;
        try {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                if (this.tblMain.getRow(i).getCell("enddate").getValue() != null) continue;
                this.tblMain.getRow(i).getCell("assureCloseDate").setValue(null);
                closedID.add(this.tblMain.getRow(i).getCell("id").getValue());
                upClosed = true;
            }
            if (upClosed) {
                IAssureBill assure = AssureBillFactory.getRemoteInstance();
                assure.upAssureEndTime(closedID);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public String[] getMergeColumnKeys() {
        return new String[]{"id", "assureUnionType", "company.name", "number", "state", "bizDate", "unionType", "assuredCompany", "bank.name", "assureType.name", "currency.name", "contactAmount", "exRate", "contactLocalAmt", "assurePercent", "assureLimitAmt", "asLocalLimitAmt", "bizLocalBalance", "assureResAmount", "assureBeginDate", "assureEndDate", "assurefee", "assurecfgfee", "project.name", "begindate", "enddate", "horizons", "assureArticle", "antiAssAmount", "antiassurer", "antiAssValue", "canceled", "description", "tailorCompany", "creator", "currency.id", "deferDay", "assureCloseDate"};
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.CTL_MANAGE;
    }

    protected String getDateField() {
        return "beginDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSubmit", "actionEdit", "actionRemove", "actionAntiAudit"};
    }
}

