/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.DefaultOriginalCurrencyPrecProvider;
import com.kingdee.eas.fm.common.client.DefaultTablePrecisionFormat;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.ITablePrecisionProvider;
import com.kingdee.eas.fm.ctl.BankFactorException;
import com.kingdee.eas.fm.ctl.BankFactorFactory;
import com.kingdee.eas.fm.ctl.BankFactorHelper;
import com.kingdee.eas.fm.ctl.BankFactorInfo;
import com.kingdee.eas.fm.ctl.FactorStateEnum;
import com.kingdee.eas.fm.ctl.IBankFactor;
import com.kingdee.eas.fm.ctl.client.AbstractBankFactorListUI;
import com.kingdee.eas.fm.ctl.client.BankFactorFilterUI;
import com.kingdee.eas.fm.nt.AssureAmountInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class BankFactorListUI
extends AbstractBankFactorListUI {
    private BankFactorFilterUI filterUI;
    private static final String tdTemplateFile = "/FM/CTL/BANKFACTOR";

    public BankFactorListUI() throws Exception {
        DefaultTablePrecisionFormat precFmt = new DefaultTablePrecisionFormat();
        DefaultOriginalCurrencyPrecProvider origCurrPrecProvider = new DefaultOriginalCurrencyPrecProvider("currency.id");
        precFmt.setPrecProvider((ITablePrecisionProvider)origCurrPrecProvider);
        precFmt.initFormat(this.tblMain, new String[]{"amount", "loanAmount", "loanBalance"});
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnTDPrint.setEnabled(true);
        this.btnTDPrintPreview.setEnabled(true);
        this.setBizActionState(this.currentCompanyCommon.isIsBizUnit());
        this.tblMain.getColumn("issueDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("expireDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BankFactorFilterUI();
        }
        return this.filterUI;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected void execQuery() {
        if (this.currentCompanyCommon.isIsBizUnit()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("applicant.id", (Object)this.currentCompanyCommon.getId()));
            try {
                FilterInfo extFilter = this.getBillChangeToAssure();
                if (extFilter != null && extFilter.getFilterItems().size() > 0) {
                    filter.mergeFilter(extFilter, "AND");
                }
                this.mainQuery.getFilter().mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        super.execQuery();
    }

    private FilterInfo getBillChangeToAssure() {
        Map btpeditparameter;
        String targetBillType;
        FilterInfo filterInfo = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && (targetBillType = (String)(btpeditparameter = (Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType")) != null && "AssureAmount".equals(targetBillType)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
            filterInfo.getFilterItems().add(new FilterItemInfo("IsChangeToAssureAmount", (Object)Boolean.FALSE));
        }
        return filterInfo;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionRepeal.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_restore"));
        this.actionCancelRepeal.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_affirm"));
        this.actionRetrade.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unreview"));
        this.actionCancelRetrade.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_review"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionCreateTo.setVisible(false);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BankFactorFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        BankFactorInfo objectValue = new BankFactorInfo();
        return objectValue;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.currentCompanyCommon.isIsBizUnit()) {
            throw new FMException(FMException.UNIONCANNOTOPRT);
        }
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
        if (hasWf) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"95_GuaranteeApplyListUI"));
            this.abort();
        }
        IBankFactor bankFactor = (IBankFactor)this.getBizInterface();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BankFactorInfo info = bankFactor.getBankFactorInfo((IObjectPK)pk);
        if (BankFactorHelper.isCanEditFromParam()) {
            if (BankFactorHelper.isCanNotEditFromAudit(info)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"74_BankFactorEditUI"));
            } else {
                super.actionEdit_actionPerformed(e);
            }
        } else if (BankFactorHelper.isCanEdit(info)) {
            super.actionEdit_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"75_BankFactorEditUI"));
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        IBankFactor bankFactor = (IBankFactor)this.getBizInterface();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BankFactorInfo info = bankFactor.getBankFactorInfo((IObjectPK)pk);
        if (BankFactorHelper.isCanRemove(info)) {
            boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
            if (hasWf && !info.getState().equals((Object)FactorStateEnum.SAVE)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"97_GuaranteeApplyListUI"));
                this.abort();
            }
            super.actionRemove_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"9_BankFactorControllerBean"));
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        IBankFactor bankFactor = (IBankFactor)this.getBizInterface();
        bankFactor.batchSubmit(idSet);
        this.refreshList();
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"62_AssureBillListUI"));
    }

    @Override
    public void actionRepeal_actionPerformed(ActionEvent e) throws Exception {
        super.actionRepeal_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        IBankFactor bankFactor = (IBankFactor)this.getBizInterface();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BankFactorInfo info = bankFactor.getBankFactorInfo((IObjectPK)pk);
        if (!BankFactorHelper.isCanRepeal(info)) {
            throw new BankFactorException(BankFactorException.CAN_NOT_REPEAL);
        }
        bankFactor.repeal((IObjectPK)pk);
        this.refreshList();
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"84_BankFactorListUI"));
    }

    @Override
    public void actionCancelRepeal_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelRepeal_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        IBankFactor bankFactor = (IBankFactor)this.getBizInterface();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BankFactorInfo info = bankFactor.getBankFactorInfo((IObjectPK)pk);
        if (BankFactorHelper.isCanCancelRepeal(info)) {
            if (null != info.getLoanAmount() && null != info.getLoanBalance()) {
                if (info.getLoanAmount().compareTo(Constants.ZERO) > 0 && info.getLoanBalance().compareTo(Constants.ZERO) == 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"85_BankFactorListUI"));
                    SysUtil.abort();
                } else {
                    bankFactor.cancelRepeal((IObjectPK)pk);
                    this.refreshList();
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"86_BankFactorListUI"));
                    SysUtil.abort();
                }
            } else {
                bankFactor.cancelRepeal((IObjectPK)pk);
                this.refreshList();
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"86_BankFactorListUI"));
            }
        } else {
            throw new BankFactorException(BankFactorException.CAN_NOT_CANCEL_REPEAL);
        }
    }

    @Override
    public void actionRetrade_actionPerformed(ActionEvent e) throws Exception {
        super.actionRetrade_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        IBankFactor bankFactor = (IBankFactor)this.getBizInterface();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BankFactorInfo info = bankFactor.getBankFactorInfo((IObjectPK)pk);
        if (!BankFactorHelper.isCanRetrade(info)) {
            throw new BankFactorException(BankFactorException.CAN_NOT_RETRADE);
        }
        bankFactor.retrade((IObjectPK)pk);
        this.refreshList();
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"87_BankFactorListUI"));
    }

    @Override
    public void actionCancelRetrade_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelRetrade_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        IBankFactor bankFactor = (IBankFactor)this.getBizInterface();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BankFactorInfo info = bankFactor.getBankFactorInfo((IObjectPK)pk);
        if (!BankFactorHelper.isCanCancelRetrade(info)) {
            throw new BankFactorException(BankFactorException.CAN_NOT_CANCEL_RETRADE);
        }
        bankFactor.cancelRetrade((IObjectPK)pk);
        this.refreshList();
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"88_BankFactorListUI"));
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
        if (hasWf) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            ObjectUuidPK pk;
            IBankFactor bankFactor = (IBankFactor)this.getBizInterface();
            BankFactorInfo info = bankFactor.getBankFactorInfo((IObjectPK)(pk = new ObjectUuidPK(id)));
            if (BankFactorHelper.isCanAudit(info)) {
                bankFactor.audit((IObjectPK)pk);
                this.refreshList();
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"65_AssureBillListUI"));
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"89_BankFactorListUI"));
            }
        }
        this.refresh(e);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
        if (hasWf) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            ObjectUuidPK pk;
            IBankFactor bankFactor = (IBankFactor)this.getBizInterface();
            BankFactorInfo info = bankFactor.getBankFactorInfo((IObjectPK)(pk = new ObjectUuidPK(id)));
            if (BankFactorHelper.isCanAntiAudit(info)) {
                bankFactor.antiAudit((IObjectPK)pk);
                this.refreshList();
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"67_AssureBillListUI"));
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"154_BankFactorListUI"));
            }
        }
        this.refresh(e);
    }

    @Override
    public void actionChangeToAssureAmount_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String pk = this.getSelectedKeyValue();
        FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new BankFactorInfo().getBOSType().toString(), (String)new AssureAmountInfo().getBOSType().toString(), (String)pk, (String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        this.refresh(e);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.checkSelected();
        super.tblMain_tableSelectChanged(e);
        this.actionChangeToAssureAmount.setEnabled(false);
        this.btnChangeToAssureAmount.setEnabled(false);
        BankFactorInfo info = this.getSelectedBankFactorInfo();
        if (FactorStateEnum.SAVE.equals((Object)info.getState())) {
            this.btnAudit.setEnabled(false);
            this.actionAudit.setEnabled(false);
            this.btnSubmit.setEnabled(true);
            this.actionSubmit.setEnabled(true);
            this.actionAntiAudit.setEnabled(false);
        } else if (FactorStateEnum.SUBMIT.equals((Object)info.getState())) {
            this.btnAudit.setEnabled(true);
            this.actionAudit.setEnabled(true);
            this.btnSubmit.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionAntiAudit.setEnabled(false);
        } else if (FactorStateEnum.APPROVE.equals((Object)info.getState())) {
            this.btnAudit.setEnabled(false);
            this.actionAudit.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionAntiAudit.setEnabled(true);
        }
        if (info.getState() == FactorStateEnum.APPROVE && !info.isIsChangeToAssureAmount()) {
            this.actionChangeToAssureAmount.setEnabled(true);
            this.btnChangeToAssureAmount.setEnabled(true);
        }
        if (info.isFivouchered()) {
            this.actionVoucher.setEnabled(false);
            this.actionAntiAudit.setEnabled(false);
            this.actionPCVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(true);
        } else {
            this.actionVoucher.setEnabled(FactorStateEnum.APPROVE.equals((Object)info.getState()));
            this.actionPCVoucher.setEnabled(true);
            this.actionDelVoucher.setEnabled(false);
        }
    }

    protected boolean isIgnoreBizUnit() {
        return false;
    }

    private void setBizActionState(boolean state) {
        this.actionAddNew.setEnabled(state);
        this.actionEdit.setEnabled(state);
        this.actionRemove.setEnabled(state);
        this.actionRepeal.setEnabled(state);
        this.actionCancelRepeal.setEnabled(state);
        this.actionRetrade.setEnabled(state);
        this.actionCancelRetrade.setEnabled(state);
        this.actionAudit.setEnabled(state);
        this.actionAntiAudit.setEnabled(state);
        this.actionSubmit.setEnabled(state);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(true);
    }

    private void tdPrint(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPreview) {
            appHlp.printPreview(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.print(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    private BankFactorInfo getSelectedBankFactorInfo() throws Exception {
        return BankFactorFactory.getRemoteInstance().getBankFactorInfo((IObjectPK)new ObjectStringPK(this.getSelectedKeyValue()));
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.ctl.app.BankFactorTDQuery");
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.CTL_MANAGE;
    }

    protected String getDateField() {
        return "issueDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSubmit", "actionEdit", "actionRemove", "actionAntiAudit"};
    }
}

