/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.framework.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CurrentInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ctl.ReceiveLetterInfo;
import com.kingdee.eas.fm.ctl.ReceiveRepayFactory;
import com.kingdee.eas.fm.ctl.ReceiveRepayInfo;
import com.kingdee.eas.fm.ctl.ReceiveStateEnum;
import com.kingdee.eas.fm.ctl.client.AbstractReceiveRepayEditUI;
import com.kingdee.eas.fm.ctl.client.util.CtlClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.nt.client.CSF7Selector;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReceiveRepayEditUI
extends AbstractReceiveRepayEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceiveRepayEditUI.class);
    private IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.prmtBank.getValue() != null && this.prmtBank.getValue() instanceof BankInfo) {
            this.editData.setBank((BankInfo)this.prmtBank.getValue());
        }
        this.editData.setBankName(this.getStringName(this.prmtBank.getValue()));
        this.editData.setCustomerAcct(this.getCustomer(this.prmtCustomerAcct.getData()));
        this.editData.setSupplierAcct(this.getSupplier(this.prmtCustomerAcct.getData()));
        if (this.prmtCustomerAcct.getData() != null) {
            Object data = this.prmtCustomerAcct.getData();
            if (data instanceof CustomerInfo) {
                this.editData.setAcctName(((CustomerInfo)data).getName());
            } else if (data instanceof SupplierInfo) {
                this.editData.setAcctName(((SupplierInfo)data).getName());
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReceiveRepayFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        CtlClientHelper.initPrmtBankAcct((IUIObject)this, this.prmtBankRec, this.currentCompany, null, null);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        this.txtLoculCurExRate.setHorizontalAlignment(4);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmountLoculCur);
        this.menuItemCopyLine.setVisible(false);
        this.prmtBank.setEnabled(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.getUIContext().get("srcBillID") != null && this.getOprtState().equals("ADDNEW")) {
            String srcId = this.getUIContext().get("srcBillID").toString();
            try {
                ReceiveLetterInfo receiveLetter;
                Map receiveMap = ReceiveRepayFactory.getRemoteInstance().getReceiveMap(srcId);
                if (receiveMap != null && (receiveLetter = (ReceiveLetterInfo)receiveMap.get("ReceiveLetter")) != null) {
                    this.txtSrcBillNum.setText(receiveLetter.getNumber());
                    this.prmtCurrency.setValue((Object)receiveLetter.getCurrency());
                    this.txtLoculCurExRate.setValue((Object)receiveLetter.getLoculCurExRate());
                    BigDecimal bdAmount = this.txtAmount.getBigDecimalValue();
                    BigDecimal bdLocalExRate = this.txtLoculCurExRate.getBigDecimalValue();
                    if (bdAmount != null && bdLocalExRate != null) {
                        this.txtAmountLoculCur.setValue((Object)bdAmount.multiply(bdLocalExRate));
                    }
                    int prec = receiveLetter.getCurrency().getPrecision();
                    this.txtAmountLoculCur.setPrecision(prec);
                    this.txtAmount.setPrecision(prec);
                    this.prmtCreator.setValue((Object)this.userinfo);
                    this.prmtCompany.setValue((Object)this.currentCompany);
                    this.txtSuoIndex.setValue(receiveMap.get("SuoIndex"));
                    this.pkSuoDate.setValue((Object)new Date());
                    this.editData.setBizDate(new Date());
                    if (receiveLetter.getBankAcct() != null) {
                        this.prmtBank.setValue((Object)receiveLetter.getBankAcct());
                    } else if (receiveLetter.getBankName() != null) {
                        this.prmtBank.setValue((Object)receiveLetter.getBankName());
                    }
                }
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        if (this.editData.getCustomerAcct() != null) {
            this.prmtCustomerAcct.setData((Object)this.editData.getCustomerAcct());
        } else if (this.editData.getSupplierAcct() != null) {
            this.prmtCustomerAcct.setData((Object)this.editData.getSupplierAcct());
        }
        if (this.editData.getBank() != null) {
            this.prmtBank.setValue((Object)this.editData.getBank());
        } else if (this.editData.getBankName() != null) {
            this.prmtBank.setValue((Object)this.editData.getBankName());
        }
        if (this.editData.getComBankAcct() != null) {
            this.prmtBankAcct.setText(this.editData.getComBankAcct());
            this.prmtBankAcct.setData((Object)this.editData.getComBankAcct());
        }
    }

    protected IObjectValue createNewData() {
        ReceiveRepayInfo info = new ReceiveRepayInfo();
        info.setCompany(this.currentCompany);
        info.setCreator(this.userinfo);
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
        return info;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (!ReceiveStateEnum.APPROVE.equals((Object)this.editData.getState())) {
            this.editData.setState(ReceiveStateEnum.SUBMIT);
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtLoculCurExRate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkSuoDate);
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal bdAmount = this.txtAmount.getBigDecimalValue();
        BigDecimal bdLocalExRate = this.txtLoculCurExRate.getBigDecimalValue();
        if (bdAmount != null && bdLocalExRate != null) {
            this.txtAmountLoculCur.setValue((Object)bdAmount.multiply(bdLocalExRate));
        }
    }

    @Override
    protected void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        CurrencyInfo currency = (CurrencyInfo)this.prmtCurrency.getValue();
        if (currency != null) {
            this.txtAmount.setPrecision(currency.getPrecision());
            this.txtAmountLoculCur.setPrecision(currency.getPrecision());
            CompanyOrgUnitInfo currentFIUnit = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            try {
                ReceiveRepayInfo info = (ReceiveRepayInfo)this.getDataObject();
                if (info != null) {
                    FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtLoculCurExRate, (CompanyOrgUnitInfo)currentFIUnit, (CurrencyInfo)currency, (CurrencyInfo)currentFIUnit.getBaseCurrency(), (Date)info.getBizDate(), null);
                }
            }
            catch (EASBizException e1) {
                this.prmtCurrency.setValue(null);
                throw e1;
            }
            this.txtAmountLoculCur.setValue((Object)this.calcLocalAmount());
        }
    }

    private BigDecimal calcLocalAmount() {
        BigDecimal bdAmount = this.txtAmount.getBigDecimalValue();
        BigDecimal bdLocalExRate = this.txtLoculCurExRate.getBigDecimalValue();
        if (bdAmount != null && bdLocalExRate != null) {
            return bdAmount.multiply(bdLocalExRate);
        }
        return Constants.ZERO;
    }

    @Override
    protected void prmtCustomerAcct_willShow(SelectorEvent e) throws Exception {
        CSF7Selector selector = new CSF7Selector((IUIObject)this, this.prmtCustomerAcct, this.contextHelper.getCurrentCtrlUnit());
        this.prmtCustomerAcct.setSelector((KDPromptSelector)selector);
    }

    @Override
    protected void prmtAccount_willCommit(CommitEvent e) throws Exception {
        Object c = this.prmtCurrency.getValue();
        if (c instanceof CurrencyInfo) {
            CurrencyInfo currency = (CurrencyInfo)c;
            CtlClientHelper.initPrmtAcctView((IUIObject)this, this.prmtAccount, this.currentCompany, currency.getId().toString());
        }
    }

    @Override
    protected void prmtAccount_willShow(SelectorEvent e) throws Exception {
        Object c = this.prmtCurrency.getValue();
        if (c instanceof CurrencyInfo) {
            CurrencyInfo currency = (CurrencyInfo)c;
            CtlClientHelper.initPrmtAcctView((IUIObject)this, this.prmtAccount, this.currentCompany, currency.getId().toString());
        }
    }

    @Override
    protected void prmtBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        Object bankAcct = this.prmtBankAcct.getValue();
        if (bankAcct instanceof CustomerCompanyBankInfo) {
            CustomerCompanyBankInfo bankAcctInfo = (CustomerCompanyBankInfo)bankAcct;
            this.editData.setComBankAcct(bankAcctInfo.getBankAccount());
        } else if (bankAcct instanceof SupplierCompanyBankInfo) {
            SupplierCompanyBankInfo supplier = (SupplierCompanyBankInfo)bankAcct;
            this.editData.setComBankAcct(supplier.getBankAccount());
        } else if (bankAcct instanceof AccountBankInfo) {
            this.editData.setComBankAcct(((AccountBankInfo)bankAcct).getBankAccountNumber());
        } else if (bankAcct instanceof String) {
            this.editData.setComBankAcct(bankAcct.toString());
        }
    }

    @Override
    protected void prmtBankAcct_willShow(SelectorEvent e) throws Exception {
        super.prmtBankAcct_willShow(e);
        this.setPrmtBankAcct();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("ComBankAcct"));
        sic.add(new SelectorItemInfo("BankAcct.*"));
        sic.add(new SelectorItemInfo("bankName"));
        sic.add(new SelectorItemInfo("acctName"));
        sic.add(new SelectorItemInfo("SupplierAcct.*"));
        sic.add(new SelectorItemInfo("CustomerAcct.*"));
        return sic;
    }

    private void setCustomerF7(CoreUIObject ui, KDBizPromptBox bizPromptBox, String sCompanyId, String cuId, boolean isMultiSelect, int f7DisplayMode, String groupStandardId, boolean isQueryUI) throws BOSException, EASBizException {
        bizPromptBox.setCommitFormat("$number$;$mnemonicCode$");
        String queryInfo = "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery";
        FilterInfo filter = new FilterInfo();
        if (isQueryUI) {
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(0), CompareType.GREATER));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("CustomerCompanyInfo.usingStatus", (Object)new Integer(0)));
        }
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)sCompanyId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        bizPromptBox.setEntityViewInfo(evi);
        if (f7DisplayMode == 0) {
            SelectorListener[] selectorListener1 = this.removePrmtAllSelListener(bizPromptBox);
            GeneralKDPromptSelectorAdaptor selectorLisenterCustomer = null;
            selectorLisenterCustomer = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, F7CustomerTreeDetailListUI.class.getName(), (Object)ui, CSSPGroupInfo.getBosType(), queryInfo, "browseGroup.id", "companyOrgUnit.id");
            selectorLisenterCustomer.setQueryProperty("mnemonicCode", "or");
            this.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)selectorLisenterCustomer);
            selectorLisenterCustomer.setIsMultiSelect(isMultiSelect);
            selectorLisenterCustomer.setCUId(cuId);
            this.addPrmtAllSelListener(bizPromptBox, selectorListener1);
            bizPromptBox.addSelectorListener((SelectorListener)selectorLisenterCustomer);
        } else {
            bizPromptBox.setQueryInfo(queryInfo);
        }
    }

    private SelectorListener[] removePrmtAllSelListener(KDBizPromptBox prmtCtrl) {
        SelectorListener[] selListeners = prmtCtrl.getSelectorListeners();
        if (selListeners == null) {
            return selListeners;
        }
        for (int i = 0; i < selListeners.length; ++i) {
            prmtCtrl.removeSelectorListener(selListeners[i]);
        }
        return selListeners;
    }

    private void assignSelector(KDPromptBox promptBox, KDPromptSelector selector) {
        promptBox.setSelector(selector);
    }

    private void addPrmtAllSelListener(KDBizPromptBox prmtCtrl, SelectorListener[] selListeners) {
        if (selListeners == null) {
            return;
        }
        for (int i = 0; i < selListeners.length; ++i) {
            prmtCtrl.addSelectorListener(selListeners[i]);
        }
    }

    protected boolean isNeedAddToolMenus() {
        return false;
    }

    @Override
    protected void txtLoculCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal loculCurExRate = this.txtLoculCurExRate.getBigDecimalValue();
        BigDecimal amount = this.txtAmount.getBigDecimalValue();
        if (loculCurExRate != null && amount != null) {
            this.txtAmountLoculCur.setValue((Object)amount.multiply(loculCurExRate));
        }
    }

    private void setPrmtBankAcct() throws EASBizException, BOSException {
        Object payee = this.prmtCustomerAcct.getValue();
        boolean isSupplier = false;
        boolean isCustomer = false;
        boolean isInnerSupplierOrCustomer = false;
        SupplierInfo supplier = null;
        CustomerInfo customer = null;
        if (payee instanceof SupplierInfo) {
            isSupplier = true;
            supplier = (SupplierInfo)payee;
            if (supplier != null) {
                supplier = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(supplier.getId()));
                isInnerSupplierOrCustomer = supplier.isIsInternalCompany();
            }
        } else if (payee instanceof CustomerInfo) {
            isCustomer = true;
            customer = (CustomerInfo)payee;
            if (customer != null) {
                customer = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(customer.getId()));
                isInnerSupplierOrCustomer = customer.isIsInternalCompany();
            }
        }
        if (isSupplier && !isInnerSupplierOrCustomer) {
            this.initSupplierCompanyInfoBank((DataBaseInfo)supplier, this.prmtBankAcct);
        } else if (isCustomer && !isInnerSupplierOrCustomer) {
            this.initCustomerCompanyInfoBank((DataBaseInfo)customer, this.prmtBankAcct);
        } else {
            this.initPayeeAcctBankASAcctBank();
        }
    }

    private void initSupplierCompanyInfoBank(DataBaseInfo supply, KDBizPromptBox prmtBankAcct) {
        prmtBankAcct.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyInfoBankQuery");
        prmtBankAcct.setHasCUDefaultFilter(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (supply != null) {
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supply.getId()));
        }
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.currentCompany.getId()));
        view.setFilter(filter);
        prmtBankAcct.setEntityViewInfo(view);
        prmtBankAcct.setEditFormat("$bankAccount$");
        prmtBankAcct.setDisplayFormat("$bankAccount$");
        prmtBankAcct.setCommitFormat("$bankAccount$");
        prmtBankAcct.getQueryAgent().resetRuntimeEntityView();
    }

    private void initCustomerCompanyInfoBank(DataBaseInfo customer, KDBizPromptBox prmtBankAcct) {
        prmtBankAcct.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyInfoBankQuery");
        prmtBankAcct.setHasCUDefaultFilter(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (customer != null) {
            filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customer.getId()));
        }
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.currentCompany.getId()));
        view.setFilter(filter);
        prmtBankAcct.setEntityViewInfo(view);
        prmtBankAcct.setEditFormat("$bankAccount$");
        prmtBankAcct.setDisplayFormat("$bankAccount$");
        prmtBankAcct.setCommitFormat("$bankAccount$");
        prmtBankAcct.getQueryAgent().resetRuntimeEntityView();
    }

    private void initPayeeAcctBankASAcctBank() {
        Object customerAcct = this.prmtCustomerAcct.getData();
        AccountViewInfo oppAccount = null;
        if (this.prmtAccount.getValue() != null) {
            oppAccount = (AccountViewInfo)this.prmtAccount.getValue();
        }
        if (oppAccount == null) {
            this.initPayeeAccountBankEV(oppAccount, false, customerAcct);
        } else if (oppAccount.isIsBank()) {
            this.initPayeeAccountBankEV(oppAccount, true, customerAcct);
        } else {
            this.initPayeeAccountBankEV(oppAccount, false, customerAcct);
        }
        this.prmtBankAcct.setEditFormat("$bankAccountNumber$");
        this.prmtBankAcct.setDisplayFormat("$bankAccountNumber$");
        this.prmtBankAcct.setCommitFormat("$simpleCode$;$id$;$number$;$name$;$bankAccountNumber$");
        this.prmtBankAcct.getQueryAgent().resetRuntimeEntityView();
    }

    private void initPayeeAccountBankEV(AccountViewInfo oppAccount, boolean isBank, Object customerAcct) {
        FilterInfo filterName;
        CurrentInfo current;
        SupplierInfo spi;
        SelectorItemCollection spSelector;
        DataBaseInfo dbi;
        this.prmtBankAcct.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"0"));
        if (oppAccount != null && isBank) {
            filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)oppAccount.getId().toString()));
        }
        String realPayee = "";
        if (customerAcct instanceof SupplierInfo && !EmptyUtil.isEmpty((Object)customerAcct)) {
            block17: {
                if (customerAcct instanceof DataBaseInfo) {
                    dbi = (DataBaseInfo)customerAcct;
                    try {
                        spSelector = new SelectorItemCollection();
                        spSelector.add("internalCompany.name");
                        spi = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(dbi.getId()), spSelector);
                        realPayee = spi.getInternalCompany().getName();
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        if (customerAcct instanceof SupplierInfo) {
                            SupplierInfo supplierInfo = (SupplierInfo)customerAcct;
                            realPayee = supplierInfo.getName();
                        }
                        if (!(customerAcct instanceof CurrentInfo)) break block17;
                        current = (CurrentInfo)customerAcct;
                        realPayee = current.getName();
                    }
                }
            }
            if (realPayee != null) {
                filterName = new FilterInfo();
                filterName.getFilterItems().add(new FilterItemInfo("company.name", (Object)realPayee));
                filterName.getFilterItems().add(new FilterItemInfo("name", (Object)realPayee));
                filterName.getFilterItems().add(new FilterItemInfo("acctName", (Object)realPayee));
                filterName.setMaskString("#0 or #1 or #2");
                try {
                    filter.mergeFilter(filterName, "and");
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
        }
        if (customerAcct instanceof CustomerInfo && !EmptyUtil.isEmpty((Object)customerAcct)) {
            block18: {
                if (customerAcct instanceof DataBaseInfo) {
                    dbi = (DataBaseInfo)customerAcct;
                    try {
                        spSelector = new SelectorItemCollection();
                        spSelector.add("internalCompany.name");
                        spi = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(dbi.getId()), spSelector);
                        realPayee = spi.getInternalCompany().getName();
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        if (customerAcct instanceof CustomerInfo) {
                            CustomerInfo customerInfo = (CustomerInfo)customerAcct;
                            realPayee = customerInfo.getName();
                        }
                        if (!(customerAcct instanceof CurrentInfo)) break block18;
                        current = (CurrentInfo)customerAcct;
                        realPayee = current.getName();
                    }
                }
            }
            if (realPayee != null) {
                filterName = new FilterInfo();
                filterName.getFilterItems().add(new FilterItemInfo("company.name", (Object)realPayee));
                filterName.getFilterItems().add(new FilterItemInfo("name", (Object)realPayee));
                filterName.getFilterItems().add(new FilterItemInfo("acctName", (Object)realPayee));
                filterName.setMaskString("#0 or #1 or #2");
                try {
                    filter.mergeFilter(filterName, "and");
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtBankAcct.setEntityViewInfo(evi);
        this.prmtBankAcct.getQueryAgent().resetRuntimeEntityView();
    }

    private SupplierInfo getSupplier(Object obj) {
        if (obj instanceof SupplierInfo) {
            return (SupplierInfo)obj;
        }
        return null;
    }

    private CustomerInfo getCustomer(Object obj) {
        if (obj instanceof CustomerInfo) {
            return (CustomerInfo)obj;
        }
        return null;
    }

    private String getStringName(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.CTL_MANAGE;
    }

    protected String getDateField() {
        return "SuoDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit", "actionAntiAduit"};
    }
}

