/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.DefaultKDTCurrencyProvider;
import com.kingdee.eas.fm.common.client.DefaultKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IKDTPrecisionProvider;
import com.kingdee.eas.fm.common.client.IKDTablePrecisionFormater;
import com.kingdee.eas.fm.ctl.IReceiveRepay;
import com.kingdee.eas.fm.ctl.ReceiveRepayFactory;
import com.kingdee.eas.fm.ctl.ReceiveRepayInfo;
import com.kingdee.eas.fm.ctl.ReceiveStateEnum;
import com.kingdee.eas.fm.ctl.client.AbstractReceiveRepayListUI;
import com.kingdee.eas.fm.ctl.client.ReceiveRepayEditUI;
import com.kingdee.eas.fm.ctl.client.ReceiveRepayFilterParam;
import com.kingdee.eas.fm.ctl.client.ReceiveRepayFilterUI;
import com.kingdee.eas.fm.ctl.client.ReceiveRepayQueryProcessor;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ReceiveRepayListUI
extends AbstractReceiveRepayListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceiveRepayListUI.class);
    private IKDTablePrecisionFormater precFormater = new DefaultKDTablePrecisionFormater();
    private ReceiveRepayFilterUI filterUI = null;

    public ReceiveRepayListUI() throws Exception {
        this.precFormater.setPrecProvider((IKDTPrecisionProvider)new DefaultKDTCurrencyProvider(this.getCurrencyIdColName()));
    }

    public void onLoad() throws Exception {
        this.precFormater.init(this.getMainTable(), this.getPrecColName());
        super.onLoad();
        this.checkBizUnit();
        this.actionAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.tblMain.getColumn("SuoDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("ApprovalDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReceiveRepayFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return ReceiveRepayEditUI.class.getName();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ReceiveRepayFilterUI();
        }
        return this.filterUI;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAduit.setEnabled(true);
        this.actionAntiAduit.setEnabled(true);
        this.btnAuditResult.setVisible(false);
        this.actionAduit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAduit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
    }

    protected void execQuery() {
        super.execQuery();
        this.formatFootRow();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            ReceiveRepayFilterParam param = (ReceiveRepayFilterParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrency() == null ? company.getBaseCurrency().getId().toString() : param.getCurrency();
            String[] columns = new String[]{"Amount", "AmountLoculCur"};
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void actionAduit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IReceiveRepay repay = ReceiveRepayFactory.getRemoteInstance();
        ReceiveRepayInfo info = repay.getReceiveRepayInfo((IObjectPK)pk);
        if (info != null && ReceiveStateEnum.SUBMIT.equals((Object)info.getState())) {
            repay.andit((IObjectPK)pk);
            this.refresh(e);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"65_AssureBillListUI"));
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"33_ReceiveLetterControllerBean"));
        }
    }

    @Override
    public void actionAntiAduit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IReceiveRepay repay = ReceiveRepayFactory.getRemoteInstance();
        ReceiveRepayInfo info = repay.getReceiveRepayInfo((IObjectPK)pk);
        if (info != null && ReceiveStateEnum.APPROVE.equals((Object)info.getState())) {
            repay.antiAndit((IObjectPK)pk);
            this.refresh(e);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"67_AssureBillListUI"));
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"127_ReceiveRepayListUI"));
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        ReceiveRepayInfo info = ReceiveRepayFactory.getRemoteInstance().getReceiveRepayInfo((IObjectPK)pk);
        if (info != null && ReceiveStateEnum.SUBMIT.equals((Object)info.getState())) {
            super.actionRemove_actionPerformed(e);
            this.refresh(e);
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"128_ReceiveRepayListUI"));
        }
    }

    protected void checkBizUnit() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
            this.btnVoucher.setVisible(false);
            this.btnDelVoucher.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.menuItemAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.menuItemEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.menuItemRemove.setVisible(false);
            this.actionAduit.setEnabled(false);
            this.actionAntiAduit.setEnabled(false);
        }
    }

    protected String getCurrencyIdColName() {
        return "Currency.id";
    }

    protected String[] getPrecColName() {
        return new String[]{"Amount", "AmountLoculCur"};
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new ReceiveRepayQueryProcessor();
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.CTL_MANAGE;
    }

    protected String getDateField() {
        return "SuoDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionAntiAduit"};
    }
}

