/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ecore.ECoreException;
import com.kingdee.eas.fm.ecore.MQManageCollection;
import com.kingdee.eas.fm.ecore.MQManageFactory;
import com.kingdee.eas.fm.ecore.MQManageInfo;
import com.kingdee.eas.fm.ecore.MQQueueInfo;
import com.kingdee.eas.fm.ecore.MQQueueModelEnum;
import com.kingdee.eas.fm.ecore.MQQueueTypeEnum;
import com.kingdee.eas.fm.ecore.MessageReceiveQueueListenFacadeFactory;
import com.kingdee.eas.fm.ecore.client.AbstractMQManageMainUI;
import com.kingdee.eas.fm.ecore.client.CFCACertEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MQManageMainUI
extends AbstractMQManageMainUI {
    private static final long serialVersionUID = 4879318571978771037L;
    private static final Logger logger = CoreUIObject.getLogger(MQManageMainUI.class);
    public static final String srcPath = "com.kingdee.eas.fm.ecore.client.EcoreResource";

    @Override
    public void onLoad() throws Exception {
        this.init();
    }

    public void setUITitle(String title) {
        super.setUITitle(EASResource.getString((String)srcPath, (String)"MQManageUI"));
    }

    @Override
    protected void initWorkButton() {
        try {
            String ipAddress = InetAddress.getLocalHost().getHostAddress();
            Map client_Map = MessageReceiveQueueListenFacadeFactory.getRemoteInstance().getMessageQueue(ipAddress);
            this.commonOnBtn.setEnabled(!client_Map.containsKey("COMMON_SWITCH_NAME"));
            this.commonOffBtn.setEnabled(client_Map.containsKey("COMMON_SWITCH_NAME"));
            this.intimeOnBtn.setEnabled(!client_Map.containsKey("INTIME_SWITCH_NAME"));
            this.intimeOffBtn.setEnabled(client_Map.containsKey("INTIME_SWITCH_NAME"));
            this.edrafOnBtn.setEnabled(!client_Map.containsKey("EDRAF_SWITCH_NAME"));
            this.edrafOffBtn.setEnabled(client_Map.containsKey("EDRAF_SWITCH_NAME"));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.actionRefresh.setEnabled(true);
        this.actionSetCert.setEnabled(true);
        super.initWorkButton();
        this.actionSetCert.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sn"));
        this.kDTextField1.setEnabled(false);
        this.kDTextField2.setEnabled(false);
        this.kDTextField3.setEnabled(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.kdtQueue.getColumn("name").setRequired(true);
        this.kdtQueue.getColumn("state").getStyleAttributes().setLocked(true);
        this.kdtQueue.getColumn("mqtype").getStyleAttributes().setLocked(true);
        this.kdtQueue.getColumn("mqmodel").getStyleAttributes().setLocked(true);
        this.actionAttachment.setVisible(false);
        this.setQueueStatus();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        ArrayList<String> nameList = new ArrayList<String>();
        for (int i = 0; i < this.kdtQueue.getRowCount(); ++i) {
            String name = (String)this.kdtQueue.getRow(i).getCell("name").getValue();
            if (name == null) {
                throw new ECoreException(ECoreException.QUEUEISEMPTYERROR);
            }
            if (nameList.contains(name)) {
                throw new ECoreException(ECoreException.MQQUEUEISEXISTS);
            }
            nameList.add(name);
        }
        try {
            Long.valueOf(this.txtPort.getText());
            Long.valueOf(this.txtCcsid.getText());
            Long.valueOf(this.txtBankCode.getText());
            Long.valueOf(this.txtCCPC.getText());
            Long.valueOf(this.txtNPC.getText());
        }
        catch (Exception ex) {
            throw new ECoreException(ECoreException.MQISMUSTINT);
        }
    }

    protected IObjectValue createNewData() {
        MQManageCollection infoColl = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("queue.*"));
            view.getSelector().add(new SelectorItemInfo("serverIP"));
            view.getSelector().add(new SelectorItemInfo("port"));
            view.getSelector().add(new SelectorItemInfo("ccsid"));
            view.getSelector().add(new SelectorItemInfo("name"));
            view.getSelector().add(new SelectorItemInfo("bankCode"));
            view.getSelector().add(new SelectorItemInfo("CCPCCode"));
            view.getSelector().add(new SelectorItemInfo("NPC"));
            infoColl = MQManageFactory.getRemoteInstance().getMQManageCollection(view);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        MQManageInfo objectValue = null;
        if (infoColl != null && infoColl.size() > 0) {
            objectValue = infoColl.get(0);
        } else {
            objectValue = new MQManageInfo();
            objectValue.setCompany(this.currentCompany);
            objectValue.setNumber("TECoreMQNumber");
        }
        return objectValue;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        MQQueueInfo entryInfo = new MQQueueInfo();
        entryInfo.setCompany(this.currentCompany);
        entryInfo.setNumber("TECoreMQQueueNumber");
        String CommonQueue = "0";
        String SendQueue = "2";
        ArrayList<String> existList = new ArrayList<String>();
        for (int i = 0; i < this.kdtQueue.getRowCount(); ++i) {
            SendQueue = ((MQQueueTypeEnum)((Object)this.kdtQueue.getRow(i).getCell("mqtype").getValue())).equals((Object)MQQueueTypeEnum.sendQueue) ? "2" : "3";
            CommonQueue = ((MQQueueModelEnum)((Object)this.kdtQueue.getRow(i).getCell("mqmodel").getValue())).equals((Object)MQQueueModelEnum.normal) ? "0" : "1";
            existList.add(SendQueue + CommonQueue);
        }
        if (!existList.contains("20")) {
            entryInfo.setMqType(MQQueueTypeEnum.sendQueue);
            entryInfo.setMqModel(MQQueueModelEnum.normal);
        } else if (!existList.contains("21")) {
            entryInfo.setMqType(MQQueueTypeEnum.sendQueue);
            entryInfo.setMqModel(MQQueueModelEnum.realTime);
        } else if (!existList.contains("30")) {
            entryInfo.setMqType(MQQueueTypeEnum.recQueue);
            entryInfo.setMqModel(MQQueueModelEnum.normal);
        } else {
            entryInfo.setMqType(MQQueueTypeEnum.recQueue);
            entryInfo.setMqModel(MQQueueModelEnum.realTime);
        }
        return entryInfo;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtQueue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MQManageFactory.getRemoteInstance();
    }

    public void init() throws Exception {
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        Map map = MessageReceiveQueueListenFacadeFactory.getRemoteInstance().getSwitchTime();
        Date cdate = (Date)map.get("COMMON_SWITCH_TIME");
        Date idate = (Date)map.get("INTIME_SWITCH_TIME");
        Date edate = (Date)map.get("EDRAF_SWITCH_TIME");
        if (cdate == null || idate == null || edate == null) {
            cdate = new Date();
            idate = new Date();
            edate = new Date();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String strCdate = format.format(cdate);
        String strIdate = format.format(idate);
        String strEdate = format.format(edate);
        this.kDTextField1.setText(strCdate);
        this.kDTextField2.setText(strIdate);
        this.kDTextField3.setText(strEdate);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtQueue.getRowCount() < 4) {
            super.actionAddLine_actionPerformed(e);
        } else {
            this.setMessageText(EASResource.getString((String)srcPath, (String)"QueueSizeIsMax"));
            this.showMessage();
        }
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    @Override
    public void actionSetCert_actionPerformed(ActionEvent e) throws Exception {
        if (FMHelper.isEmpty((Object)this.editData.getId())) {
            throw new ECoreException(ECoreException.REQUIREDMQDATA);
        }
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CFCACertEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.init();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.init();
    }

    private void setQueueStatus() {
        Map inLink = new HashMap();
        ArrayList<String> queueList = new ArrayList<String>();
        for (int i = 0; i < this.kdtQueue.getRowCount(); ++i) {
            String queue = (String)this.kdtQueue.getRow(i).getCell(1).getValue();
            if (FMHelper.isEmpty((String)queue)) continue;
            queueList.add(queue);
        }
        try {
            inLink = MQManageFactory.getRemoteInstance().checkQueueStatus(queueList);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        for (Map.Entry pairs : inLink.entrySet()) {
            if (pairs.getValue().toString().equals("true")) {
                this.kdtQueue.getRow(Integer.parseInt(pairs.getKey().toString())).getCell("state").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"410_MQManageMainUI"));
                continue;
            }
            this.kdtQueue.getRow(Integer.parseInt(pairs.getKey().toString())).getCell("state").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"411_MQManageMainUI"));
        }
    }

    @Override
    public void actionCommonOff_actionPerformed(ActionEvent e) throws Exception {
        MessageReceiveQueueListenFacadeFactory.getRemoteInstance().offCommonMessageFromQueue();
        super.actionCommonOff_actionPerformed(e);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"412_MQManageMainUI"));
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionCommonOn_actionPerformed(ActionEvent e) throws Exception {
        MessageReceiveQueueListenFacadeFactory.getRemoteInstance().onCommonMessageFromQueue();
        super.actionCommonOn_actionPerformed(e);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"413_MQManageMainUI"));
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionEdrafOff_actionPerformed(ActionEvent e) throws Exception {
        MessageReceiveQueueListenFacadeFactory.getRemoteInstance().offBusinessNotification();
        super.actionEdrafOff_actionPerformed(e);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"414_MQManageMainUI"));
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionEdrafOn_actionPerformed(ActionEvent e) throws Exception {
        MessageReceiveQueueListenFacadeFactory.getRemoteInstance().onBusinessNotification();
        super.actionEdrafOn_actionPerformed(e);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"415_MQManageMainUI"));
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionIntimeOff_actionPerformed(ActionEvent e) throws Exception {
        MessageReceiveQueueListenFacadeFactory.getRemoteInstance().offInTimeMessageFormQueue();
        super.actionIntimeOff_actionPerformed(e);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"416_MQManageMainUI"));
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionIntimeOn_actionPerformed(ActionEvent e) throws Exception {
        MessageReceiveQueueListenFacadeFactory.getRemoteInstance().onInTimeMessageFormQueue();
        super.actionIntimeOn_actionPerformed(e);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"417_MQManageMainUI"));
        this.actionRefresh_actionPerformed(e);
    }
}

