/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.ent.client.AbstractDiscountBill4ElecListUI;
import com.kingdee.eas.fm.ent.client.DiscountBill4ElecEditUI;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.DiscountBillCollection;
import com.kingdee.eas.fm.nt.DiscountBillFactory;
import com.kingdee.eas.fm.nt.DiscountBillInfo;
import com.kingdee.eas.fm.nt.DiscountBillStateEnum;
import com.kingdee.eas.fm.nt.IDiscountBill;
import com.kingdee.eas.fm.nt.client.DiscountBillFilterUI;
import com.kingdee.eas.fm.nt.client.util.FMToolTipUtil;
import com.kingdee.eas.fm.nt.vo.FMToolTipInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class DiscountBill4ElecListUI
extends AbstractDiscountBill4ElecListUI {
    private static final long serialVersionUID = -2860536986521767365L;
    private static final Logger logger = CoreUIObject.getLogger(DiscountBill4ElecListUI.class);
    public static final String ENT_RES = "com.kingdee.eas.fm.ent.EntResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionConfirm.setVisible(false);
        this.actionCancelConfirm.setVisible(false);
        this.actionCommitToBe.setVisible(true);
        this.actionSynStatus.setVisible(true);
        this.actionSynForceStatus.setVisible(false);
        this.actionNoteCancle.setVisible(true);
        this.actionEditStatus.setVisible(true);
        this.actionDiscountTrial.setEnabled(false);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new DiscountBillFilterUI(BillSourceEnum.BYECDS);
        }
        return this.filterUI;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("DiscountDate"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("billAmount"));
        sic.add(new SelectorItemInfo("buyerPayInt"));
        sic.add(new SelectorItemInfo("DiscountRate"));
        sic.add(new SelectorItemInfo("DiscountInt"));
        sic.add(new SelectorItemInfo("actRecvAmount"));
        sic.add(new SelectorItemInfo("DiscountBank.name"));
        sic.add(new SelectorItemInfo("recvAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("recvAccountView.displayName"));
        sic.add(new SelectorItemInfo("recvBank.name"));
        sic.add(new SelectorItemInfo("Digest"));
        sic.add(new SelectorItemInfo("maturityDate"));
        sic.add(new SelectorItemInfo("noteBillNumber"));
        sic.add(new SelectorItemInfo("deliver.name"));
        sic.add(new SelectorItemInfo("issureDate"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("actDiscountInt"));
        sic.add(new SelectorItemInfo("intRateTypeExp"));
        sic.add(new SelectorItemInfo("convertDays"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        sic.add(new SelectorItemInfo("innerAcct.acctNumber"));
        sic.add(new SelectorItemInfo("receivingBill.number"));
        sic.add(new SelectorItemInfo("debitDays"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("Accountant.name"));
        sic.add(new SelectorItemInfo("confirmDate"));
        sic.add(new SelectorItemInfo("confirmer.name"));
        sic.add(new SelectorItemInfo("type"));
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("bgOutItemName"));
        sic.add(new SelectorItemInfo("bgFeeItemName"));
        sic.add(new SelectorItemInfo("bgInItemName"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("costCenter.name"));
        sic.add(new SelectorItemInfo("billMedium"));
        sic.add(new SelectorItemInfo("isCommitToBe"));
        sic.add(new SelectorItemInfo("discountApplierAcctNum"));
        sic.add(new SelectorItemInfo("discountApplierBankNum"));
        sic.add(new SelectorItemInfo("pasterBankNum"));
        sic.add(new SelectorItemInfo("elecBillStatus"));
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        sic.add(new SelectorItemInfo("bankReturnMsg"));
        sic.add(new SelectorItemInfo("noteStatus"));
        sic.add(new SelectorItemInfo("cirStatus"));
        sic.add("*");
        sic.add("fpItem.*");
        sic.add("currency.*");
        sic.add("company.*");
        sic.add("DiscountBank.*");
        sic.add("billMedium");
        sic.add("pasterBankNum");
        sic.add("receivablebill.*");
        sic.add("entrys.*");
        sic.add("entrys.receivableBill.*");
        sic.add("entrys.receivableBill.currency.id");
        sic.add("entrys.receivableBill.nttype.name");
        return sic;
    }

    protected String getEditUIName() {
        return DiscountBill4ElecEditUI.class.getName();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        boolean isConfirmed = this.getRowsConfirmFlag(idList);
        if (isConfirmed) {
            this.actionDiscountTrial.setEnabled(false);
        } else {
            this.actionDiscountTrial.setEnabled(true);
        }
        this.actionConfirmTie.setVisible(false);
        this.actionAntiConfirmTie.setVisible(false);
    }

    public boolean getRowsConfirmFlag(List idList) {
        boolean isConfirmed = false;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getDiscountBillSelector());
        try {
            DiscountBillInfo info = null;
            DiscountBillCollection coll = ((IDiscountBill)this.getBizInterface()).getDiscountBillCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                if (DiscountBillStateEnum.CONFIRMSTATE != info.getBillState() && !info.isIsCommitToBe()) continue;
                isConfirmed = true;
                break;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isConfirmed;
    }

    public SelectorItemCollection getDiscountBillSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("billState"));
        selector.add(new SelectorItemInfo("isCommitToBe"));
        return selector;
    }

    @Override
    public void actionDiscountTrial_actionPerformed(ActionEvent e) throws Exception {
        super.actionDiscountTrial_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
        if (EBSstatus == 1) {
            boolean isSameDiscountBank = this.checkIsSameDiscountBank(idList);
            if (!isSameDiscountBank) {
                MsgBox.showWarning((String)EASResource.getString((String)ENT_RES, (String)"13_DiscountTrial_verify01"));
                return;
            }
            HashSet idSet = new HashSet(idList);
            Map result = DiscountBillFactory.getRemoteInstance().discountTrial(idSet);
            boolean successFlag = (Boolean)result.get("successflag");
            if (successFlag) {
                if (result.get("infoMsg") != null && result.get("detailMsg") != null) {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)result.get("infoMsg").toString(), (String)result.get("detailMsg").toString(), (int)1);
                    this.refresh(e);
                }
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)ENT_RES, (String)"14_DiscountTrial_fail"), (String)result.get("errorMsg").toString(), (int)0);
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"061_BE_SERVICE_FAILURE"));
            SysUtil.abort();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("isCommitToBe").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("isCommitCancel").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("isNoteCancel").getStyleAttributes().setHided(false);
        this.addCustomerToolTip();
    }

    protected void addCustomerToolTip() {
        FMToolTipUtil.setToolTipInfo((JComponent)this.btnCancelDiscount, (FMToolTipInfo)new FMToolTipInfo("btnCancelDiscount", EASResource.getString((String)"com.kingdee.eas.fm.nt.client.NtResource", (String)"DiscountBill4ElecListUI_btnCancelDiscount"), ""));
        FMToolTipUtil.setToolTipInfo((JComponent)this.btnNoteCancle, (FMToolTipInfo)new FMToolTipInfo("btnNoteCancle", EASResource.getString((String)"com.kingdee.eas.fm.nt.client.NtResource", (String)"DiscountBill4ElecListUI_btnNoteCancle"), ""));
    }

    public boolean checkIsSameDiscountBank(ArrayList<String> idList) {
        boolean isSameDiscountBank = true;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(idList), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getDiscountBankSelector());
        try {
            String disBankId = null;
            DiscountBillInfo info = null;
            DiscountBillCollection coll = ((IDiscountBill)this.getBizInterface()).getDiscountBillCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                if (disBankId == null) {
                    disBankId = info.getDiscountBank().getId().toString();
                    continue;
                }
                if (disBankId.equals(info.getDiscountBank().getId().toString())) continue;
                isSameDiscountBank = false;
                break;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isSameDiscountBank;
    }

    public SelectorItemCollection getDiscountBankSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("DiscountBank"));
        return selector;
    }

    public void setAuditVisible() {
        super.setAuditVisible();
        this.actionConfirmTie.setVisible(false);
        this.actionAntiConfirmTie.setVisible(false);
    }
}

