/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.WorkCalendarDayEntryCollection;
import com.kingdee.eas.basedata.assistant.WorkCalendarDayEntryFactory;
import com.kingdee.eas.basedata.assistant.WorkCalendarDayEntryInfo;
import com.kingdee.eas.basedata.assistant.WorkCalendarFactory;
import com.kingdee.eas.basedata.assistant.WorkCalendarInfo;
import com.kingdee.eas.basedata.assistant.WorkDateTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ent.client.AbstractDiscountBillBatch4ElecEditUI;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.DiscountBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;

public class DiscountBillBatch4ElecEditUI
extends AbstractDiscountBillBatch4ElecEditUI {
    private static final long serialVersionUID = 1519333963462661199L;
    private static final Logger logger = CoreUIObject.getLogger(DiscountBillBatch4ElecEditUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtPayRate.setRequired(true);
        this.txtPayRate.setHorizontalAlignment(4);
        this.txtPayRate.setMinimumValue((Comparable)Constants.ZERO);
        this.txtDiscountRate.setEditable(true);
        this.comboBillMedium.setSelectedItem((Object)BillMediumEnum.ELECTRONIC);
        Map uiContext = this.getUIContext();
        IObjectCollection coll = (IObjectCollection)uiContext.get("ReceivableColl");
        if (coll != null) {
            ReceivableBillCollection recColl = new ReceivableBillCollection();
            for (int i = 0; i < coll.size(); ++i) {
                recColl.add((ReceivableBillInfo)coll.getObject(i));
            }
            if (recColl.size() == 1) {
                ReceivableBillInfo receivableBillInfo = recColl.get(0);
                if (receivableBillInfo.isIsVendeePayInt()) {
                    this.cbIsVenderPay.setSelected(true);
                } else {
                    this.cbIsVenderPay.setSelected(false);
                }
            } else if (recColl.size() > 1) {
                HashSet<String> drawerNameSet = new HashSet<String>();
                for (int i = 0; i < recColl.size(); ++i) {
                    ReceivableBillInfo receivableBillInfo = recColl.get(i);
                    drawerNameSet.add(receivableBillInfo.getDrawerName());
                    if (!receivableBillInfo.isIsVendeePayInt()) break;
                }
                if (drawerNameSet.size() == recColl.size()) {
                    this.cbIsVenderPay.setSelected(true);
                } else {
                    this.cbIsVenderPay.setSelected(false);
                }
            }
        }
        this.vederPay();
    }

    private void vederPay() {
        if (this.cbIsVenderPay.isSelected()) {
            this.cbIsVenderPay.setSelected(true);
            this.txtPayRate.setValue((Object)Constants.ONE_HUNDRED);
            this.txtPayRate.setRequired(true);
            this.txtdrawerAccount.setRequired(true);
            this.txtdrawerAccount.setEnabled(true);
            this.txtdrawerName.setRequired(true);
            this.txtdrawerName.setEnabled(true);
            this.txtDiscountRate.setEnabled(false);
        } else {
            this.cbIsVenderPay.setSelected(false);
            this.txtPayRate.setValue((Object)Constants.ZERO);
            this.txtPayRate.setMaximumValue((Comparable)Constants.ONE_HUNDRED);
            this.txtdrawerAccount.setRequired(false);
            this.txtdrawerAccount.setEnabled(false);
            this.txtdrawerName.setRequired(false);
            this.txtdrawerName.setEnabled(false);
            this.txtDiscountRate.setEnabled(true);
        }
    }

    @Override
    protected void cbIsVenderPay_actionPerformed(ActionEvent e) throws Exception {
        this.vederPay();
    }

    public void storeFields(DiscountBillInfo info, IRow row) throws BOSException, EASBizException {
        super.storeFields(info, row);
        info.setPayRate(Integer.valueOf(this.txtPayRate.getValue().toString()).intValue());
        this.editData.setPayRate(Integer.valueOf(this.txtPayRate.getValue().toString()).intValue());
        info.setBuyerPayInt(this.cbIsVenderPay.isSelected());
        this.editData.setBuyerPayInt(this.cbIsVenderPay.isSelected());
        info.setDiscountInBank((BEBankInfo)this.prmtDiscountInBank.getData());
        info.setDrawerAccount(this.txtdrawerAccount.getText());
        info.setDrawerName(this.txtdrawerName.getText());
    }

    protected void pkDiscountDate_dataChanged(DataChangeEvent e) throws Exception {
        this.calcDiscountInt();
    }

    protected void txtDiscountRate_dataChanged(DataChangeEvent e) throws Exception {
        this.calcDiscountInt();
    }

    protected void txtConvertDays_dataChanged(DataChangeEvent e) throws Exception {
        this.calcDiscountInt();
    }

    protected void txtDebitDays_dataChanged(DataChangeEvent e) throws Exception {
        this.calcDiscountInt();
    }

    @Override
    protected void txtPayRate_dataChanged(DataChangeEvent e) throws Exception {
        this.calcDiscountInt();
    }

    private void calcDiscountInt() {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        BigDecimal intAmt = Constants.ZERO;
        BigDecimal actRecvAmount = Constants.ZERO;
        BigDecimal intLocAmt = Constants.ZERO;
        BigDecimal billLocAmt = Constants.ZERO;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            BigDecimal inTimeValue = (BigDecimal)row.getCell("billAmt").getValue();
            BigDecimal discountRate = this.txtDiscountRate.getBigDecimalValue();
            BigDecimal convertDays = FMHelper.getBigDecimal((Object)this.txtConvertDays.getBigIntegerValue());
            BigDecimal debitDays = FMHelper.getBigDecimal((Object)this.txtDebitDays.getBigIntegerValue());
            IntRateTypeExpressionEnum intRateTypeExp = (IntRateTypeExpressionEnum)this.comboIntRateTypeExp.getSelectedItem();
            Date matDate = (Date)row.getCell("expiredDate").getValue();
            Date discountDate = (Date)this.pkDiscountDate.getValue();
            if (inTimeValue == null || discountRate == null || matDate == null || discountDate == null || convertDays.intValue() == 0) continue;
            BigDecimal dividend = Constants.ONE;
            if (intRateTypeExp.equals((Object)IntRateTypeExpressionEnum.YEAR)) {
                dividend = convertDays.multiply(Constants.ONE_HUNDRED);
            } else if (intRateTypeExp.equals((Object)IntRateTypeExpressionEnum.MONTH)) {
                dividend = convertDays.multiply(Constants.ONE_THOUSAND);
            }
            long datediff = this.dateDiff(discountDate, matDate);
            BigDecimal payRate = FMHelper.getBigDecimal((Object)this.txtPayRate.getBigDecimalValue());
            BigDecimal dateDiff = new BigDecimal(datediff).abs().add(debitDays);
            BigDecimal discountInt = inTimeValue.multiply(discountRate.divide(Constants.ONE_HUNDRED)).multiply(dateDiff).multiply(Constants.ONE_HUNDRED.subtract(payRate).divide(Constants.ONE_HUNDRED)).divide(convertDays, 10, 4);
            row.getCell("DiscountInt").setValue((Object)discountInt);
            row.getCell("realDiscountInt").setValue((Object)discountInt);
            row.getCell("realDiscountLocInt").setValue((Object)discountInt.multiply(this.txtExRate.getBigDecimalValue()));
            row.getCell("actRecvAmount").setValue((Object)inTimeValue.subtract(discountInt));
            intAmt = intAmt.add((BigDecimal)row.getCell("DiscountInt").getValue());
            BigDecimal actRecvAmountDetail = (BigDecimal)row.getCell("actRecvAmount").getValue();
            actRecvAmount = actRecvAmount.add(actRecvAmountDetail);
            intLocAmt = intLocAmt.add((BigDecimal)row.getCell("realDiscountLocInt").getValue());
            billLocAmt = actRecvAmount.multiply(this.txtExRate.getBigDecimalValue());
            row.getCell("billLocAmt").setValue((Object)actRecvAmountDetail.multiply(this.txtExRate.getBigDecimalValue()));
        }
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell("DiscountInt").setValue((Object)intAmt);
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell("realDiscountInt").setValue((Object)intAmt);
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell("actRecvAmount").setValue((Object)actRecvAmount);
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell("realDiscountLocInt").setValue((Object)intLocAmt);
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell("billLocAmt").setValue((Object)billLocAmt);
    }

    public Map<String, Set<Date>> getWorkAndHolidays(String companyID) {
        HashSet<Date> holidays = new HashSet<Date>();
        HashSet<Date> workDays = new HashSet<Date>();
        HashMap<String, Set<Date>> daysMap = new HashMap<String, Set<Date>>();
        daysMap.put("workDays", workDays);
        daysMap.put("holidays", holidays);
        try {
            WorkCalendarDayEntryInfo wcei = null;
            WorkCalendarDayEntryCollection entryColl = null;
            WorkCalendarInfo wci = WorkCalendarFactory.getRemoteInstance().getWorkCalendarInfo("where orgUnit = '" + companyID + "'");
            if (wci != null && (entryColl = WorkCalendarDayEntryFactory.getRemoteInstance().getWorkCalendarDayEntryCollection(this.getWCEntryEntity(wci.getId().toString()))) != null) {
                for (int i = 0; i < entryColl.size(); ++i) {
                    wcei = entryColl.get(i);
                    if (wcei.getDateType() == WorkDateTypeEnum.WORKDAY) {
                        workDays.add(wcei.getWorkDate());
                        continue;
                    }
                    if (wcei.getDateType() != WorkDateTypeEnum.HOLIDAY) continue;
                    holidays.add(wcei.getWorkDate());
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return daysMap;
    }

    public EntityViewInfo getWCEntryEntity(String wcID) {
        EntityViewInfo entity = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("workDate"));
        selector.add(new SelectorItemInfo("dateType"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("workCanlendar", (Object)wcID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dateType", (Object)WorkDateTypeEnum.HALFWORKDAY, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dateType", (Object)WorkDateTypeEnum.RESTDAY, CompareType.NOTEQUALS));
        entity.setFilter(filter);
        return entity;
    }

    public long dateDiff(Date startDate, Date endDate) {
        String companyID = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        Map<String, Set<Date>> daysMap = this.getWorkAndHolidays(companyID);
        Set<Date> workDays = daysMap.get("workDays");
        Set<Date> holidays = daysMap.get("holidays");
        Calendar calStart = Calendar.getInstance();
        Calendar calEnd = Calendar.getInstance();
        calStart.setTime(startDate);
        calEnd.setTime(endDate);
        if (!calEnd.after(calStart)) {
            return 0L;
        }
        boolean flag = true;
        while (flag) {
            int week = calEnd.get(7);
            if (week == 7 || week == 1) {
                if (this.isWorkDay(calEnd.getTime(), workDays)) break;
                calEnd.add(5, 1);
                continue;
            }
            if (!this.isHoliday(calEnd.getTime(), holidays)) break;
            calEnd.add(5, 1);
        }
        long datediff = DateUtil.dateDiff((String)"d", (Date)startDate, (Date)calEnd.getTime());
        return datediff;
    }

    public boolean isWorkDay(Date date, Set<Date> workDays) {
        for (Date workDay : workDays) {
            if (!DateUtils.isSameDay((Date)workDay, (Date)date)) continue;
            return true;
        }
        return false;
    }

    public boolean isHoliday(Date date, Set<Date> holidays) {
        for (Date holiday : holidays) {
            if (!DateUtils.isSameDay((Date)holiday, (Date)date)) continue;
            return true;
        }
        return false;
    }
}

