/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataParameter;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.FMBatchProcessFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.edraf.AcceptanceRegisterBillFactory;
import com.kingdee.eas.fm.ent.client.AbstractPayableBillSummaryListUI;
import com.kingdee.eas.fm.ent.client.PayableBill4ElecEditUI;
import com.kingdee.eas.fm.ent.client.PayableBillSummaryFilterUI;
import com.kingdee.eas.fm.fee.BusinessFeeBatchHanlder;
import com.kingdee.eas.fm.fee.client.BusinessFeeHelper;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.nt.AssureAmountCollection;
import com.kingdee.eas.fm.nt.AssureAmountFactory;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillMakeTypeEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.CommitToBe;
import com.kingdee.eas.fm.nt.DiscountBillFactory;
import com.kingdee.eas.fm.nt.DiscountBillInfo;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.IAssureAmount;
import com.kingdee.eas.fm.nt.IPayableBill;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NtRpcCacheInfo;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.PayableBillStateEnum;
import com.kingdee.eas.fm.nt.PayableException;
import com.kingdee.eas.fm.nt.SpecialConstantForCMHI;
import com.kingdee.eas.fm.nt.client.AssureAmountEditUI;
import com.kingdee.eas.fm.nt.client.NtAbandonUI;
import com.kingdee.eas.fm.nt.client.PayableBillEditUI;
import com.kingdee.eas.fm.nt.client.PayableBillQueryProcessor;
import com.kingdee.eas.fm.nt.client.RepaymentBatEditUI;
import com.kingdee.eas.fm.nt.client.util.PayableBillPrintListener;
import com.kingdee.eas.fm.ntp.NTPException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class PayableBillSummaryListUI
extends AbstractPayableBillSummaryListUI {
    private static final String NT_AUTO_GENERATE_RESOURCE = "com.kingdee.eas.fm.nt.NTAutoGenerateResource";
    private static final String NTP_RESOURCE = "com.kingdee.eas.fm.ntp.NtpResource";
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    protected static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";
    protected PayableBillSummaryFilterUI filterUI = null;
    private BillSourceEnum billSource = BillSourceEnum.BYHAND;
    public static final String NT_RESOURCE = "com.kingdee.eas.fm.nt.NtResource";
    protected CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private boolean isFromPayment = false;
    private boolean isPrintOnce = false;
    private boolean isCanModifyDraftNumber;
    private boolean isCancelled;
    private int imAndExParam = 0;

    public PayableBillSummaryListUI() throws Exception {
        IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
        this.isPrintOnce = contextHelper.getBooleanParam("NT008", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId().toString()));
        this.isCanModifyDraftNumber = contextHelper.getBooleanParam("NT042", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId().toString()));
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        IContextHelper contextHelper1 = ContextHelperFactory.getRemoteInstance();
        this.isCanModifyDraftNumber = contextHelper1.getBooleanParam("NT042", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId().toString()));
        if (!FSClientHelper.isClearingHouseCompanyId((String)this.currentCompany.getId().toString())) {
            FMClientHelper.hideIfBizUnitCompany((KDTable)this.tblMain, (String)"company.name");
        }
        this.tblMain.getViewManager().freeze(-1, this.tblMain.getColumnIndex("Type.name") + 1);
        this.tblMain.getColumn("AssProp").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)4));
        this.tblMain.getColumn("company.name").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("isBitBack").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("abandonDate").getStyleAttributes().setHided(true);
        this.actionVoucher.setVisible(true);
        this.actionDelVoucher.setVisible(true);
        this.actionTDPrintPreview.setEnabled(true);
        this.actionViewBgBalance.setEnabled(true);
        this.actionSum.setEnabled(true);
        this.actionAppointAssure.setVisible(false);
        SpecialConstantForCMHI specialConstant = new SpecialConstantForCMHI();
        boolean flag = specialConstant.getFlag();
        if (flag) {
            this.menuItemImportData.setVisible(false);
            this.menuImport.setVisible(true);
            this.menuExport.setVisible(true);
        } else {
            this.menuItemImportData.setVisible(true);
            this.menuImport.setVisible(false);
            this.menuExport.setVisible(false);
        }
        FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String[])new String[]{"CommerDraftAcct", "CommerDraftAcctName", "payeeAccountName"}, (String)"@");
        this.onshows();
    }

    protected void execQuery() {
        if (this.getBOTPViewStatus() == 1) {
            FilterInfo filter = null;
            Map botpCtx = (Map)this.getUIContext().get("BTPEDITPARAMETER");
            if (botpCtx != null) {
                String targetBillType = (String)botpCtx.get("TargetBillType");
                if (targetBillType != null) {
                    if (targetBillType.equals("PaymentBill")) {
                        filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("rpBillId", null));
                        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
                    }
                    if (targetBillType.equals("BusinessFee")) {
                        filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(8), CompareType.NOTEQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
                    }
                    if (targetBillType.equals("AssureAmount")) {
                        filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(5)));
                        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
                    }
                }
                if ((targetBillType = (String)botpCtx.get("TargetBill")) != null && targetBillType.equals("Loan")) {
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(5)));
                    filter.getFilterItems().add(new FilterItemInfo("makeType", (Object)new Integer(0)));
                    filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
                }
            }
            if (filter != null) {
                try {
                    this.mainQuery.getFilter().mergeFilter(filter, "and");
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        }
        super.execQuery();
        this.onshows();
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        if (this.getUIContext().get("BTPEDITPARAMETER") == null) {
            for (int i = 0; i < this.getPrecColName().length; ++i) {
                this.tblMain.getFootRow(0).getCell(this.getPrecColName()[i]).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)2));
            }
        }
        return row;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        Map btp = (Map)this.getUIContext().get("BTPEDITPARAMETER");
        String companyid = null;
        if (btp != null) {
            companyid = (String)btp.get("CurrencyID");
        }
        if (companyid == null) {
            companyid = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
        if (btp != null && btp.get("fromRepayment") != null && btp.get("fromRepayment").toString().equals("fromRepayment")) {
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(5)));
            filter.getFilterItems().add(new FilterItemInfo("makeType", (Object)new Integer(2), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("ExpiredDate", (Object)new Date(), CompareType.LESS_EQUALS));
        }
        return filter;
    }

    protected boolean isInMsgCenter() {
        Boolean wf = (Boolean)this.getUIContext().get("IsBatchDispose");
        if (wf == null) {
            return false;
        }
        return wf;
    }

    @Override
    public void actionImportData2_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.nt.payableBill";
        param.alias = EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"310_PayableBillListUI");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        task.setParentComponent((Component)((Object)this));
        task.invoke(paramList, 0, false);
    }

    @Override
    protected String getEditUIName() {
        if (this.billSource.equals((Object)BillSourceEnum.BYHAND)) {
            return PayableBillEditUI.class.getName();
        }
        return PayableBill4ElecEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PayableBillFactory.getRemoteInstance();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectUuidPK id = new ObjectUuidPK(this.getSelectedKeyValue());
        BusinessFeeHelper.checkHasFee((String)id.toString());
        PayableBillInfo bill = ((IPayableBill)this.getBizInterface()).getPayableBillInfo((IObjectPK)id);
        if (this.isFromPayment) {
            throw new PayableException(PayableException.NODEL4FROMPAYMENT);
        }
        if (!bill.isHistoryBill() && bill.getMakeType() == BillMakeTypeEnum.ENTRUST && bill.getConfirmer() != null && bill.getConfirmer() != null) {
            throw new PayableException(PayableException.NOTDEL4ENTRUST);
        }
        if (!bill.isHistoryBill() && bill.getMakeType() == BillMakeTypeEnum.SUB && bill.getConfirmer() != null) {
            throw new PayableException(PayableException.NOTDEL4SUB);
        }
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("SourceBillId", (Object)bill.getId().toString(), CompareType.EQUALS));
        env.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("1"));
        env.setSelector(sic);
        if (AcceptanceRegisterBillFactory.getRemoteInstance().getAcceptanceRegisterBillCollection(env).size() > 0) {
            throw new PayableException(PayableException.NOTACCEPTDELETE);
        }
        if ((bill.getElecBillStatus() != null || bill.getCommitToBe() != null) && bill.getElecBillStatus() != ElecBillStatusEnum.NT000002) {
            throw new NTPException(NTPException.CANNOT_REMOVE);
        }
        super.actionRemove_actionPerformed(e);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new PayableBillSummaryFilterUI();
        }
        return this.filterUI;
    }

    protected void checkBizUnit() throws EASBizException, BOSException {
        super.checkBizUnit();
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.currentCompany)) {
            this.btnCreateTo.setVisible(false);
            this.menuItemCreateTo.setVisible(false);
        } else {
            this.btnCreateTo.setVisible(true);
            this.menuItemCreateTo.setVisible(true);
        }
    }

    public String[] getMergeColumnKeys() {
        return new String[0];
    }

    protected String getCurrencyIdColName() {
        return "CurrencyId";
    }

    protected String[] getPrecColName() {
        return new String[]{"Amount", "Balance", "oriAssureAmount", "AssureAmount", "Discount", "UsedQuota"};
    }

    private void checkBillState() throws Exception {
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        PayableBillInfo info = PayableBillFactory.getRemoteInstance().getPayableBillInfo((IObjectPK)new ObjectUuidPK(keyValue));
        if (info.getBillState() == PayableBillStateEnum.CASH) {
            throw new PayableException(PayableException.HASCASH);
        }
        IAssureAmount assure = AssureAmountFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourcebillid", (Object)keyValue));
        view.setFilter(filter);
        AssureAmountCollection coll = AssureAmountFactory.getRemoteInstance().getAssureAmountCollection(view);
        if (coll.size() != 0 && (coll.size() != 1 || coll.get(0).getSeq() != 0L)) {
            MsgBox.showWarning((String)EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"311_PayableBillListUI"));
            SysUtil.abort();
        }
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Institution.*"));
        sic.add(new SelectorItemInfo("ApplyUnit.*"));
        sic.add(new SelectorItemInfo("OutBankAccount.*"));
        sic.add(new SelectorItemInfo("billMaker.*"));
        sic.add(new SelectorItemInfo("sourceCompany.*"));
        sic.add(new SelectorItemInfo("payee.*"));
        sic.add(new SelectorItemInfo("InstitutionCompany.*"));
        sic.add(new SelectorItemInfo("Currency.*"));
        return sic;
    }

    protected boolean isFootVisible() {
        return this.getUIContext().get("BTPEDITPARAMETER") == null;
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        if (this.isInMsgCenter()) {
            try {
                while (rowSet.next()) {
                    rowSet.updateString("fpItem.name", "");
                    rowSet.updateString("billAccount.name", "");
                    rowSet.updateString("oppAccount.name", "");
                }
                rowSet.beforeFirst();
            }
            catch (SQLException e) {
                this.handUIException(e);
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCreateTo.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_associatecreate"));
        this.btnCopyTo.setText("");
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionCancelAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionViewFee.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_diathesisaccord"));
        this.actionGenFee.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_readin"));
        this.menuWorkFlow.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        this.menuWorkFlow.setVisible(true);
        this.btnWorkFlowG.setVisible(true);
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionGenFee.setEnabled(true);
        this.actionViewFee.setEnabled(true);
        this.actionAppointAssure.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_choosein"));
        this.actionCancelAppointAssure.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_chooseout"));
        this.actionAddAssure.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_adduction"));
        this.actionBatchTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_analyze"));
        this.actionBatchTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_bluepencil"));
        this.actionBatchConfirm.setVisible(false);
        this.actionUpdateBill.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.actionAddBatch.setVisible(false);
        this.actionCopy.setVisible(false);
        this.buttonCommitToBe.setVisible(false);
        this.actionIssueRegister.setVisible(false);
        this.actionPromptAccept.setVisible(false);
        this.actionPromptRecBill.setVisible(false);
        this.actionNoteCancle.setVisible(false);
        this.actionCancelIssue.setVisible(false);
        this.actionSynStatus.setVisible(false);
        this.actionSynForceStatus.setVisible(false);
        this.actionEditStatus.setVisible(false);
        this.actionInTransfer.setVisible(false);
        this.actionOutTransfer.setVisible(false);
        this.actionConfirmNoWF.setVisible(false);
        this.actionCancelConfirm.setVisible(false);
        this.confirm.setVisible(false);
        this.actionApply.setVisible(false);
        this.actionAccept.setVisible(false);
        this.actionTranLoan.setVisible(false);
        this.actionDiscount.setVisible(false);
        this.actionCancelDiscount.setVisible(false);
        this.actionatchEdit.setVisible(false);
        this.actionBatchEdit.setVisible(false);
        this.actionPredownload.setVisible(false);
        this.actionBitBack.setVisible(false);
        this.actionReturnBill.setVisible(false);
        this.actionCancelTranLoan.setVisible(false);
        this.actionCancelReturnBil.setVisible(false);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String ids = (String)idList.get(0);
        BusinessFeeHelper.checkHasFee((String)ids);
        PayableBillInfo sourceBill = ((IPayableBill)this.getBizInterface()).getPayableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids)));
        IObjectPK pks = LogUtil.beginLog(null, null, (BOSObjectType)new PayableBillInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(sourceBill.getId()), (String)sourceBill.getNumber(), (String)"fin_PayableBill_edit");
        this.checkBillState();
        if ((sourceBill.getElecBillStatus() != null || sourceBill.getCommitToBe() != null) && (sourceBill.getCommitToBe() != CommitToBe.ISSUE_REGISTER || sourceBill.getBankReturnStatus() != BankReturnStatusEnum.COMMIT_FAIL && sourceBill.getBankReturnStatus() != BankReturnStatusEnum.BANK_FAIL)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"008_PayableBillListUI"));
            SysUtil.abort();
        }
        this.billSource = sourceBill.getDraftSource();
        super.actionEdit_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pks);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String ids = (String)idList.get(0);
        BusinessFeeHelper.checkHasFee((String)ids);
        PayableBillInfo sourceBill = ((IPayableBill)this.getBizInterface()).getPayableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids)));
        this.billSource = sourceBill.getDraftSource();
        super.actionView_actionPerformed(e);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"idList", (Object)this.getSelectedIdValues());
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int result;
        this.checkSelected();
        boolean isCreatePayment = false;
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> numbers = new ArrayList<String>();
        Map map = new HashMap();
        BizEnumValueDTO status = null;
        boolean isCreatedPayment = true;
        boolean isCreateFromPaymentBill = false;
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            status = (BizEnumValueDTO)row.getCell("BillState").getValue();
            if (status.getInt() == 4) {
                ids.add(row.getCell("id").getValue().toString());
                numbers.add(row.getCell("number").getValue().toString());
            }
            if (row.getCell("sourcebillid").getValue() != null && FMHelper.isInstanceof((String)row.getCell("sourcebillid").getValue().toString(), PaymentBillInfo.class)) {
                isCreateFromPaymentBill = true;
            }
            if (row.getCell("rpbillid").getValue() != null) continue;
            isCreatedPayment = false;
        }
        boolean isNTAssociaWithRP = NTHelper.getParam4Boolean(null, (String)"NT014", (boolean)false);
        if (!isCreateFromPaymentBill && !isCreatedPayment && isNTAssociaWithRP && MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)NT_RESOURCE, (String)"isGenPaymentBill")) == 0) {
            isCreatePayment = true;
        }
        IPayableBill iPayableBill = PayableBillFactory.getRemoteInstance();
        if (ids.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"419_PayableBillListUI"));
            SysUtil.abort();
        } else if (ids.size() == 1) {
            iPayableBill.submitBatch(ids, isCreatePayment);
            FMClientHelper.showSuccessMessageBox((CoreUI)this, (ActionEvent)e);
        } else if (ids.size() == indexs.length) {
            map = iPayableBill.submitBatch(ids, isCreatePayment);
            this.showMessage(map, numbers);
        } else if (ids.size() < indexs.length && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"420_PayableBillListUI"))) == 0) {
            map = iPayableBill.submitBatch(ids, isCreatePayment);
            this.showMessage(map, numbers);
        }
        this.refreshList();
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("rpbillid");
                PayableBillInfo rInfo = PayableBillFactory.getRemoteInstance().getPayableBillInfo((IObjectPK)new ObjectUuidPK(idList.get(i).toString()), sic);
                if (rInfo.getRpBillId() == null) continue;
                throw new NTException(NTException.CANNOT_OPERATION);
            }
        }
        String ids = (String)idList.get(0);
        PayableBillInfo sourceBill = ((IPayableBill)this.getBizInterface()).getPayableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids)));
        IObjectPK pks = LogUtil.beginLog(null, null, (BOSObjectType)new PayableBillInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(sourceBill.getId()), (String)sourceBill.getNumber(), (String)"fin_PayableBill_Voucher");
        this.checkSelected();
        ObjectUuidPK id = new ObjectUuidPK(this.getSelectedKeyValue());
        PayableBillInfo bill = ((IPayableBill)this.getBizInterface()).getPayableBillInfo((IObjectPK)id);
        if (bill.getMakeType() == BillMakeTypeEnum.SUB && bill.getConfirmer() == null && !bill.isIsFromEntrust()) {
            throw new PayableException(PayableException.NOVOUCHER4NOCONFIRM);
        }
        super.actionVoucher_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pks);
        this.refreshList();
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String ids = (String)idList.get(0);
        PayableBillInfo sourceBill = ((IPayableBill)this.getBizInterface()).getPayableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids)));
        IObjectPK pks = LogUtil.beginLog(null, null, (BOSObjectType)new PayableBillInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(sourceBill.getId()), (String)sourceBill.getNumber(), (String)"fin_PayableBill_DelVoucher");
        super.actionDelVoucher_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pks);
        this.refreshList();
    }

    private void showMessage(Map map, List list) {
        String msg1 = EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"421_PayableBillListUI");
        msg1 = MessageFormat.format(msg1, list.size(), (String)map.get("batch"), ((BigDecimal)map.get("totals")).toString());
        String msg2 = EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"424_PayableBillListUI");
        msg2 = MessageFormat.format(msg2, list.toString());
        MsgBox.showDetailAndOK((Component)((Object)this), (String)msg1, (String)msg2, (int)1);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        BOSObjectType bosType;
        IRow selectRow;
        ICell cell;
        super.tblMain_tableSelectChanged(e);
        ArrayList idList = this.getSelectedIdValues();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (idList.size() == 0) {
            return;
        }
        IContextHelper iContextHelper = ContextHelperFactory.getRemoteInstance();
        boolean isNotSamePerson = iContextHelper.getBooleanParam("NT032", (IObjectPK)new ObjectUuidPK(this.companyInfo.getId()));
        this.menuItemBatchTDPrint.setEnabled(false);
        this.menuItemBatchTDPrintPrview.setEnabled(false);
        this.btnBatchNoTDPrint.setEnabled(false);
        this.btnBatchNoTDPrintPreview.setEnabled(false);
        if (idList.size() == 1 && (cell = (selectRow = this.tblMain.getRow(selectRows[0])).getCell("batchNo")).getValue() != null) {
            this.menuItemBatchTDPrint.setEnabled(true);
            this.menuItemBatchTDPrintPrview.setEnabled(true);
            this.btnBatchNoTDPrint.setEnabled(true);
            this.btnBatchNoTDPrintPreview.setEnabled(true);
        }
        if (isNotSamePerson) {
            BOTRelationCollection BOTRelation = this.getBOTPCollection(selectRows);
            for (int i = 0; i < selectRows.length; ++i) {
                if (!this.tblMain.getRow(selectRows[i]).getCell("BillState").getValue().toString().equals(PayableBillStateEnum.Audit.toString()) || !this.tblMain.getRow(selectRows[i]).getCell("makeType").getValue().toString().equals(BillMakeTypeEnum.SELF.toString()) || BOTRelation.size() >= 1) {
                    this.btnBetchEdit.setEnabled(false);
                    break;
                }
                this.btnBetchEdit.setEnabled(true);
            }
        }
        String id = (String)idList.get(0);
        NtRpcCacheInfo paramInfo = new NtRpcCacheInfo();
        paramInfo.setId(id);
        paramInfo.setBatchImplClassName("com.kingdee.eas.fm.nt.app.NTBatchFetcher");
        NtRpcCacheInfo rpcCacheInfo = (NtRpcCacheInfo)FMBatchProcessFacadeFactory.getRemoteInstance().batchFetchData((FmRpcCacheInfo)paramInfo);
        PayableBillInfo sourceBill = (PayableBillInfo)rpcCacheInfo.getBillInfo();
        this.isCancelled = ElecBillStatusEnum.NT000002 == sourceBill.getElecBillStatus();
        this.isFromPayment = false;
        if (sourceBill.getSourceBillId() != null && (bosType = BOSUuid.read((String)sourceBill.getSourceBillId().toString()).getType()).equals((Object)new PaymentBillInfo().getBOSType())) {
            this.isFromPayment = true;
        }
        boolean isSubmited = sourceBill.getBillState() == PayableBillStateEnum.SUBMIT;
        boolean isTempSaved = sourceBill.getBillState() == PayableBillStateEnum.TempSaved;
        boolean isDiscount = sourceBill.getBillState() == PayableBillStateEnum.Discount;
        boolean inTransfer = sourceBill.getBillState() == PayableBillStateEnum.InTransfer;
        boolean outTransfer = sourceBill.getBillState() == PayableBillStateEnum.OutTransfer;
        boolean doNextTask = sourceBill.getBillState() == PayableBillStateEnum.Audit;
        doNextTask = doNextTask && !this.isCancelled;
        this.actionSubmit.setEnabled(isTempSaved);
        this.actionCreateTo.setEnabled(isSubmited);
        boolean isConfirmed = sourceBill.getConfirmer() != null;
        boolean isHistory = sourceBill.isHistoryBill();
        boolean isEntrust = sourceBill.getMakeType() == BillMakeTypeEnum.ENTRUST;
        boolean isTransfer = sourceBill.getBillState() == PayableBillStateEnum.InTransfer || sourceBill.getBillState() == PayableBillStateEnum.OutTransfer || sourceBill.getBillState() == PayableBillStateEnum.TranLoan;
        boolean isAbandoned = sourceBill.getBillState() == PayableBillStateEnum.AbandonByHand;
        boolean bCurCompany = this.currentCompany.getId().toString().equals(sourceBill.getCompany().getId().toString());
        this.actionAddAssure.setEnabled(sourceBill.getBalance().compareTo(Constants.ZERO) != 0 && (doNextTask || inTransfer || outTransfer));
        if (!isHistory) {
            this.actionRemove.setEnabled(bCurCompany && (isSubmited || isTempSaved) && !isConfirmed && !isTransfer);
            this.actionEdit.setEnabled(sourceBill.isCanEdit());
            this.actionVoucher.setEnabled(bCurCompany && !sourceBill.isFiVouchered() && !this.isFromPayment && (sourceBill.getBillState() == PayableBillStateEnum.InTransfer || sourceBill.getBillState() == PayableBillStateEnum.OutTransfer || sourceBill.getBillState() == PayableBillStateEnum.ABANDON || sourceBill.getBillState() == PayableBillStateEnum.CASH || doNextTask) && FMHelper.isEmpty((String)sourceBill.getRpBillId()));
            this.actionDelVoucher.setEnabled(bCurCompany && sourceBill.isFiVouchered() && !this.isFromPayment && !isAbandoned);
            this.actionCreateTo.setEnabled(bCurCompany && (doNextTask || isTransfer || isDiscount) && !isEntrust);
        } else {
            this.actionRemove.setEnabled(bCurCompany && (isSubmited || isTempSaved) && !isTransfer);
            this.actionEdit.setEnabled(sourceBill.isCanEdit());
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(false);
            this.actionCreateTo.setEnabled(bCurCompany && (doNextTask || isTransfer || isDiscount));
        }
        if (!(!this.isCanModifyDraftNumber && !isNotSamePerson || sourceBill.getBillState() != PayableBillStateEnum.Audit || sourceBill.getMakeType().equals((Object)BillMakeTypeEnum.SUB) && sourceBill.getApplyUnit().getId().toString().equals(this.companyInfo.getId().toString()) && sourceBill.getConfirmer() == null)) {
            this.actionEdit.setEnabled(true);
        }
        this.actionViewBgBalance.setEnabled(bCurCompany);
        this.actionTraceUp.setEnabled(bCurCompany);
        this.actionTraceDown.setEnabled(bCurCompany);
        this.actionAudit.setEnabled(bCurCompany && isSubmited);
        this.actionCancelAudit.setEnabled(bCurCompany && sourceBill.getBillState() == PayableBillStateEnum.Audit && sourceBill.getConfirmer() == null && (sourceBill.getCommitToBe() == null || CommitToBe.ISSUE_REGISTER == sourceBill.getCommitToBe() && (BankReturnStatusEnum.COMMIT_FAIL == sourceBill.getBankReturnStatus() || BankReturnStatusEnum.BANK_FAIL == sourceBill.getBankReturnStatus()) || sourceBill.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS && sourceBill.getElecBillStatus() != null && sourceBill.getElecBillStatus() == ElecBillStatusEnum.NT000002));
        if (isNotSamePerson) {
            // empty if block
        }
        this.actionAppointAssure.setEnabled(false);
        this.actionCancelAppointAssure.setEnabled(false);
        if (sourceBill.getOriAssureAmount().compareTo(BigDecimal.ZERO) != 1 && sourceBill.getBillState() == PayableBillStateEnum.Audit && idList.size() == 1 && sourceBill.getAssureAmount().equals(BigDecimal.ZERO)) {
            this.actionAppointAssure.setEnabled(true);
        }
        if (idList.size() == 1 && sourceBill.getBillState() == PayableBillStateEnum.Audit) {
            this.actionCancelAppointAssure.setEnabled(true);
        }
        boolean isSelf = sourceBill.getMakeType() == BillMakeTypeEnum.SELF;
        this.actionAbandon.setEnabled(bCurCompany && !sourceBill.isFiVouchered() && isSelf);
        this.actionCancelAbandon.setEnabled(isAbandoned);
        if (sourceBill.getDraftSource().equals((Object)BillSourceEnum.BYECDS) || sourceBill.getDraftSource().equals((Object)BillSourceEnum.BYNEW)) {
            if (sourceBill.getDraftNumber() != null && sourceBill.getBillState() == PayableBillStateEnum.Audit && sourceBill.getElecBillStatus() != null && sourceBill.getElecBillStatus() != ElecBillStatusEnum.NT000002) {
                this.actionCreateTo.setEnabled(true);
            } else {
                this.actionCreateTo.setEnabled(false);
            }
        }
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanRepay();
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 1) {
            String ids = (String)idList.get(0);
            PayableBillInfo sourceBill = ((IPayableBill)this.getBizInterface()).getPayableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids)));
            Date d = new Date();
            String id = this.getSelectedKeyValue();
            if (id != null) {
                if (sourceBill.getExpiredDate() != null && sourceBill.getExpiredDate().compareTo(d) > 0) {
                    if (MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"442_NotBillDueDate")) == 0) {
                        FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new PayableBillInfo().getBOSType().toString(), (String)RepaymentInfo.BOSTYPE.toString(), (String)id, (String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                    }
                } else {
                    FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new PayableBillInfo().getBOSType().toString(), (String)RepaymentInfo.BOSTYPE.toString(), (String)id, (String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                }
            }
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"PayableColl", (Object)this.getAccordPayableList4Repayment(idList));
            this.checkSelected4Repayment();
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RepaymentBatEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            this.refreshList();
        }
    }

    private void checkSelected4Repayment() throws NTException {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = this.tblMain.getRow(selectRows[i]);
            Date expiredDate = (Date)row.getCell("ExpiredDate").getValue();
            if (!new Date().before(expiredDate)) continue;
            throw new NTException(NTException.PAYABLECHECK);
        }
    }

    private IObjectCollection getAccordPayableList(List srcList) throws Exception {
        String currencyId = "";
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < srcList.size(); ++i) {
            String id = (String)srcList.get(i);
            set.add(id);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        SelectorItemCollection selector = this.getSelectors();
        view.getSelector().addObjectCollection((IObjectCollection)selector);
        view.setFilter(fi);
        PayableBillCollection colInfo = PayableBillFactory.getRemoteInstance().getPayableBillCollection(view);
        int i = 0;
        for (PayableBillInfo selInfo : colInfo) {
            if (i == 0) {
                currencyId = selInfo.getCurrency().getId().toString();
            }
            if (!currencyId.equals(selInfo.getCurrency().getId().toString())) {
                throw new NTException(NTException.CURRENCYNOTACCORD);
            }
            ++i;
        }
        return colInfo;
    }

    private IObjectCollection getAccordPayableList4Repayment(List srcList) throws Exception {
        String applyUnitId = "";
        PayableBillCollection colInfo = (PayableBillCollection)this.getAccordPayableList(srcList);
        int i = 0;
        for (PayableBillInfo selInfo : colInfo) {
            if (i == 0 && !EmptyUtil.isEmpty((CoreBaseInfo)selInfo.getApplyUnit())) {
                applyUnitId = selInfo.getApplyUnit().getId().toString();
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)selInfo.getApplyUnit()) || !EmptyUtil.isEmpty((CoreBaseInfo)selInfo.getApplyUnit()) && !EmptyUtil.isEmpty((String)applyUnitId) && !applyUnitId.equals(selInfo.getApplyUnit().getId().toString())) {
                throw new NTException(NTException.APPUNITNOTACCORD);
            }
            if (selInfo.getBillState() == PayableBillStateEnum.CASH) {
                throw new PayableException(PayableException.HASCASH);
            }
            if (selInfo.getConfirmer() == null && !selInfo.isIsFromEntrust() && selInfo.getMakeType() == BillMakeTypeEnum.SUB) {
                throw new PayableException(PayableException.NOTCASH4NOCONFIRM);
            }
            if (selInfo.getMakeType() == BillMakeTypeEnum.ENTRUST) {
                throw new PayableException(PayableException.NOTCASH4ENTRUST);
            }
            if (selInfo.getDraftSource() == BillSourceEnum.BYECDS && (selInfo.getDraftNumber() == null || selInfo.getBillState() != PayableBillStateEnum.Audit || selInfo.getElecBillStatus() == null || selInfo.getElecBillStatus() == ElecBillStatusEnum.NT000002)) {
                throw new PayableException(PayableException.EDCPAYABLENOTOCREATE);
            }
            ++i;
        }
        return colInfo;
    }

    private void checkCanRepay() throws Exception {
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        PayableBillInfo info = PayableBillFactory.getRemoteInstance().getPayableBillInfo((IObjectPK)new ObjectUuidPK(keyValue));
        if (info.getBillState() == PayableBillStateEnum.CASH) {
            throw new PayableException(PayableException.HASCASH);
        }
        if (info.getConfirmer() == null && info.getMakeType() == BillMakeTypeEnum.SUB && !info.isIsFromEntrust()) {
            throw new PayableException(PayableException.NOTCASH4NOCONFIRM);
        }
        if (info.getDraftSource() == BillSourceEnum.BYECDS && (info.getDraftNumber() == null || info.getBillState() != PayableBillStateEnum.Audit || info.getElecBillStatus() == null || info.getElecBillStatus() == ElecBillStatusEnum.NT000002)) {
            throw new PayableException(PayableException.EDCPAYABLENOTOCREATE);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.onshows();
        this.tblMain.getColumn("commitToBe").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("elecBillStatus").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("bankReturnStatus").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("bankReturnInfo").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("isPreBill").getStyleAttributes().setHided(false);
    }

    public void onshows() {
        this.tblMain.getColumn("draftNumber").getStyleAttributes().setHided(false);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("oriAssureAmount"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("oppAccount.id"));
        sic.add(new SelectorItemInfo("oppAccount.number"));
        sic.add(new SelectorItemInfo("oppAccount.name"));
        sic.add(new SelectorItemInfo("oppAccount.isBank"));
        sic.add(new SelectorItemInfo("oppAccount.isCash"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("Type.*"));
        sic.add(new SelectorItemInfo("Institution.id"));
        sic.add(new SelectorItemInfo("Institution.name"));
        sic.add(new SelectorItemInfo("Institution.number"));
        sic.add(new SelectorItemInfo("Institution.isBank"));
        sic.add(new SelectorItemInfo("ntType.id"));
        sic.add(new SelectorItemInfo("ntType.group"));
        sic.add(new SelectorItemInfo("ntType.isUsed"));
        sic.add(new SelectorItemInfo("ntType.isRecNote"));
        sic.add(new SelectorItemInfo("ntType.name"));
        sic.add(new SelectorItemInfo("ntType.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("person.CU"));
        sic.add(new SelectorItemInfo("CreditLimit.CreditUsage.*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("Institution.*"));
        sic.add(new SelectorItemInfo("Institution.accountBank.*"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        sic.add(new SelectorItemInfo("mbgNumber"));
        sic.add(new SelectorItemInfo("mbgName"));
        return sic;
    }

    private Set getBatchTDData() throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow selectRow = this.tblMain.getRow(selectRows[0]);
        if (selectRow.getCell("batchNo") == null || selectRow.getCell("batchNo").getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"312_PayableBillListUI"));
            SysUtil.abort();
        }
        Object batchNo = selectRow.getCell("batchNo").getValue();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("batchNo", (Object)batchNo.toString()));
        view.setFilter(filter);
        CoreBaseCollection vc = this.getBizInterface().getCollection(view);
        int vcSize = vc.size();
        HashSet<BOSUuid> idSet = new HashSet<BOSUuid>();
        for (int i = 0; i < vcSize; ++i) {
            idSet.add(((PayableBillInfo)vc.get(i)).getId());
        }
        return idSet;
    }

    public DefaultNoteDataProvider getDataProvider() throws Exception {
        final Set idSet = this.getBatchTDData();
        String mainDsName = "PayableBillBatchNoTDQuery";
        IMetaDataPK billPk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.nt.app.PayableBillBatchNoTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, billPk);
        dataProvider.addMetaDataPK(mainDsName, billPk);
        IMetaDataPK approvePk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.base.multiapprove.app.MultiApproveViewQuery");
        String approveDsName = "MultiApproveViewQuery";
        dataProvider.addMetaDataPK(approveDsName, approvePk);
        dataProvider.addForeignKey((Object)approveDsName, "billId");
        dataProvider.addCustomFilterMaker(approveDsName, new DefaultNoteDataProvider.ICustomFilterMaker(){

            public void customize(FilterInfo filter, R1PrintDataParameter[] params) {
                filter.getFilterItems().add(new FilterItemInfo("billId", (Object)((String)idSet.iterator().next())));
            }
        });
        dataProvider.setNumberOfEachBatch(100);
        return dataProvider;
    }

    @Override
    public void actionBatchTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDNoteHelper helper = new KDNoteHelper();
        helper.print(this.getTDFileName(), (Object)this.getDataProvider(), (Component)((Object)this));
    }

    @Override
    public void actionBatchTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDNoteHelper helper = new KDNoteHelper();
        helper.printPreview(this.getTDFileName(), (Object)this.getDataProvider(), (Component)((Object)this));
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        if (this.isPrintOnce) {
            this.checkCanTDPrint(idList);
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        PayableBillPrintListener listener = new PayableBillPrintListener();
        listener.setIdSet(new HashSet(idList));
        appHlp.addKDNoteActionListener((IPrintActionListener)listener);
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    private void checkCanTDPrint(ArrayList idList) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add("isTDPrinted");
        CoreBaseCollection coll = this.getBizInterface().getCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            boolean hasPrintNote = false;
            if (!coll.get(i).getBoolean("isTDPrinted")) continue;
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"hasPrintedPayableBill"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrintPreview_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        if (this.isPrintOnce) {
            this.checkCanTDPrint(idList);
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        PayableBillPrintListener listener = new PayableBillPrintListener();
        listener.setIdSet(new HashSet(idList));
        appHlp.addKDNoteActionListener((IPrintActionListener)listener);
        appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected String getTDFileName() {
        return "/FM/NT/Payablebill";
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.nt.app.PayableBillTDQuery");
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        PayableBillInfo info = ((IPayableBill)this.getBizInterface()).getPayableBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.nt.app.PayableBill", null, (IObjectValue)info);
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new PayableBillQueryProcessor((IUIObject)this);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        boolean hasWfInstance = FMHelper.hasWFInstance(null, (List)idList);
        if (hasWfInstance) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        ((IPayableBill)this.getBizInterface()).audit(new HashSet(idList));
        this.refreshList();
    }

    @Override
    public void actionCancelAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UserInfo currentUser = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        ObjectUuidPK userPK = null;
        if (currentUser != null) {
            userPK = new ObjectUuidPK(currentUser.getId());
        }
        ArrayList idList = this.getSelectedIdValues();
        Map map = ((IPayableBill)this.getBizInterface()).cancelAudit(new HashSet(idList), (IObjectPK)userPK);
        if (map.size() > 0) {
            ArrayList unValids = new ArrayList();
            ArrayList unValidsMessage = new ArrayList();
            for (Map.Entry entry : map.entrySet()) {
                unValids.add(entry.getKey());
                unValidsMessage.add(entry.getValue());
            }
            StringBuffer detail = new StringBuffer();
            detail.append(EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"577_BillNumber")).append("\t\t").append(EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"578_ErrorReason")).append("\n");
            int size = unValids.size();
            for (int i = 0; i < size; ++i) {
                detail.append(unValids.get(i)).append("\t").append(unValidsMessage.get(i)).append("\n");
            }
            String error = EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"579_BillCancelAuditFailure");
            error = MessageFormat.format(error, idList.size(), unValids.size());
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)detail.toString(), (int)1);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"580_BillCancelAuditSuccess"));
        }
        this.refreshList();
    }

    private String getDestObjectId(String srcObjId, String destType) throws Exception {
        ArrayList idList = BOTRelationFactory.getRemoteInstance().getDestObjIdByDestType(srcObjId, destType);
        if (idList != null && idList.size() > 0) {
            return (String)idList.get(0);
        }
        return null;
    }

    @Override
    public void actionAddAssure_actionPerformed(ActionEvent e) throws Exception {
        boolean doNextTask;
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        PayableBillInfo billInfo = ((IPayableBill)this.getBizInterface()).getPayableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), sic);
        if (billInfo == null) {
            return;
        }
        if (billInfo.getMakeType() == BillMakeTypeEnum.ENTRUST) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"CannotAddAssure"));
            SysUtil.abort();
        }
        boolean isSubmited = billInfo.getBillState() == PayableBillStateEnum.SUBMIT;
        boolean isAudited = billInfo.getBillState() == PayableBillStateEnum.Audit;
        boolean inTransfer = billInfo.getBillState() == PayableBillStateEnum.InTransfer;
        boolean outTransfer = billInfo.getBillState() == PayableBillStateEnum.OutTransfer;
        boolean isDiscount = billInfo.getBillState() == PayableBillStateEnum.Discount;
        boolean bl = doNextTask = isAudited || inTransfer || outTransfer || isDiscount;
        if (!doNextTask) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"validBill"));
            SysUtil.abort();
        }
        if (billInfo.getBalance().compareTo(Constants.ZERO) == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"balanceZero"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"payableBill", (Object)billInfo);
        uiContext.put((Object)"sourceBillType", (Object)"payableBill");
        uiContext.put((Object)"fmtype", (Object)"createTo");
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AssureAmountEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshList();
    }

    public BOTRelationCollection getBOTPCollection(int[] rows) throws BOSException {
        HashSet<Object> idSet = new HashSet<Object>();
        FilterInfo filter = new FilterInfo();
        for (int i = 0; i < rows.length; ++i) {
            idSet.add(this.tblMain.getRow(rows[i]).getCell("id").getValue());
        }
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("id");
        evi.setFilter(filter);
        IBOTRelation iBotRelation = BOTRelationFactory.getRemoteInstance();
        return iBotRelation.getCollection(evi);
    }

    @Override
    public void actionGenFee_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        PayableBillCollection coll = new PayableBillCollection();
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            BizEnumValueDTO state = (BizEnumValueDTO)row.getCell("BillState").getValue();
            if (state.getInt() == 8) {
                FMHelper.throwFMCommonException((String)EASResource.getString((String)"com.kingdee.eas.fm.fee.FeeResource", (String)"canNotChooseAbandonByHand"));
            }
            PayableBillInfo info = new PayableBillInfo();
            info.setId(BOSUuid.read((String)((String)row.getCell("id").getValue())));
            info.setAmount((BigDecimal)row.getCell("Amount").getValue());
            CurrencyInfo currInfo = new CurrencyInfo();
            currInfo.setId(BOSUuid.read((String)((String)row.getCell("CurrencyId").getValue())));
            info.setCurrency(currInfo);
            info.setNumber((String)row.getCell("number").getValue());
            info.setDraftNumber((String)row.getCell("draftNumber").getValue());
            coll.add(info);
        }
        BusinessFeeBatchHanlder.genBatchFee((IObjectCollection)coll, (BOSObjectType)new PayableBillInfo().getBOSType(), (Object)((Object)this), (String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
    }

    @Override
    public void actionAbandon_actionPerformed(ActionEvent e) throws Exception {
        Map retMap = null;
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        Date date = NtAbandonUI.showDialogWindow((IUIObject)this);
        if (date != null) {
            retMap = ((IPayableBill)this.getBizInterface()).batchAbandon(new HashSet(idList), date);
        }
        if (retMap != null && (Integer)retMap.get("ERROR_COUNT") == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"47_PayableBillSummaryListUI"));
        } else if (retMap != null && (Integer)retMap.get("ERROR_COUNT") > 0) {
            int successCount = (Integer)retMap.get("SUCCESS_COUNT");
            int errorCount = (Integer)retMap.get("ERROR_COUNT");
            String errMsg = ((StringBuffer)retMap.get("ERROR_MESSAGE")).toString();
            MsgBox.showDetailAndOK((Component)((Object)this), (String)(successCount + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"48_PayableBillSummaryListUI") + errorCount + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"49_PayableBillSummaryListUI")), (String)errMsg, (int)2);
        }
        this.refreshList();
    }

    @Override
    public void actionCancelAbandon_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        ((IPayableBill)this.getBizInterface()).cancelAbandon(new HashSet(idList));
        this.refreshList();
    }

    @Override
    public void actionViewFee_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            idSet.add((String)row.getCell("id").getValue());
        }
        BusinessFeeBatchHanlder.viewBatchFee((Object)((Object)this), idSet, (BOSObjectType)new PayableBillInfo().getBOSType());
    }

    protected String[] getQueryShowField() {
        return new String[]{"company.name", "AppCompany", "BillState", "makeType", "number", "draftNumber", "bizDate", "nttype", "Maker", "bank", "CommerDraftAcct", "CommerDraftAcctName", "Payee", "payeeBankName", "payeeAccountName", "IsInCredit", "UsedQuota", "Currency.name", "Amount", "AssProp", "oriAssureAmount", "AssureAmount", "Balance", "LocalCurExRate", "IssueDate", "acceptor", "acceptDate", "ExpiredDate", "Horizon", "transferDate", "GaranteeType.name", "Garantee", "BuyerPayDisCnt", "DiscountRate", "Discount", "IsHistory", "GaranteeType", "guaranteeTypeInputMode", "digest", "Remark", "audit", "accountant", "Confirmer", "bgItem", "billAccount", "oppAccount", "adminOrgUnit", "person", "isTDPrinted", "applyDate", "applyInfo", "isApply", "isAccept", "rpbillid", "isAcceptSubmit"};
    }

    @Override
    public void actionImportBOBData_actionPerformed(ActionEvent e) throws Exception {
        this.imAndExParam = 0;
        super.actionImportData_actionPerformed(e);
    }

    @Override
    public void actionImportCMBData_actionPerformed(ActionEvent e) throws Exception {
        this.imAndExParam = 1;
        super.actionImportData_actionPerformed(e);
    }

    @Override
    public void actionImportABCData_actionPerformed(ActionEvent e) throws Exception {
        this.imAndExParam = 2;
        super.actionImportData_actionPerformed(e);
    }

    @Override
    public void actionExportBOBData_actionPerformed(ActionEvent e) throws Exception {
        this.imAndExParam = 0;
        this.ExportData();
    }

    @Override
    public void actionExportCMBData_actionPerformed(ActionEvent e) throws Exception {
        this.imAndExParam = 1;
        this.ExportData();
    }

    @Override
    public void actionExportABCData_actionPerformed(ActionEvent e) throws Exception {
        this.imAndExParam = 2;
        this.ExportData();
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        switch (this.imAndExParam) {
            case 0: {
                param.solutionName = "eas.fm.nt.payableBillForBOB";
                break;
            }
            case 1: {
                param.solutionName = "eas.fm.nt.payableBillForCMB";
                break;
            }
            default: {
                param.solutionName = "eas.fm.nt.payableBillForABC";
            }
        }
        param.alias = EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"310_PayableBillListUI");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    private void ExportData() throws Exception {
        DatataskCaller task = new DatataskCaller();
        DatataskParameter param = new DatataskParameter();
        switch (this.imAndExParam) {
            case 0: {
                param.solutionName = "eas.fm.nt.payableBillForBOB";
                break;
            }
            case 1: {
                param.solutionName = "eas.fm.nt.payableBillForCMB";
                break;
            }
            default: {
                param.solutionName = "eas.fm.nt.payableBillForABC";
            }
        }
        param.alias = EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"310_PayableBillListUI");
        param.putContextParam((Object)"filter", (Object)this.getMainQuery().getFilter());
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        task.setParentComponent((Component)((Object)this));
        task.invoke(paramList, 1, false);
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "IssueDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionSubmit", "actionCancelAudit", "actionAudit"};
    }

    @Override
    public void actionCancelAppointAssure_actionPerformed(ActionEvent e) throws Exception {
        String keyValue = this.getSelectedKeyValue();
        PayableBillInfo info = PayableBillFactory.getRemoteInstance().getPayableBillInfo((IObjectPK)new ObjectUuidPK(keyValue));
        PayableBillFactory.getRemoteInstance().cancelAppointAssure(info);
        MsgBox.showWarning((String)EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"576_CancelAppoinAssure"));
        this.refreshList();
    }

    @Override
    public void actionSum_actionPerformed(ActionEvent e) throws Exception {
        super.actionSum_actionPerformed(e);
        String id = this.getSelectedKeyValue();
        if (id == null) {
            return;
        }
        String msg = this.sumList(this.tblMain);
        MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
    }

    public String sumList(KDTable tblMain) {
        String colAmt = "Amount";
        String colCautionAmt = "AssureAmount";
        String colBalanceAmt = "Balance";
        StringBuffer msg = new StringBuffer();
        int sumCount = KDTableHelper.getSelectedCountInColumn((KDTable)tblMain, (int)tblMain.getColumn("id").getColumnIndex());
        BigDecimal sumMoney = KDTableHelper.getSelectedSumInColumn((KDTable)tblMain, (int)tblMain.getColumn(colAmt).getColumnIndex());
        BigDecimal sumCautionMoney = KDTableHelper.getSelectedSumInColumn((KDTable)tblMain, (int)tblMain.getColumn(colCautionAmt).getColumnIndex());
        BigDecimal sumBalanceMoney = KDTableHelper.getSelectedSumInColumn((KDTable)tblMain, (int)tblMain.getColumn(colBalanceAmt).getColumnIndex());
        NumberFormat fm = NumberFormat.getInstance();
        msg.append(EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"payableBill_SumAmt")).append(fm.format(sumMoney)).append(",").append(EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"payableBill_SumCautionAmt")).append(fm.format(sumCautionMoney)).append(",").append(EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"payableBill_SumBalanceAmt")).append(fm.format(sumBalanceMoney)).append(",").append(EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"587_recordSum")).append(sumCount).append(EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"588_count"));
        return msg.toString();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(PayableBillSummaryListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            String currencyId = null;
            String exp = "year";
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                if (row.getCell("creditCurrencyId").getValue() != null) {
                    currencyId = row.getCell("creditCurrencyId").getValue().toString();
                    FMClientHelper.setNumberFormat((IRow)row, (String)"UsedQuota", (String)currencyId);
                } else if (row.getCell("CurrencyId").getValue() != null) {
                    currencyId = row.getCell("CurrencyId").getValue().toString();
                    FMClientHelper.setNumberFormat((IRow)row, (String)"UsedQuota", (String)currencyId);
                }
                row.getCell("DiscountRate").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
                if (!PayableBillStateEnum.Discount.toString().equals(row.getCell("BillState").getValue().toString()) || row.getCell("DiscountRate").getValue() == null || ((BigDecimal)row.getCell("DiscountRate").getValue()).compareTo(Constants.ZERO) <= 0 || !"month".equalsIgnoreCase(exp = this.getIntRateTypeExp(row.getCell("id").getValue()))) continue;
                row.getCell("DiscountRate").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
            }
        }

        private String getIntRateTypeExp(Object payableBillId) {
            String exp = "year";
            try {
                String oql = "select intRateTypeExp where payablebill = '" + payableBillId + "'";
                DiscountBillInfo disInfo = DiscountBillFactory.getRemoteInstance().getDiscountBillInfo(oql);
                if (disInfo.getIntRateTypeExp() != null) {
                    exp = disInfo.getIntRateTypeExp().getValue();
                }
            }
            catch (Exception e) {
                return exp;
            }
            return exp;
        }
    }
}

