/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.spi.SPInfo;
import com.kingdee.bos.spi.SPManager;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.dap.IDAPTransformerWrapper;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMBatchProcessFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.ent.client.AbstractReceivableBillSummaryListUI;
import com.kingdee.eas.fm.ent.client.ReceivableBillSummaryFilterUI;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.DiscountApplyBillFactory;
import com.kingdee.eas.fm.nt.DiscountApplyBillInfo;
import com.kingdee.eas.fm.nt.DiscountBillFactory;
import com.kingdee.eas.fm.nt.DiscountBillInfo;
import com.kingdee.eas.fm.nt.DiscountBillStateEnum;
import com.kingdee.eas.fm.nt.EndorseStateEnum;
import com.kingdee.eas.fm.nt.EndorsementBillFactory;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTFacadeFactory;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NtRpcCacheInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.EndorseListingUI;
import com.kingdee.eas.fm.nt.client.PayableBillQueryProcessor;
import com.kingdee.eas.fm.nt.client.ReceivableBillEditUI;
import com.kingdee.eas.fm.nt.client.ReceivableRecBatchUI;
import com.kingdee.eas.fm.ntp.BillTransactionLogCollection;
import com.kingdee.eas.fm.ntp.BillTransactionLogFactory;
import com.kingdee.eas.fm.ntp.client.ViewBillTransLogUI;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.mutex.DataObjectMutex;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ReceivableBillSummaryListUI
extends AbstractReceivableBillSummaryListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceivableBillSummaryListUI.class);
    private static final String NT_AUTO_GENERATE_RESOURCE = "com.kingdee.eas.fm.nt.NTAutoGenerateResource";
    public static final String OPER_COPY = "COPY";
    public static final String NTRESOURCE_PATH = "com.kingdee.eas.fm.nt.ReceivableBill";
    protected static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";
    protected ReceivableBillSummaryFilterUI filterUI;
    private CompanyOrgUnitInfo currentCompany;
    private boolean isFromReceiving = false;
    private boolean isNeedAudit;
    private boolean isFpItem;
    NtRpcCacheInfo ntRpcCacheInfo = null;

    protected CommonQueryProcessor getQueryProcessor() {
        return new PayableBillQueryProcessor((IUIObject)this);
    }

    private NtRpcCacheInfo getRpcCacheInfo(String id) throws Exception {
        NtRpcCacheInfo paramInfo = new NtRpcCacheInfo();
        paramInfo.setId(id);
        paramInfo.setBatchImplClassName("com.kingdee.eas.fm.nt.app.NTBatchFetcher");
        return (NtRpcCacheInfo)FMBatchProcessFacadeFactory.getRemoteInstance().batchFetchData((FmRpcCacheInfo)paramInfo);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        BOSObjectType bosType;
        boolean noTrustAndPledge;
        super.tblMain_tableSelectChanged(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 0 || idList == null) {
            return;
        }
        String id = (String)idList.get(0);
        this.ntRpcCacheInfo = this.getRpcCacheInfo(id);
        ReceivableBillInfo sourceBill = (ReceivableBillInfo)this.ntRpcCacheInfo.getBillInfo();
        this.isNeedAudit = this.ntRpcCacheInfo.isNeedAudit();
        boolean bl = noTrustAndPledge = !sourceBill.isIsTrustee() && (!sourceBill.isIsPledge() || sourceBill.isIsDisPledge()) && !sourceBill.isIsPoolTrustee() && !sourceBill.isIsPoolPledge();
        boolean bSaveOrAudit = this.isNeedAudit ? sourceBill.getBillState() == BillStateEnum.Audit : sourceBill.getBillState() == BillStateEnum.SAVED || sourceBill.getBillState() == BillStateEnum.Audit;
        boolean doNextTask = bSaveOrAudit && noTrustAndPledge;
        logger.error((Object)("doNextTask = " + doNextTask));
        if (!doNextTask) {
            logger.error((Object)"");
        }
        this.isFromReceiving = false;
        if (sourceBill.getSourceBillId() != null && (bosType = BOSUuid.read((String)sourceBill.getSourceBillId().toString()).getType()).equals((Object)new ReceivingBillInfo().getBOSType())) {
            this.isFromReceiving = true;
        }
        boolean bCurCompany = sourceBill.getCompany().getId().toString().equals(this.currentCompany.getId().toString());
        this.actionVoucher.setEnabled(!sourceBill.isIsHistory() && !sourceBill.isFivouchered() && bCurCompany && (sourceBill.getBillState() == BillStateEnum.INENDORSED || sourceBill.getBillState() == BillStateEnum.OUTENDORSED || sourceBill.getBillState() == BillStateEnum.DISCOUNTED || sourceBill.getBillState() == BillStateEnum.GATHERED || sourceBill.getBillState() == BillStateEnum.ABANDON || sourceBill.getBillState() == BillStateEnum.TranLend || bSaveOrAudit) && !this.isFromReceiving && FMHelper.isEmpty((String)sourceBill.getRpBillId()));
        this.actionDelVoucher.setEnabled(bCurCompany && sourceBill.isFivouchered());
        this.actionEdit.setEnabled(sourceBill.isCanEdit() && sourceBill.getEndorseBill() == null && sourceBill.getRpBillId() == null);
        logger.error((Object)"");
        this.actionGather.setEnabled(this.isNeedAudit ? sourceBill.getBillState() == BillStateEnum.Audit : (sourceBill.getBillState() == BillStateEnum.SAVED || sourceBill.getBillState() == BillStateEnum.Audit) && bCurCompany);
        this.actionGather.setEnabled(sourceBill.getDiscountApplyBill() == null);
        this.actionCancelGather.setEnabled(sourceBill.getBillState() == BillStateEnum.GATHERED && bCurCompany && !sourceBill.isIsWriteOff());
        this.actionViewBgBalance.setEnabled(bCurCompany);
        this.actionTraceUp.setEnabled(bCurCompany);
        this.actionTraceDown.setEnabled(bCurCompany);
        boolean isAudit = this.ntRpcCacheInfo.isIsAudit();
        EndorsementBillInfo endorseInfo = null;
        if (sourceBill.getEndorseBill() != null) {
            endorseInfo = EndorsementBillFactory.getRemoteInstance().getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(sourceBill.getEndorseBill().getId()));
        }
        if (isAudit && endorseInfo != null && endorseInfo.getState() != EndorseStateEnum.Audited) {
            this.actionCancelAudit.setEnabled(false);
        } else {
            this.actionCancelAudit.setEnabled(bCurCompany && sourceBill.getBillState() == BillStateEnum.Audit && this.isNeedAudit && noTrustAndPledge);
        }
        this.actionAudit.setEnabled(bCurCompany && sourceBill.getBillState() == BillStateEnum.SAVED && this.isNeedAudit && noTrustAndPledge);
        this.actionBook.setEnabled(bSaveOrAudit && bCurCompany && sourceBill.getCashier() == null && FMHelper.isEmpty((String)sourceBill.getRpBillId()) && noTrustAndPledge);
        this.actionCancelBook.setEnabled(bCurCompany && sourceBill.getCashier() != null && FMHelper.isEmpty((String)sourceBill.getRpBillId()));
        boolean isTempSaved = sourceBill.getBillState() == BillStateEnum.TempSaved;
        this.actionSubmit.setEnabled(isTempSaved);
        if (!(sourceBill.getBillState() != BillStateEnum.Audit && sourceBill.getBillState() != BillStateEnum.SAVED || sourceBill.get("endorseBill") == null || sourceBill.isIsNoteCancel())) {
            this.setButStateOfBillAudit(false);
        }
        if (this.ntRpcCacheInfo.isTxAudit()) {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("receivablebill", (Object)sourceBill.getId());
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            CoreBillBaseCollection discountBillCollection = new CoreBillBaseCollection();
            if (sourceBill.getDiscountBill() != null) {
                discountBillCollection = DiscountBillFactory.getRemoteInstance().getCoreBillBaseCollection(view);
            }
            DiscountApplyBillInfo disAppInfo = null;
            if (sourceBill.getDiscountApplyBill() != null) {
                disAppInfo = DiscountApplyBillFactory.getRemoteInstance().getDiscountApplyBillInfo((IObjectPK)new ObjectUuidPK(sourceBill.getDiscountApplyBill().getId()));
            }
            boolean isHasDiscountBill = false;
            boolean isHsDiscountApply = false;
            if (discountBillCollection.size() > 0) {
                isHasDiscountBill = true;
            }
            if (disAppInfo != null) {
                isHsDiscountApply = true;
            }
            if (isHasDiscountBill || isHsDiscountApply) {
                this.actionEdit.setEnabled(false);
                this.actionGather.setEnabled(false);
                this.actionCancelAudit.setEnabled(false);
            }
            if (discountBillCollection.size() > 0) {
                DiscountBillInfo discountBill = (DiscountBillInfo)discountBillCollection.get(0);
                this.actionCancelAudit.setEnabled(!DiscountBillStateEnum.NEWSTATE.equals((Object)discountBill.getBillState()));
            }
        }
        if (idList.size() == 1) {
            this.checkSingle(id);
        }
        if (sourceBill.isIsPoolTrustee()) {
            this.setButStateOfBillAudit(false);
            this.actionCancelAudit.setEnabled(false);
        }
        if (!(sourceBill.getBillState() != BillStateEnum.POOLPLEDGE && sourceBill.getBillState() != BillStateEnum.POOLTRUSTEE || sourceBill.getOutPledgeID() != null || sourceBill.getTrusteeOutBill() != null || sourceBill.getTrusteeToPledgeBill() != null || sourceBill.isIsPledgeToTrustee() || sourceBill.getDiscountApplyBill() != null)) {
            this.actionGather.setEnabled(true);
        }
        this.actionLock.setEnabled(true);
        this.actionUnLock.setEnabled(true);
    }

    protected void initDapButtons() throws Exception {
        if (this.getEntityBOSType() == null || this.getEntityBOSType().length() != 8) {
            this.separatorFW4.setVisible(false);
            this.actionVoucher.setVisible(false);
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setVisible(false);
            this.actionDelVoucher.setEnabled(false);
        } else {
            boolean isCanVoucher = false;
            if (SPManager.isSPInstalled((String)"DAPClientProvider")) {
                SPInfo spInfo = SPManager.getInstance().getSeviceProvider("DAPClientProvider");
                Class dapClass = spInfo.getProviderClass();
                IDAPTransformerWrapper wraper = (IDAPTransformerWrapper)dapClass.newInstance();
                isCanVoucher = wraper.isCanVoucher(this.getEntityBOSType()) && this.isVoucherVisible();
            }
            this.separatorFW4.setVisible(isCanVoucher);
            this.actionVoucher.setVisible(isCanVoucher);
            this.actionDelVoucher.setVisible(isCanVoucher);
        }
    }

    private void checkSingle(String id) throws Exception {
        this.ntRpcCacheInfo = this.getRpcCacheInfo(id);
        ReceivableBillInfo info = (ReceivableBillInfo)this.ntRpcCacheInfo.getBillInfo();
        this.isNeedAudit = ContextHelperFactory.getRemoteInstance().getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId().toString()));
        if (info.isIsPoolPledge()) {
            this.setButStateOfBillAudit(false);
            this.actionCancelAudit.setEnabled(false);
        }
    }

    private void setButStateOfBillAudit(boolean flag) {
        this.actionVoucher.setEnabled(flag);
        this.actionDelVoucher.setEnabled(flag);
        this.actionGather.setEnabled(flag);
        this.actionBook.setEnabled(flag);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("oppAccount.id"));
        sic.add(new SelectorItemInfo("oppAccount.number"));
        sic.add(new SelectorItemInfo("oppAccount.name"));
        sic.add(new SelectorItemInfo("oppAccount.isBank"));
        sic.add(new SelectorItemInfo("oppAccount.isCash"));
        sic.add(new SelectorItemInfo("billAccount.id"));
        sic.add(new SelectorItemInfo("billAccount.number"));
        sic.add(new SelectorItemInfo("billAccount.name"));
        sic.add(new SelectorItemInfo("billAccount.isBank"));
        sic.add(new SelectorItemInfo("billAccount.isCash"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("payeeaccount.id"));
        sic.add(new SelectorItemInfo("payeeaccount.name"));
        sic.add(new SelectorItemInfo("payeeaccount.number"));
        sic.add(new SelectorItemInfo("payeeaccount.cu"));
        sic.add(new SelectorItemInfo("payeeaccount.bank.id"));
        sic.add(new SelectorItemInfo("payeeaccount.account"));
        sic.add(new SelectorItemInfo("ntType.id"));
        sic.add(new SelectorItemInfo("ntType.group"));
        sic.add(new SelectorItemInfo("ntType.isUsed"));
        sic.add(new SelectorItemInfo("ntType.isRecNote"));
        sic.add(new SelectorItemInfo("ntType.name"));
        sic.add(new SelectorItemInfo("ntType.number"));
        sic.add(new SelectorItemInfo("wageId.*"));
        sic.add(new SelectorItemInfo("wageId.entrys.*"));
        sic.add(new SelectorItemInfo("cu"));
        sic.add("outBgItemId");
        sic.add("outBgItemNumber");
        sic.add("outBgItemName");
        sic.add("project.id");
        sic.add("project.name");
        sic.add("project.number");
        sic.add(new SelectorItemInfo("drawer.number"));
        sic.add(new SelectorItemInfo("deliver.number"));
        sic.add("fundFlowItem.*");
        sic.add("mbgNumber");
        sic.add("mbgName");
        sic.add(new SelectorItemInfo("billMedium"));
        sic.add(new SelectorItemInfo("acceptorName"));
        sic.add(new SelectorItemInfo("acceptorAccountName"));
        sic.add(new SelectorItemInfo("acceptorBank.id"));
        sic.add(new SelectorItemInfo("acceptorBank.name"));
        sic.add(new SelectorItemInfo("acceptorBank.number"));
        sic.add(new SelectorItemInfo("acceptanceBankName"));
        sic.add(new SelectorItemInfo("acceptorBankNum"));
        sic.add(new SelectorItemInfo("elecBillStatus"));
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        sic.add(new SelectorItemInfo("bankReturnMsg"));
        sic.add(new SelectorItemInfo("source"));
        sic.add(new SelectorItemInfo("isTransfer"));
        sic.add(new SelectorItemInfo("inPledgeID"));
        sic.add(new SelectorItemInfo("trusteeInBill.*"));
        sic.add(new SelectorItemInfo("receivingBillId"));
        sic.add(new SelectorItemInfo("discountBill.id"));
        sic.add(new SelectorItemInfo("trusteeOutBill.*"));
        sic.add(new SelectorItemInfo("discountApplyBill.*"));
        sic.add(new SelectorItemInfo("trusteeToPledgeBill.*"));
        sic.add(new SelectorItemInfo("isIsPledgeToTrustee"));
        sic.add(new SelectorItemInfo("pledgeToTrusteeBill.*"));
        sic.add(new SelectorItemInfo("outPledgeID"));
        sic.add(new SelectorItemInfo("endorseBill.id"));
        sic.add(new SelectorItemInfo("isLockByBill"));
        sic.add(new SelectorItemInfo("isLockByManual"));
        return sic;
    }

    @Override
    public void actionCancelGather_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        for (int i = 0; i < idList.size(); ++i) {
            String id = (String)idList.get(i);
            ReceivableBillInfo sourceBill1 = ((IReceivableBill)this.getBizInterface()).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            ReceivableBillFactory.getRemoteInstance().cancelGather(BOSUuid.read((String)id));
        }
        this.refreshList();
    }

    protected void execQuery() {
        FilterInfo extFilter = this.getBillCanbeReceived();
        if (extFilter != null && extFilter.getFilterItems().size() > 0) {
            try {
                this.mainQuery.getFilter().mergeFilter(extFilter, "AND");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e.getCause());
            }
        }
        super.execQuery();
        try {
            this.onShow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo f = new FilterInfo();
        IContextHelper ctxHelper = ContextHelperFactory.getRemoteInstance();
        boolean needAudit = ctxHelper.getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(ctxHelper.getCurrentCompany().getId()));
        if (needAudit) {
            f.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS));
            HashSet<Integer> statusSet = new HashSet<Integer>();
            statusSet.add(new Integer(0));
            statusSet.add(new Integer(1));
            statusSet.add(new Integer(9));
            f.getFilterItems().add(new FilterItemInfo("billState", statusSet, CompareType.NOTINCLUDE));
            f.getFilterItems().add(new FilterItemInfo("isPledge", (Object)new Integer(0)));
            f.getFilterItems().add(new FilterItemInfo("isTrustee", (Object)new Integer(0)));
        } else {
            f.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS));
            HashSet<Integer> statusSet = new HashSet<Integer>();
            statusSet.add(new Integer(0));
            statusSet.add(new Integer(9));
            f.getFilterItems().add(new FilterItemInfo("billState", statusSet, CompareType.NOTINCLUDE));
            f.getFilterItems().add(new FilterItemInfo("isPledge", (Object)new Integer(0)));
            f.getFilterItems().add(new FilterItemInfo("isTrustee", (Object)new Integer(0)));
        }
        return f;
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        if (row != null && this.getBOTPViewStatus() == 0) {
            for (int i = 0; i < this.getPrecColName().length; ++i) {
                String curID = this.currentCompany.getBaseCurrency().getId().toString();
                FMClientHelper.setNumberFormat((IRow)row, (String)this.getPrecColName()[i], (String)curID);
            }
            this.tblMain.getFootRow(0).getCell("discount").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)5));
        }
        return row;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected IObjectCollection getAccordReceivableList(List srcList) throws Exception {
        IObjectCollection coll = this.getBaseAccordReceivableList(srcList);
        for (ReceivableBillInfo selInfo : coll) {
            if (selInfo.isIsTrustee()) {
                throw new NTException(NTException.HAVETRUSTEE);
            }
            if (selInfo.isIsPledge() && !selInfo.isIsDisPledge()) {
                throw new NTException(NTException.HAVEPLEDGE);
            }
            this.checkIsLock(selInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("DiscountApplyBill");
            sic.add("ispoolpledge");
            ReceivableBillInfo rInfo = ReceivableBillFactory.getRemoteInstance().getReceivableBillInfo((IObjectPK)new ObjectUuidPK(selInfo.getId()), sic);
            if (!rInfo.isIsPoolPledge()) continue;
            throw new NTException(NTException.CANNOT_OPERATION);
        }
        return coll;
    }

    protected IObjectCollection getAccordReceivableListForCollect(List srcList) throws Exception {
        IObjectCollection coll = this.getBaseAccordReceivableList(srcList);
        for (ReceivableBillInfo selInfo : coll) {
            if (selInfo.isIsCollect()) {
                if (selInfo.getBillMedium().equals((Object)BillMediumEnum.ELECTRONIC)) {
                    throw new NTException(NTException.HASENTCOLLECT_226);
                }
                throw new NTException(NTException.HASCOLLECT_217);
            }
            if (selInfo.isIsTrustee()) {
                throw new NTException(NTException.HAVETRUSTEE);
            }
            if (selInfo.isIsPledge() && !selInfo.isIsDisPledge()) {
                throw new NTException(NTException.HAVEPLEDGE);
            }
            this.checkIsLock(selInfo);
        }
        return coll;
    }

    private IObjectCollection getBaseAccordReceivableList(List srcList) throws Exception {
        String currencyId = "";
        HashSet set = new HashSet(srcList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        SelectorItemCollection selector = this.getSelectors();
        selector.add(new SelectorItemInfo("isPoolTrustee"));
        selector.add(new SelectorItemInfo("ispoolpledge"));
        selector.add(new SelectorItemInfo("PayeeAccount.*"));
        selector.add(new SelectorItemInfo("PayeeAccount.bank.*"));
        selector.add(new SelectorItemInfo("source"));
        selector.add(new SelectorItemInfo("elecBillStatus"));
        view.getSelector().addObjectCollection((IObjectCollection)selector);
        view.setFilter(fi);
        ReceivableBillCollection colInfo = ReceivableBillFactory.getRemoteInstance().getReceivableBillCollection(view);
        this.isNeedAudit = NTHelper.getParam4Boolean(null, (String)"NT011", (boolean)true);
        int i = 0;
        for (ReceivableBillInfo selInfo : colInfo) {
            if (i == 0) {
                currencyId = selInfo.getCurrency().getId().toString();
            }
            if (!currencyId.equals(selInfo.getCurrency().getId().toString())) {
                throw new NTException(NTException.CURRENCYNOTACCORD);
            }
            if (selInfo.isIsPoolTrustee() || selInfo.isIsPoolPledge()) {
                throw new NTException(NTException.CANNOT_OPERATION);
            }
            if (this.isNeedAudit) {
                if (selInfo.getBillState() != BillStateEnum.Audit && selInfo.getBillState() != BillStateEnum.POOLTRUSTEE && selInfo.getBillState() != BillStateEnum.POOLPLEDGE) {
                    throw new NTException(NTException.NOTALLAUDIT);
                }
            } else if (selInfo.getBillState() != BillStateEnum.SAVED && selInfo.getBillState() != BillStateEnum.Audit && selInfo.getBillState() != BillStateEnum.POOLTRUSTEE && selInfo.getBillState() != BillStateEnum.POOLPLEDGE) {
                throw new NTException(NTException.NOTALLSAVED);
            }
            ++i;
        }
        return colInfo;
    }

    public IObjectCollection getReceivableList4Gather(List srcList) throws Exception {
        this.isNeedAudit = NTHelper.getParam4Boolean(null, (String)"NT011", (boolean)true);
        return this.getAccordReceivableList4Gather(srcList);
    }

    private IObjectCollection getAccordReceivableList4Gather(List srcList) throws Exception {
        return this.getBaseAccordReceivableList(srcList);
    }

    protected IObjectCollection getAccordReceivableList4Discont(List srcList) throws Exception {
        IObjectCollection coll = this.getAccordReceivableList(srcList);
        boolean isVendeePayInt = false;
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo selInfo = (ReceivableBillInfo)coll.getObject(i);
            if (i == 0) {
                isVendeePayInt = selInfo.isIsVendeePayInt();
            }
            if (isVendeePayInt != selInfo.isIsVendeePayInt()) {
                throw new NTException(NTException.ISVENDEEPAYINTNOTACCORD);
            }
            if (selInfo.getDiscountBill() == null) continue;
            throw new NTException(NTException.COMMON, new Object[]{EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"365_ReceivableBillListUI")});
        }
        return coll;
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("rpbillid");
                ReceivableBillInfo rInfo = ReceivableBillFactory.getRemoteInstance().getReceivableBillInfo((IObjectPK)new ObjectUuidPK(idList.get(i).toString()), sic);
                if (rInfo.getRpBillId() == null) continue;
                throw new NTException(NTException.CANNOT_OPERATION);
            }
        }
        String id = (String)idList.get(0);
        ReceivableBillInfo sourceBill = ((IReceivableBill)this.getBizInterface()).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        IObjectPK pk = LogUtil.beginLog(null, null, (BOSObjectType)new ReceivableBillInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(sourceBill.getId()), (String)sourceBill.getNumber(), (String)"fin_ReceivableBill_Voucher");
        super.actionVoucher_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pk);
        this.refreshList();
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        ReceivableBillInfo sourceBill = ((IReceivableBill)this.getBizInterface()).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        IObjectPK pk = LogUtil.beginLog(null, null, (BOSObjectType)new ReceivableBillInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(sourceBill.getId()), (String)sourceBill.getNumber(), (String)"fin_ReceivableBill_DelVoucher");
        super.actionDelVoucher_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pk);
        this.refreshList();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String ids = (String)idList.get(0);
        ReceivableBillInfo sourceBill = ((IReceivableBill)this.getBizInterface()).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids)));
        if (sourceBill.getSource() == BillSourceEnum.BYECDS) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"090_BYSIGNED_NOT_DELETE"));
            SysUtil.abort();
        }
        if (sourceBill.isIsFormRediscount()) {
            MsgBox.showInfo((String)EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"366_ReceivableBillListUI"));
            SysUtil.abort();
        }
        if (this.isFromReceiving) {
            throw new NTException(NTException.NODEL4FROMRECEIVING);
        }
        this.checkIsLock(sourceBill);
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionGather_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String ids = (String)idList.get(0);
        ReceivableBillInfo sourceBill = ((IReceivableBill)this.getBizInterface()).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids)));
        UIContext uiContext = new UIContext((Object)this);
        IObjectCollection receviableColl = this.getAccordReceivableList4Gather(idList);
        uiContext.put((Object)"ReceivableColl", (Object)receviableColl);
        if (idList.size() == 1) {
            String idscheck = (String)idList.get(0);
            ReceivableBillInfo paysourceBill = ((IReceivableBill)this.getBizInterface()).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)idscheck)));
            this.checkIsLock(paysourceBill);
            Date d = new Date();
            String id = this.getSelectedKeyValue();
            if (id != null && paysourceBill.getExpiredDate().compareTo(d) > 0 && MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"454_NotBillDueDate")) != 0) {
                return;
            }
        } else {
            this.checkSelected4Gather();
            this.checkGather(idList);
        }
        DataObjectMutex mutextControl = new DataObjectMutex();
        for (ReceivableBillInfo info : receviableColl) {
            try {
                mutextControl.requestDataObjectLock(info.getId().toString());
            }
            catch (Throwable e1) {
                this.handUIException(e1);
                this.abort();
            }
        }
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReceivableRecBatchUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshList();
    }

    private void checkGather(ArrayList idList) throws BOSException {
        ArrayList msg = new ArrayList();
        StringBuffer str = new StringBuffer();
        Set idSet = FMHelper.list2Set((List)idList);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        ReceivableBillCollection coll = ReceivableBillFactory.getRemoteInstance().getReceivableBillCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo billInfo = coll.get(i);
            if (billInfo.getOutPledgeID() != null) {
                str.append(EASResource.getString((String)NTP_RES, (String)"134_BILL_OutPledge", (Object[])new String[]{billInfo.getDraftNumber()}));
                str.append("\r\n");
                continue;
            }
            if (billInfo.getTrusteeOutBill() != null) {
                str.append(EASResource.getString((String)NTP_RES, (String)"l135_BILL_TrusteeOutBill", (Object[])new String[]{billInfo.getDraftNumber()}));
                str.append("\r\n");
                continue;
            }
            if (billInfo.getTrusteeToPledgeBill() != null) {
                str.append(EASResource.getString((String)NTP_RES, (String)"136_BILL_TrusteeToPledgeBill", (Object[])new String[]{billInfo.getDraftNumber()}));
                str.append("\r\n");
                continue;
            }
            if (billInfo.isIsPledgeToTrustee()) {
                str.append(EASResource.getString((String)NTP_RES, (String)"137_BILL_IsPledgeToTrustee", (Object[])new String[]{billInfo.getDraftNumber()}));
                str.append("\r\n");
                continue;
            }
            if (billInfo.getDiscountApplyBill() != null) {
                str.append(EASResource.getString((String)NTP_RES, (String)"133_BILL_IS_DISCOUNTAPPLY", (Object[])new String[]{billInfo.getDraftNumber()}));
                str.append("\r\n");
                continue;
            }
            if (!billInfo.isIsLockByBill() && !billInfo.isIsLockByManual()) continue;
            str.append(EASResource.getString((String)NTP_RES, (String)"BILL_IS_LOCK", (Object[])new String[]{billInfo.getDraftNumber()}));
            str.append("\r\n");
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)NTP_RES, (String)"003_CHECK_FAIL"), (String)str.toString(), (int)1);
            SysUtil.abort();
        }
    }

    private void checkSelected4Gather() throws NTException {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = this.tblMain.getRow(selectRows[i]);
            Date expiredDate = (Date)row.getCell("expiredDate").getValue();
            if (!new Date().before(expiredDate)) continue;
            throw new NTException(NTException.RECEIVABLECHECK);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.currentCompany = this.currentCompanyCommon;
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
        super.onLoad();
        this.init();
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.initFpOrBgF7Item((boolean)this.isFpItem, (IColumn)this.tblMain.getColumn("fpItem"), (IColumn)this.tblMain.getColumn("outBgItem"));
        this.tblMain.getColumn("draftNumber").getStyleAttributes().setHided(false);
    }

    protected String[] getPrecColName() {
        return new String[]{"billAmt", "naturalAmt", "discount"};
    }

    protected String getCurrencyIdColName() {
        return "CurrencyID";
    }

    private void init() throws BOSException {
        this.actionAuditResult.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionViewBgBalance.setEnabled(true);
        this.actionViewLog.setEnabled(true);
        FMClientHelper.setActualDigitNumberFormat((KDTable)this.tblMain, (String)"exchangeRate");
        FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String[])new String[]{"drawerAccount", "payeeAccount", "bankAccount.name", "innerAccount.name"}, (String)"@");
        FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String[])new String[]{"expiredDate", "issuesDate", "takeDate"}, (String)CtrlFormatUtilities.getDateFormatString());
        FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String[])new String[]{"discount"}, (String)"##,###,###,###,###,##0.00000");
        FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String[])new String[]{"period"}, (String)"##,###,###,###,###,##0.0");
        this.tblMain.getColumn("period").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("discountRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionGather.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_gathering"));
        this.actionCancelGather.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_ungathering"));
        this.actionEndoseListing.putValue("SmallIcon", EASResource.getIcon((String)"imgTtn_writeatback"));
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionCancelAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dengzsetting"));
        this.actionCancelBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_versapost"));
        this.actionViewLog.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dengzsetting"));
        this.actionLock.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_freeze"));
        this.actionUnLock.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.actionCreateTo.setVisible(false);
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionAddNew.setVisible(false);
        this.actionBatchInput.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionEndorseIn.setVisible(false);
        this.actionEndorseOut.setVisible(false);
        this.actionDiscount.setVisible(false);
        this.actionDiscountApply.setVisible(false);
        this.actionCancelDiscount.setVisible(false);
        this.actionCollectRegister.setVisible(false);
        this.actionTrustee.setVisible(false);
        this.actionPledge.setVisible(false);
        this.actionNavInnerEreceipt.setVisible(false);
        this.actionTranEnt.setVisible(false);
        this.actionTranLend.setVisible(false);
        this.actionPoolPledge.setVisible(false);
        this.actionPoolTrustee.setVisible(false);
        this.actionDataMatch.setVisible(false);
        this.actionTranNt.setVisible(false);
        this.actionNotify.setVisible(false);
        this.actionReturnBill.setVisible(false);
        this.actionCancelReturnBil.setVisible(false);
        this.actionCancelTrustee.setVisible(false);
        this.actionCancelNotify.setVisible(false);
        this.actionCancelTranLend.setVisible(false);
        this.actionCancelEndorse.setVisible(false);
        this.actionCancelPledge.setVisible(false);
        this.actionDisPledge.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.actionCancelDisPledge.setVisible(false);
    }

    @Override
    protected String getEditUIName() {
        return ReceivableBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ReceivableBillFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected IObjectValue createNewData() {
        ReceivableBillInfo objectValue = new ReceivableBillInfo();
        return objectValue;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ReceivableBillSummaryFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public void actionImportData2_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.nt.receivableBill";
        param.alias = EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"54_ReceivableBillControllerBean");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        task.setParentComponent((Component)((Object)this));
        task.invoke(paramList, 0, false);
        ReceivableBillFactory.getRemoteInstance().updatePeriod();
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    public void actionEndoseListing_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.showEndorseListing();
    }

    private void showEndorseListing() throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        ReceivableBillInfo receivableBillInfo = ReceivableBillFactory.getRemoteInstance().getReceivableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id).toString()));
        if (receivableBillInfo == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"InitDataObject", (Object)receivableBillInfo);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EndorseListingUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("payee.*"));
        sic.add(new SelectorItemInfo("payeeBank.*"));
        sic.add(new SelectorItemInfo("payeeAccount.*"));
        sic.add(new SelectorItemInfo("payeeAccount.account.*"));
        sic.add(new SelectorItemInfo("drawer.*"));
        sic.add(new SelectorItemInfo("drawerAccount.*"));
        sic.add(new SelectorItemInfo("acceptanceBank.*"));
        sic.add(new SelectorItemInfo("deliver.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("bankAccount.*"));
        sic.add(new SelectorItemInfo("department.*"));
        sic.add(new SelectorItemInfo("innerAccount.*"));
        sic.add(new SelectorItemInfo("ntType.*"));
        sic.add(new SelectorItemInfo("accountant.*"));
        sic.add(new SelectorItemInfo("trusteeBank.*"));
        sic.add(new SelectorItemInfo("trusteeCompany.*"));
        return sic;
    }

    @Override
    public void actionTDPrint2_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDFileName() == null) {
            return;
        }
        DefaultNoteDataProvider defaultNoteDataProvider = new DefaultNoteDataProvider((List)idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.getTDFileName(), (Object)defaultNoteDataProvider, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview2_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDFileName() == null) {
            return;
        }
        DefaultNoteDataProvider defaultNoteDataProvider = new DefaultNoteDataProvider((List)idList);
        defaultNoteDataProvider.addMetaDataPK("Acceptence", this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.getTDFileName(), (Object)defaultNoteDataProvider, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected String getTDFileName() {
        return "/FM/NT/AC";
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.nt.app.ReceivableBillTDQuery");
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        IRow row = null;
        String currencyId = null;
        if (e == null) {
            return;
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            row = tblMain.getRow(i);
            currencyId = (String)row.getCell(this.getCurrencyIdColName()).getValue();
            if (currencyId == null) continue;
            FMClientHelper.setNumberFormat((IRow)row, (String)"billAmt", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"discount", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"naturalAmt", (String)this.currentCompany.getBaseCurrency().getId().toString());
            row.getCell("discount").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)5));
            row.getCell("lastUpdateTime").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
        }
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ReceivableBillInfo info = ((IReceivableBill)this.getBizInterface()).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.nt.app.ReceivableBill", null, (IObjectValue)info);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int result;
        this.checkSelected();
        boolean isCreateReceivable = false;
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> numbers = new ArrayList<String>();
        Map map = new HashMap();
        BizEnumValueDTO status = null;
        boolean isReceivable = true;
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            status = (BizEnumValueDTO)row.getCell("billState").getValue();
            if (status.getInt() == 0) {
                ids.add(row.getCell("id").getValue().toString());
                numbers.add(row.getCell("number").getValue().toString());
            }
            if (row.getCell("rpbillid").getValue() != null) continue;
            isReceivable = false;
        }
        boolean isNTAssociaWithRP = NTHelper.getParam4Boolean(null, (String)"NT014", (boolean)false);
        if (!isReceivable && isNTAssociaWithRP && MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"isGenReceivingBill")) == 0) {
            isCreateReceivable = true;
        }
        IReceivableBill iReceivableBill = ReceivableBillFactory.getRemoteInstance();
        if (ids.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"419_PayableBillListUI"));
            SysUtil.abort();
        } else if (ids.size() == 1) {
            iReceivableBill.submitBatch(ids, isCreateReceivable);
            FMClientHelper.showSuccessMessageBox((CoreUI)this, (ActionEvent)e);
        } else if (ids.size() == indexs.length) {
            map = iReceivableBill.submitBatch(ids, isCreateReceivable);
            this.showMessage(map, numbers);
        } else if (ids.size() < indexs.length && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"420_PayableBillListUI"))) == 0) {
            map = iReceivableBill.submitBatch(ids, isCreateReceivable);
            this.showMessage(map, numbers);
        }
        this.refreshList();
    }

    private void showMessage(Map map, List list) {
        String msg1 = EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"561_ReceivableBillListUI");
        msg1 = MessageFormat.format(msg1, list.size());
        String msg2 = EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"424_PayableBillListUI");
        msg2 = MessageFormat.format(msg2, list.toString());
        MsgBox.showDetailAndOK((Component)((Object)this), (String)msg1, (String)msg2, (int)1);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        boolean hasWfInstance = FMHelper.hasWFInstance(null, (List)idList);
        if (hasWfInstance) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            ReceivableBillFactory.getRemoteInstance().audit(new HashSet(idList));
        }
        this.refreshList();
    }

    @Override
    public void actionCancelAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String ids = (String)idList.get(0);
        ReceivableBillInfo sourceBill = ((IReceivableBill)this.getBizInterface()).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids)));
        Map map = ReceivableBillFactory.getRemoteInstance().cancelAudit(new HashSet(idList));
        if (map.size() > 0) {
            ArrayList unValids = new ArrayList();
            ArrayList unValidsMessage = new ArrayList();
            for (Map.Entry entry : map.entrySet()) {
                unValids.add(entry.getKey());
                unValidsMessage.add(entry.getValue());
            }
            StringBuffer detail = new StringBuffer();
            detail.append(EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"577_BillNumber")).append("\t\t").append(EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"578_ErrorReason")).append("\n");
            int size = unValids.size();
            for (int i = 0; i < size; ++i) {
                detail.append(unValids.get(i)).append("\t").append(unValidsMessage.get(i)).append("\n");
            }
            String error = EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"579_BillCancelAuditFailure");
            error = MessageFormat.format(error, idList.size(), unValids.size());
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)detail.toString(), (int)1);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"580_BillCancelAuditSuccess"));
        }
        this.refreshList();
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ReceivableBillInfo sourceBill = ((IReceivableBill)this.getBizInterface()).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        NTFacadeFactory.getRemoteInstance().bookJouranl(id, "com.kingdee.eas.fm.nt.app.ReceivableBillBookNotifyBuilder");
        MsgBox.showInfo((String)EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"568_BOOK_SUCC"));
        this.refreshList();
    }

    @Override
    public void actionCancelBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        NTFacadeFactory.getRemoteInstance().cancelBookJouranl(id);
        this.refreshList();
    }

    private FilterInfo getBillCanbeReceived() {
        FilterInfo f = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            IContextHelper ctxHelper = ContextHelperFactory.getRemoteInstance();
            boolean needAudit = ctxHelper.getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(ctxHelper.getCurrentCompany().getId()));
            Map btpeditparameter = (Map)this.getUIContext().get("BTPEDITPARAMETER");
            String targetBillType = (String)btpeditparameter.get("TargetBillType");
            if (targetBillType != null && "ReceivableBill".equals(targetBillType)) {
                if (needAudit) {
                    f.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS));
                    f.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(8)));
                    f.getFilterItems().add(new FilterItemInfo("isPledge", (Object)new Integer(0)));
                    f.getFilterItems().add(new FilterItemInfo("isTrustee", (Object)new Integer(0)));
                } else {
                    f.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS));
                    f.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(1)));
                    f.getFilterItems().add(new FilterItemInfo("isPledge", (Object)new Integer(0)));
                    f.getFilterItems().add(new FilterItemInfo("isTrustee", (Object)new Integer(0)));
                }
            }
        }
        return f;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String ids = (String)idList.get(0);
        ReceivableBillInfo sourceBill = ((IReceivableBill)this.getBizInterface()).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids)));
        super.actionEdit_actionPerformed(e);
    }

    protected String[] getQueryShowField() {
        return new String[]{"company.name", "company.number", "nttype", "billState", "issuesDate", "number", "draftNumber", "isNoUsed", "drawerName", "drawerAccount", "acceptanceBankName", "payee", "payeeAccount", "payeeBankName", "currency.name", "billAmt", "exchangeRate", "naturalAmt", "expiredDate", "takeDate", "deliverName", "department.name", "operator.name", "contractNo", "transferDate", "digest", "description", "bankAccount.name", "innerAccount.name", "creator.name", "audit", "accountant.name", "currency.id", "isHistory", "isVendeePayInt", "createTime", "lastUpdateTime", "outBgItem", "oppAccount", "billAccount", "period", "discountRate", "discount", "cashier", "rpbillid", "isTrustee", "isPledge", "isDisPledge", "isCollect", "collectNum", "collectBank", "billMedium"};
    }

    protected IObjectCollection checkIsCollect(IObjectCollection coll) {
        ReceivableBillCollection reCol = new ReceivableBillCollection();
        if (coll != null && coll.size() > 0) {
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                ReceivableBillInfo selInfo = (ReceivableBillInfo)coll.getObject(i);
                if (selInfo.isIsCollect()) continue;
                reCol.addObject((IObjectValue)selInfo);
            }
        }
        return reCol;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"number", "name", "draftNumber"};
        return locateNames;
    }

    @Override
    public void actionViewLog_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 0 || idList == null) {
            return;
        }
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"PleaseSelectOne"));
            SysUtil.abort();
        }
        ReceivableBillInfo info = ReceivableBillFactory.getRemoteInstance().getReceivableBillInfo("where id = '" + idList.get(0) + "'");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)info.getDraftNumber()));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("draftNumber");
        selector.add("handler.name");
        selector.add("bizType");
        selector.add("handleDate");
        selector.add("company.name");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(selector);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("handleDate"));
        view.setSorter(sorter);
        BillTransactionLogCollection coll = BillTransactionLogFactory.getRemoteInstance().getBillTransactionLogCollection(view);
        IUIWindow uiWindow = null;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"logColl", (Object)coll);
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ViewBillTransLogUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionSum_actionPerformed(ActionEvent e) throws Exception {
        super.actionSum_actionPerformed(e);
        String id = this.getSelectedKeyValue();
        if (id == null) {
            return;
        }
        String msg = FMClientHelper.sumList((KDTable)this.tblMain, (String)"receivableBill", (String)"naturalAmt");
        MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
    }

    protected void checkIsLock(ReceivableBillInfo bill) throws Exception {
        if (bill != null && (bill.isIsLockByBill() || bill.isIsLockByManual())) {
            throw new NTException(NTException.NOLOCKBILL);
        }
    }

    @Override
    public void actionLock_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 0 || idList == null) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        ReceivableBillCollection coll = this.getReceivableByLock(idSet);
        this.isNeedAudit = ContextHelperFactory.getRemoteInstance().getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId().toString()));
        StringBuffer number = new StringBuffer();
        for (int i = 0; i < coll.size(); ++i) {
            boolean flag;
            ReceivableBillInfo receivablebillBill = coll.get(i);
            boolean bl = this.isNeedAudit ? !receivablebillBill.getBillState().equals((Object)BillStateEnum.Audit) : (flag = !receivablebillBill.getBillState().equals((Object)BillStateEnum.SAVED) && !receivablebillBill.getBillState().equals((Object)BillStateEnum.Audit));
            if (flag) {
                if (number.length() == 0) {
                    number.append(receivablebillBill.getDraftNumber());
                } else {
                    number.append("\u3001").append(receivablebillBill.getDraftNumber());
                }
                idList.remove(receivablebillBill.getId().toString());
                continue;
            }
            this.checkBill(receivablebillBill, number, idList);
        }
        ReceivableBillFactory.getRemoteInstance().lock((List)idList);
        if (idList.size() != idSet.size()) {
            StringBuffer detail = new StringBuffer();
            detail.append(EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"598_draftNumber")).append(":").append(number);
            String error = EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"596_bathLock");
            error = MessageFormat.format(error, idSet.size(), idSet.size() - idList.size());
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)detail.toString(), (int)1);
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"585_lock"));
        }
        this.refreshList();
    }

    private List checkBill(ReceivableBillInfo receivablebillBill, StringBuffer number, List idList) throws Exception {
        boolean bCurCompany = receivablebillBill.getCompany().getId().toString().equals(this.currentCompany.getId().toString());
        if (!bCurCompany || receivablebillBill.isIsTrustee() || receivablebillBill.isIsPledge() && !receivablebillBill.isIsDisPledge() || receivablebillBill.isIsCollect() || receivablebillBill.isIsPoolPledge() || receivablebillBill.isIsPoolTrustee()) {
            if (number.length() == 0) {
                number.append(receivablebillBill.getDraftNumber());
            } else {
                number.append("\u3001").append(receivablebillBill.getDraftNumber());
            }
            idList.remove(receivablebillBill.getId().toString());
        }
        return idList;
    }

    @Override
    public void actionUnLock_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 0 || idList == null) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        ReceivableBillCollection coll = this.getReceivableByLock(idSet);
        StringBuffer number = new StringBuffer();
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo receivablebillBill = coll.get(i);
            if (receivablebillBill.isIsLockByManual()) continue;
            if (number.length() == 0) {
                number.append(receivablebillBill.getDraftNumber());
            } else {
                number.append("\u3001").append(receivablebillBill.getDraftNumber());
            }
            idList.remove(receivablebillBill.getId().toString());
        }
        ReceivableBillFactory.getRemoteInstance().unLock((List)idList);
        if (idList.size() != idSet.size()) {
            StringBuffer detail = new StringBuffer();
            detail.append(EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"598_draftNumber")).append(":").append(number);
            String error = EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"597_bathUnLock");
            error = MessageFormat.format(error, idSet.size(), idSet.size() - idList.size());
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)detail.toString(), (int)1);
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"586_unLock"));
        }
        this.refreshList();
    }

    private ReceivableBillCollection getReceivableByLock(Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("draftNumber"));
        selector.add(new SelectorItemInfo("billState"));
        selector.add(new SelectorItemInfo("company"));
        selector.add(new SelectorItemInfo("isTrustee"));
        selector.add(new SelectorItemInfo("isPledge"));
        selector.add(new SelectorItemInfo("isDisPledge"));
        selector.add(new SelectorItemInfo("isCollect"));
        selector.add(new SelectorItemInfo("isPoolPledge"));
        selector.add(new SelectorItemInfo("isPoolTrustee"));
        selector.add(new SelectorItemInfo("isLockByBill"));
        selector.add(new SelectorItemInfo("isLockByManual"));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(selector);
        ReceivableBillCollection coll = ReceivableBillFactory.getRemoteInstance().getReceivableBillCollection(view);
        return coll;
    }

    protected Boolean checkEntCollect(IObjectCollection coll) {
        ReceivableBillInfo selInfo;
        Boolean falg = false;
        if (coll != null && coll.size() > 0 && (selInfo = (ReceivableBillInfo)coll.getObject(0)).getBillMedium().equals((Object)BillMediumEnum.ELECTRONIC)) {
            falg = true;
        }
        return falg;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "takeDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionSubmit", "ActionCancelAudit"};
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            ReceivableBillSummaryListUI.this.setListUITable(ReceivableBillSummaryListUI.this.tblMain, e);
        }
    }
}

