/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.CollectionUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.EReceiptIsMatchEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.erec.ERecDetailMatchFilterParam;
import com.kingdee.eas.fm.erec.ERecDetailMatchResultFilterParam;
import com.kingdee.eas.fm.erec.client.AbstractERecDetailMatchResultFilterUI;
import com.kingdee.eas.util.client.EASResource;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class ERecDetailMatchResultFilterUI
extends AbstractERecDetailMatchResultFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ERecDetailMatchResultFilterUI.class);
    String PERMISSIONITEM = "rpm_recDetail_01view";
    private Map bankInterMap = new HashMap();
    static ERecDetailMatchFilterParam param;

    public static void setSuperParam(ERecDetailMatchFilterParam params) throws Exception {
        param = params;
    }

    public static ERecDetailMatchFilterParam getSuperParam() throws Exception {
        return param;
    }

    protected void init() throws Exception {
        super.init();
        this.customInit(param);
    }

    private void customInit(ERecDetailMatchFilterParam uiContext) throws Exception {
        if (uiContext == null) {
            this.company.setValue((Object)this.getCompanyOrgUnitInfoByUserPermisson());
            this.initBankInterface();
            this.accountBank.setEnabledMultiSelection(true);
            Date date = new Date();
            this.startTransDate.setValue((Object)date);
            this.endTransDate.setValue((Object)date);
            this.isMatch.addItem((Object)EReceiptIsMatchEnum.manual);
            this.isMatch.setSelectedItem((Object)EReceiptIsMatchEnum.manual);
            this.isMatch.setEnabled(false);
        } else {
            ERecDetailMatchFilterParam param = uiContext;
            if (!EmptyUtil.isEmpty(param.getCompanyIdSet())) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("id", param.getCompanyIdSet(), CompareType.INCLUDE));
                try {
                    CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                    this.company.setValue((Object)coll.toArray());
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
            this.bankInterface.setSelectedItem((Object)param.getBankInterface());
            this.initBankInterface();
            if (EmptyUtil.isEmpty((String)param.getBankInterface())) {
                this.bankInterface.setSelectedItem(this.bankInterface.getItemAt(this.bankInterface.getItemCount() - 1));
            } else {
                int index = (Integer)this.bankInterMap.get(param.getBankInterface());
                UIUtil.setSelectObject((KDComboBox)this.bankInterface, (Object)this.bankInterface.getItemAt(index));
            }
            this.startTransDate.setValue((Object)param.getStartTransDate());
            this.endTransDate.setValue((Object)param.getEndTransDate());
            if (param.getAccountBankIdArray() != null) {
                String[] bankAcctId = param.getAccountBankIdArray();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)CollectionUtil.asSet((String[])bankAcctId), CompareType.INCLUDE));
                AccountBankCollection bankAcct = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
                this.accountBank.setData((Object)bankAcct.toArray());
            } else {
                this.accountBank.setData(null);
            }
            this.isMatch.addItem((Object)EReceiptIsMatchEnum.manual);
            this.isMatch.setSelectedItem((Object)EReceiptIsMatchEnum.manual);
            this.isMatch.setEnabled(false);
        }
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson() throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isOnlyUnion", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        CompanyOrgUnitCollection coll = FMHelper.getUserOrgRangesWithRange(null, (String)this.PERMISSIONITEM, (FilterInfo)filter);
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo info = coll.get(i);
            if (!this.currentCompany.getId().toString().equals(info.getId().toString())) continue;
            return info;
        }
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public String getPermissionItem() {
        return this.PERMISSIONITEM;
    }

    public boolean isSupportMultiOrgs() {
        return true;
    }

    private CompanyOrgUnitCollection getMainOrgColl() {
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        Object mainBizOrgValue = this.company.getValue();
        if (mainBizOrgValue instanceof Object[]) {
            Object[] arrays = (Object[])mainBizOrgValue;
            for (int i = 0; i < arrays.length; ++i) {
                if (null == arrays[i]) continue;
                coll.add((CompanyOrgUnitInfo)arrays[i]);
            }
        } else if (mainBizOrgValue instanceof CompanyOrgUnitInfo) {
            coll.add((CompanyOrgUnitInfo)mainBizOrgValue);
        }
        return coll;
    }

    private AccountBankCollection getAcctBanks() {
        AccountBankCollection coll = new AccountBankCollection();
        Object acctBanks = this.accountBank.getValue();
        if (acctBanks instanceof Object[]) {
            Object[] arrays = (Object[])acctBanks;
            for (int i = 0; i < arrays.length; ++i) {
                if (null == arrays[i]) continue;
                coll.add((AccountBankInfo)arrays[i]);
            }
        } else if (acctBanks instanceof AccountBankInfo) {
            coll.add((AccountBankInfo)acctBanks);
        }
        return coll;
    }

    @Override
    protected void company_dataChanged(DataChangeEvent e) throws Exception {
        this.setAcctBank(true);
    }

    private void initBankInterface() throws BOSException, EASBizException {
        this.bankInterface.removeAllItems();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setSelector(this.getSelectors());
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        if (!FMClientHelper.isNotExistsMulBeService()) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId()));
        }
        view.setFilter(filter);
        AccountBankCollection colls = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        int k = 0;
        this.bankInterMap.clear();
        for (int i = 0; i < colls.size(); ++i) {
            AccountBankInfo info = colls.get(i);
            BankInterface bankAcct = new BankInterface();
            if (FMHelper.isEmpty((String)info.getBankInterFaceID())) continue;
            bankAcct.setNumber(info.getBankInterFaceID());
            bankAcct.setName(info.getBankInterFace());
            if (this.bankInterMap.containsKey(bankAcct.getNumber())) continue;
            this.bankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(bankAcct.getNumber(), new Integer(k));
            ++k;
        }
        if (!this.bankInterMap.containsKey(null)) {
            BankInterface bankAcct = new BankInterface();
            bankAcct.setNumber(null);
            bankAcct.setName(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"Select_All"));
            this.bankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(null, new Integer(this.bankInterMap.size() + 1));
        }
    }

    private void setAcctBank(Boolean flag) {
        if (flag.booleanValue()) {
            this.accountBank.setValue(null);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl())) {
            CompanyOrgUnitCollection coll = this.getMainOrgColl();
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        this.accountBank.setEntityViewInfo(view);
    }

    public Object getParam() {
        int i;
        HashSet<String> idSet;
        CompanyOrgUnitCollection coll;
        ERecDetailMatchResultFilterParam param = new ERecDetailMatchResultFilterParam();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl())) {
            coll = this.getMainOrgColl();
            idSet = new HashSet<String>();
            for (i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            param.setCompanyIdSet(idSet);
        }
        if (this.bankInterface.getSelectedItem() instanceof BankInterface) {
            BankInterface bankInterface = (BankInterface)this.bankInterface.getSelectedItem();
            param.setBankInterface(bankInterface.getNumber());
        } else {
            param.setBankInterface(null);
        }
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getAcctBanks())) {
            coll = this.getAcctBanks();
            idSet = new HashSet();
            for (i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            param.setAccountBankIdSet(idSet);
        }
        param.setStartDate((Date)this.startTransDate.getValue());
        param.setEndDate((Date)this.endTransDate.getValue());
        param.setIsMatch(EReceiptIsMatchEnum.manual);
        return param;
    }

    public void setParam(Object param) {
        CompanyOrgUnitCollection coll;
        FilterInfo filter;
        if (param == null) {
            return;
        }
        if (!(param instanceof ERecDetailMatchResultFilterParam)) {
            return;
        }
        ERecDetailMatchResultFilterParam para = (ERecDetailMatchResultFilterParam)param;
        if (!EmptyUtil.isEmpty(para.getCompanyIdSet())) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", para.getCompanyIdSet(), CompareType.INCLUDE));
            try {
                coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                this.company.setValue((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        } else {
            this.company.setValue(null);
        }
        if (FMHelper.isEmpty((String)para.getBankInterface())) {
            this.bankInterface.setSelectedItem(this.bankInterface.getItemAt(this.bankInterface.getItemCount() - 1));
        } else {
            int index = (Integer)this.bankInterMap.get(para.getBankInterface());
            FMClientHelper.setSelectObject((KDComboBox)this.bankInterface, (Object)this.bankInterface.getItemAt(index));
        }
        if (!EmptyUtil.isEmpty(para.getAccountBankIdSet())) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", para.getAccountBankIdSet(), CompareType.INCLUDE));
            try {
                coll = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
                this.accountBank.setValue((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        } else {
            this.accountBank.setValue(null);
        }
        this.startTransDate.setValue((Object)para.getStartDate());
        this.endTransDate.setValue((Object)para.getEndDate());
        this.isMatch.setSelectedItem((Object)EReceiptIsMatchEnum.manual);
    }

    public KDBizPromptBox getMainOrg() {
        return this.company;
    }

    protected Class getParamClass() {
        return ERecDetailMatchResultFilterParam.class;
    }
}

