/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.model.util.DateHelper;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptIsMatchEnum;
import com.kingdee.eas.fm.be.EReceiptStorageSettingCollection;
import com.kingdee.eas.fm.be.EReceiptStorageSettingFactory;
import com.kingdee.eas.fm.be.EReceiptStorageSettingInfo;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.be.client.EReceiptClientHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.erec.EDMatchResultCollection;
import com.kingdee.eas.fm.erec.ERecDetailMatchFacadeFactory;
import com.kingdee.eas.fm.erec.ERecDetailMatchFilterParam;
import com.kingdee.eas.fm.erec.client.AbstractERecDetailMatchUI;
import com.kingdee.eas.fm.erec.client.ERecDetailFilterUI;
import com.kingdee.eas.fm.erec.client.ERecDetailMatchResultUI;
import com.kingdee.eas.fm.erec.client.ERecDetailQueryProcessor;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ERecDetailMatchUI
extends AbstractERecDetailMatchUI {
    private static final Logger logger = CoreUIObject.getLogger(ERecDetailMatchUI.class);
    private static final String resourcePath = "com.kingdee.eas.fm.erec.ERecResources";
    private static final String SELECT = "select";
    private CommonQueryDialog queryDialog;
    private CommonQueryDialog erecQueryDialog;
    private CommonQueryDialog detailQueryDialog;
    IMetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.fm.be.app", "EReceiptQuery");
    IMetaDataPK erecQueryPK = new MetaDataPK("com.kingdee.eas.fm.erec.app", "EReceiptMatchQuery");
    IMetaDataPK detailQueryPK = new MetaDataPK("com.kingdee.eas.fm.erec.app", "TransDetailMatchQuery");
    private int scale = 2;
    private boolean erecSelect = false;
    private boolean detailSelect = false;
    FMFilterBaseUI filterUI = null;
    private ERecDetailMatchFilterParam filterParam;
    private BigDecimal erecDebitAmt = BigDecimal.ZERO;
    private BigDecimal erecCreditAmt = BigDecimal.ZERO;
    private BigDecimal detailDebitAmt = BigDecimal.ZERO;
    private BigDecimal detailCreditAmt = BigDecimal.ZERO;
    private BigDecimal erecDebitTotalAmt = BigDecimal.ZERO;
    private BigDecimal erecCreditTotalAmt = BigDecimal.ZERO;
    private BigDecimal detailDebitTotalAmt = BigDecimal.ZERO;
    private BigDecimal detailCreditTotalAmt = BigDecimal.ZERO;
    private final String ERecDebitAmtCol = "debitAmount";
    private final String ERecCreditAmtCol = "creditAmount";
    private final String DetailDebitAmtCol = "debitAmount";
    private final String DetailCreditAmtCol = "creditAmount";

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ERecDetailFilterUI();
        }
        return this.filterUI;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.showFilterUI(this.mainQueryPK.getFullName());
        this.handlerRecDetailEntityView();
        this.initTable();
        this.initUI();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionMatch.setEnabled(true);
    }

    public void showFilterUI(String queryName) throws Exception {
        if (this.filterParam != null) {
            return;
        }
        if (this.getUIContext().containsKey("isDirectShow") && ((Boolean)this.getUIContext().get("isDirectShow")).booleanValue()) {
            this.getFilterUI();
            this.getQueryDialog();
            this.filterParam = (ERecDetailMatchFilterParam)this.getUIContext().get("filterParam");
            FMFilterBaseUI fui = this.getFilterUI();
            if (fui != null) {
                fui.onLoad();
                try {
                    fui.setParam((Object)this.filterParam);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            return;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        QuerySolutionInfo ds = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), queryName);
        if (ds != null) {
            QueryPanelCollection queryPanelInfo = ds.getQueryPanelInfo();
            this.getFilterUI();
            this.getQueryDialog();
            if (queryPanelInfo.size() > 0) {
                for (int i = 0; i < queryPanelInfo.size(); ++i) {
                    String filterUICName = this.filterUI.getMetaDataPK().getFullName();
                    if (!filterUICName.equals(queryPanelInfo.get(i).getPanelClassName())) continue;
                    CustomerParams cp = CustomerParams.getCustomerParams2((String)queryPanelInfo.get(i).getCustomerParams());
                    if (cp == null) break;
                    this.filterParam = (ERecDetailMatchFilterParam)this.filterUI.getFilterParamFromCP(cp);
                }
            }
            if (this.filterParam == null) {
                this.filterParam = this.getDefaultQueryParam();
            }
        } else if (!this.getQueryDialog().show()) {
            SysUtil.abort();
        }
    }

    private ERecDetailMatchFilterParam getDefaultQueryParam() {
        ERecDetailMatchFilterParam param = (ERecDetailMatchFilterParam)this.filterUI.getParam();
        return param;
    }

    private void handlerRecDetailEntityView() throws BOSException {
        this.handlerERecEntityView();
        this.handlerDetailEntityView();
    }

    private void handlerERecEntityView() throws BOSException {
        try {
            this.eReceiptMatchQuery = new EntityViewInfo();
            if (this.getERecQueryDialog().getEntityViewInfoResult() != null) {
                this.eReceiptMatchQuery = (EntityViewInfo)this.getERecQueryDialog().getEntityViewInfoResult().clone();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FilterInfo erecFilter = new FilterInfo();
        this.filterParam = (ERecDetailMatchFilterParam)this.filterUI.getParam();
        if (!EmptyUtil.isEmpty(this.filterParam.getCompanyIdSet())) {
            Set<String> companyIdSet = this.filterParam.getCompanyIdSet();
            erecFilter.getFilterItems().add(new FilterItemInfo("company.id", companyIdSet, CompareType.INCLUDE));
        }
        if (!EmptyUtil.isEmpty((Object[])this.filterParam.getAccountBankIdArray())) {
            String[] acctBankIdArray = this.filterParam.getAccountBankIdArray();
            erecFilter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)FMHelper.Array2Set((String[])acctBankIdArray), CompareType.INCLUDE));
        }
        if (!EmptyUtil.isEmpty((Object)this.filterParam.getStartTransDate()) && !EmptyUtil.isEmpty((Object)this.filterParam.getEndTransDate())) {
            Date start = DateHelper.truncateDate((Date)this.filterParam.getStartTransDate());
            Date end = DateHelper.truncateDate((Date)this.filterParam.getEndTransDate());
            end = DateHelper.getAfterDay((Date)end);
            erecFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)start, CompareType.GREATER_EQUALS));
            erecFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)end, CompareType.LESS));
        }
        if (!EmptyUtil.isEmpty((Object)this.filterParam.getIsMatch())) {
            erecFilter.getFilterItems().add(new FilterItemInfo("isMatch", (Object)this.filterParam.getIsMatch().getValue()));
        }
        if (this.eReceiptMatchQuery.getFilter() != null) {
            this.eReceiptMatchQuery.getFilter().mergeFilter(erecFilter, "AND");
        } else {
            this.eReceiptMatchQuery.setFilter(erecFilter);
        }
        SorterItemCollection sort = new SorterItemCollection();
        SorterItemInfo comSort = new SorterItemInfo("company.name");
        comSort.setSortType(SortType.DESCEND);
        SorterItemInfo acctSort = new SorterItemInfo("bankAccount.bankAccountNumber");
        acctSort.setSortType(SortType.DESCEND);
        SorterItemInfo dateSort = new SorterItemInfo("transDate");
        dateSort.setSortType(SortType.DESCEND);
        SorterItemInfo creAmtSort = new SorterItemInfo("creditAmount");
        creAmtSort.setSortType(SortType.DESCEND);
        sort.add(comSort);
        sort.add(acctSort);
        sort.add(dateSort);
        sort.add(creAmtSort);
        this.eReceiptMatchQuery.setSorter(sort);
    }

    private void handlerDetailEntityView() throws BOSException {
        this.transDetailMatchQuery = new EntityViewInfo();
        try {
            if (this.getDetailQueryDialog().getEntityViewInfoResult() != null) {
                this.transDetailMatchQuery = (EntityViewInfo)this.getDetailQueryDialog().getEntityViewInfoResult().clone();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FilterInfo detailFilter = new FilterInfo();
        this.filterParam = (ERecDetailMatchFilterParam)this.filterUI.getParam();
        if (!EmptyUtil.isEmpty(this.filterParam.getCompanyIdSet())) {
            Set<String> companyIdSet = this.filterParam.getCompanyIdSet();
            detailFilter.getFilterItems().add(new FilterItemInfo("company.id", companyIdSet, CompareType.INCLUDE));
        }
        if (!EmptyUtil.isEmpty((Object[])this.filterParam.getAccountBankIdArray())) {
            String[] acctBankIdArray = this.filterParam.getAccountBankIdArray();
            detailFilter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)FMHelper.Array2Set((String[])acctBankIdArray), CompareType.INCLUDE));
        }
        if (!EmptyUtil.isEmpty((Object)this.filterParam.getStartTransDate()) && !EmptyUtil.isEmpty((Object)this.filterParam.getEndTransDate())) {
            Date start = DateHelper.truncateDate((Date)this.filterParam.getStartTransDate());
            Date end = DateHelper.truncateDate((Date)this.filterParam.getEndTransDate());
            end = DateHelper.getAfterDay((Date)end);
            detailFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)start, CompareType.GREATER_EQUALS));
            detailFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)end, CompareType.LESS));
        }
        if (!EmptyUtil.isEmpty((Object)this.filterParam.getIsMatch())) {
            detailFilter.getFilterItems().add(new FilterItemInfo("isMatchEReceipt", (Object)this.filterParam.getIsMatch().getValue()));
        }
        if (this.transDetailMatchQuery.getFilter() != null) {
            this.transDetailMatchQuery.getFilter().mergeFilter(detailFilter, "AND");
        } else {
            this.transDetailMatchQuery.setFilter(detailFilter);
        }
        SorterItemCollection sort = new SorterItemCollection();
        SorterItemInfo comSort = new SorterItemInfo("company.name");
        comSort.setSortType(SortType.DESCEND);
        SorterItemInfo acctSort = new SorterItemInfo("bankAccount.bankAccountNumber");
        acctSort.setSortType(SortType.DESCEND);
        SorterItemInfo dateSort = new SorterItemInfo("bizDate");
        dateSort.setSortType(SortType.DESCEND);
        SorterItemInfo creAmtSort = new SorterItemInfo("creditAmount");
        creAmtSort.setSortType(SortType.DESCEND);
        sort.add(comSort);
        sort.add(acctSort);
        sort.add(dateSort);
        sort.add(creAmtSort);
        this.transDetailMatchQuery.setSorter(sort);
    }

    private CommonQueryDialog getQueryDialog() throws Exception {
        if (this.queryDialog == null) {
            IMetaDataPK mockQuery = this.mainQueryPK;
            this.queryDialog = new CommonQueryDialog();
            this.queryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setShowFilter(false);
            this.queryDialog.setShowSorter(false);
            this.queryDialog.setQueryObjectPK(mockQuery);
            this.queryDialog.addUserPanel((KDPanel)this.getFilterUI());
            this.queryDialog.setTitle(EASResource.getString((String)resourcePath, (String)"2_filterTitle"));
            this.queryDialog.setHeight(320);
            this.queryDialog.setWidth(586);
            this.queryDialog.setProcessor((IProcessor)this.getQueryProcessor("query"));
            if (this.queryDialog.getWindow() == null) {
                this.queryDialog.init();
            }
            this.queryDialog.getCommonQueryParam().setDirty(false);
            this.queryDialog.getCommonqueryPanel().disVisiableRowCount();
        }
        return this.queryDialog;
    }

    private CommonQueryDialog getERecQueryDialog() throws Exception {
        if (this.erecQueryDialog == null) {
            IMetaDataPK mockQuery = this.erecQueryPK;
            this.erecQueryDialog = new CommonQueryDialog();
            this.erecQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.erecQueryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.erecQueryDialog.setShowFilter(true);
            this.erecQueryDialog.setShowSorter(false);
            this.erecQueryDialog.setQueryObjectPK(mockQuery);
            this.erecQueryDialog.setTitle("\u94f6\u884c\u7535\u5b50\u56de\u5355\u67e5\u8be2");
            this.erecQueryDialog.setHeight(320);
            this.erecQueryDialog.setWidth(450);
            if (this.erecQueryDialog.getWindow() == null) {
                this.erecQueryDialog.init();
            }
            this.erecQueryDialog.getCommonQueryParam().setDirty(false);
            this.erecQueryDialog.getCommonqueryPanel().disVisiableRowCount();
        }
        return this.erecQueryDialog;
    }

    private CommonQueryDialog getDetailQueryDialog() throws Exception {
        if (this.detailQueryDialog == null) {
            IMetaDataPK mockQuery = this.detailQueryPK;
            this.detailQueryDialog = new CommonQueryDialog();
            this.detailQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.detailQueryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.detailQueryDialog.setShowFilter(true);
            this.detailQueryDialog.setShowSorter(false);
            this.detailQueryDialog.setQueryObjectPK(mockQuery);
            this.detailQueryDialog.setTitle("\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2");
            this.detailQueryDialog.setHeight(320);
            this.detailQueryDialog.setWidth(450);
            if (this.detailQueryDialog.getWindow() == null) {
                this.detailQueryDialog.init();
            }
            this.detailQueryDialog.getCommonQueryParam().setDirty(false);
            this.detailQueryDialog.getCommonqueryPanel().disVisiableRowCount();
        }
        return this.detailQueryDialog;
    }

    protected CommonQueryProcessor getQueryProcessor(String filterName) {
        return new ERecDetailQueryProcessor((IUIObject)this, filterName);
    }

    protected void initTable() {
        this.tblERec.checkParsed();
        this.tblDetail.checkParsed();
        this.tblDetail.getStyleAttributes().setLocked(true);
        this.tblERec.getStyleAttributes().setLocked(true);
        this.tblERec.getSelectManager().setSelectMode(10);
        this.tblDetail.getSelectManager().setSelectMode(10);
        this.tblERec.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    ERecDetailMatchUI.this.erecSelect_tableClicked(e);
                }
                catch (Exception exc) {
                    ERecDetailMatchUI.this.handUIException(exc);
                }
            }
        });
        this.tblDetail.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    ERecDetailMatchUI.this.detailSelect_tableClicked(e);
                }
                catch (Exception exc) {
                    ERecDetailMatchUI.this.handUIException(exc);
                }
            }
        });
        this.tblERec.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                ERecDetailMatchUI.this.afterFillERecTable(e);
            }
        });
        this.tblDetail.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                ERecDetailMatchUI.this.afterFillDetailTable(e);
            }
        });
        this.splitRD.setDividerLocation(this.getHeight() / 2 + 50);
    }

    public void erecSelect_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            if (this.tblERec.getColumn(e.getColIndex()).getKey() != null && this.tblERec.getColumn(e.getColIndex()).getKey().equals(SELECT) && !this.erecSelect) {
                this.selectERecAll();
                this.erecSelect = true;
            } else if (this.tblERec.getColumn(e.getColIndex()).getKey() != null && this.tblERec.getColumn(e.getColIndex()).getKey().equals(SELECT) && this.erecSelect) {
                this.clearERecAll();
                this.erecSelect = false;
            }
        } else if (e.getType() == 1) {
            // empty if block
        }
    }

    public void detailSelect_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            if (this.tblDetail.getColumn(e.getColIndex()).getKey() != null && this.tblDetail.getColumn(e.getColIndex()).getKey().equals(SELECT) && !this.detailSelect) {
                this.selectDetailAll();
                this.detailSelect = true;
            } else if (this.tblDetail.getColumn(e.getColIndex()).getKey() != null && this.tblDetail.getColumn(e.getColIndex()).getKey().equals(SELECT) && this.detailSelect) {
                this.clearDetailAll();
                this.detailSelect = false;
            }
        } else if (e.getType() == 1) {
            // empty if block
        }
    }

    protected void afterFillERecTable(KDTDataRequestEvent e) {
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        IRow row = null;
        for (int i = firstRow; i <= lastRow; ++i) {
            row = this.tblERec.getRow(i);
            row.getCell(SELECT).setValue((Object)false);
        }
        this.tblDetail.getColumn("creditAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)this.scale));
        this.tblDetail.getColumn("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblDetail.getColumn("debitAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)this.scale));
        this.tblDetail.getColumn("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected void afterFillDetailTable(KDTDataRequestEvent e) {
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        IRow row = null;
        for (int i = firstRow; i <= lastRow; ++i) {
            row = this.tblDetail.getRow(i);
            row.getCell(SELECT).setValue((Object)false);
        }
        this.tblDetail.getColumn("creditAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)this.scale));
        this.tblDetail.getColumn("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblDetail.getColumn("debitAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)this.scale));
        this.tblDetail.getColumn("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void initUI() throws EASBizException, BOSException {
        String end;
        String start;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (!EmptyUtil.isEmpty((Object)this.filterParam.getStartTransDate()) && !EmptyUtil.isEmpty((Object)this.filterParam.getEndTransDate())) {
            start = df.format(this.filterParam.getStartTransDate());
            end = df.format(this.filterParam.getEndTransDate());
            this.txtTransDetailDate.setText(start + EASResource.getString((String)resourcePath, (String)"1_To") + end);
        }
        if (!EmptyUtil.isEmpty((Object)this.filterParam.getStartTransDate()) && !EmptyUtil.isEmpty((Object)this.filterParam.getEndTransDate())) {
            start = df.format(this.filterParam.getStartTransDate());
            end = df.format(this.filterParam.getEndTransDate());
            this.txtRecBizDate.setText(start + EASResource.getString((String)resourcePath, (String)"1_To") + end);
        }
    }

    @Override
    protected void tblDetail_tableClicked(KDTMouseEvent e) throws Exception {
        int column;
        int selectColumn = this.tblDetail.getSelectManager().getActiveColumnIndex();
        if (selectColumn != (column = this.tblDetail.getColumnIndex(SELECT))) {
            return;
        }
        int activeRowIndex = this.tblDetail.getSelectManager().getActiveRowIndex();
        IRow row = this.tblDetail.getRow(activeRowIndex);
        boolean isSelected = (Boolean)row.getCell(SELECT).getValue();
        row.getCell(SELECT).setValue((Object)new Boolean(!isSelected));
        this.calDetailAmt(true, row, !isSelected);
    }

    @Override
    protected void tblERec_tableClicked(KDTMouseEvent e) throws Exception {
        int column;
        int selectColumn = this.tblERec.getSelectManager().getActiveColumnIndex();
        if (selectColumn != (column = this.tblERec.getColumnIndex(SELECT))) {
            if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
                EReceiptInfo info;
                if (e.getType() == 0) {
                    return;
                }
                if (this.tblERec.getRowCount() == 0 || this.tblERec.getSelectManager().size() == 0) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                    SysUtil.abort();
                }
                int activeRowIndex = this.tblERec.getSelectManager().getActiveRowIndex();
                IRow row = this.tblERec.getRow(activeRowIndex);
                String erecBillId = (String)row.getCell("id").getValue();
                ArrayList<String> idList = new ArrayList<String>();
                idList.add(erecBillId);
                EntityViewInfo View = new EntityViewInfo();
                SelectorItemCollection Sic = new SelectorItemCollection();
                Sic.add(new SelectorItemInfo("*"));
                View.setSelector(Sic);
                EReceiptStorageSettingCollection colls = EReceiptStorageSettingFactory.getRemoteInstance().getEReceiptStorageSettingCollection(View);
                EReceiptStorageSettingInfo settinginfo = colls.get(0);
                EntityViewInfo erview = new EntityViewInfo();
                FilterInfo erfilter = new FilterInfo();
                erfilter.getFilterItems().add(new FilterItemInfo("id", idList.get(0), CompareType.EQUALS));
                erview.setFilter(erfilter);
                SelectorItemCollection ersic = new SelectorItemCollection();
                ersic.add(new SelectorItemInfo("isInnerEReceipt"));
                ersic.add(new SelectorItemInfo("fileSource"));
                erview.setSelector(ersic);
                EReceiptCollection coll = EReceiptFactory.getRemoteInstance().getEReceiptCollection(erview);
                if (coll.size() > 0 && Integer.parseInt((info = coll.get(0)).getFileSource()) != 0 && ((Integer.parseInt(info.getFileSource()) == 1 || Integer.parseInt(info.getFileSource()) == 2) && (settinginfo.getStorageType().getValue() == 2 || settinginfo.getStorageType().getValue() == 3) || Integer.parseInt(info.getFileSource()) == 4 && settinginfo.getStorageType().getValue() != 3)) {
                    String exMsg = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1198_EReceiptListUI");
                    MsgBox.showWarning((String)exMsg);
                    SysUtil.abort();
                }
                EReceiptClientHelper.viewEReceiptByIdList(idList, (Component)((Object)this));
            }
        } else {
            int activeRowIndex = this.tblERec.getSelectManager().getActiveRowIndex();
            IRow row = this.tblERec.getRow(activeRowIndex);
            boolean isSelected = (Boolean)row.getCell(SELECT).getValue();
            row.getCell(SELECT).setValue((Object)new Boolean(!isSelected));
            this.calERecAmt(true, row, !isSelected);
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblERec.getRowCount() > 0 && this.tblERec.getSelectManager().size() > 0 && this.tblDetail.getRowCount() > 0 && this.tblDetail.getSelectManager().size() > 0) {
            this.selectAll();
        } else if (this.tblERec.getRowCount() > 0 && this.tblERec.getSelectManager().size() > 0) {
            this.selectERecAll();
        } else if (this.tblDetail.getRowCount() > 0 && this.tblDetail.getSelectManager().size() > 0) {
            this.selectDetailAll();
        } else {
            this.selectAll();
        }
    }

    private void selectAll() {
        this.selectERecAll();
        this.selectDetailAll();
    }

    private void selectERecAll() {
        int recRowCount = this.tblERec.getRowCount3();
        for (int i = 0; i < recRowCount; ++i) {
            if (this.tblERec.getRow2(i) == null) continue;
            this.tblERec.getRow2(i).getCell(SELECT).setValue((Object)Boolean.TRUE);
        }
        if (this.erecDebitTotalAmt.compareTo(BigDecimal.ZERO) == 0 && this.erecCreditTotalAmt.compareTo(BigDecimal.ZERO) == 0) {
            this.erecDebitTotalAmt = this.getPageTotalAmt(this.tblERec, this.tblERec.getColumnIndex("debitAmount"));
            this.erecCreditTotalAmt = this.getPageTotalAmt(this.tblERec, this.tblERec.getColumnIndex("creditAmount"));
        }
        this.erecDebitAmt = this.erecDebitTotalAmt;
        this.erecCreditAmt = this.erecCreditTotalAmt;
        this.calERecAmt(false, null, false);
    }

    private void selectDetailAll() {
        int delRowCount = this.tblDetail.getRowCount3();
        for (int i = 0; i < delRowCount; ++i) {
            if (this.tblDetail.getRow2(i) == null) continue;
            this.tblDetail.getRow2(i).getCell(SELECT).setValue((Object)Boolean.TRUE);
        }
        if (this.detailDebitTotalAmt.compareTo(BigDecimal.ZERO) == 0 && this.detailCreditTotalAmt.compareTo(BigDecimal.ZERO) == 0) {
            this.detailDebitTotalAmt = this.getPageTotalAmt(this.tblDetail, this.tblDetail.getColumnIndex("debitAmount"));
            this.detailCreditTotalAmt = this.getPageTotalAmt(this.tblDetail, this.tblDetail.getColumnIndex("creditAmount"));
        }
        this.detailDebitAmt = this.detailDebitTotalAmt;
        this.detailCreditAmt = this.detailCreditTotalAmt;
        this.calDetailAmt(false, null, false);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.clearERecAll();
        this.clearDetailAll();
    }

    private void clearERecAll() {
        int erecRowCount = this.tblERec.getRowCount3();
        for (int i = 0; i < erecRowCount; ++i) {
            if (this.tblERec.getRow2(i) == null) continue;
            this.tblERec.getRow2(i).getCell(SELECT).setValue((Object)Boolean.FALSE);
        }
        this.erecDebitAmt = BigDecimal.ZERO;
        this.erecCreditAmt = BigDecimal.ZERO;
        this.calERecAmt(false, null, false);
    }

    private void clearDetailAll() {
        int detailRowCount = this.tblDetail.getRowCount3();
        for (int i = 0; i < detailRowCount; ++i) {
            if (this.tblDetail.getRow2(i) == null) continue;
            this.tblDetail.getRow2(i).getCell(SELECT).setValue((Object)Boolean.FALSE);
        }
        this.detailDebitAmt = BigDecimal.ZERO;
        this.detailCreditAmt = BigDecimal.ZERO;
        this.calDetailAmt(false, null, false);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getQueryDialog().show()) {
            SysUtil.abort();
        }
        this.handlerRecDetailEntityView();
        this.refresh();
        this.initUI();
    }

    @Override
    public void actionERecQuery_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getERecQueryDialog().show()) {
            SysUtil.abort();
        }
        this.handlerERecEntityView();
        this.refreshERecTable();
        this.erecDebitAmt = BigDecimal.ZERO;
        this.erecCreditAmt = BigDecimal.ZERO;
        this.erecDebitTotalAmt = BigDecimal.ZERO;
        this.erecCreditTotalAmt = BigDecimal.ZERO;
        this.calERecAmt(false, null, false);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (!EmptyUtil.isEmpty((Object)this.filterParam.getStartTransDate()) && !EmptyUtil.isEmpty((Object)this.filterParam.getEndTransDate())) {
            String start = df.format(this.filterParam.getStartTransDate());
            String end = df.format(this.filterParam.getEndTransDate());
            this.txtRecBizDate.setText(start + EASResource.getString((String)resourcePath, (String)"1_To") + end);
        }
    }

    @Override
    public void actionDetailQuery_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getDetailQueryDialog().show()) {
            SysUtil.abort();
        }
        this.handlerDetailEntityView();
        this.refreshDetailTable();
        this.detailDebitAmt = BigDecimal.ZERO;
        this.detailCreditAmt = BigDecimal.ZERO;
        this.detailDebitTotalAmt = BigDecimal.ZERO;
        this.detailCreditTotalAmt = BigDecimal.ZERO;
        this.calDetailAmt(false, null, false);
    }

    private void refresh() throws BOSException {
        this.refreshERecTable();
        this.refreshDetailTable();
        this.initAmt();
    }

    private void refreshERecTable() throws BOSException {
        this.tblERec.repaint();
        this.tblERec.removeRows();
    }

    private void refreshDetailTable() throws BOSException {
        this.tblDetail.repaint();
        this.tblDetail.removeRows();
    }

    private void initAmt() {
        this.erecDebitAmt = BigDecimal.ZERO;
        this.erecCreditAmt = BigDecimal.ZERO;
        this.detailDebitAmt = BigDecimal.ZERO;
        this.detailCreditAmt = BigDecimal.ZERO;
        this.erecDebitTotalAmt = BigDecimal.ZERO;
        this.erecCreditTotalAmt = BigDecimal.ZERO;
        this.detailDebitTotalAmt = BigDecimal.ZERO;
        this.detailCreditTotalAmt = BigDecimal.ZERO;
        this.calERecAmt(false, null, false);
        this.calDetailAmt(false, null, false);
    }

    private void calERecAmt(boolean noCal, IRow row, boolean select) {
        if (noCal && row != null) {
            if (select) {
                this.erecDebitAmt = FMHelper.add((BigDecimal)this.erecDebitAmt, (BigDecimal)((BigDecimal)row.getCell("debitAmount").getValue()));
                this.erecCreditAmt = FMHelper.add((BigDecimal)this.erecCreditAmt, (BigDecimal)((BigDecimal)row.getCell("creditAmount").getValue()));
            } else {
                this.erecDebitAmt = FMHelper.subtract((BigDecimal)this.erecDebitAmt, (BigDecimal)((BigDecimal)row.getCell("debitAmount").getValue()));
                this.erecCreditAmt = FMHelper.subtract((BigDecimal)this.erecCreditAmt, (BigDecimal)((BigDecimal)row.getCell("creditAmount").getValue()));
            }
        }
        String msgStr = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"3_ERecTitle"), ClientUtils.formatDecimal((BigDecimal)this.erecDebitAmt.setScale(this.scale, 4)), ClientUtils.formatDecimal((BigDecimal)this.erecCreditAmt.setScale(this.scale, 4)));
        this.contERec.setTitle(msgStr);
    }

    private void calDetailAmt(boolean noCal, IRow row, boolean select) {
        if (noCal && row != null) {
            if (select) {
                this.detailDebitAmt = FMHelper.add((BigDecimal)this.detailDebitAmt, (BigDecimal)((BigDecimal)row.getCell("debitAmount").getValue()));
                this.detailCreditAmt = FMHelper.add((BigDecimal)this.detailCreditAmt, (BigDecimal)((BigDecimal)row.getCell("creditAmount").getValue()));
            } else {
                this.detailDebitAmt = FMHelper.subtract((BigDecimal)this.detailDebitAmt, (BigDecimal)((BigDecimal)row.getCell("debitAmount").getValue()));
                this.detailCreditAmt = FMHelper.subtract((BigDecimal)this.detailCreditAmt, (BigDecimal)((BigDecimal)row.getCell("creditAmount").getValue()));
            }
        }
        String msgStr = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"4_DetailTitle"), ClientUtils.formatDecimal((BigDecimal)this.detailDebitAmt.setScale(this.scale, 4)), ClientUtils.formatDecimal((BigDecimal)this.detailCreditAmt.setScale(this.scale, 4)));
        this.contDetail.setTitle(msgStr);
    }

    private BigDecimal getPageTotalAmt(KDTable table, int colIndex) {
        BigDecimal result = new BigDecimal(0.0);
        int rowCount = table.getRowCount3();
        for (int r = 0; r < rowCount; ++r) {
            Object value;
            ICell cell = table.getCell(r, colIndex);
            Object object = value = cell == null ? null : cell.getValue();
            if (value == null || !(value instanceof Number)) continue;
            result = value instanceof BigDecimal ? result.add((BigDecimal)value) : result.add(new BigDecimal(((Number)value).doubleValue()));
        }
        return result;
    }

    @Override
    public void actionShowErecPDF_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        for (int rowIndex = 0; rowIndex < this.tblERec.getRowCount3(); ++rowIndex) {
            IRow row = this.tblERec.getRow(rowIndex);
            if (!((Boolean)row.getCell(SELECT).getValue()).booleanValue()) continue;
            String id = row.getCell("id").getValue().toString();
            idList.add(id);
        }
        if (EmptyUtil.isEmpty(idList) || idList.size() > 1 || idList.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"5_viewSelect"));
            SysUtil.abort();
        }
        EReceiptClientHelper.viewEReceiptByIdList(idList, (Component)((Object)this));
    }

    @Override
    public void actionMatch_actionPerformed(ActionEvent e) throws Exception {
        ICell idCell;
        int rowIndex;
        ArrayList<String> erecIdList = new ArrayList<String>();
        ArrayList<String> detailIdList = new ArrayList<String>();
        int erecCount = this.tblERec.getRowCount3();
        for (rowIndex = 0; rowIndex < erecCount; ++rowIndex) {
            Object erecId;
            if (!((Boolean)this.tblERec.getCell(rowIndex, SELECT).getValue()).booleanValue()) continue;
            idCell = this.tblERec.getCell(rowIndex, "id");
            Object object = erecId = idCell == null ? null : idCell.getValue();
            if (erecId == null) continue;
            erecIdList.add(erecId.toString());
        }
        int detailCount = this.tblDetail.getRowCount3();
        for (rowIndex = 0; rowIndex < detailCount; ++rowIndex) {
            Object detailId;
            if (!((Boolean)this.tblDetail.getCell(rowIndex, SELECT).getValue()).booleanValue()) continue;
            idCell = this.tblDetail.getCell(rowIndex, "id");
            Object object = detailId = idCell == null ? null : idCell.getValue();
            if (detailId == null) continue;
            detailIdList.add(detailId.toString());
        }
        if (erecIdList.size() == 0 || detailIdList.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"6_erecDetailSelect"));
            SysUtil.abort();
        } else if (erecIdList.size() == 1 && detailIdList.size() == 1) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("bankAccount.bankAccountNumber"));
            selector.add(new SelectorItemInfo("company.id"));
            selector.add(new SelectorItemInfo("currency.id"));
            EReceiptInfo ereceiptInfo = EReceiptFactory.getRemoteInstance().getEReceiptInfo((IObjectPK)new ObjectUuidPK(((String)erecIdList.get(0)).toString()), selector);
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("bankAccount.bankAccountNumber"));
            selector.add(new SelectorItemInfo("bankAccount.bank"));
            selector.add(new SelectorItemInfo("company.id"));
            selector.add(new SelectorItemInfo("currency.id"));
            TransDetailInfo detailInfo = TransDetailFactory.getRemoteInstance().getTransDetailInfo((IObjectPK)new ObjectUuidPK(((String)detailIdList.get(0)).toString()), selector);
            if (!ereceiptInfo.getIsMatch().equals((Object)EReceiptIsMatchEnum.UnMatch) || !detailInfo.getIsMatchEReceipt().equals((Object)EReceiptIsMatchEnum.UnMatch)) {
                MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"7_unMatchSelect"));
                SysUtil.abort();
            } else if (ereceiptInfo.getDetailNo() != null && detailInfo.getReceiptNo() != null && ereceiptInfo.getDetailNo().equals(detailInfo.getReceiptNo())) {
                Map returnMap = ERecDetailMatchFacadeFactory.getRemoteInstance().erecDetailMatch(ereceiptInfo, detailInfo, EReceiptIsMatchEnum.AutoMatic);
                if (Constants.ONE.equals(returnMap.get("manualSuccessCount"))) {
                    MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"15_codeMatchOne"));
                    this.refresh();
                } else {
                    MsgBox.showInfo((String)((String)returnMap.get("errorMsg")));
                    SysUtil.abort();
                }
            } else {
                CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                int days = ContextHelperFactory.getRemoteInstance().getIntParam("EREC003", (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()));
                if (days > 10) {
                    days = 10;
                }
                GregorianCalendar cal = new GregorianCalendar();
                boolean isBizDateMatch = true;
                if (days == 0) {
                    if (!ereceiptInfo.getTransDate().equals(detailInfo.getBizDate())) {
                        isBizDateMatch = false;
                    }
                } else {
                    cal.setTime(ereceiptInfo.getTransDate());
                    ((Calendar)cal).add(5, -days);
                    Date beginDate = cal.getTime();
                    cal.setTime(ereceiptInfo.getTransDate());
                    ((Calendar)cal).add(5, days);
                    Date lastDate = cal.getTime();
                    if (detailInfo.getBizDate().before(beginDate) || detailInfo.getBizDate().after(lastDate)) {
                        isBizDateMatch = false;
                    }
                }
                if (isBizDateMatch && ereceiptInfo.getBankNumber().equals(detailInfo.getBankAccount().getBankAccountNumber())) {
                    if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"8_confirmMatch")) == 0) {
                        Map resultmap = ERecDetailMatchFacadeFactory.getRemoteInstance().erecDetailMatch(ereceiptInfo, detailInfo, EReceiptIsMatchEnum.manual);
                        if (resultmap.get("manualSuccessCount") != null) {
                            int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"12_matchResult", (Object[])new Object[]{0, 1}));
                            if (result == 0) {
                                EDMatchResultCollection edMatchColl = (EDMatchResultCollection)((Object)resultmap.get("matchResultColl"));
                                this.showManualMatchResult(edMatchColl);
                            }
                        } else {
                            MsgBox.showInfo((String)((String)resultmap.get("errorMsg")));
                            SysUtil.abort();
                        }
                    }
                } else if (days == 0) {
                    MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"9_cannotMatch"));
                    SysUtil.abort();
                } else {
                    MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"18_cannotMatch", (Object[])new Object[]{days}));
                    SysUtil.abort();
                }
            }
        } else if (erecIdList.size() >= 1 && detailIdList.size() >= 1) {
            Map resultmap = ERecDetailMatchFacadeFactory.getRemoteInstance().erecDetailMatchBatch(erecIdList, detailIdList);
            if (resultmap.get("noMatch") != null) {
                MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"13_matchAction"));
                SysUtil.abort();
            } else if (!EmptyUtil.isEmpty((AbstractObjectCollection)((EDMatchResultCollection)((Object)resultmap.get("matchResultColl"))))) {
                int matchCodeSucCount = (Integer)resultmap.get("matchCodeSucCount");
                int manualSuccessCount = (Integer)resultmap.get("manualSuccessCount");
                int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"12_matchResult", (Object[])new Object[]{matchCodeSucCount, manualSuccessCount}));
                if (result == 0 && resultmap.get("matchResultColl") != null) {
                    EDMatchResultCollection edMatchColl = (EDMatchResultCollection)((Object)resultmap.get("matchResultColl"));
                    this.showManualMatchResult(edMatchColl);
                    this.refresh();
                }
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"12_matchResult", (Object[])new String[]{"0", "0"}));
            }
        }
    }

    private void showManualMatchResult(EDMatchResultCollection matchResultColl) throws EASBizException, BOSException {
        HashSet<String> keySet = new HashSet<String>();
        for (int index = 0; matchResultColl != null && index < matchResultColl.size(); ++index) {
            keySet.add(matchResultColl.get(index).getKey());
        }
        ERecDetailMatchResultUI.showMatchResultUI((CoreUIObject)this, keySet);
    }

    private void showManualMatchResult(UIContext UIContext2, EDMatchResultCollection matchResultColl) throws EASBizException, BOSException {
        HashSet<String> keySet = new HashSet<String>();
        for (int index = 0; matchResultColl != null && index < matchResultColl.size(); ++index) {
            keySet.add(matchResultColl.get(index).getKey());
        }
        try {
            ERecDetailMatchResultUI.showMatchResultUI((CoreUIObject)this, UIContext2, keySet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionQueryMatchResult_actionPerformed(ActionEvent e) throws Exception {
        ERecDetailMatchFilterParam param = (ERecDetailMatchFilterParam)this.filterUI.getParam();
        UIContext uiContext = new UIContext((Object)this.ui);
        uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
        uiContext.put((Object)"filterParam", (Object)param);
        this.showManualMatchResult(uiContext, null);
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }
}

