/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.client.EReceiptNoteHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.erec.client.EReceiptViewDataProvider;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.fs.TransDownBillEntryCollection;
import com.kingdee.eas.fm.fs.TransDownBillEntryFactory;
import com.kingdee.eas.fm.fs.TransDownBillEntryInfo;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillEntryCollection;
import com.kingdee.eas.fm.fs.TransUpBillEntryFactory;
import com.kingdee.eas.fm.fs.TransUpBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class EReceiptInnerClientHelper {
    private static PrintInnerListener printInnerActionListener = null;
    private static final String resourcePath = "com.kingdee.eas.fm.erec.ERecResources";

    protected static List getErecList(List idList, boolean param, boolean print) throws Exception {
        ArrayList<String> erecList = new ArrayList<String>();
        if (idList.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)idList), CompareType.INCLUDE));
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("company"));
            view.getSelector().add(new SelectorItemInfo("PrintCount"));
            view.getSelector().add(new SelectorItemInfo("filename"));
            view.getSelector().add(new SelectorItemInfo("fileSource"));
            view.setFilter(fi);
            EReceiptCollection colInfo = EReceiptFactory.getRemoteInstance().getEReceiptCollection(view);
            if (print) {
                for (int i = 0; i < colInfo.size(); ++i) {
                    EReceiptInfo erInfo = colInfo.get(i);
                    if (erInfo.getFileSource() == "3" || (!param || erInfo.getPrintCount() != 0) && param) continue;
                    erecList.add(erInfo.getId().toString());
                }
            } else {
                EReceiptInfo erInfo = colInfo.get(0);
                if (erInfo.getFileSource() == "3") {
                    MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"35_ereceipFile", (Object[])new Object[]{erInfo.getFileName()}));
                    SysUtil.abort();
                } else {
                    erecList.add(erInfo.getId().toString());
                }
            }
        }
        return erecList;
    }

    protected static String getTDFileName() {
        return "/FM/BE/ERECEIPT";
    }

    public static void viewInnerEReceiptByIdList(List idList, Component ui, boolean flag) throws Exception {
        EReceiptInnerClientHelper.invokeMultiPrintInnerEReceiptFunction(idList, ui, false, flag);
    }

    public static void printInnerEReceiptByIdList(List idList, Component ui, boolean flag) throws Exception {
        EReceiptInnerClientHelper.invokeMultiPrintInnerEReceiptFunction(idList, ui, true, flag);
    }

    protected static void invokeMultiPrintInnerEReceiptFunction(List idList, Component ui, boolean print, boolean flag) throws Exception {
        if (idList == null || idList.size() == 0) {
            return;
        }
        EReceiptViewDataProvider provider = new EReceiptViewDataProvider(idList, print);
        EReceiptNoteHelper tpHelper = new EReceiptNoteHelper();
        printInnerActionListener = new PrintInnerListener(idList, print, flag);
        tpHelper.addKDNoteActionListener((IPrintActionListener)printInnerActionListener);
        if (print) {
            tpHelper.print(EReceiptInnerClientHelper.getTDFileName(), (Object)provider, (Component)SwingUtilities.getWindowAncestor(ui));
        } else {
            tpHelper.printPreview(EReceiptInnerClientHelper.getTDFileName(), (Object)provider, (Component)SwingUtilities.getWindowAncestor(ui));
        }
    }

    public static void viewInnerEreceiptByBillIdList(List billIdList, Component ui) throws Exception {
        EReceiptInnerClientHelper.viewInnerEreceipt(billIdList, ui, "billId", false);
    }

    public static void viewInnerEreceiptBySubsIdList(List billIdList, Component ui) throws Exception {
        EReceiptInnerClientHelper.viewInnerEreceipt(billIdList, ui, "id", true);
    }

    public static String changeTransBillId(List billIdList) throws EASBizException, BOSException {
        TransDownBillEntryCollection coll;
        String id = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)FMHelper.list2Set((List)billIdList), CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setFilter(filter);
        view.setSelector(sic);
        if (BOSUuid.read((String)billIdList.get(0).toString()).getType().equals((Object)new TransUpBillInfo().getBOSType())) {
            TransUpBillEntryCollection coll2 = TransUpBillEntryFactory.getRemoteInstance().getTransUpBillEntryCollection(view);
            if (coll2.size() > 0) {
                TransUpBillEntryInfo info = coll2.get(0);
                id = info.getId().toString();
            }
        } else if (BOSUuid.read((String)billIdList.get(0).toString()).getType().equals((Object)new TransDownBillInfo().getBOSType()) && (coll = TransDownBillEntryFactory.getRemoteInstance().getTransDownBillEntryCollection(view)).size() > 0) {
            TransDownBillEntryInfo info = coll.get(0);
            id = info.getId().toString();
        }
        return id;
    }

    protected static void viewInnerEreceipt(List billIdList, Component ui, String field, boolean flag) throws Exception {
        String id = EReceiptInnerClientHelper.changeTransBillId(billIdList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (id != null) {
            filter.getFilterItems().add(new FilterItemInfo(field, (Object)id, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo(field, (Object)FMHelper.list2Set((List)billIdList), CompareType.INCLUDE));
        }
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("innerEReceiptId"));
        view.setSelector(sic);
        SubsidiaryLedgerCollection coll = SubsidiaryLedgerFactory.getRemoteInstance().getSubsidiaryLedgerCollection(view);
        ArrayList<String> idList = new ArrayList<String>();
        if (coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                SubsidiaryLedgerInfo info = coll.get(i);
                if (info.getInnerEReceiptId() == null) continue;
                idList.add(info.getInnerEReceiptId().toString());
            }
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"33_noSubsidiary"));
            SysUtil.abort();
        }
        if (idList.size() > 0) {
            EReceiptInnerClientHelper.invokeMultiPrintInnerEReceiptFunction(idList, ui, false, flag);
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"34_noInnerEreceipt"));
            SysUtil.abort();
        }
    }

    static class PrintInnerListener
    implements IPrintActionListener {
        private List printList = null;
        private boolean print = false;
        private boolean flag = true;

        public PrintInnerListener(List printList, boolean print, boolean flag) {
            this.printList = printList;
            this.print = print;
            this.flag = flag;
        }

        public void beforePrintOrPreview() {
        }

        public void beforePreview() {
        }

        public void beforePrint() {
            if (!this.print && this.printList.size() > 0) {
                try {
                    this.printList = EReceiptInnerClientHelper.getErecList(this.printList, false, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                if (this.printList.size() > 0) {
                    EReceiptFactory.getRemoteInstance().updateInnerPrintCount(this.printList, this.flag);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void closePreview() {
        }
    }
}

