/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.attachment.AttachmentSecurityFactory;
import com.kingdee.eas.base.attachment.IAttachmentSecurity;
import com.kingdee.eas.base.attachment.security.PlainFileInfo;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.core.client.f7.F7ContextInitializationHelper;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.erec.client.AbstractImportEReceipt;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ImportEReceipt
extends AbstractImportEReceipt {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ImportEReceipt.class);
    private EReceiptCollection eReceiptCollection = new EReceiptCollection();
    private static boolean isSuccess = false;
    public CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() throws Exception {
        NewCompanyF7 selector = F7ContextInitializationHelper.getSelectCompany((IUIObject)this, null, null, (boolean)false);
        this.prmtCompany.setSelector((KDPromptSelector)selector);
        this.prmtCompany.setValue((Object)this.currentCompany);
        this.prmtCompany.setRequired(true);
        this.prmtBankAccount.setRequired(true);
        this.initAccountBankEvi();
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        this.prmtBankAccount.setData(null);
        this.initAccountBankEvi();
    }

    @Override
    protected void prmtBankAccount_willShow(SelectorEvent e) throws Exception {
        this.initAccountBankEvi();
    }

    private void initAccountBankEvi() {
        String companyId;
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterInfo agencyCompanyFilter = new FilterInfo();
        if (this.prmtCompany.getData() != null && !EmptyUtil.isEmpty((String)(companyId = ((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString()))) {
            companyFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.INCLUDE));
            agencyCompanyFilter.getFilterItems().add(new FilterItemInfo("agencyCompany.id", (Object)companyId, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isEReceipt", (Object)new Integer(0)));
        try {
            companyFilter.mergeFilter(agencyCompanyFilter, "or");
            filterInfo.mergeFilter(companyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        this.prmtBankAccount.setSelectorCollection(selectors);
        this.prmtBankAccount.setEntityViewInfo(evi);
        this.prmtBankAccount.getQueryAgent().resetRuntimeEntityView();
        this.prmtBankAccount.setEnabledMultiSelection(false);
    }

    @Override
    protected void prmtBankAccount_dataChanged(DataChangeEvent e) throws Exception {
        if (EmptyUtil.isEmpty((Object)this.prmtCompany.getData()) && !EmptyUtil.isEmpty((Object)this.prmtBankAccount.getData())) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(((AccountBankInfo)this.prmtBankAccount.getData()).getCompany().getId()));
            this.prmtCompany.setDataNoNotify((Object)company);
        }
    }

    @Override
    protected void btnImport_actionPerformed(ActionEvent e) throws Exception {
        String[] filePaths = this.getFilePath();
        if (filePaths != null && filePaths.length > 0) {
            this.setFile(filePaths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getFilePath() throws IOException {
        int i;
        KDFileChooser choose = new KDFileChooser();
        choose.setMultiSelectionEnabled(true);
        ArrayList<String> fileList = new ArrayList<String>();
        int rVal = choose.showOpenDialog((Component)((Object)this));
        if (rVal == 0) {
            File[] files = choose.getSelectedFiles();
            if (files != null && files.length > 100) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.erec.ERECAutoGenerateResource", (String)"0_ImportEReceipt"));
                SysUtil.abort();
            }
            for (i = 0; i < files.length; ++i) {
                if (!files[i].exists()) {
                    MsgBox.showInfo((String)Resrcs.getString((String)"FileNotExisted"));
                    SysUtil.abort();
                    break;
                }
                String filePath = files[i].getPath();
                if (filePath == null || !filePath.toLowerCase(Locale.ENGLISH).endsWith(".pdf") && !filePath.toLowerCase(Locale.ENGLISH).endsWith(".jpg") && !filePath.toLowerCase(Locale.ENGLISH).endsWith(".ofd")) {
                    filePath = "";
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.erec.ERECAutoGenerateResource", (String)"1_ImportEReceipt"));
                    SysUtil.abort();
                    break;
                }
                fileList.add(filePath);
                FileInputStream fis = new FileInputStream(filePath);
                try {
                    byte[] buffer = new byte[8];
                    int bytesRead = ((InputStream)fis).read(buffer);
                    StringBuilder header = new StringBuilder();
                    for (int j = 0; j < bytesRead; ++j) {
                        header.append(String.format("%02X", buffer[j]));
                    }
                    System.out.println("File Header: " + header);
                    if (header != null && header.indexOf("504B030414000000") <= -1 && header.indexOf("FFD8FF") <= -1 && header.indexOf("255044462D312E") <= -1) {
                        filePath = "";
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.erec.ERECAutoGenerateResource", (String)"1_ImportEReceipt"));
                        SysUtil.abort();
                        break;
                    }
                    byte[] bty = this.toByteArray(fis);
                    if (bty == null || bty.length <= 0xA00000) continue;
                    filePath = "";
                    MsgBox.showInfo((String)"\u60a8\u63d0\u4ea4\u7684\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u4e8610M\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4");
                    SysUtil.abort();
                    break;
                }
                catch (Exception e) {
                    filePath = "";
                    MsgBox.showInfo((String)"\u60a8\u63d0\u4ea4\u7684\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u4e8610M\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4");
                    SysUtil.abort();
                    continue;
                }
                catch (Error e1) {
                    filePath = "";
                    MsgBox.showInfo((String)"\u60a8\u63d0\u4ea4\u7684\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u4e8610M\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4");
                    SysUtil.abort();
                    continue;
                }
                finally {
                    if (fis != null) {
                        try {
                            ((InputStream)fis).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    fis = null;
                }
            }
        }
        String[] filePaths = new String[fileList.size()];
        for (i = 0; i < fileList.size(); ++i) {
            filePaths[i] = (String)fileList.get(i);
        }
        return filePaths;
    }

    public void setFile(String[] filePaths) {
        for (int i = 0; i < filePaths.length; ++i) {
            String filePath = filePaths[i];
            EReceiptInfo info = new EReceiptInfo();
            try {
                FileInputStream fis = new FileInputStream(filePath);
                byte[] bty = this.toByteArray(fis);
                int index = filePath.lastIndexOf(File.separator);
                String filename = filePath.substring(index + 1).toLowerCase(Locale.ENGLISH);
                info.setFileValue(bty);
                info.setFileName(filename);
                ((InputStream)fis).close();
                this.eReceiptCollection.add(info);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                filePath = "";
                MsgBox.showInfo((String)"\u60a8\u63d0\u4ea4\u7684\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u4e8610M\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4");
                SysUtil.abort();
            }
        }
    }

    private byte[] toByteArray(InputStream fis) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while ((n = fis.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
        return out.toByteArray();
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getData();
        AccountBankInfo acctBankInfo = (AccountBankInfo)this.prmtBankAccount.getData();
        for (int i = 0; i < this.eReceiptCollection.size(); ++i) {
            EReceiptInfo eReceiptInfo = this.eReceiptCollection.get(i);
            eReceiptInfo.setCompany(companyInfo);
            eReceiptInfo.setBankAccount(acctBankInfo);
            eReceiptInfo.setBankNumber(acctBankInfo.getBankAccountNumber());
            eReceiptInfo.setTransDate((Date)this.pkTransDate.getSqlDate());
        }
        isSuccess = EReceiptFactory.getRemoteInstance().importEReceipt(this.eReceiptCollection);
        this.disposeUIWindow();
    }

    public void verify() throws Exception {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        if (this.prmtCompany.getValue() != null) {
            iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString()), "eReceipt_07Import");
        }
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtBankAccount);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkTransDate);
        IAttachmentSecurity securityCheck = AttachmentSecurityFactory.getInstance();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.eReceiptCollection)) {
            if (this.eReceiptCollection.size() > 100) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.erec.ERECAutoGenerateResource", (String)"0_ImportEReceipt"));
                SysUtil.abort();
            }
            for (int i = 0; i < this.eReceiptCollection.size(); ++i) {
                EReceiptInfo eReceiptInfo = this.eReceiptCollection.get(i);
                if (EmptyUtil.isEmpty((Object)eReceiptInfo.getFileValue())) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.erec.ERECAutoGenerateResource", (String)"2_ImportEReceipt"));
                    SysUtil.abort();
                }
                ByteArrayInputStream input = new ByteArrayInputStream(eReceiptInfo.getFileValue());
                PlainFileInfo plainInfo = new PlainFileInfo(eReceiptInfo.getFileName(), (InputStream)input);
                securityCheck.check(plainInfo);
            }
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.erec.ERECAutoGenerateResource", (String)"2_ImportEReceipt"));
            SysUtil.abort();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        isSuccess = false;
        super.disposeUIWindow();
    }

    public static boolean showPreInterestLoanUI(CoreUI ui) {
        try {
            UIContext uiContext = new UIContext((Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ImportEReceipt.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return isSuccess;
    }
}

