/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.AbstractBizCtrl;
import com.kingdee.bos.framework.ejb.EJBRemoteException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.ICreditLimitManager;
import com.kingdee.eas.fm.fin.app.CreditLimitManagerController;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.Map;

public class CreditLimitManager
extends AbstractBizCtrl
implements ICreditLimitManager {
    public CreditLimitManager() {
        this.registerInterface(ICreditLimitManager.class, this);
    }

    public CreditLimitManager(Context ctx) {
        super(ctx);
        this.registerInterface(ICreditLimitManager.class, this);
    }

    public BOSObjectType getType() {
        return new BOSObjectType("CF0BABBD");
    }

    private CreditLimitManagerController getController() throws BOSException {
        return (CreditLimitManagerController)this.getBizController();
    }

    @Override
    public void useLimit(BOSUuid creditLimitId, BigDecimal amount, BOSUuid companyId, BOSUuid finBillId, boolean isRepayment) throws BOSException, EASBizException {
        try {
            this.getController().useLimit(this.getContext(), creditLimitId, amount, companyId, finBillId, isRepayment);
        }
        catch (RemoteException err) {
            throw new EJBRemoteException((Throwable)err);
        }
    }

    @Override
    public void cancelLimit(BOSUuid billId, BOSUuid creditLimitId) throws BOSException, EASBizException {
        try {
            this.getController().cancelLimit(this.getContext(), billId, creditLimitId);
        }
        catch (RemoteException err) {
            throw new EJBRemoteException((Throwable)err);
        }
    }

    @Override
    public void useLimitByFinancingProduct(BOSUuid creditLimitID, BigDecimal amount, BOSUuid companyID, BOSUuid finbillID, boolean isRepayment, FinancingBillInfo financingBillInfo) throws BOSException, EASBizException {
        try {
            this.getController().useLimitByFinancingProduct(this.getContext(), creditLimitID, amount, companyID, finbillID, isRepayment, financingBillInfo);
        }
        catch (RemoteException err) {
            throw new EJBRemoteException((Throwable)err);
        }
    }

    @Override
    public void cancelLimitByFinancingProduct(BOSUuid billID, FinancingBillInfo finbill, BigDecimal returnAmt) throws BOSException, EASBizException {
        try {
            this.getController().cancelLimitByFinancingProduct(this.getContext(), billID, finbill, returnAmt);
        }
        catch (RemoteException err) {
            throw new EJBRemoteException((Throwable)err);
        }
    }

    @Override
    public Map getCreditEntryAfterRetore(BOSUuid billID, BOSUuid creditPK) throws BOSException, EASBizException {
        try {
            return this.getController().getCreditEntryAfterRetore(this.getContext(), billID, creditPK);
        }
        catch (RemoteException err) {
            throw new EJBRemoteException((Throwable)err);
        }
    }

    @Override
    public void useLimit(BOSUuid creditLimitId, BigDecimal amount, BOSUuid companyId, BOSUuid finBillId, boolean isRepayment, boolean isPayable) throws BOSException, EASBizException {
        try {
            this.getController().useLimit(this.getContext(), creditLimitId, amount, companyId, finBillId, isRepayment, isPayable);
        }
        catch (RemoteException err) {
            throw new EJBRemoteException((Throwable)err);
        }
    }

    @Override
    public void cancelLetterOfCreditLimitByFinancingProduct(BOSUuid billID, FinancingBillInfo finbill, BigDecimal returnAmt) throws BOSException, EASBizException {
        try {
            this.getController().cancelLetterOfCreditLimitByFinancingProduct(this.getContext(), billID, finbill, returnAmt);
        }
        catch (RemoteException err) {
            throw new EJBRemoteException((Throwable)err);
        }
    }

    @Override
    public void useLetterOfCreditLimitByFinancingProduct(BOSUuid creditLimitID, BigDecimal amount, BOSUuid companyID, BOSUuid finbillID, boolean isRepayment, FinancingBillInfo financingBillInfo) throws BOSException, EASBizException {
        try {
            this.getController().useLetterOfCreditLimitByFinancingProduct(this.getContext(), creditLimitID, amount, companyID, finbillID, isRepayment, financingBillInfo);
        }
        catch (RemoteException err) {
            throw new EJBRemoteException((Throwable)err);
        }
    }

    @Override
    public void useLetterLimit(BOSUuid creditLimitId, BigDecimal amount, BOSUuid companyId, BOSUuid finBillId, boolean isRepayment) throws BOSException, EASBizException {
        try {
            this.getController().useLetterLimit(this.getContext(), creditLimitId, amount, companyId, finBillId, isRepayment);
        }
        catch (RemoteException err) {
            throw new EJBRemoteException((Throwable)err);
        }
    }

    @Override
    public void cancelLetterLimit(BOSUuid billId, BOSUuid creditLimitId) throws BOSException, EASBizException {
        try {
            this.getController().cancelLetterLimit(this.getContext(), billId, creditLimitId);
        }
        catch (RemoteException err) {
            throw new EJBRemoteException((Throwable)err);
        }
    }
}

