/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowCollection;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowInfo;
import com.kingdee.eas.fm.mnt.IForecastedBlockingFlowGenerator;
import com.kingdee.eas.fm.mnt.SourceTypeEnum;

public class LCForecastedBlockingFlowGenerator
implements IForecastedBlockingFlowGenerator {
    public ForecastedBlockingFlowCollection genForecastedBlockingFlowColl(Context ctx, String billId) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("entrys.*");
        selectors.add("company.id");
        selectors.add("company.name");
        selectors.add("Institution.id");
        selectors.add("Institution.name");
        selectors.add("BlockFlowType.*");
        selectors.add("BlockFlowType.id");
        selectors.add("BlockFlowType.IsInFlow");
        LetterOfCreditInfo srcInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(billId), selectors);
        if (srcInfo.getBlockFlowType() == null || !FinUtils.dayAfterEquals(srcInfo.getExpiredDate(), DateUtil.getDayBegin())) {
            return new ForecastedBlockingFlowCollection();
        }
        ForecastedBlockingFlowCollection destColl = new ForecastedBlockingFlowCollection();
        String billTypeName = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityAlias(srcInfo.getId().toString());
        ForecastedBlockingFlowInfo destInfo = new ForecastedBlockingFlowInfo();
        destInfo.setNumber(srcInfo.getNumber());
        destInfo.setAmount(srcInfo.getAmount());
        destInfo.setOriginalAmount(srcInfo.getAmount());
        destInfo.setBillId(srcInfo.getId().toString());
        destInfo.setCompany(srcInfo.getCompany());
        destInfo.setCounterPart(srcInfo.getInstitution().getName());
        destInfo.setCurrency(srcInfo.getCurrency());
        destInfo.setDescription(billTypeName + srcInfo.getNumber());
        destInfo.setExchangeRate(srcInfo.getLocalCurExRate());
        destInfo.setExpectedDate(srcInfo.getExpiredDate());
        destInfo.setIsInsider(false);
        destInfo.setIsInFlow(srcInfo.getBlockFlowType().isIsInFlow());
        destInfo.setRegion(srcInfo.getRegion());
        destInfo.setSourceType(SourceTypeEnum.system);
        destInfo.setBlockFlowType(srcInfo.getBlockFlowType());
        destColl.add(destInfo);
        return destColl;
    }
}

