/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.util.Locale;

public class LetterOfCreditBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        JournalInfo journalInfoMargin;
        LetterOfCreditInfo letterOfCreditInfo = this.getLetterOfCreditInfo(ctx, billId);
        JournalCollection journalColl = new JournalCollection();
        JournalInfo journalInfoAmt = this.createJournalInfoAmt(ctx, letterOfCreditInfo);
        if (journalInfoAmt != null) {
            journalColl.add(journalInfoAmt);
        }
        if ((journalInfoMargin = this.journalInfoMargin(ctx, letterOfCreditInfo)) != null) {
            journalColl.add(journalInfoMargin);
        }
        return journalColl;
    }

    private JournalInfo createJournalInfoAmt(Context ctx, LetterOfCreditInfo letterOfCreditInfo) throws BOSException {
        JournalInfo journalInfoAutionAmt = null;
        if (letterOfCreditInfo.getPayBankAcct() != null) {
            journalInfoAutionAmt = new JournalInfo();
            this.setCommonInfo(ctx, letterOfCreditInfo, journalInfoAutionAmt);
            if (letterOfCreditInfo.getPayBankAcct().getCurrency() != null) {
                journalInfoAutionAmt.setCurrency(letterOfCreditInfo.getPayBankAcct().getCurrency());
            } else if (letterOfCreditInfo.getMarginAcct() != null) {
                if (letterOfCreditInfo.getMarginAcct().getCurrency() != null) {
                    journalInfoAutionAmt.setCurrency(letterOfCreditInfo.getMarginAcct().getCurrency());
                } else {
                    journalInfoAutionAmt.setCurrency(letterOfCreditInfo.getMarginCurrency());
                }
            } else {
                journalInfoAutionAmt.setCurrency(letterOfCreditInfo.getMarginCurrency());
            }
            journalInfoAutionAmt.setAccountBank(letterOfCreditInfo.getPayBankAcct());
            journalInfoAutionAmt.setAccountView(letterOfCreditInfo.getPayBankAcct().getAccount());
            journalInfoAutionAmt.setDebitAmount(Constants.ZERO);
            journalInfoAutionAmt.setIsDebit(false);
            journalInfoAutionAmt.setCreditAmount(letterOfCreditInfo.getMarginEx());
        }
        return journalInfoAutionAmt;
    }

    private JournalInfo journalInfoMargin(Context ctx, LetterOfCreditInfo letterOfCreditInfo) throws BOSException {
        JournalInfo journalInfoMargin = null;
        if (letterOfCreditInfo.getMarginAcct() != null) {
            journalInfoMargin = new JournalInfo();
            this.setCommonInfo(ctx, letterOfCreditInfo, journalInfoMargin);
            if (letterOfCreditInfo.getMarginAcct().getCurrency() != null) {
                journalInfoMargin.setCurrency(letterOfCreditInfo.getMarginAcct().getCurrency());
            } else if (letterOfCreditInfo.getPayBankAcct() == null) {
                journalInfoMargin.setCurrency(letterOfCreditInfo.getMarginCurrency());
            } else if (letterOfCreditInfo.getPayBankAcct().getCurrency() == null) {
                journalInfoMargin.setCurrency(letterOfCreditInfo.getMarginCurrency());
            } else {
                journalInfoMargin.setCurrency(letterOfCreditInfo.getPayBankAcct().getCurrency());
            }
            journalInfoMargin.setAccountBank(letterOfCreditInfo.getMarginAcct());
            journalInfoMargin.setAccountView(letterOfCreditInfo.getMarginAcct().getAccount());
            journalInfoMargin.setDebitAmount(letterOfCreditInfo.getMarginEx());
            journalInfoMargin.setIsDebit(true);
            journalInfoMargin.setCreditAmount(Constants.ZERO);
        }
        return journalInfoMargin;
    }

    private void setCommonInfo(Context ctx, LetterOfCreditInfo letterOfCreditInfo, JournalInfo journalInfo) throws BOSException {
        journalInfo.setCreateDate(DateUtil.getDayBegin());
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setSettlementType(this.getSettlementType(ctx));
        journalInfo.setSettlementNumber(letterOfCreditInfo.getNumber());
        journalInfo.setBizDate(letterOfCreditInfo.getIssueDate());
        journalInfo.setBillType(BillTypeEnum.letterOfCredit);
        journalInfo.setBillNumber(letterOfCreditInfo.getNumber());
        String des = "";
        des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"447_LetterOfCreditBookNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"447_LetterOfCreditBookNotifyBuilder");
        journalInfo.setDescription(des);
        journalInfo.setCompany(letterOfCreditInfo.getCompany());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(letterOfCreditInfo.getId().toString());
    }

    private JournalInfo createJournalInfoAmt(Context ctx, LoanInfo loanInfo) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(loanInfo.getBankAcct());
        journalInfo.setCurrency(loanInfo.getCurrency());
        journalInfo.setCreateDate(loanInfo.getBizDate());
        journalInfo.setDebitAmount(loanInfo.getAmount().subtract(loanInfo.getCautionAmt()));
        journalInfo.setIsDebit(true);
        journalInfo.setCreditAmount(Constants.ZERO);
        journalInfo.setBizDate(loanInfo.getIssueDate());
        journalInfo.setAccountView(loanInfo.getSettlementAcct());
        journalInfo.setOppAccountView(loanInfo.getLoanAcct());
        journalInfo.setBillType(BillTypeEnum.loanBill);
        journalInfo.setBillId(loanInfo.getId().toString());
        journalInfo.setBillNumber(loanInfo.getNumber());
        String des = "";
        des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"448_LetterOfCreditBookNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"448_LetterOfCreditBookNotifyBuilder");
        journalInfo.setDescription(des);
        journalInfo.setCompany(loanInfo.getCompany());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        return journalInfo;
    }

    private LetterOfCreditInfo getLetterOfCreditInfo(Context ctx, String billId) throws EASBizException, BOSException {
        LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return info;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("payBankAcct.currency.id");
        sic.add("marginAcct.currency.id");
        sic.add("payBankAcct.account.id");
        sic.add("marginAcct.account.id");
        return sic;
    }

    private SettlementTypeInfo getSettlementType(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ntType", (Object)"55555555-5555-5555-5555-5555555555551C9A9013"));
        view.setFilter(filter);
        SettlementTypeCollection coll = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(view);
        SettlementTypeInfo type = null;
        if (coll != null && coll.size() == 1) {
            type = coll.get(0);
        }
        return type;
    }
}

